/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.common.lang;

import com.argo21.common.lang.XDataException;
import com.argo21.common.lang.XDataSet;
import com.argo21.common.lang.XObject;

public final class XObjectSet
extends XDataSet {
    protected Object[] m_obj = null;
    int elementType = 17;

    public XObjectSet(int size) {
        this.m_obj = new Object[size];
    }

    public XObjectSet(int elementType, int size) {
        this.m_obj = new Object[size];
        this.elementType = elementType;
    }

    public XObjectSet() {
        this.m_obj = new Object[BASESIZE];
    }

    public XObjectSet(Object[] obj) {
        this.m_obj = obj;
        this.count = obj.length;
    }

    @Override
    public int getType() {
        return 273;
    }

    @Override
    public String getTypeName() {
        return "Object[]";
    }

    public int getElementType() {
        return this.elementType;
    }

    @Override
    public double doubleValue() throws XDataException {
        return this.doubleValue(0);
    }

    @Override
    public double doubleValue(int index) throws XDataException {
        if (this.count <= index) {
            return 0.0;
        }
        if (this.m_obj[index] instanceof Number) {
            return ((Number)this.m_obj[index]).doubleValue();
        }
        if (this.m_obj[index] instanceof XObject) {
            return ((XObject)this.m_obj[index]).doubleValue();
        }
        try {
            return Double.parseDouble(this.m_obj[index].toString());
        }
        catch (Exception e) {
            return 0.0;
        }
    }

    @Override
    public boolean booleanValue() throws XDataException {
        return this.booleanValue(0);
    }

    @Override
    public boolean booleanValue(int index) throws XDataException {
        if (this.count <= index) {
            return false;
        }
        if (this.m_obj[index] instanceof Boolean) {
            return (Boolean)this.m_obj[index];
        }
        if (this.m_obj[index] instanceof XObject) {
            return ((XObject)this.m_obj[index]).booleanValue();
        }
        return Boolean.valueOf(this.m_obj[index].toString());
    }

    @Override
    public Object objectValue() {
        return this.m_obj;
    }

    @Override
    public Object objectValue(int index) {
        return this.count <= index ? null : this.m_obj[index];
    }

    @Override
    public String stringValue() {
        return this.stringValue(0);
    }

    @Override
    public String stringValue(int index) {
        if (this.count <= index) {
            return "";
        }
        if (this.m_obj[index] instanceof XObject) {
            return ((XObject)this.m_obj[index]).stringValue();
        }
        return this.m_obj[index].toString();
    }

    @Override
    public float floatValue() throws XDataException {
        return (float)this.doubleValue(0);
    }

    @Override
    public float floatValue(int index) throws XDataException {
        return (float)this.doubleValue(index);
    }

    @Override
    public int intValue() throws XDataException {
        return (int)this.longValue(0);
    }

    @Override
    public int intValue(int index) throws XDataException {
        return (int)this.longValue(0);
    }

    @Override
    public long longValue() throws XDataException {
        return this.longValue(0);
    }

    @Override
    public long longValue(int index) throws XDataException {
        if (this.count <= index) {
            return 0L;
        }
        if (this.m_obj[index] instanceof Number) {
            return ((Number)this.m_obj[index]).longValue();
        }
        if (this.m_obj[index] instanceof XObject) {
            return ((XObject)this.m_obj[index]).longValue();
        }
        try {
            return Long.parseLong(this.m_obj[index].toString());
        }
        catch (Exception e) {
            return 0L;
        }
    }

    @Override
    public Object[] objectValues() throws XDataException {
        if (this.m_obj.length != this.count) {
            Object[] tmp = this.m_obj;
            this.m_obj = new Object[this.count];
            System.arraycopy(tmp, 0, this.m_obj, 0, this.count);
        }
        return this.m_obj;
    }

    @Override
    public double[] doubleValues() throws XDataException {
        double[] result = new double[this.count];
        if (this.count <= 0) {
            return result;
        }
        if (this.m_obj[0] instanceof Number) {
            for (int i = 0; i < this.count; ++i) {
                result[i] = ((Number)this.m_obj[i]).doubleValue();
            }
        } else if (this.m_obj[0] instanceof XObject) {
            for (int i = 0; i < this.count; ++i) {
                result[i] = ((XObject)this.m_obj[i]).doubleValue();
            }
        } else {
            for (int i = 0; i < this.count; ++i) {
                try {
                    result[i] = Double.parseDouble(this.m_obj[i].toString());
                    continue;
                }
                catch (Exception e) {
                    result[i] = 0.0;
                }
            }
        }
        return result;
    }

    @Override
    public String[] stringValues() throws XDataException {
        String[] result = new String[this.count];
        if (this.count <= 0) {
            return result;
        }
        if (this.m_obj[0] instanceof XObject) {
            for (int i = 0; i < this.count; ++i) {
                result[i] = ((XObject)this.m_obj[i]).stringValue();
            }
        } else {
            for (int i = 0; i < this.count; ++i) {
                result[i] = this.m_obj[i].toString();
            }
        }
        return result;
    }

    @Override
    public boolean[] booleanValues() throws XDataException {
        boolean[] result = new boolean[this.count];
        if (this.count <= 0) {
            return result;
        }
        if (this.m_obj[0] instanceof Boolean) {
            for (int i = 0; i < this.count; ++i) {
                result[i] = (Boolean)this.m_obj[i];
            }
        } else if (this.m_obj[0] instanceof XObject) {
            for (int i = 0; i < this.count; ++i) {
                result[i] = ((XObject)this.m_obj[i]).booleanValue();
            }
        } else {
            for (int i = 0; i < this.count; ++i) {
                result[i] = Boolean.valueOf(this.m_obj[i].toString());
            }
        }
        return result;
    }

    public boolean containArray() {
        if (this.m_obj.length <= 0) {
            return false;
        }
        return this.m_obj[0] instanceof XDataSet;
    }

    public void append(Object obj) {
        if (this.count >= this.m_obj.length) {
            this.expendsCapacity(this.count + 1);
        }
        this.m_obj[this.count++] = obj;
    }

    @Override
    public synchronized void expendsCapacity(int minCapacity) {
        int oldCapacity = this.m_obj.length;
        if (minCapacity > oldCapacity) {
            Object[] oldData = this.m_obj;
            int newCapacity = XObjectSet.expectCapacity(oldCapacity, minCapacity);
            this.m_obj = new Object[newCapacity];
            System.arraycopy(oldData, 0, this.m_obj, 0, this.count);
        }
    }

    @Override
    public void reverse() throws XDataException {
        int start = 0;
        for (int end = this.count - 1; start < end; ++start, --end) {
            Object tmp = this.m_obj[start];
            this.m_obj[start] = this.m_obj[end];
            this.m_obj[end] = tmp;
        }
    }

    @Override
    public XDataSet extendDataSet(int length) {
        Object[] result = new Object[length];
        if (this.count > 0) {
            int size;
            for (int k = 0; k < length; k += size) {
                size = length - k < this.count ? length - k : this.count;
                System.arraycopy(this.m_obj, 0, result, k, size);
            }
        }
        return new XObjectSet(result);
    }
}

