/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.common.lang;

import com.argo21.common.lang.XDataException;
import com.argo21.map.MappingProcessor2;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class XStringFormat {
    protected static String trim(String str) {
        if (str == null || str.length() == 0) {
            return "";
        }
        String result = str.replaceAll("^[\\s\u3000]*", "").replaceAll("[\\s\u3000]*$", "");
        return result;
    }

    protected static String suppressZero(String str) {
        if (str == null || str.length() == 0) {
            return "";
        }
        String result = str.replaceAll("^0*", "");
        if (result.length() == 0) {
            result = "0";
        }
        return result;
    }

    protected static String paddingZero(String str, int length) {
        if (str == null || str.length() == 0) {
            return "";
        }
        String padZero = "0000000000";
        while (str.length() < length) {
            if ((str = padZero.concat(str)).length() <= length) continue;
            str = str.substring(str.length() - length, str.length());
            break;
        }
        return str;
    }

    protected static String addDateDelimiter(String str, String separator) throws XDataException {
        if (str == null || str.length() == 0) {
            return "";
        }
        try {
            SimpleDateFormat df1 = new SimpleDateFormat("yyyyMMdd");
            Date date = df1.parse(str);
            SimpleDateFormat df2 = new SimpleDateFormat("yyyy" + separator + "MM" + separator + "dd");
            String result = df2.format(date);
            String verifyStr = df1.format(df2.parse(result));
            if (!str.equals(verifyStr)) {
                throw new XDataException("addDateDelimiter()\u5bfe\u8c61\u306e\u6587\u5b57\u5217\u304c\u7570\u5e38\u3067\u3059\uff1a" + str);
            }
            return result;
        }
        catch (ParseException e) {
            throw new XDataException("addDateDelimiter()\u5bfe\u8c61\u306e\u6587\u5b57\u5217\u304c\u7570\u5e38\u3067\u3059\uff1a" + str, e);
        }
    }

    protected static String deleteDateDelimiter(String str, String separator) throws XDataException {
        if (str == null || str.length() == 0) {
            return "";
        }
        try {
            SimpleDateFormat df1 = new SimpleDateFormat("yyyy" + separator + "MM" + separator + "dd");
            Date date = df1.parse(str);
            SimpleDateFormat df2 = new SimpleDateFormat("yyyyMMdd");
            String result = df2.format(date);
            String verifyStr = df1.format(df2.parse(result));
            if (!str.equals(verifyStr)) {
                throw new XDataException("parseDate()\u5bfe\u8c61\u306e\u6587\u5b57\u5217\u304c\u7570\u5e38\u3067\u3059\uff1a" + str);
            }
            return result;
        }
        catch (ParseException e) {
            throw new XDataException("parseDate()\u5bfe\u8c61\u306e\u6587\u5b57\u5217\u304c\u7570\u5e38\u3067\u3059\uff1a" + str, e);
        }
    }

    protected static String addDecimalPoint(String str, int place) {
        if (str == null || str.length() == 0) {
            return "";
        }
        while (str.length() < place) {
            str = "0".concat(str);
        }
        String numberInt = str.substring(0, str.length() - place);
        String numberDec = str.substring(str.length() - place);
        if ((numberInt = numberInt.replaceAll("^0*", "")).length() == 0) {
            numberInt = "0";
        }
        if (!MappingProcessor2.getIsAddDecimalZero()) {
            numberDec = numberDec.replaceAll("0*$", "");
        }
        if (numberDec.length() == 0) {
            return numberInt;
        }
        return numberInt + "." + numberDec;
    }

    protected static String deleteDecimalPoint(String str, int place) {
        if (str == null || str.length() == 0) {
            return "";
        }
        int point = str.indexOf(".");
        if (point < 0) {
            str = str.concat(".0");
            point = str.indexOf(".");
        }
        String numberInt = str.substring(0, point);
        String numberDec = str.substring(point + 1);
        while (numberDec.length() < place) {
            numberDec = numberDec.concat("0");
        }
        return numberInt + numberDec;
    }
}

