/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.common.lang;

import com.argo21.common.lang.ObjectDeclaration;
import com.argo21.common.lang.ObjectManager;
import com.argo21.common.lang.XBoolean;
import com.argo21.common.lang.XData;
import com.argo21.common.lang.XDataException;
import com.argo21.common.lang.XDataSet;
import com.argo21.common.lang.XIntegerSet;
import com.argo21.common.lang.XNode;
import com.argo21.common.lang.XString;
import com.argo21.common.lang.XStringFormat;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import org.w3c.dom.Node;

public final class XStringSet
extends XDataSet {
    String[] m_val = null;

    public static void registObject() {
        Class<XStringSet> cls = XStringSet.class;
        if (ObjectManager.isRegisted(cls)) {
            return;
        }
        ObjectDeclaration od = ObjectManager.createObjectDeclaration(cls, "String[]");
        Method md = null;
        try {
            md = cls.getMethod("invoke", String.class, XData[].class);
        }
        catch (Exception e) {
            return;
        }
        od.addMethodDeclaration("charAt", md, String.valueOf(257), cls, 1);
        od.addMethodDeclaration("compareTo", md, String.valueOf(258), XIntegerSet.class, 1);
        od.addMethodDeclaration("compareToIgnoreCase", md, String.valueOf(259), XIntegerSet.class, 1);
        od.addMethodDeclaration("concat", md, String.valueOf(260), cls, 1);
        od.addMethodDeclaration("equals", md, String.valueOf(261), XBoolean.class, 1);
        od.addMethodDeclaration("equalsIgnoreCase", md, String.valueOf(262), XBoolean.class, 1);
        od.addMethodDeclaration("indexOf", md, String.valueOf(263), XIntegerSet.class, 1);
        od.addMethodDeclaration("indexOf", md, String.valueOf(264), XIntegerSet.class, 2);
        od.addMethodDeclaration("lastIndexOf", md, String.valueOf(265), XIntegerSet.class, 1);
        od.addMethodDeclaration("lastIndexOf", md, String.valueOf(272), XIntegerSet.class, 2);
        od.addMethodDeclaration("length", md, String.valueOf(273), XIntegerSet.class, 0);
        od.addMethodDeclaration("replace", md, String.valueOf(274), cls, 2);
        od.addMethodDeclaration("substr", md, String.valueOf(277), cls, 1);
        od.addMethodDeclaration("substr", md, String.valueOf(278), cls, 2);
        od.addMethodDeclaration("substring", md, String.valueOf(279), cls, 1);
        od.addMethodDeclaration("substring", md, String.valueOf(280), cls, 2);
        od.addMethodDeclaration("toLowerCase", md, String.valueOf(281), cls, 0);
        od.addMethodDeclaration("toUpperCase", md, String.valueOf(288), cls, 0);
        od.addMethodDeclaration("trim", md, String.valueOf(289), cls, 0);
        od.addMethodDeclaration("suppressZero", md, String.valueOf(290), cls, 0);
        od.addMethodDeclaration("paddingZero", md, String.valueOf(291), cls, 1);
        od.addMethodDeclaration("addDateDelimiter", md, String.valueOf(292), cls, 1);
        od.addMethodDeclaration("deleteDateDelimiter", md, String.valueOf(293), cls, 1);
        od.addMethodDeclaration("addDecimalPoint", md, String.valueOf(294), cls, 1);
        od.addMethodDeclaration("deleteDecimalPoint", md, String.valueOf(295), cls, 1);
    }

    @Override
    public XData invoke(String id2, XData[] parameters) throws XDataException, NoSuchMethodException {
        int idd = -1;
        try {
            idd = Integer.parseInt(id2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        switch (idd) {
            case 257: {
                String[] result_S = new String[this.count];
                for (int i = 0; i < this.count; ++i) {
                    int tmpInt = parameters[0].intValue(i);
                    if (tmpInt >= this.m_val[i].length()) {
                        result_S[i] = "";
                        continue;
                    }
                    char c = this.m_val[i].charAt(tmpInt);
                    result_S[i] = String.valueOf(c);
                }
                return new XStringSet(result_S);
            }
            case 258: {
                int[] result_I = new int[this.count];
                for (int i = 0; i < this.count; ++i) {
                    String tmpStr = parameters[0].stringValue(i);
                    result_I[i] = this.m_val[i].compareTo(tmpStr);
                }
                return new XIntegerSet(result_I);
            }
            case 259: {
                int[] result_I = new int[this.count];
                for (int i = 0; i < this.count; ++i) {
                    String tmpStr = parameters[0].stringValue(i);
                    result_I[i] = this.m_val[i].compareToIgnoreCase(tmpStr);
                }
                return new XIntegerSet(result_I);
            }
            case 260: {
                String[] result_S = new String[this.count];
                for (int i = 0; i < this.count; ++i) {
                    String tmpStr = parameters[0].stringValue(i);
                    result_S[i] = this.m_val[i].concat(tmpStr);
                }
                return new XStringSet(result_S);
            }
            case 261: {
                for (int i = 0; i < this.count; ++i) {
                    String tmpStr = parameters[0].stringValue(i);
                    if (this.m_val[i].equals(tmpStr)) continue;
                    return new XBoolean(false);
                }
                return new XBoolean(true);
            }
            case 262: {
                for (int i = 0; i < this.count; ++i) {
                    String tmpStr = parameters[0].stringValue(i);
                    if (this.m_val[i].equalsIgnoreCase(tmpStr)) continue;
                    return new XBoolean(false);
                }
                return new XBoolean(true);
            }
            case 263: {
                int[] result_I = new int[this.count];
                for (int i = 0; i < this.count; ++i) {
                    String tmpStr = parameters[0].stringValue(i);
                    result_I[i] = this.m_val[i].indexOf(tmpStr);
                }
                return new XIntegerSet(result_I);
            }
            case 264: {
                int[] result_I = new int[this.count];
                for (int i = 0; i < this.count; ++i) {
                    String tmpStr = parameters[0].stringValue(i);
                    int tmpInt = parameters[1].intValue(i);
                    result_I[i] = this.m_val[i].indexOf(tmpStr, tmpInt);
                }
                return new XIntegerSet(result_I);
            }
            case 265: {
                int[] result_I = new int[this.count];
                for (int i = 0; i < this.count; ++i) {
                    String tmpStr = parameters[0].stringValue(i);
                    result_I[i] = this.m_val[i].lastIndexOf(tmpStr);
                }
                return new XIntegerSet(result_I);
            }
            case 272: {
                int[] result_I = new int[this.count];
                for (int i = 0; i < this.count; ++i) {
                    String tmpStr = parameters[0].stringValue(i);
                    int tmpInt = parameters[1].intValue(i);
                    result_I[i] = this.m_val[i].lastIndexOf(tmpStr, tmpInt);
                }
                return new XIntegerSet(result_I);
            }
            case 273: {
                int[] result_I = new int[this.count];
                for (int i = 0; i < this.count; ++i) {
                    result_I[i] = this.m_val[i].length();
                }
                return new XIntegerSet(result_I);
            }
            case 274: {
                String[] result_S = new String[this.count];
                for (int i = 0; i < this.count; ++i) {
                    String tmpStr = parameters[0].stringValue(i);
                    if (tmpStr.length() == 0) {
                        result_S[i] = this.m_val[i];
                        continue;
                    }
                    String s = parameters[1].stringValue(i);
                    String res = this.m_val[i];
                    int tmpInt = res.indexOf(tmpStr);
                    while (tmpInt >= 0) {
                        res = res.substring(0, tmpInt) + s + res.substring(tmpInt + tmpStr.length());
                        tmpInt = res.indexOf(tmpStr);
                    }
                    result_S[i] = res;
                }
                return new XStringSet(result_S);
            }
            case 275: 
            case 276: {
                XData.error("TYPE_INVALID_METHOD", new Object[]{this.getTypeName(), "split"}, true);
            }
            case 277: 
            case 279: {
                String[] result_S = new String[this.count];
                for (int i = 0; i < this.count; ++i) {
                    int tmpInt = parameters[0].intValue(i);
                    result_S[i] = tmpInt >= this.m_val[i].length() ? "" : this.m_val[i].substring(tmpInt);
                }
                return new XStringSet(result_S);
            }
            case 278: {
                String[] result_S = new String[this.count];
                for (int i = 0; i < this.count; ++i) {
                    int tmpInt = parameters[0].intValue(i);
                    int tmpInt2 = parameters[1].intValue(i);
                    result_S[i] = tmpInt >= this.m_val[i].length() ? "" : (tmpInt2 >= this.m_val[i].length() ? this.m_val[i].substring(tmpInt) : this.m_val[i].substring(tmpInt, tmpInt + tmpInt2));
                }
                return new XStringSet(result_S);
            }
            case 280: {
                String[] result_S = new String[this.count];
                for (int i = 0; i < this.count; ++i) {
                    int tmpInt = parameters[0].intValue(i);
                    int tmpInt2 = parameters[1].intValue(i);
                    result_S[i] = tmpInt >= this.m_val[i].length() ? "" : (tmpInt2 >= this.m_val[i].length() ? this.m_val[i].substring(tmpInt) : this.m_val[i].substring(tmpInt, tmpInt2));
                }
                return new XStringSet(result_S);
            }
            case 281: {
                String[] result_S = new String[this.count];
                for (int i = 0; i < this.count; ++i) {
                    result_S[i] = this.m_val[i].toLowerCase();
                }
                return new XStringSet(result_S);
            }
            case 288: {
                String[] result_S = new String[this.count];
                for (int i = 0; i < this.count; ++i) {
                    result_S[i] = this.m_val[i].toUpperCase();
                }
                return new XStringSet(result_S);
            }
            case 289: {
                String[] results = new String[this.size()];
                for (int i = 0; i < this.size(); ++i) {
                    results[i] = XStringFormat.trim(this.m_val[i]);
                }
                return new XStringSet(results);
            }
            case 290: {
                String[] results = new String[this.size()];
                for (int i = 0; i < this.size(); ++i) {
                    results[i] = XStringFormat.suppressZero(this.m_val[i]);
                }
                return new XStringSet(results);
            }
            case 291: {
                String[] results = new String[this.size()];
                for (int i = 0; i < this.size(); ++i) {
                    results[i] = XStringFormat.paddingZero(this.m_val[i], parameters[0].intValue());
                }
                return new XStringSet(results);
            }
            case 292: {
                String[] results = new String[this.size()];
                for (int i = 0; i < this.size(); ++i) {
                    results[i] = XStringFormat.addDateDelimiter(this.m_val[i], parameters[0].stringValue());
                }
                return new XStringSet(results);
            }
            case 293: {
                String[] results = new String[this.size()];
                for (int i = 0; i < this.size(); ++i) {
                    results[i] = XStringFormat.deleteDateDelimiter(this.m_val[i], parameters[0].stringValue());
                }
                return new XStringSet(results);
            }
            case 294: {
                String[] results = new String[this.size()];
                for (int i = 0; i < this.size(); ++i) {
                    results[i] = XStringFormat.addDecimalPoint(this.m_val[i], parameters[0].intValue());
                }
                return new XStringSet(results);
            }
            case 295: {
                String[] results = new String[this.size()];
                for (int i = 0; i < this.size(); ++i) {
                    results[i] = XStringFormat.deleteDecimalPoint(this.m_val[i], parameters[0].intValue());
                }
                return new XStringSet(results);
            }
        }
        return super.invoke(id2, parameters);
    }

    @Override
    public boolean isEmpty() {
        return this.m_val == null || this.count == 0;
    }

    public XStringSet(int capacity) {
        this.m_val = new String[capacity];
    }

    public XStringSet(String[] val) {
        this.m_val = val;
        this.count = val.length;
    }

    @Override
    public int getType() {
        return 262;
    }

    @Override
    public String getTypeName() {
        return "String[]";
    }

    @Override
    public boolean booleanValue() throws XDataException {
        return this.booleanValue(0);
    }

    @Override
    public boolean booleanValue(int index) throws XDataException {
        return this.count <= index ? false : this.m_val[index] != null && this.m_val[index].length() > 0;
    }

    @Override
    public double doubleValue() throws XDataException {
        return this.doubleValue(0);
    }

    @Override
    public double doubleValue(int index) throws XDataException {
        if (this.count <= index) {
            return 0.0;
        }
        try {
            return this.m_val[index] == null || this.m_val[index].length() == 0 ? 0.0 : Double.parseDouble(this.m_val[index].trim());
        }
        catch (NumberFormatException nfe) {
            return Double.NaN;
        }
    }

    @Override
    public float floatValue() throws XDataException {
        return (float)this.doubleValue(0);
    }

    @Override
    public float floatValue(int index) throws XDataException {
        return (float)this.doubleValue(index);
    }

    @Override
    public int intValue() throws XDataException {
        return (int)this.longValue(0);
    }

    @Override
    public int intValue(int index) throws XDataException {
        return (int)this.longValue(index);
    }

    @Override
    public long longValue() throws XDataException {
        return this.longValue(0);
    }

    @Override
    public long longValue(int index) throws XDataException {
        if (this.count <= index) {
            return 0L;
        }
        try {
            return this.m_val[index] == null || this.m_val[index].length() == 0 ? 0L : Long.parseLong(this.m_val[index].trim());
        }
        catch (NumberFormatException nfe) {
            return 0L;
        }
    }

    @Override
    public Object objectValue() {
        return this.m_val;
    }

    @Override
    public Object objectValue(int index) {
        return this.count <= index ? "" : this.m_val[index];
    }

    @Override
    public String stringValue() {
        return this.stringValue(0);
    }

    @Override
    public String stringValue(int index) {
        if (this.count <= index) {
            return "";
        }
        return this.m_val[index] == null ? "" : this.m_val[index];
    }

    @Override
    public String[] stringValues() throws XDataException {
        if (this.m_val.length == this.count) {
            return this.m_val;
        }
        String[] result = new String[this.count];
        System.arraycopy(this.m_val, 0, result, 0, this.count);
        return result;
    }

    public void append(String val) {
        if (this.count >= this.m_val.length) {
            this.expendsCapacity(this.count + 1);
        }
        if (val == null) {
            val = "";
        }
        this.m_val[this.count++] = val;
    }

    @Override
    public XData sum() throws XDataException {
        int n = this.size();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            sb.append(this.m_val[i]);
        }
        return new XString(sb.toString());
    }

    @Override
    public void sort(boolean rise) throws XDataException {
        if (rise) {
            Arrays.sort(this.m_val);
        } else {
            Arrays.sort(this.m_val, Collections.reverseOrder());
        }
    }

    @Override
    public void reverse() throws XDataException {
        int start = 0;
        for (int end = this.count - 1; start < end; ++start, --end) {
            String tmp = this.m_val[start];
            this.m_val[start] = this.m_val[end];
            this.m_val[end] = tmp;
        }
    }

    public void set(int index, String val) {
        if (index >= this.count) {
            this.count = index + 1;
            this.expendsCapacity(this.count);
        }
        if (val == null) {
            val = "";
        }
        this.m_val[index] = val;
    }

    @Override
    public synchronized void expendsCapacity(int minCapacity) {
        int oldCapacity = this.m_val.length;
        if (minCapacity > oldCapacity) {
            String[] oldData = this.m_val;
            int newCapacity = XStringSet.expectCapacity(oldCapacity, minCapacity);
            this.m_val = new String[newCapacity];
            System.arraycopy(oldData, 0, this.m_val, 0, this.count);
        }
    }

    @Override
    public void setValue(int index, int value) throws XDataException {
        this.setValue(index, String.valueOf(value));
    }

    @Override
    public void setValue(int index, long value) throws XDataException {
        this.setValue(index, String.valueOf(value));
    }

    @Override
    public void setValue(int index, float value) throws XDataException {
        this.setValue(index, String.valueOf(value));
    }

    @Override
    public void setValue(int index, double value) throws XDataException {
        this.setValue(index, String.valueOf(value));
    }

    @Override
    public void setValue(int index, String value) throws XDataException {
        if (index >= this.count) {
            this.expendsCapacity(index + 1);
            this.count = index + 1;
        }
        if (value == null) {
            value = "";
        }
        this.m_val[index] = value;
    }

    @Override
    public void setValue(int index, boolean value) throws XDataException {
        this.setValue(index, String.valueOf(value));
    }

    @Override
    public void setValue(int index, Date value) throws XDataException {
        this.setValue(index, value.toString());
    }

    @Override
    public void setValue(int index, Node value) throws XDataException {
        XNode xn = new XNode(value);
        this.setValue(index, xn.stringValue());
    }

    @Override
    public void setValue(int index, XData value) throws XDataException {
        this.setValue(index, value.stringValue());
    }

    @Override
    public boolean equals(XData obj2) throws XDataException {
        if (this.count <= 0) {
            return false;
        }
        if (obj2.isNode()) {
            return obj2.equals(this);
        }
        for (int i = 0; i < this.count; ++i) {
            if (obj2.stringValue(i).equals(this.m_val[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public XDataSet extendDataSet(int length) {
        String[] result = new String[length];
        if (this.count > 0) {
            int size;
            for (int k = 0; k < length; k += size) {
                size = length - k < this.count ? length - k : this.count;
                System.arraycopy(this.m_val, 0, result, k, size);
            }
        }
        return new XStringSet(result);
    }
}

