/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.common.log;

import com.argo21.common.log.AppMessage;
import com.argo21.common.log.BizTranException;
import com.argo21.common.log.Logger;
import com.argo21.common.log.WriterMode;
import com.argo21.common.log.builder.BizTranExceptionLogDirector;
import com.argo21.common.log.builder.BizTranLogBuilder;
import com.argo21.common.log.builder.ErrorLogDirector;
import com.argo21.common.log.builder.ExceptionLogDirector;
import com.argo21.common.log.builder.LogBuilder;
import com.argo21.common.log.builder.LogDirector;
import com.argo21.common.log.builder.NormalLogDirector;
import com.argo21.common.log.writer.LogFileWriter;
import com.argo21.common.log.writer.NullLogFileWriter;
import com.argo21.common.log.writer.RetryLogFileWriter;
import com.argo21.common.log.writer.SimpleLogFileWriter;
import com.argo21.common.util.MappingInfo;
import java.io.IOException;

public class BizTranAPILogger
implements Logger {
    private LogFileWriter usrWriter = null;
    private MappingInfo mapInfo = null;
    private int ngCnt = 0;
    private static final int RETRY_CNT = 10;
    private static final long INTERVAL = 500L;

    public BizTranAPILogger() throws IOException {
        this.init();
    }

    private void init() throws IOException {
        this.mapInfo = new MappingInfo();
        this.usrWriter = new NullLogFileWriter();
    }

    @Override
    public void addLog(String logFilePath, WriterMode mode) {
        try {
            if (this.usrWriter != null) {
                this.usrWriter.close();
            }
            if (logFilePath == null || logFilePath.length() == 0) {
                this.usrWriter = new NullLogFileWriter();
            } else {
                this.usrWriter = new RetryLogFileWriter(new SimpleLogFileWriter(logFilePath, mode), 10, 500L);
                this.usrWriter.open();
            }
        }
        catch (IOException e) {
            this.usrWriter = new NullLogFileWriter();
            System.err.println("\u51e6\u7406\u5225\u30ed\u30b0\u306e\u4f5c\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002" + logFilePath);
        }
    }

    private void writeErrorLog(LogBuilder builder, LogDirector director) {
        ++this.ngCnt;
        this.writeLog(builder, director);
    }

    private void writeLog(LogBuilder builder, LogDirector director) {
        director.constract();
        String logContent = builder.getResult();
        try {
            this.usrWriter.write(logContent);
        }
        catch (IOException e) {
            System.err.println("\u51e6\u7406\u5225\u30ed\u30b0\u306e\u51fa\u529b\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002" + this.usrWriter.getName());
        }
    }

    @Override
    public void error(AppMessage appMsg) {
        BizTranLogBuilder builder = new BizTranLogBuilder();
        ErrorLogDirector director = new ErrorLogDirector(builder, this.mapInfo, appMsg);
        this.writeErrorLog(builder, director);
    }

    @Override
    public void error(AppMessage appMsg, Throwable error) {
        BizTranLogBuilder builder = new BizTranLogBuilder();
        ExceptionLogDirector director = new ExceptionLogDirector(builder, this.mapInfo, appMsg, error);
        this.writeErrorLog(builder, director);
    }

    @Override
    public void error(BizTranException error) {
        BizTranLogBuilder builder = new BizTranLogBuilder();
        BizTranExceptionLogDirector director = new BizTranExceptionLogDirector(builder, this.mapInfo, error);
        this.writeErrorLog(builder, director);
    }

    @Override
    public void normal() {
        BizTranLogBuilder builder = new BizTranLogBuilder();
        NormalLogDirector director = new NormalLogDirector(builder, this.mapInfo);
        this.writeLog(builder, director);
    }

    @Override
    public synchronized boolean renameByResult() {
        return true;
    }

    @Override
    public MappingInfo getMappingInfo() {
        return this.mapInfo;
    }

    @Override
    public void deleteLogFile() {
    }
}

