/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.common.log;

import com.argo21.common.log.AppMessage;
import java.util.ArrayList;

public class BizTranException
extends Exception {
    private int stsCode;
    private String[] messages;

    public BizTranException() {
        this.stsCode = 0;
    }

    public BizTranException(int stsCode, String[] messages) {
        this.stsCode = stsCode;
        this.messages = messages;
    }

    public BizTranException(AppMessage appMessage) {
        this.stsCode = appMessage.getCode();
        this.messages = new String[]{appMessage.getMessage()};
    }

    public BizTranException(AppMessage appMessage, String message) {
        this.stsCode = appMessage.getCode();
        this.messages = new String[]{appMessage.getMessage(), message};
    }

    public BizTranException(AppMessage appMessage, Throwable error) {
        this.stsCode = appMessage.getCode();
        ArrayList<String> errMsgList = new ArrayList<String>();
        errMsgList.add(appMessage.getMessage());
        errMsgList.add(error.getClass().getName() + ":" + error.getLocalizedMessage());
        StackTraceElement[] stElem = error.getStackTrace();
        for (int i = 0; i < stElem.length; ++i) {
            errMsgList.add(stElem[i].toString());
        }
        this.messages = errMsgList.toArray(new String[0]);
    }

    public BizTranException(AppMessage appMessage, String message, Throwable error) {
        this.stsCode = appMessage.getCode();
        ArrayList<String> errMsgList = new ArrayList<String>();
        errMsgList.add(appMessage.getMessage());
        errMsgList.add(message);
        errMsgList.add(error.getClass().getName() + ":" + error.getLocalizedMessage());
        StackTraceElement[] stElem = error.getStackTrace();
        for (int i = 0; i < stElem.length; ++i) {
            errMsgList.add(stElem[i].toString());
        }
        this.messages = errMsgList.toArray(new String[0]);
    }

    public String[] getMessages() {
        return this.messages;
    }

    public void setMessages(String[] messages) {
        this.messages = messages;
    }

    public int getStsCode() {
        return this.stsCode;
    }

    public void setStsCode(int stsCode) {
        this.stsCode = stsCode;
    }
}

