/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.common.log;

import com.argo21.common.log.AppMessage;
import com.argo21.common.log.BizTranException;
import com.argo21.common.log.Logger;
import com.argo21.common.log.WriterMode;
import com.argo21.common.log.builder.BizTranExceptionLogDirector;
import com.argo21.common.log.builder.BizTranLogBuilder;
import com.argo21.common.log.builder.ErrorLogDirector;
import com.argo21.common.log.builder.ExceptionLogDirector;
import com.argo21.common.log.builder.LogBuilder;
import com.argo21.common.log.builder.LogDirector;
import com.argo21.common.log.builder.NormalLogDirector;
import com.argo21.common.log.writer.LogFileWriter;
import com.argo21.common.log.writer.NullLogFileWriter;
import com.argo21.common.log.writer.RetryLogFileWriter;
import com.argo21.common.log.writer.RollingLogFileWriter;
import com.argo21.common.log.writer.SimpleLogFileWriter;
import com.argo21.common.log.writer.TimeLogFileWriter;
import com.argo21.common.util.BizTranUtil;
import com.argo21.common.util.MappingInfo;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import org.apache.commons.io.filefilter.AndFileFilter;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.NotFileFilter;
import org.apache.commons.io.filefilter.OrFileFilter;
import org.apache.commons.io.filefilter.PrefixFileFilter;

public class BizTranLogger
implements Logger {
    private LogFileWriter logWriter = null;
    private LogFileWriter usrWriter = null;
    private MappingInfo mapInfo = null;
    private boolean isRename = false;
    private int ngCnt = 0;
    private static String LOG_FOLDER = new File(new File(System.getProperty("user.dir")).getAbsolutePath()).getParent();
    private static final String LOGFILE_PRE_RESULT_OK = "OK_";
    private static final String LOGFILE_PRE_RESULT_NG = "NG_";
    private static final String LOGFILE_EXT = ".txt";
    private static String LOGFILE_DIR = LOG_FOLDER + File.separator + "Log" + File.separator;
    private static final int RETRY_CNT = 10;
    private static final long INTERVAL = 500L;
    private static final int MAX_LOGFILE_HISTORY = 999;

    public BizTranLogger() throws IOException {
        this.init();
    }

    private void init() throws IOException {
        this.mapInfo = new MappingInfo();
        LOG_FOLDER = BizTranUtil.getMappingFolderPath();
        LOGFILE_DIR = LOG_FOLDER + File.separator + "Log" + File.separator;
        OrFileFilter logFilter = new OrFileFilter((IOFileFilter)new PrefixFileFilter(LOGFILE_PRE_RESULT_OK), (IOFileFilter)new PrefixFileFilter(LOGFILE_PRE_RESULT_NG));
        NotFileFilter notDirFilter = new NotFileFilter(DirectoryFileFilter.INSTANCE);
        AndFileFilter filter = new AndFileFilter((IOFileFilter)logFilter, (IOFileFilter)notDirFilter);
        TimeLogFileWriter timeWriter = new TimeLogFileWriter(LOGFILE_DIR, LOGFILE_EXT, new SimpleDateFormat("yyyyMMddHHmmssSSS"));
        RetryLogFileWriter retryWriter = new RetryLogFileWriter(timeWriter, 10, 500L);
        RollingLogFileWriter rollingWriter = new RollingLogFileWriter(retryWriter, (FilenameFilter)filter, LOGFILE_DIR, 999);
        this.logWriter = rollingWriter;
        try {
            this.logWriter.open();
        }
        catch (IOException e) {
            System.err.println("\u7d2f\u7a4d\u30ed\u30b0\u306e\u4f5c\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002" + this.logWriter.getName());
            this.logWriter = new NullLogFileWriter();
        }
        this.usrWriter = new NullLogFileWriter();
    }

    @Override
    public void addLog(String logFilePath, WriterMode mode) {
        try {
            if (this.usrWriter != null) {
                this.usrWriter.close();
            }
            if (logFilePath == null || logFilePath.length() == 0) {
                this.usrWriter = new NullLogFileWriter();
            } else {
                this.usrWriter = new RetryLogFileWriter(new SimpleLogFileWriter(logFilePath, mode), 10, 500L);
                this.usrWriter.open();
            }
        }
        catch (IOException e) {
            this.usrWriter = new NullLogFileWriter();
            System.err.println("\u51e6\u7406\u5225\u30ed\u30b0\u306e\u4f5c\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002" + logFilePath);
        }
    }

    private void writeErrorLog(LogBuilder builder, LogDirector director) {
        ++this.ngCnt;
        this.writeLog(builder, director);
    }

    private void writeLog(LogBuilder builder, LogDirector director) {
        director.constract();
        String logContent = builder.getResult();
        try {
            this.logWriter.write(logContent);
        }
        catch (IOException e) {
            System.err.println("\u7d2f\u7a4d\u30ed\u30b0\u306e\u51fa\u529b\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002" + this.logWriter.getName());
        }
        try {
            this.usrWriter.write(logContent);
        }
        catch (IOException e) {
            System.err.println("\u51e6\u7406\u5225\u30ed\u30b0\u306e\u51fa\u529b\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002" + this.usrWriter.getName());
        }
    }

    @Override
    public void error(AppMessage appMsg) {
        BizTranLogBuilder builder = new BizTranLogBuilder();
        ErrorLogDirector director = new ErrorLogDirector(builder, this.mapInfo, appMsg);
        this.writeErrorLog(builder, director);
    }

    @Override
    public void error(AppMessage appMsg, Throwable error) {
        BizTranLogBuilder builder = new BizTranLogBuilder();
        ExceptionLogDirector director = new ExceptionLogDirector(builder, this.mapInfo, appMsg, error);
        this.writeErrorLog(builder, director);
    }

    @Override
    public void error(BizTranException error) {
        BizTranLogBuilder builder = new BizTranLogBuilder();
        BizTranExceptionLogDirector director = new BizTranExceptionLogDirector(builder, this.mapInfo, error);
        this.writeErrorLog(builder, director);
    }

    @Override
    public void normal() {
        BizTranLogBuilder builder = new BizTranLogBuilder();
        NormalLogDirector director = new NormalLogDirector(builder, this.mapInfo);
        this.writeLog(builder, director);
    }

    @Override
    public synchronized boolean renameByResult() {
        if (this.logWriter == null) {
            return false;
        }
        String oldFileName = this.logWriter.getName();
        File oldFile = new File(oldFileName);
        String newFileName = null;
        if (this.isRename) {
            if (oldFile.getName().startsWith(LOGFILE_PRE_RESULT_NG)) {
                return true;
            }
            if (this.ngCnt == 0) {
                return true;
            }
            newFileName = LOGFILE_PRE_RESULT_NG + oldFile.getName().substring(LOGFILE_PRE_RESULT_OK.length());
        } else {
            newFileName = this.ngCnt == 0 ? LOGFILE_PRE_RESULT_OK + oldFile.getName() : LOGFILE_PRE_RESULT_NG + oldFile.getName();
        }
        boolean result = false;
        try {
            this.logWriter.close();
            File newFile = new File(oldFile.getParent(), newFileName);
            result = oldFile.renameTo(newFile);
            if (result) {
                this.logWriter = new RetryLogFileWriter(new SimpleLogFileWriter(newFile.getAbsolutePath(), WriterMode.APPEND), 10, 500L);
                this.logWriter.open();
                this.isRename = true;
            }
        }
        catch (IOException e) {
            System.err.print("\u30ed\u30b0\u306e\u30ea\u30cd\u30fc\u30e0\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002" + oldFileName);
        }
        return result;
    }

    @Override
    public MappingInfo getMappingInfo() {
        return this.mapInfo;
    }

    @Override
    public void deleteLogFile() {
        String fileName = this.logWriter.getName();
        try {
            this.logWriter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        new File(fileName).delete();
    }
}

