/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.common.log.builder;

import com.argo21.common.log.builder.LogBuilder;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public class BizTranLogBuilder
implements LogBuilder {
    private static String lineSeparator = System.getProperty("line.separator");
    private static final String EXEC_TIME = "@EXEC_TIME@";
    private static final String STATUS_MSG = "@STATUS_MSG@";
    private static final String EXIT_CODE = "@EXIT_CODE@";
    private static final String MAPFILE_PATH = "@MAPFILE_PATH@";
    private static final String INPUTFILE_PATH = "@INPUTFILE_PATH@";
    private static final String TABLEFILE_PATH = "@TABLEFILE_PATH@";
    private static final String DIVPROP_PATH = "@DIVPROP_PATH@";
    private static final String OUTPUTFILE_PATH = "@OUTPUTFILE_PATH@";
    private static final String DIV_INPUTFILE_PATH = "@DIV_INPUTFILE_PATH@";
    private static final String DIV_OUTPUTFILE_PATH = "@DIV_OUTPUTFILE_PATH@";
    private static final String PARAMETES = "@PARAMETES@";
    private static final String MESSAGES = "@MESSAGES@";
    private static final String VALUE_OFFSET = "                            ";
    private static String header = "================================================================================" + lineSeparator + "    Biz Tran    [" + "@EXEC_TIME@" + "]    <" + "@STATUS_MSG@" + ">" + lineSeparator + "================================================================================" + lineSeparator;
    private static String body = "    \u7d42\u4e86\u30b3\u30fc\u30c9            \uff1a@EXIT_CODE@" + lineSeparator + "    \u30de\u30c3\u30d4\u30f3\u30b0\u30d5\u30a1\u30a4\u30eb    \uff1a" + "@MAPFILE_PATH@" + lineSeparator + "    \u5165\u529b\u30d5\u30a1\u30a4\u30eb          \uff1a" + "@INPUTFILE_PATH@" + lineSeparator + "    \u5909\u63db\u88dc\u52a9\u30d5\u30a1\u30a4\u30eb      \uff1a" + "@TABLEFILE_PATH@" + lineSeparator + "    \u5206\u5272\u30d7\u30ed\u30d1\u30c6\u30a3\u30d5\u30a1\u30a4\u30eb\uff1a" + "@DIVPROP_PATH@" + lineSeparator + "    \u51fa\u529b\u30d5\u30a1\u30a4\u30eb          \uff1a" + "@OUTPUTFILE_PATH@" + lineSeparator + "    \u5206\u5272\u5909\u63db\u6642\u5165\u529b\u30d5\u30a1\u30a4\u30eb\uff1a" + "@DIV_INPUTFILE_PATH@" + lineSeparator + "    \u5206\u5272\u5909\u63db\u6642\u51fa\u529b\u30d5\u30a1\u30a4\u30eb\uff1a" + "@DIV_OUTPUTFILE_PATH@" + lineSeparator + "    \u30d1\u30e9\u30e1\u30fc\u30bf            \uff1a" + "@PARAMETES@" + lineSeparator + "    \u30e1\u30c3\u30bb\u30fc\u30b8            \uff1a" + "@MESSAGES@" + lineSeparator;
    private static String footer = "--------------------------------------------------------------------------------";
    private StringBuffer logContent = new StringBuffer();

    public BizTranLogBuilder() {
        this.logContent.append(header);
        this.logContent.append(body);
        this.logContent.append(footer);
    }

    @Override
    public String getResult() {
        this.setDefault();
        return this.logContent.toString();
    }

    private void setDefault() {
        this.setExecuteTime(System.currentTimeMillis(), SimpleDateFormat.getDateTimeInstance());
        this.setStatusMessage("");
        this.setExitCode(0);
        this.setMapFilePath("");
        this.setInputFilePath("");
        this.setTableFilePath("");
        this.setDivPropPath("");
        this.setOutputFilePath("");
        this.setDivInputFilePath("");
        this.setDivOutputFilePath("");
        this.setParameters(new String[]{""});
        this.setMessages(new String[]{""});
    }

    @Override
    public void setExecuteTime(long time, DateFormat df) {
        Date date = new Date(time);
        String strDate = df.format(date);
        this.replace(EXEC_TIME, strDate);
    }

    @Override
    public void setStatusMessage(String stMsg) {
        this.replace(STATUS_MSG, stMsg);
    }

    @Override
    public void setExitCode(int exitCode) {
        this.replace(EXIT_CODE, Integer.toString(exitCode));
    }

    @Override
    public void setMapFilePath(String mapPath) {
        this.replace(MAPFILE_PATH, mapPath);
    }

    @Override
    public void setInputFilePath(String inputPath) {
        this.replace(INPUTFILE_PATH, inputPath);
    }

    @Override
    public void setTableFilePath(String tablePath) {
        this.replace(TABLEFILE_PATH, tablePath);
    }

    @Override
    public void setDivPropPath(String divpropPath) {
        this.replace(DIVPROP_PATH, divpropPath);
    }

    @Override
    public void setOutputFilePath(String outputPath) {
        this.replace(OUTPUTFILE_PATH, outputPath);
    }

    @Override
    public void setDivInputFilePath(String divInputPath) {
        this.replace(DIV_INPUTFILE_PATH, divInputPath);
    }

    @Override
    public void setDivOutputFilePath(String divOutputPath) {
        this.replace(DIV_OUTPUTFILE_PATH, divOutputPath);
    }

    @Override
    public void setParameters(String[] params) {
        this.replace(PARAMETES, BizTranLogBuilder.concatList(params, "", ", "));
    }

    @Override
    public void setMessages(String[] messages) {
        this.replace(MESSAGES, BizTranLogBuilder.concatList(messages, VALUE_OFFSET, lineSeparator));
    }

    private static String concatList(String[] values, String prefix, String sufix) {
        if (values == null || values.length == 0) {
            return "";
        }
        StringBuffer strBuf = new StringBuffer();
        for (int i = 0; i < values.length; ++i) {
            if (i != 0) {
                strBuf.append(prefix);
            }
            strBuf.append(values[i]);
            if (i == values.length - 1) continue;
            strBuf.append(sufix);
        }
        return strBuf.toString();
    }

    private void replace(String key, String value) {
        if (key == null) {
            return;
        }
        if (value == null) {
            return;
        }
        int beginIndex = this.logContent.toString().indexOf(key);
        int endIndex = 0;
        int len = 0;
        len = key.length();
        while (beginIndex != -1) {
            endIndex = beginIndex + len;
            this.logContent.replace(beginIndex, endIndex, value);
            beginIndex = this.logContent.toString().indexOf(key, endIndex + 1);
        }
    }
}

