/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.common.log.builder;

import com.argo21.common.log.AppMessage;
import com.argo21.common.log.builder.LogBuilder;
import com.argo21.common.log.builder.LogDirector;
import com.argo21.common.util.MappingInfo;
import java.text.SimpleDateFormat;
import java.util.ArrayList;

public class ExceptionLogDirector
extends LogDirector {
    private Throwable error = null;
    private AppMessage app = null;

    public ExceptionLogDirector(LogBuilder builder, MappingInfo mapInfo, AppMessage app, Throwable error) {
        super(builder, mapInfo);
        this.app = app;
        this.error = error;
    }

    @Override
    public void constract() {
        this.builder.setExecuteTime(System.currentTimeMillis(), SimpleDateFormat.getDateTimeInstance());
        this.builder.setStatusMessage("\u7570\u5e38\u7d42\u4e86");
        this.builder.setExitCode(this.app.getCode());
        this.builder.setMapFilePath(this.mapInfo.getMapFilePath());
        this.builder.setInputFilePath(this.mapInfo.getInputFilePath());
        this.builder.setTableFilePath(this.mapInfo.getTableFilePath());
        this.builder.setDivPropPath(this.mapInfo.getDividePropFilePath());
        this.builder.setOutputFilePath(this.mapInfo.getOutputFilePath());
        this.builder.setParameters(this.mapInfo.getParameters());
        ArrayList<String> errMsgList = new ArrayList<String>();
        errMsgList.add(this.app.getMessage());
        errMsgList.add(this.error.getClass().getName() + " : " + this.error.getLocalizedMessage());
        StackTraceElement[] stElem = this.error.getStackTrace();
        for (int i = 0; i < stElem.length; ++i) {
            errMsgList.add(stElem[i].toString());
        }
        for (Throwable cause = this.error.getCause(); cause != null; cause = cause.getCause()) {
            errMsgList.add("");
            errMsgList.add("Caused By " + cause.getClass().getName() + " : " + cause.getLocalizedMessage());
            stElem = cause.getStackTrace();
            for (int i = 0; i < stElem.length; ++i) {
                errMsgList.add(stElem[i].toString());
            }
        }
        this.builder.setMessages(errMsgList.toArray(new String[0]));
    }
}

