/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.common.log.writer;

import com.argo21.common.log.writer.LogFileWriter;
import java.io.IOException;

public class RetryLogFileWriter
extends LogFileWriter {
    private LogFileWriter logWriter = null;
    private int retryCnt = 10;
    private long interval = 500L;

    public RetryLogFileWriter(LogFileWriter logWriter, int retryCnt, long interval) {
        this.logWriter = logWriter;
        this.retryCnt = retryCnt;
        this.interval = interval;
    }

    @Override
    public void open() throws IOException {
        for (int i = 0; i < this.retryCnt; ++i) {
            try {
                this.logWriter.open();
                break;
            }
            catch (IOException e) {
                if (!this.canRetry(i)) {
                    throw e;
                }
                this.waitInterval();
                continue;
            }
        }
    }

    @Override
    public void write(String value) throws IOException {
        for (int i = 0; i < this.retryCnt; ++i) {
            try {
                this.logWriter.write(value);
                break;
            }
            catch (IOException e) {
                if (!this.canRetry(i)) {
                    throw e;
                }
                this.waitInterval();
                continue;
            }
        }
    }

    @Override
    public void close() throws IOException {
        for (int i = 0; i < this.retryCnt; ++i) {
            try {
                this.logWriter.close();
                break;
            }
            catch (IOException e) {
                if (!this.canRetry(i)) {
                    throw e;
                }
                this.waitInterval();
                continue;
            }
        }
    }

    @Override
    public String getName() {
        return this.logWriter.getName();
    }

    private boolean canRetry(int index) {
        return index < this.retryCnt - 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitInterval() {
        RetryLogFileWriter retryLogFileWriter = this;
        synchronized (retryLogFileWriter) {
            try {
                this.wait(this.interval);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

