/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.common.log.writer;

import com.argo21.common.log.writer.LogFileWriter;
import com.argo21.common.log.writer.ModifiedFileComparator;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Arrays;

public class RollingLogFileWriter
extends LogFileWriter {
    private LogFileWriter logWriter = null;
    private FilenameFilter filter = null;
    private String logDirectry = null;
    private int maxFileHistory = 5;
    private static Object mutex = new Object();

    public RollingLogFileWriter(LogFileWriter logWriter, FilenameFilter fileNameFilter, String logDirectry, int maxFileHistory) {
        this.logWriter = logWriter;
        this.filter = fileNameFilter;
        this.logDirectry = logDirectry;
        this.maxFileHistory = maxFileHistory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() throws IOException {
        Object object = mutex;
        synchronized (object) {
            int delFileCnt;
            File[] files = new File(this.logDirectry).listFiles(this.filter);
            if (files != null && files.length != 0 && (delFileCnt = files.length - (this.maxFileHistory - 1)) > 0) {
                Arrays.sort(files, new ModifiedFileComparator());
                for (int i = 0; i < delFileCnt; ++i) {
                    files[i].delete();
                }
            }
        }
        this.logWriter.open();
    }

    @Override
    public String getName() {
        return this.logWriter.getName();
    }

    @Override
    public void write(String value) throws IOException {
        this.logWriter.write(value);
    }

    @Override
    public void close() throws IOException {
        this.logWriter.close();
    }
}

