/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.common.log.writer;

import com.argo21.common.log.WriterMode;
import com.argo21.common.log.writer.LogFileWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import org.apache.commons.io.IOUtils;

public class SimpleLogFileWriter
extends LogFileWriter {
    private String fileName = null;
    private WriterMode mode = WriterMode.APPEND;

    public SimpleLogFileWriter(String fileName, WriterMode mode) {
        this.fileName = fileName;
        this.mode = mode;
    }

    @Override
    public synchronized void open() throws IOException {
        File file = new File(this.fileName);
        if (this.isExistSameLogFile(this.fileName)) {
            if (this.mode == WriterMode.ERROR) {
                throw new IOException("\u540c\u540d\u306e\u30ed\u30b0\u30d5\u30a1\u30a4\u30eb\u304c\u65e2\u306b\u5b58\u5728\u3057\u3066\u3044\u307e\u3059\u3002" + file.getAbsoluteFile());
            }
        } else {
            File parentDir = file.getParentFile();
            boolean isNewDir = true;
            if (!parentDir.exists()) {
                isNewDir = parentDir.mkdirs();
            }
            if (!isNewDir) {
                throw new IOException("\u30ed\u30b0\u30d5\u30a1\u30a4\u30eb\u306e\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u4f5c\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002" + parentDir.getAbsoluteFile());
            }
            boolean isNewFile = file.createNewFile();
            if (!isNewFile) {
                throw new IOException("\u30ed\u30b0\u30d5\u30a1\u30a4\u30eb\u306e\u4f5c\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002" + file.getAbsoluteFile());
            }
        }
    }

    @Override
    public synchronized void write(String value) throws IOException {
        File file = new File(this.fileName);
        FileWriter fw = null;
        PrintWriter pw = null;
        try {
            fw = new FileWriter(file, this.mode.getAppendMode());
            pw = new PrintWriter(fw);
            pw.println(value);
            pw.flush();
            fw.flush();
        }
        catch (IOException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(pw);
                IOUtils.closeQuietly(fw);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Writer)pw);
        IOUtils.closeQuietly((Writer)fw);
        this.mode = WriterMode.APPEND;
    }

    @Override
    public String getName() {
        return this.fileName;
    }

    @Override
    public synchronized void close() throws IOException {
    }

    private boolean isExistSameLogFile(String filePath) {
        File file = new File(filePath);
        String parentPath = file.getParent();
        String fileName = file.getName();
        return file.exists() || new File(parentPath + "/OK_" + fileName).exists() || new File(parentPath + "/NG_" + fileName).exists();
    }
}

