/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.common.log.writer;

import com.argo21.common.log.WriterMode;
import com.argo21.common.log.writer.LogFileWriter;
import com.argo21.common.log.writer.SimpleLogFileWriter;
import com.argo21.common.util.ProcessIdGetter;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Date;

public class TimeLogFileWriter
extends LogFileWriter {
    private String logFilePath = null;
    private String logFileExt = null;
    private DateFormat format = null;
    private SimpleLogFileWriter writer = null;

    public TimeLogFileWriter(String logFilePath, String logFileExt, DateFormat format) {
        this.logFilePath = logFilePath;
        this.logFileExt = logFileExt;
        this.format = format;
    }

    @Override
    public void open() throws IOException {
        while (true) {
            long pid = ProcessIdGetter.getProcessId();
            File file = new File(this.logFilePath, this.format.format(new Date(System.currentTimeMillis())) + "_" + pid + this.logFileExt);
            String fileName = file.getAbsolutePath();
            this.writer = new SimpleLogFileWriter(fileName, WriterMode.ERROR);
            try {
                this.writer.open();
                break;
            }
            catch (IOException e) {
                if (!file.exists()) {
                    throw e;
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e1) {
                    throw new IOException(e1.getMessage());
                }
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }

    @Override
    public String getName() {
        return this.writer.getName();
    }

    @Override
    public void write(String value) throws IOException {
        this.writer.write(value);
    }
}

