/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.common.security;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.spec.DSAPrivateKeySpec;
import java.security.spec.DSAPublicKeySpec;

public class FileSignature {
    public static void main(String[] args) {
        if (args.length < 3) {
            System.out.println("java com.argo21.common.security.Signature -make[-parse],\u5165\u529b\u30d5\u30a1\u30a4\u30eb,\u51fa\u529b\u30d5\u30a1\u30a4\u30eb");
            System.exit(0);
        }
        if (args[0].equals("-make")) {
            FileSignature.make(args[1], args[2]);
        } else if (args[0].equals("-parse")) {
            FileSignature.parse(args[1], args[2]);
        } else {
            System.out.println("java com.argo21.common.security.Signature -make[-parse],\u5165\u529b\u30d5\u30a1\u30a4\u30eb,\u51fa\u529b\u30d5\u30a1\u30a4\u30eb");
        }
        System.exit(0);
    }

    private static void make(String inFile, String outFile) {
        File inf = new File(inFile);
        if (!(inf.exists() && inf.isFile() && inf.canRead())) {
            System.out.println("\u5165\u529b\u30d5\u30a1\u30a4\u30eb\u306e\u6307\u5b9a\u304c\u9055\u3044\u307e\u3059");
            return;
        }
        int n = (int)inf.length();
        byte[] data = new byte[n];
        try {
            FileInputStream in = new FileInputStream(inf);
            in.read(data, 0, n);
            in.close();
        }
        catch (Exception e) {
            System.out.println(e);
        }
        data = FileSignature.makeBASE64(data);
        n = data.length;
        String strx = "934b0d8f4191e24a3f274c03c80a70df356013b9";
        String strp = "fca682ce8e12caba26efccf7110e526db078b05edecbcd1eb4a208f3ae1617ae01f35b91a47e6df63413c5e12ed0899bcd132acd50d99151bdc43ee737592e17";
        String strq = "962eddcc369cba8ebb260ee6b6a126d9346e38c5";
        String strg = "678471b27a9cf44ee91a49c5147db1a9aaf244f05a434d6486931d2d14271b9e35030b71fd73da179069b32e2935630e1c2062354d0da20a6c416e50be794ca4";
        BigInteger x = new BigInteger(strx, 16);
        BigInteger p = new BigInteger(strp, 16);
        BigInteger q = new BigInteger(strq, 16);
        BigInteger g = new BigInteger(strg, 16);
        try {
            KeyPairGenerator kpgen = KeyPairGenerator.getInstance("DSA");
            SecureRandom random = SecureRandom.getInstance("SHA1PRNG", "SUN");
            random.setSeed(19511212L);
            kpgen.initialize(512, random);
            KeyPair kpair = kpgen.generateKeyPair();
            DSAPrivateKey dsaprikey = (DSAPrivateKey)kpair.getPrivate();
            DSAPublicKey dsapubkey = (DSAPublicKey)kpair.getPublic();
            DSAParams pqg = dsaprikey.getParams();
            BigInteger xx = dsaprikey.getX();
            BigInteger pp = pqg.getP();
            BigInteger qq = pqg.getQ();
            BigInteger gg = pqg.getG();
            pqg = dsapubkey.getParams();
            BigInteger yy = dsapubkey.getY();
            pp = pqg.getP();
            qq = pqg.getQ();
            gg = pqg.getG();
            KeyFactory keyFactory = KeyFactory.getInstance("DSA");
            DSAPrivateKeySpec priKeySpec = new DSAPrivateKeySpec(x, p, q, g);
            PrivateKey prikey = keyFactory.generatePrivate(priKeySpec);
            Signature signature = Signature.getInstance("DSA");
            signature.initSign(prikey);
            signature.update(data);
            byte[] sign = signature.sign();
            FileOutputStream out = new FileOutputStream(outFile);
            out.write((byte)(n & 0xFF));
            out.write((byte)(n >> 8 & 0xFF));
            out.write(data);
            out.write(sign);
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        byte[] data1 = FileSignature.verifySignatureAndGetData(outFile);
        data1 = FileSignature.parseBASE64(data1);
        if (data1 != null) {
            System.out.println("\u30d5\u30a1\u30a4\u30eb\u306f\u6b63\u3057\u304f\u7f72\u540d\u3055\u308c\u307e\u3057\u305f");
        } else {
            System.out.println("\u30d5\u30a1\u30a4\u30eb\u306f\u6b63\u3057\u304f\u7f72\u540d\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        }
    }

    private static void parse(String inFile, String outFile) {
        byte[] data1 = FileSignature.verifySignatureAndGetData(inFile);
        if ((data1 = FileSignature.parseBASE64(data1)) != null) {
            System.out.println("\u30d5\u30a1\u30a4\u30eb\u306f\u6b63\u3057\u304f\u89e3\u6790\u3055\u308c\u307e\u3057\u305f");
        } else {
            System.out.println("\u30d5\u30a1\u30a4\u30eb\u306f\u89e3\u6790\u3067\u304d\u307e\u305b\u3093");
        }
        try {
            FileOutputStream out = new FileOutputStream(outFile);
            out.write(data1);
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static byte[] verifySignatureAndGetData(String filename) {
        byte[] digest = null;
        byte[] signature = null;
        String stry = "5bb1af241fd6c7ec22fccdfaf73e3d2aa6521d0c41535f9edf9e8bd8b3055dc0a3f93def24e0e10b9da305b3fa6eb72b95be22aa7db30b91d7c5d18cb6e7c769";
        String strp = "fca682ce8e12caba26efccf7110e526db078b05edecbcd1eb4a208f3ae1617ae01f35b91a47e6df63413c5e12ed0899bcd132acd50d99151bdc43ee737592e17";
        String strq = "962eddcc369cba8ebb260ee6b6a126d9346e38c5";
        String strg = "678471b27a9cf44ee91a49c5147db1a9aaf244f05a434d6486931d2d14271b9e35030b71fd73da179069b32e2935630e1c2062354d0da20a6c416e50be794ca4";
        BigInteger y = new BigInteger(stry, 16);
        BigInteger p = new BigInteger(strp, 16);
        BigInteger q = new BigInteger(strq, 16);
        BigInteger g = new BigInteger(strg, 16);
        File inf = new File(filename);
        if (!(inf.exists() && inf.isFile() && inf.canRead())) {
            System.out.println("\u5165\u529b\u30d5\u30a1\u30a4\u30eb\u306e\u6307\u5b9a\u304c\u9055\u3044\u307e\u3059");
        }
        try {
            FileInputStream in = new FileInputStream(inf);
            int byte1 = in.read();
            int byte2 = in.read();
            int n = byte2 << 8 | byte1 & 0xFF;
            digest = new byte[n];
            in.read(digest, 0, n);
            n = (int)inf.length() - 2 - n;
            signature = new byte[n];
            in.read(signature, 0, n);
            in.close();
            DSAPublicKeySpec pubKeySpec = new DSAPublicKeySpec(y, p, q, g);
            KeyFactory keyFactory = KeyFactory.getInstance("DSA");
            PublicKey pubkey = keyFactory.generatePublic(pubKeySpec);
            Signature sign = Signature.getInstance("DSA");
            sign.initVerify(pubkey);
            sign.update(digest);
            if (!sign.verify(signature)) {
                return null;
            }
            return digest;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static byte[] makeBASE64(byte[] bytes) {
        int m = bytes.length;
        int mm = m % 3;
        mm = mm == 1 ? m + 2 : (mm == 2 ? m + 1 : m);
        int len = mm * 8 / 6;
        byte[] newbytes = new byte[len];
        int k1 = 0;
        int k2 = 0;
        while (k1 < mm) {
            byte b1 = bytes[k1];
            byte b2 = k1 + 1 < m ? bytes[k1 + 1] : (byte)0;
            byte b3 = k1 + 2 < m ? bytes[k1 + 2] : (byte)0;
            newbytes[k2] = (byte)(b1 >> 2 & 0x3F);
            newbytes[k2 + 1] = (byte)(b1 << 4 & 0x30 | b2 >> 4 & 0xF);
            newbytes[k2 + 2] = (byte)(b2 << 2 & 0x3C | b3 >> 6 & 3);
            newbytes[k2 + 3] = (byte)(b3 & 0x3F);
            k1 += 3;
            k2 += 4;
        }
        for (int i = 0; i < len; ++i) {
            if (newbytes[i] == 62) {
                newbytes[i] = 43;
                continue;
            }
            if (newbytes[i] == 63) {
                newbytes[i] = 47;
                continue;
            }
            if (newbytes[i] == 0) {
                newbytes[i] = 61;
                continue;
            }
            if (newbytes[i] <= 25) {
                int n = i;
                newbytes[n] = (byte)(newbytes[n] + 65);
                continue;
            }
            if (newbytes[i] <= 51) {
                int n = i;
                newbytes[n] = (byte)(newbytes[n] + 71);
                continue;
            }
            if (newbytes[i] <= 61) {
                int n = i;
                newbytes[n] = (byte)(newbytes[n] - 4);
                continue;
            }
            newbytes[i] = 0;
        }
        return newbytes;
    }

    private static byte[] parseBASE64(byte[] bytes) {
        for (int i = 0; i < bytes.length; ++i) {
            if (bytes[i] == 43) {
                bytes[i] = 62;
                continue;
            }
            if (bytes[i] == 47) {
                bytes[i] = 63;
                continue;
            }
            if (bytes[i] == 61) {
                bytes[i] = 0;
                continue;
            }
            if (bytes[i] <= 57) {
                int n = i;
                bytes[n] = (byte)(bytes[n] + 4);
                continue;
            }
            if (bytes[i] <= 90) {
                int n = i;
                bytes[n] = (byte)(bytes[n] - 65);
                continue;
            }
            if (bytes[i] <= 122) {
                int n = i;
                bytes[n] = (byte)(bytes[n] - 71);
                continue;
            }
            bytes[i] = 0;
        }
        int len = bytes.length * 6 / 8;
        byte[] newbytes = new byte[len];
        int k1 = 0;
        int k2 = 0;
        while (k1 < len) {
            newbytes[k1] = (byte)(bytes[k2] << 2 | bytes[k2 + 1] >> 4);
            newbytes[k1 + 1] = (byte)(bytes[k2 + 1] << 4 | bytes[k2 + 2] >> 2);
            newbytes[k1 + 2] = (byte)(bytes[k2 + 2] << 6 | bytes[k2 + 3]);
            k1 += 3;
            k2 += 4;
        }
        while (len > 0 && newbytes[len - 1] == 0) {
            --len;
        }
        if (newbytes.length > len) {
            byte[] newbytes1 = new byte[len];
            System.arraycopy(newbytes, 0, newbytes1, 0, len);
            return newbytes1;
        }
        return newbytes;
    }
}

