/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.common.security;

import java.io.File;
import java.io.FileInputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.DSAPublicKeySpec;
import java.util.Properties;
import java.util.StringTokenizer;

public final class LicenceKeys {
    public static Properties ps = null;

    public static Properties loadKeys(File file) {
        ps = new Properties();
        if (file.exists() && file.isFile() && file.canRead()) {
            byte[] data = LicenceKeys.verifySignatureAndGetData(file);
            if ((data = LicenceKeys.parseBASE64(data)) == null) {
                return ps;
            }
            try {
                String ss = "";
                try {
                    ss = new String(data, "SJIS");
                }
                catch (UnsupportedEncodingException e) {
                    ss = new String(data);
                }
                StringTokenizer sz = new StringTokenizer(ss, "|");
                while (sz.hasMoreElements()) {
                    String s = (String)sz.nextElement();
                    int k = s.indexOf("=");
                    if (k <= 0) continue;
                    ps.setProperty(s.substring(0, k).trim(), s.substring(k + 1).trim());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return ps;
    }

    private static byte[] verifySignatureAndGetData(File inf) {
        byte[] digest = null;
        byte[] signature = null;
        String stry = "5bb1af241fd6c7ec22fccdfaf73e3d2aa6521d0c41535f9edf9e8bd8b3055dc0a3f93def24e0e10b9da305b3fa6eb72b95be22aa7db30b91d7c5d18cb6e7c769";
        String strp = "fca682ce8e12caba26efccf7110e526db078b05edecbcd1eb4a208f3ae1617ae01f35b91a47e6df63413c5e12ed0899bcd132acd50d99151bdc43ee737592e17";
        String strq = "962eddcc369cba8ebb260ee6b6a126d9346e38c5";
        String strg = "678471b27a9cf44ee91a49c5147db1a9aaf244f05a434d6486931d2d14271b9e35030b71fd73da179069b32e2935630e1c2062354d0da20a6c416e50be794ca4";
        BigInteger y = new BigInteger(stry, 16);
        BigInteger p = new BigInteger(strp, 16);
        BigInteger q = new BigInteger(strq, 16);
        BigInteger g = new BigInteger(strg, 16);
        if (!(inf.exists() && inf.isFile() && inf.canRead())) {
            System.out.println("\u5165\u529b\u30d5\u30a1\u30a4\u30eb\u306e\u6307\u5b9a\u304c\u9055\u3044\u307e\u3059");
        }
        try {
            FileInputStream in = new FileInputStream(inf);
            int byte1 = in.read();
            int byte2 = in.read();
            int n = byte2 << 8 | byte1 & 0xFF;
            digest = new byte[n];
            in.read(digest, 0, n);
            n = (int)inf.length() - 2 - n;
            signature = new byte[n];
            in.read(signature, 0, n);
            in.close();
            DSAPublicKeySpec pubKeySpec = new DSAPublicKeySpec(y, p, q, g);
            KeyFactory keyFactory = KeyFactory.getInstance("DSA");
            PublicKey pubkey = keyFactory.generatePublic(pubKeySpec);
            Signature sign = Signature.getInstance("DSA");
            sign.initVerify(pubkey);
            sign.update(digest);
            if (!sign.verify(signature)) {
                return null;
            }
            return digest;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static byte[] parseBASE64(byte[] bytes) {
        for (int i = 0; i < bytes.length; ++i) {
            if (bytes[i] == 43) {
                bytes[i] = 62;
                continue;
            }
            if (bytes[i] == 47) {
                bytes[i] = 63;
                continue;
            }
            if (bytes[i] == 61) {
                bytes[i] = 0;
                continue;
            }
            if (bytes[i] <= 57) {
                int n = i;
                bytes[n] = (byte)(bytes[n] + 4);
                continue;
            }
            if (bytes[i] <= 90) {
                int n = i;
                bytes[n] = (byte)(bytes[n] - 65);
                continue;
            }
            if (bytes[i] <= 122) {
                int n = i;
                bytes[n] = (byte)(bytes[n] - 71);
                continue;
            }
            bytes[i] = 0;
        }
        int len = bytes.length * 6 / 8;
        byte[] newbytes = new byte[len];
        int k1 = 0;
        int k2 = 0;
        while (k1 < len) {
            newbytes[k1] = (byte)(bytes[k2] << 2 | bytes[k2 + 1] >> 4);
            newbytes[k1 + 1] = (byte)(bytes[k2 + 1] << 4 | bytes[k2 + 2] >> 2);
            newbytes[k1 + 2] = (byte)(bytes[k2 + 2] << 6 | bytes[k2 + 3]);
            k1 += 3;
            k2 += 4;
        }
        while (len > 0 && newbytes[len - 1] == 0) {
            --len;
        }
        if (newbytes.length > len) {
            byte[] newbytes1 = new byte[len];
            System.arraycopy(newbytes, 0, newbytes1, 0, len);
            return newbytes1;
        }
        return newbytes;
    }
}

