/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.common.util;

import com.argo21.common.util.SimpleFileFilter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public class AdaptiveClassLoader
extends ClassLoader {
    private static int generationCounter = 0;
    private int generation;
    private Hashtable cache;
    private Vector repository;

    public AdaptiveClassLoader(String paths, ClassLoader parent) throws IllegalArgumentException {
        this(AdaptiveClassLoader.stringToVector(paths), parent);
    }

    public AdaptiveClassLoader(String[] paths, ClassLoader parent) throws IllegalArgumentException {
        this(AdaptiveClassLoader.stringArrayToVector(paths), parent, false);
    }

    public AdaptiveClassLoader(String[] paths, ClassLoader parent, boolean ignorePathError) throws IllegalArgumentException {
        this(AdaptiveClassLoader.stringArrayToVector(paths), parent, ignorePathError);
    }

    public AdaptiveClassLoader(Vector classRepository) throws IllegalArgumentException {
        this.init(classRepository, false);
    }

    public AdaptiveClassLoader(Vector classRepository, ClassLoader parent) throws IllegalArgumentException {
        this(classRepository, parent, false);
    }

    public AdaptiveClassLoader(Vector classRepository, ClassLoader parent, boolean ignorePathError) throws IllegalArgumentException {
        super(parent);
        this.init(classRepository, ignorePathError);
    }

    private void init(Vector classRepository, boolean ignorePathError) throws IllegalArgumentException {
        this.cache = new Hashtable();
        this.repository = new Vector();
        Enumeration e = classRepository.elements();
        while (e.hasMoreElements()) {
            File file;
            Object o = e.nextElement();
            try {
                file = (File)o;
            }
            catch (ClassCastException objectIsNotFile) {
                if (ignorePathError) continue;
                throw new IllegalArgumentException("Object " + o + "is not a valid \"File\" instance");
            }
            String[] files = SimpleFileFilter.fileOrFiles(file);
            if (files == null) continue;
            for (int i = 0; i < files.length; ++i) {
                file = new File(files[i]);
                if (!file.exists()) {
                    if (!ignorePathError) {
                        throw new IllegalArgumentException("Repository " + file.getAbsolutePath() + " doesn't exist!");
                    }
                } else if (!file.canRead() && !ignorePathError) {
                    throw new IllegalArgumentException("Do not have read access for file " + file.getAbsolutePath());
                }
                if (file.isDirectory() || this.isZipOrJarArchive(file) || ignorePathError) continue;
                throw new IllegalArgumentException(file.getAbsolutePath() + " is not a directory or zip/jar file or if it's a zip/jar file then it is corrupted.");
            }
            this.repository.addElement(file);
        }
        this.generation = generationCounter++;
    }

    public static Vector stringToVector(String paths) {
        Vector<File> files = new Vector<File>();
        StringTokenizer sz = new StringTokenizer(paths, ";");
        while (sz.hasMoreElements()) {
            String fname = (String)sz.nextElement();
            File file = new File(fname);
            if (!file.exists() || !file.canRead()) {
                System.out.println(fname + " dosn't exists or can't read !");
            }
            files.addElement(file);
        }
        return files;
    }

    public static Vector stringArrayToVector(String[] paths) {
        Vector<File> files = new Vector<File>();
        for (int i = 0; i < paths.length; ++i) {
            File file = new File(paths[i]);
            if (!file.exists() || !file.canRead()) {
                System.out.println(paths[i] + " dosn't exists or can't read !");
            }
            files.addElement(file);
        }
        return files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isZipOrJarArchive(File file) {
        boolean isArchive = true;
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(file);
        }
        catch (ZipException zipCurrupted) {
            isArchive = false;
        }
        catch (IOException anyIOError) {
            isArchive = false;
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException zipCurrupted) {}
            }
        }
        return isArchive;
    }

    public synchronized boolean shouldReload(String classname) {
        ClassCacheEntry entry = (ClassCacheEntry)this.cache.get(classname);
        if (entry == null) {
            return false;
        }
        if (entry.isSystemClass()) {
            return false;
        }
        boolean reload = entry.origin.lastModified() != entry.lastModified;
        return reload;
    }

    public synchronized boolean shouldReload() {
        Enumeration e = this.cache.elements();
        while (e.hasMoreElements()) {
            ClassCacheEntry entry = (ClassCacheEntry)e.nextElement();
            if (entry.isSystemClass()) continue;
            long msOrigin = entry.origin.lastModified();
            if (msOrigin == 0L) {
                return true;
            }
            if (msOrigin == entry.lastModified) continue;
            return true;
        }
        return false;
    }

    public AdaptiveClassLoader reinstantiate() {
        return new AdaptiveClassLoader(this.repository);
    }

    protected synchronized Class loadClass(String name2, boolean resolve) throws ClassNotFoundException {
        Class<?> c = null;
        ClassCacheEntry entry = (ClassCacheEntry)this.cache.get(name2);
        if (entry != null) {
            c = entry.loadedClass;
            if (resolve) {
                this.resolveClass(c);
            }
            return c;
        }
        if (!this.securityAllowsClass(name2)) {
            return this.loadSystemClass(name2, resolve);
        }
        try {
            ClassLoader parent = this.getParent();
            c = parent != null ? parent.loadClass(name2) : this.loadSystemClass(name2, resolve);
            if (c != null) {
                if (resolve) {
                    this.resolveClass(c);
                }
                return c;
            }
        }
        catch (Exception e) {
            c = null;
        }
        Enumeration repEnum = this.repository.elements();
        ClassCacheEntry classCache = new ClassCacheEntry();
        while (repEnum.hasMoreElements()) {
            byte[] classData = null;
            File file = (File)repEnum.nextElement();
            try {
                classData = file.isDirectory() ? this.loadClassFromDirectory(file, name2, classCache) : this.loadClassFromZipfile(file, name2, classCache);
            }
            catch (IOException ioe) {
                classData = null;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            if (classData == null) continue;
            classCache.loadedClass = c = this.defineClass(name2, classData, 0, classData.length);
            classCache.lastModified = classCache.origin.lastModified();
            this.cache.put(name2, classCache);
            if (resolve) {
                this.resolveClass(c);
            }
            return c;
        }
        throw new ClassNotFoundException(name2);
    }

    private Class loadSystemClass(String name2, boolean resolve) throws NoClassDefFoundError, ClassNotFoundException {
        Class<?> c = this.findSystemClass(name2);
        ClassCacheEntry cacheEntry = new ClassCacheEntry();
        cacheEntry.origin = null;
        cacheEntry.loadedClass = c;
        cacheEntry.lastModified = Long.MAX_VALUE;
        this.cache.put(name2, cacheEntry);
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }

    private boolean securityAllowsClass(String className) {
        try {
            SecurityManager security = System.getSecurityManager();
            if (security == null) {
                return true;
            }
            int lastDot = className.lastIndexOf(46);
            security.checkPackageDefinition(lastDot > -1 ? className.substring(0, lastDot) : "");
            return true;
        }
        catch (SecurityException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] loadClassFromDirectory(File dir, String name2, ClassCacheEntry cache) throws IOException {
        File classFile;
        String classFileName = name2.replace('.', File.separatorChar) + ".class";
        if (!Character.isJavaIdentifierStart(classFileName.charAt(0))) {
            int start = 1;
            while (!Character.isJavaIdentifierStart(classFileName.charAt(start++))) {
            }
            classFileName = classFileName.substring(start);
        }
        if ((classFile = new File(dir, classFileName)).exists()) {
            cache.origin = classFile;
            try (FileInputStream in = new FileInputStream(classFile);){
                byte[] byArray = this.loadBytesFromStream(in, (int)classFile.length());
                return byArray;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] loadClassFromZipfile(File file, String name2, ClassCacheEntry cache) throws IOException {
        String classFileName = name2.replace('.', '/') + ".class";
        try (ZipFile zipfile = new ZipFile(file);){
            ZipEntry entry = zipfile.getEntry(classFileName);
            if (entry != null) {
                cache.origin = file;
                byte[] byArray = this.loadBytesFromStream(zipfile.getInputStream(entry), (int)entry.getSize());
                return byArray;
            }
            byte[] byArray = null;
            return byArray;
        }
    }

    private byte[] loadBytesFromStream(InputStream in, int length) throws IOException {
        int nRead;
        byte[] buf = new byte[length];
        int count2 = 0;
        while (length > 0 && (nRead = in.read(buf, count2, length)) != -1) {
            count2 += nRead;
            length -= nRead;
        }
        return buf;
    }

    @Override
    public InputStream getResourceAsStream(String name2) {
        InputStream s = AdaptiveClassLoader.getSystemResourceAsStream(name2);
        if (s == null) {
            Enumeration repEnum = this.repository.elements();
            while (repEnum.hasMoreElements()) {
                File file = (File)repEnum.nextElement();
                if (file.isDirectory()) {
                    s = this.loadResourceFromDirectory(file, name2);
                } else if (name2.endsWith(".initArgs")) {
                    File dir = new File(file.getParent());
                    s = this.loadResourceFromDirectory(dir, name2);
                } else {
                    s = this.loadResourceFromZipfile(file, name2);
                }
                if (s == null) continue;
                break;
            }
        }
        return s;
    }

    private InputStream loadResourceFromDirectory(File dir, String name2) {
        String fileName = name2.replace('/', File.separatorChar);
        File resFile = new File(dir, fileName);
        if (resFile.exists()) {
            try {
                return new FileInputStream(resFile);
            }
            catch (FileNotFoundException shouldnothappen) {
                return null;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStream loadResourceFromZipfile(File file, String name2) {
        ZipFile zipfile = null;
        try {
            byte[] data;
            zipfile = new ZipFile(file);
            ZipEntry entry = zipfile.getEntry(name2);
            if (entry != null && (data = this.loadBytesFromStream(zipfile.getInputStream(entry), (int)entry.getSize())) != null) {
                ByteArrayInputStream istream;
                ByteArrayInputStream byteArrayInputStream = istream = new ByteArrayInputStream(data);
                return byteArrayInputStream;
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (zipfile != null) {
                try {
                    zipfile.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    @Override
    public URL getResource(String name2) {
        URL u = AdaptiveClassLoader.getSystemResource(name2);
        if (u != null) {
            return u;
        }
        if (name2 == null) {
            return null;
        }
        Enumeration repEnum = this.repository.elements();
        while (repEnum.hasMoreElements()) {
            File file = (File)repEnum.nextElement();
            if (file.isDirectory()) {
                String fileName = name2.replace('/', File.separatorChar);
                File resFile = new File(file, fileName);
                if (!resFile.exists()) continue;
                try {
                    return new URL("file", null, resFile.getAbsolutePath());
                }
                catch (MalformedURLException badurl) {
                    badurl.printStackTrace();
                    return null;
                }
            }
            try {
                ZipFile zf = new ZipFile(file.getAbsolutePath());
                ZipEntry ze = zf.getEntry(name2);
                if (ze == null) continue;
                try {
                    return new URL("jar:file:" + file.getAbsolutePath() + "!/" + name2);
                }
                catch (MalformedURLException badurl) {
                    badurl.printStackTrace();
                    return null;
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                return null;
            }
        }
        return null;
    }

    private static class ClassCacheEntry {
        Class loadedClass;
        File origin;
        long lastModified;

        private ClassCacheEntry() {
        }

        public boolean isSystemClass() {
            return this.origin == null;
        }
    }
}

