/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.common.util;

import com.argo21.common.util.BizTranCacheNodeSet;
import com.argo21.jxp.xpath.Expr;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import org.w3c.dom.Node;

public class BizTranCache {
    private static Map nodeCache = Collections.synchronizedMap(new HashMap());
    private static Map lineCache = Collections.synchronizedMap(new HashMap());
    private static Map exprCache = Collections.synchronizedMap(new HashMap());
    private static Stack nodeNameStack = new Stack();

    public static void init() {
        nodeCache.clear();
        lineCache.clear();
        exprCache.clear();
        nodeNameStack.clear();
    }

    public static void setExpr(String xpath, int num, Expr expr) {
        exprCache.put(xpath + ":" + num, expr);
    }

    public static Expr getExpr(String xpath, int num) {
        return (Expr)exprCache.get(xpath + ":" + num);
    }

    public static void setNode(Node node) {
        String key = BizTranCache.getXPath();
        int depth = 0;
        int index = -1;
        while ((index = key.indexOf("/", index + 1)) != -1) {
            ++depth;
        }
        nodeCache.put(key, new BizTranCacheNodeSet(node, depth));
    }

    public static BizTranCacheNodeSet getNode(String key, String baseName) {
        BizTranCacheNodeSet nodeSet = (BizTranCacheNodeSet)nodeCache.get(baseName.concat("/").concat(key));
        int slashIndex = key.lastIndexOf(47);
        while (nodeSet == null && slashIndex != -1) {
            key = key.substring(0, slashIndex);
            nodeSet = (BizTranCacheNodeSet)nodeCache.get(baseName.concat("/").concat(key));
            slashIndex = key.lastIndexOf(47);
        }
        nodeNameStack.clear();
        nodeNameStack.add(baseName);
        if (nodeSet == null) {
            return new BizTranCacheNodeSet(null, 0);
        }
        nodeNameStack.add(key);
        return nodeSet;
    }

    public static void setLine(String nodeName, int first, int num) {
        lineCache.put(nodeName + first, new Integer(num));
    }

    public static int getLine(String nodeName, int first) {
        Integer i = (Integer)lineCache.get(nodeName + first);
        if (i == null) {
            return 0;
        }
        return i;
    }

    public static void setXPath(String path) {
        nodeNameStack.add(path);
    }

    public static void popXPath() {
        nodeNameStack.pop();
    }

    public static String getXPath() {
        if (nodeNameStack.empty()) {
            return null;
        }
        StringBuffer xPath = new StringBuffer();
        Iterator i = nodeNameStack.iterator();
        while (i.hasNext()) {
            xPath.append((String)i.next()).append("/");
        }
        xPath.deleteCharAt(xPath.length() - 1);
        return xPath.toString();
    }

    public static void clearXPath() {
        nodeNameStack.clear();
    }
}

