/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.common.util;

import com.argo21.common.util.AttributeInfo;
import com.argo21.common.util.ConstantPoolInfo;
import com.argo21.common.util.FieldInfo;
import com.argo21.common.util.MethodInfo;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;

public class ClassFile {
    int magic;
    short majorVersion;
    short minorVersion;
    ConstantPoolInfo[] constantPool;
    short accessFlags;
    ConstantPoolInfo thisClass;
    ConstantPoolInfo superClass;
    ConstantPoolInfo[] interfaces;
    FieldInfo[] fields;
    MethodInfo[] methods;
    AttributeInfo[] attributes;
    boolean isValidClass = false;
    public static final int ACC_PUBLIC = 1;
    public static final int ACC_PRIVATE = 2;
    public static final int ACC_PROTECTED = 4;
    public static final int ACC_STATIC = 8;
    public static final int ACC_FINAL = 16;
    public static final int ACC_SYNCHRONIZED = 32;
    public static final int ACC_THREADSAFE = 64;
    public static final int ACC_TRANSIENT = 128;
    public static final int ACC_NATIVE = 256;
    public static final int ACC_INTERFACE = 512;
    public static final int ACC_ABSTRACT = 1024;
    public boolean debug = false;
    public boolean dumpConstants = false;

    public boolean read(InputStream in) throws IOException {
        int i;
        DataInputStream di = new DataInputStream(in);
        this.magic = di.readInt();
        if (this.magic != -889275714) {
            return false;
        }
        this.majorVersion = di.readShort();
        this.minorVersion = di.readShort();
        int count2 = di.readShort();
        this.constantPool = new ConstantPoolInfo[count2];
        if (this.debug) {
            System.out.println("read(): Read header...");
        }
        this.constantPool[0] = new ConstantPoolInfo();
        for (i = 1; i < this.constantPool.length; ++i) {
            this.constantPool[i] = new ConstantPoolInfo();
            if (!this.constantPool[i].read(di)) {
                return false;
            }
            if (this.constantPool[i].type != 5 && this.constantPool[i].type != 6) continue;
            ++i;
        }
        for (i = 1; i < this.constantPool.length; ++i) {
            if (this.constantPool[i] == null) continue;
            if (this.constantPool[i].index1 > 0) {
                this.constantPool[i].arg1 = this.constantPool[this.constantPool[i].index1];
            }
            if (this.constantPool[i].index2 <= 0) continue;
            this.constantPool[i].arg2 = this.constantPool[this.constantPool[i].index2];
        }
        if (this.dumpConstants) {
            for (i = 1; i < this.constantPool.length; ++i) {
                System.out.println("C" + i + " - " + this.constantPool[i]);
            }
        }
        this.accessFlags = di.readShort();
        this.thisClass = this.constantPool[di.readShort()];
        this.superClass = this.constantPool[di.readShort()];
        if (this.debug) {
            System.out.println("read(): Read class info...");
        }
        if ((count2 = di.readShort()) != 0) {
            if (this.debug) {
                System.out.println("Class implements " + count2 + " interfaces.");
            }
            this.interfaces = new ConstantPoolInfo[count2];
            for (i = 0; i < count2; ++i) {
                short iindex = di.readShort();
                if (iindex < 1 || iindex > this.constantPool.length - 1) {
                    return false;
                }
                this.interfaces[i] = this.constantPool[iindex];
                if (!this.debug) continue;
                System.out.println("I" + i + ": " + this.interfaces[i]);
            }
        }
        if (this.debug) {
            System.out.println("read(): Read interface info...");
        }
        count2 = di.readShort();
        if (this.debug) {
            System.out.println("This class has " + count2 + " fields.");
        }
        if (count2 != 0) {
            this.fields = new FieldInfo[count2];
            for (i = 0; i < count2; ++i) {
                this.fields[i] = new FieldInfo();
                if (!this.fields[i].read(di, this.constantPool)) {
                    return false;
                }
                if (!this.debug) continue;
                System.out.println("F" + i + ": " + this.fields[i].toString(this.constantPool));
            }
        }
        if (this.debug) {
            System.out.println("read(): Read field info...");
        }
        if ((count2 = di.readShort()) != 0) {
            this.methods = new MethodInfo[count2];
            for (i = 0; i < count2; ++i) {
                this.methods[i] = new MethodInfo();
                if (!this.methods[i].read(di, this.constantPool)) {
                    return false;
                }
                if (!this.debug) continue;
                System.out.println("M" + i + ": " + this.methods[i].toString());
            }
        }
        if (this.debug) {
            System.out.println("read(): Read method info...");
        }
        if ((count2 = di.readShort()) != 0) {
            this.attributes = new AttributeInfo[count2];
            for (i = 0; i < count2; ++i) {
                this.attributes[i] = new AttributeInfo();
                if (this.attributes[i].read(di, this.constantPool)) continue;
                return false;
            }
        }
        if (this.debug) {
            System.out.println("read(): Read attribute info...");
            System.out.println("done.");
        }
        this.isValidClass = true;
        return true;
    }

    public void write(OutputStream out) throws IOException, Exception {
        int i;
        DataOutputStream dos = new DataOutputStream(out);
        if (!this.isValidClass) {
            throw new Exception("ClassFile::write() - Invalid Class");
        }
        dos.writeInt(this.magic);
        dos.writeShort(this.majorVersion);
        dos.writeShort(this.minorVersion);
        dos.writeShort(this.constantPool.length);
        for (i = 1; i < this.constantPool.length; ++i) {
            if (this.constantPool[i] == null) continue;
            this.constantPool[i].write(dos, this.constantPool);
        }
        dos.writeShort(this.accessFlags);
        dos.writeShort(ConstantPoolInfo.indexOf(this.thisClass, this.constantPool));
        dos.writeShort(ConstantPoolInfo.indexOf(this.superClass, this.constantPool));
        if (this.interfaces == null) {
            dos.writeShort(0);
        } else {
            dos.writeShort(this.interfaces.length);
            for (i = 0; i < this.interfaces.length; ++i) {
                dos.writeShort(ConstantPoolInfo.indexOf(this.interfaces[i], this.constantPool));
            }
        }
        if (this.fields == null) {
            dos.writeShort(0);
        } else {
            dos.writeShort(this.fields.length);
            for (i = 0; i < this.fields.length; ++i) {
                this.fields[i].write(dos, this.constantPool);
            }
        }
        if (this.methods == null) {
            dos.writeShort(0);
        } else {
            dos.writeShort(this.methods.length);
            for (i = 0; i < this.methods.length; ++i) {
                this.methods[i].write(dos, this.constantPool);
            }
        }
        if (this.attributes == null) {
            dos.writeShort(0);
        } else {
            dos.writeShort(this.attributes.length);
            for (i = 0; i < this.attributes.length; ++i) {
                this.attributes[i].write(dos, this.constantPool);
            }
        }
    }

    public static String accessString(short flags) {
        StringBuffer x = new StringBuffer();
        if ((flags & 1) != 0) {
            x.append("public ");
        }
        if ((flags & 2) != 0) {
            x.append("private ");
        }
        if ((flags & 4) != 0) {
            x.append("protected ");
        }
        if ((flags & 8) != 0) {
            x.append("static ");
        }
        if ((flags & 0x10) != 0) {
            x.append("final ");
        }
        if ((flags & 0x20) != 0) {
            x.append("synchronized ");
        }
        if ((flags & 0x40) != 0) {
            x.append("threadsafe ");
        }
        if ((flags & 0x80) != 0) {
            x.append("transient ");
        }
        if ((flags & 0x100) != 0) {
            x.append("native ");
        }
        if ((flags & 0x200) != 0) {
            x.append("interface ");
        }
        if ((flags & 0x400) != 0) {
            x.append("abstract ");
        }
        return x.toString();
    }

    public static String typeString(String typeString, String varName) {
        int isArray = 0;
        int ndx = 0;
        StringBuffer x = new StringBuffer();
        while (typeString.charAt(ndx) == '[') {
            ++isArray;
            ++ndx;
        }
        switch (typeString.charAt(ndx)) {
            case 'B': {
                x.append("byte ");
                break;
            }
            case 'C': {
                x.append("char ");
                break;
            }
            case 'D': {
                x.append("double ");
                break;
            }
            case 'F': {
                x.append("float ");
                break;
            }
            case 'I': {
                x.append("int ");
                break;
            }
            case 'J': {
                x.append("long ");
                break;
            }
            case 'L': {
                for (int i = ndx + 1; i < typeString.indexOf(59); ++i) {
                    if (typeString.charAt(i) != '/') {
                        x.append(typeString.charAt(i));
                        continue;
                    }
                    x.append('.');
                }
                x.append(" ");
                break;
            }
            case 'V': {
                x.append("void ");
                break;
            }
            case 'S': {
                x.append("short ");
                break;
            }
            case 'Z': {
                x.append("boolean ");
            }
        }
        x.append(varName);
        while (isArray > 0) {
            x.append("[]");
            --isArray;
        }
        return x.toString();
    }

    public static String nextSig(String sig) {
        int ndx = 0;
        while (sig.charAt(ndx) == '[') {
            ++ndx;
        }
        if (sig.charAt(ndx) == 'L') {
            while (sig.charAt(ndx) != ';') {
                ++ndx;
            }
        }
        String x = sig.substring(++ndx);
        return x;
    }

    private String printClassName(String s) {
        if (s.charAt(0) == '[') {
            return ClassFile.typeString(s, "");
        }
        StringBuffer x = new StringBuffer();
        for (int j = 0; j < s.length(); ++j) {
            if (s.charAt(j) == '/') {
                x.append('.');
                continue;
            }
            x.append(s.charAt(j));
        }
        return x.toString();
    }

    public String getClassName() {
        return this.printClassName(this.thisClass.arg1.strValue);
    }

    public String toString() {
        return "Class File (Version " + this.majorVersion + "." + this.minorVersion + ") for class " + this.thisClass.arg1;
    }

    public void display(PrintStream ps) throws Exception {
        int i;
        String packageName = null;
        if (!this.isValidClass) {
            ps.println("Not a valid class");
        }
        String myClassName = this.printClassName(this.thisClass.arg1.strValue);
        String mySuperClassName = this.printClassName(this.superClass.arg1.strValue);
        if (myClassName.indexOf(46) > 0) {
            packageName = myClassName.substring(0, myClassName.lastIndexOf(46));
            myClassName = myClassName.substring(myClassName.lastIndexOf(46) + 1);
            ps.println("package " + packageName + "\n");
        }
        for (i = 1; i < this.constantPool.length; ++i) {
            String s;
            if (this.constantPool[i] == null || this.constantPool[i] == this.thisClass || this.constantPool[i] == this.superClass || this.constantPool[i].type != 7 || (s = this.constantPool[i].arg1.strValue).charAt(0) == '[') continue;
            s = this.printClassName(this.constantPool[i].arg1.strValue);
            if (packageName != null && s.startsWith(packageName)) continue;
            ps.println("import " + this.printClassName(s) + ";");
        }
        ps.println();
        ps.println("/*");
        if (this.attributes != null) {
            ps.println(" * This class has " + this.attributes.length + " optional class attributes.");
            ps.println(" * These attributes are: ");
            for (i = 0; i < this.attributes.length; ++i) {
                String attrName = this.attributes[i].name.strValue;
                DataInputStream dis = new DataInputStream(new ByteArrayInputStream(this.attributes[i].data));
                ps.println(" * Attribute " + (i + 1) + " is of type " + this.attributes[i].name);
                if (attrName.compareTo("SourceFile") == 0) {
                    ConstantPoolInfo cpi = null;
                    try {
                        cpi = this.constantPool[dis.readShort()];
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    ps.println(" *\tSourceFile : " + cpi);
                    continue;
                }
                ps.println(" *\tTYPE (" + attrName + ")");
            }
        } else {
            ps.println(" * This class has NO optional class attributes.");
        }
        ps.println(" */\n");
        ps.print(ClassFile.accessString(this.accessFlags) + "class " + myClassName + " extends " + mySuperClassName);
        if (this.interfaces != null) {
            ps.print(" implements ");
            for (i = 0; i < this.interfaces.length - 1; ++i) {
                ps.print(this.interfaces[i].arg1.strValue + ", ");
            }
            ps.print(this.interfaces[this.interfaces.length - 1].arg1.strValue);
        }
        ps.println(" {\n");
        if (this.fields != null) {
            ps.println("/* Instance Variables */");
            for (i = 0; i < this.fields.length; ++i) {
                ps.println("    " + this.fields[i].toString(this.constantPool) + ";");
            }
        }
        if (this.methods != null) {
            ps.println("\n/* Methods */");
            for (i = 0; i < this.methods.length; ++i) {
                ps.println("    " + this.methods[i].toString(myClassName));
            }
        }
        ps.println("\n}");
    }

    public ConstantPoolInfo getConstantRef(short index) {
        return this.constantPool[index];
    }

    public short addConstantPoolItem(ConstantPoolInfo item) throws Exception {
        ConstantPoolInfo cp = item.inPool(this.constantPool);
        if (cp != null) {
            return ConstantPoolInfo.indexOf(cp, this.constantPool);
        }
        ConstantPoolInfo[] newConstantPool = new ConstantPoolInfo[this.constantPool.length + 1];
        for (int i = 1; i < this.constantPool.length; ++i) {
            newConstantPool[i] = this.constantPool[i];
        }
        newConstantPool[this.constantPool.length] = item;
        this.constantPool = newConstantPool;
        return ConstantPoolInfo.indexOf(item, this.constantPool);
    }

    public void addConstantPoolItems(ConstantPoolInfo[] items) {
        int i;
        ConstantPoolInfo newArg;
        int j;
        boolean[] delete = new boolean[items.length];
        for (j = 0; j < items.length; ++j) {
            if (items[j].type != 1 && items[j].type != 2 && items[j].type != 3 && items[j].type != 5 && items[j].type != 4 && items[j].type != 6) continue;
            delete[j] = false;
            newArg = items[j].inPool(this.constantPool);
            if (newArg == null) continue;
            delete[j] = true;
            for (i = 0; i < items.length; ++i) {
                if (items[i].arg1 == items[j]) {
                    items[i].arg1 = newArg;
                }
                if (items[i].arg2 != items[j]) continue;
                items[i].arg2 = newArg;
            }
        }
        for (j = 0; j < items.length; ++j) {
            if (items[j].type != 7 && items[j].type != 9 && items[j].type != 10 && items[j].type != 8 && items[j].type != 11 && items[j].type != 12) continue;
            delete[j] = false;
            newArg = items[j].inPool(this.constantPool);
            if (newArg == null) continue;
            delete[j] = true;
            for (i = 0; i < items.length; ++i) {
                if (items[i].arg1 == items[j]) {
                    items[i].arg1 = newArg;
                }
                if (items[i].arg2 != items[j]) continue;
                items[i].arg2 = newArg;
            }
        }
        int count2 = 0;
        for (i = 0; i < items.length; ++i) {
            if (delete[i]) continue;
            ++count2;
        }
        ConstantPoolInfo[] newConstantPool = new ConstantPoolInfo[this.constantPool.length + count2];
        for (i = 1; i < this.constantPool.length; ++i) {
            newConstantPool[i] = this.constantPool[i];
        }
        int ndx = 0;
        for (int i2 = this.constantPool.length; i2 < newConstantPool.length; ++i2) {
            while (delete[ndx]) {
                ++ndx;
            }
            newConstantPool[i2] = items[ndx];
            ++ndx;
        }
        this.constantPool = newConstantPool;
    }

    public void addAttribute(AttributeInfo newAttribute) {
        if (this.attributes == null) {
            this.attributes = new AttributeInfo[1];
            this.attributes[0] = newAttribute;
        } else {
            AttributeInfo[] newAttrList = new AttributeInfo[1 + this.attributes.length];
            for (int i = 0; i < this.attributes.length; ++i) {
                newAttrList[i] = this.attributes[i];
            }
            newAttrList[this.attributes.length] = newAttribute;
            this.attributes = newAttrList;
        }
    }

    public AttributeInfo getAttribute(String name2) {
        if (this.attributes == null) {
            return null;
        }
        for (int i = 0; i < this.attributes.length; ++i) {
            if (name2.compareTo(this.attributes[i].name.toString()) != 0) continue;
            return this.attributes[i];
        }
        return null;
    }

    public ConstantPoolInfo getConstantPoolItem(short index) throws Exception {
        if (index <= 0 || index > this.constantPool.length - 1) {
            return null;
        }
        ConstantPoolInfo cp = this.constantPool[index];
        if (cp.arg1 != null) {
            cp.index1 = ConstantPoolInfo.indexOf(cp.arg1, this.constantPool);
        }
        if (cp.arg2 != null) {
            cp.index2 = ConstantPoolInfo.indexOf(cp.arg2, this.constantPool);
        }
        return cp;
    }

    public void mapClass(String oldClass, String newClass) {
        if (this.debug) {
            System.out.println("Mapping class name " + oldClass + " ==> " + newClass + " for class " + this.thisClass.arg1);
        }
        for (int i = 0; i < this.constantPool.length; ++i) {
            String cname;
            if (this.constantPool[i].type != 7 || (cname = this.constantPool[i].arg1.strValue).compareTo(oldClass) != 0) continue;
            if (this.debug) {
                System.out.println("REPLACING " + cname + " with " + newClass);
            }
            this.constantPool[i].arg1.strValue = newClass;
        }
    }

    public void mapPackage(String oldPackage, String newPackage) {
        for (int i = 0; i < this.constantPool.length; ++i) {
            String cname;
            if (this.constantPool[i].type != 7 || !(cname = this.constantPool[i].arg1.strValue).startsWith(oldPackage)) continue;
            this.constantPool[i].arg1.strValue = newPackage + cname.substring(cname.lastIndexOf(47));
        }
    }

    public void deleteMethod(String name2, String signature) {
        for (int i = 0; i < this.constantPool.length; ++i) {
            if (this.constantPool[i].type != 7) continue;
        }
    }
}

