/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.common.util;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class ConstantPoolInfo {
    int type;
    String name;
    ConstantPoolInfo arg1 = null;
    ConstantPoolInfo arg2 = null;
    short index1 = (short)-1;
    short index2 = (short)-1;
    String strValue;
    int intValue;
    long longValue;
    float floatValue;
    double doubleValue;
    public static final int CLASS = 7;
    public static final int FIELDREF = 9;
    public static final int METHODREF = 10;
    public static final int STRING = 8;
    public static final int INTEGER = 3;
    public static final int FLOAT = 4;
    public static final int LONG = 5;
    public static final int DOUBLE = 6;
    public static final int INTERFACE = 11;
    public static final int NAMEANDTYPE = 12;
    public static final int ASCIZ = 1;
    public static final int UNICODE = 2;

    public ConstantPoolInfo(String value) {
        this.type = 1;
        this.strValue = value;
    }

    public ConstantPoolInfo(int value) {
        this.type = 3;
        this.intValue = value;
    }

    public ConstantPoolInfo(float value) {
        this.type = 4;
        this.floatValue = value;
    }

    public ConstantPoolInfo(long value) {
        this.type = 5;
        this.longValue = value;
    }

    public ConstantPoolInfo(double value) {
        this.type = 6;
        this.doubleValue = value;
    }

    public ConstantPoolInfo() {
        this.type = -1;
    }

    public int isType() {
        return this.type;
    }

    public boolean read(DataInputStream dis) throws IOException {
        this.type = dis.readByte();
        switch (this.type) {
            case 7: {
                this.name = "Class";
                this.index1 = dis.readShort();
                this.index2 = (short)-1;
                break;
            }
            case 9: {
                this.name = "Field Reference";
                this.index1 = dis.readShort();
                this.index2 = dis.readShort();
                break;
            }
            case 10: {
                this.name = "Method Reference";
                this.index1 = dis.readShort();
                this.index2 = dis.readShort();
                break;
            }
            case 11: {
                this.name = "Interface Method Reference";
                this.index1 = dis.readShort();
                this.index2 = dis.readShort();
                break;
            }
            case 12: {
                this.name = "Name and Type";
                this.index1 = dis.readShort();
                this.index2 = dis.readShort();
                break;
            }
            case 8: {
                this.name = "String";
                this.index1 = dis.readShort();
                this.index2 = (short)-1;
                break;
            }
            case 3: {
                this.name = "Integer";
                this.intValue = dis.readInt();
                break;
            }
            case 4: {
                this.name = "Float";
                this.floatValue = dis.readFloat();
                break;
            }
            case 5: {
                this.name = "Long";
                this.longValue = dis.readLong();
                break;
            }
            case 6: {
                this.name = "Double";
                this.doubleValue = dis.readDouble();
                break;
            }
            case 1: 
            case 2: {
                this.name = this.type == 1 ? "ASCIZ" : "UNICODE";
                StringBuffer xxBuf = new StringBuffer();
                for (int len = dis.readShort(); len > 0; --len) {
                    char c = (char)dis.readByte();
                    xxBuf.append(c);
                }
                this.strValue = xxBuf.toString();
                break;
            }
            default: {
                System.out.println("Warning bad type.");
            }
        }
        return true;
    }

    public void write(DataOutputStream dos, ConstantPoolInfo[] pool) throws IOException, Exception {
        dos.write(this.type);
        switch (this.type) {
            case 7: 
            case 8: {
                dos.writeShort(ConstantPoolInfo.indexOf(this.arg1, pool));
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                dos.writeShort(ConstantPoolInfo.indexOf(this.arg1, pool));
                dos.writeShort(ConstantPoolInfo.indexOf(this.arg2, pool));
                break;
            }
            case 3: {
                dos.writeInt(this.intValue);
                break;
            }
            case 4: {
                dos.writeFloat(this.floatValue);
                break;
            }
            case 5: {
                dos.writeLong(this.longValue);
                break;
            }
            case 6: {
                dos.writeDouble(this.doubleValue);
                break;
            }
            case 1: 
            case 2: {
                dos.writeShort(this.strValue.length());
                dos.writeBytes(this.strValue);
                break;
            }
            default: {
                throw new Exception("ConstantPoolInfo::write() - bad type.");
            }
        }
    }

    public String toString() {
        if (this.type == 1) {
            return this.strValue;
        }
        if (this.type == 3) {
            return "= " + this.intValue;
        }
        if (this.type == 5) {
            return "= " + this.longValue;
        }
        if (this.type == 4) {
            return "= " + this.floatValue;
        }
        if (this.type == 6) {
            return "= " + this.doubleValue;
        }
        StringBuffer s = new StringBuffer();
        s.append(this.name);
        s.append(":");
        if (this.arg1 != null) {
            s.append(this.arg1.toString());
        } else if (this.index1 != -1) {
            s.append("I1[" + this.index1 + "], ");
        }
        if (this.arg2 != null) {
            s.append(this.arg2.toString());
        } else if (this.index2 != -1) {
            s.append("I2[" + this.index2 + "], ");
        }
        return s.toString();
    }

    public static short indexOf(ConstantPoolInfo item, ConstantPoolInfo[] pool) throws Exception {
        for (int i = 0; i < pool.length; ++i) {
            if (item != pool[i]) continue;
            return (short)i;
        }
        throw new Exception("ConstantPoolInfo:: indexOf() - item not in pool.");
    }

    public boolean isEqual(ConstantPoolInfo cp) {
        if (cp == null) {
            return false;
        }
        if (cp.type != this.type) {
            return false;
        }
        switch (cp.type) {
            case 7: 
            case 8: {
                return this.arg1 == cp.arg1;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                return this.arg1 == cp.arg1 && this.arg2 == cp.arg2;
            }
            case 3: {
                return cp.intValue == this.intValue;
            }
            case 4: {
                return cp.floatValue == this.floatValue;
            }
            case 5: {
                return cp.longValue == this.longValue;
            }
            case 6: {
                return cp.doubleValue == this.doubleValue;
            }
            case 1: 
            case 2: {
                return cp.strValue.compareTo(this.strValue) == 0;
            }
        }
        return false;
    }

    public ConstantPoolInfo inPool(ConstantPoolInfo[] pool) {
        for (int i = 1; i < pool.length; ++i) {
            if (!this.isEqual(pool[i])) continue;
            return pool[i];
        }
        return null;
    }
}

