/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.common.util;

import com.argo21.common.lang.XData;
import com.argo21.common.lang.XDataException;

public class EncodeConverter {
    public static XData convertEncodingInput(XData tmp, String encoding) throws XDataException {
        if (encoding == null) {
            return tmp;
        }
        for (int i = 0; i < tmp.size(); ++i) {
            String value;
            if (tmp.isNumber() || (value = tmp.stringValue(i)) == null || value.length() == 0) continue;
            if ("SHIFT_JIS".equalsIgnoreCase(encoding)) {
                value = EncodeConverter.sjisToUnicode(value);
            } else {
                if (!"EUC-JP".equals(encoding)) continue;
                value = EncodeConverter.eucToUnicode(value);
            }
            tmp.setValue(i, value);
        }
        return tmp;
    }

    public static XData convertEncodingOutput(XData tmp, String encoding) throws XDataException {
        if (encoding == null) {
            return tmp;
        }
        for (int i = 0; i < tmp.size(); ++i) {
            String value;
            if (tmp.isNumber() || (value = tmp.stringValue(i)) == null || value.length() == 0) continue;
            if ("SHIFT_JIS".equalsIgnoreCase(encoding)) {
                value = EncodeConverter.unicodeToSjis(value);
            } else {
                if (!"EUC-JP".equals(encoding)) continue;
                value = EncodeConverter.unicodeToEuc(value);
            }
            tmp.setValue(i, value);
        }
        return tmp;
    }

    public static String unicodeToSjis(String str) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '\u2015': {
                    c = '\u2014';
                    break;
                }
                case '\uff5e': {
                    c = '\u301c';
                    break;
                }
                case '\u2225': {
                    c = '\u2016';
                    break;
                }
                case '\uff0d': {
                    c = '\u2212';
                    break;
                }
                case '\uffe0': {
                    c = '\u00a2';
                    break;
                }
                case '\uffe1': {
                    c = '\u00a3';
                    break;
                }
                case '\uffe2': {
                    c = '\u00ac';
                }
            }
            result.append(c);
        }
        return result.toString();
    }

    public static String sjisToUnicode(String str) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '\u2014': {
                    c = '\u2015';
                    break;
                }
                case '\u301c': {
                    c = '\uff5e';
                    break;
                }
                case '\u2016': {
                    c = '\u2225';
                    break;
                }
                case '\u2212': {
                    c = '\uff0d';
                    break;
                }
                case '\u00a2': {
                    c = '\uffe0';
                    break;
                }
                case '\u00a3': {
                    c = '\uffe1';
                    break;
                }
                case '\u00ac': {
                    c = '\uffe2';
                }
            }
            result.append(c);
        }
        return result.toString();
    }

    public static String unicodeToEuc(String str) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '\u2015': {
                    c = '\u2014';
                    break;
                }
                case '\uff5e': {
                    c = '\u301c';
                    break;
                }
                case '\u2225': {
                    c = '\u2016';
                    break;
                }
                case '\uff0d': {
                    c = '\u2212';
                    break;
                }
                case '\uffe0': {
                    c = '\u00a2';
                    break;
                }
                case '\uffe1': {
                    c = '\u00a3';
                    break;
                }
                case '\uffe2': {
                    c = '\u00ac';
                    break;
                }
                case '\uffe4': {
                    c = '\u00a6';
                }
            }
            result.append(c);
        }
        return result.toString();
    }

    public static String eucToUnicode(String str) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '\u2014': {
                    c = '\u2015';
                    break;
                }
                case '\u301c': {
                    c = '\uff5e';
                    break;
                }
                case '\u2016': {
                    c = '\u2225';
                    break;
                }
                case '\u2212': {
                    c = '\uff0d';
                    break;
                }
                case '\u00a2': {
                    c = '\uffe0';
                    break;
                }
                case '\u00a3': {
                    c = '\uffe1';
                    break;
                }
                case '\u00ac': {
                    c = '\uffe2';
                    break;
                }
                case '\u00a6': {
                    c = '\uffe4';
                }
            }
            result.append(c);
        }
        return result.toString();
    }
}

