/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.common.util;

import com.argo21.common.util.AttributeInfo;
import com.argo21.common.util.ClassFile;
import com.argo21.common.util.ConstantPoolInfo;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class FieldInfo {
    short accessFlags;
    ConstantPoolInfo name;
    ConstantPoolInfo signature;
    AttributeInfo[] attributes;

    public boolean read(DataInputStream di, ConstantPoolInfo[] pool) throws IOException {
        this.accessFlags = di.readShort();
        this.name = pool[di.readShort()];
        this.signature = pool[di.readShort()];
        int count2 = di.readShort();
        if (count2 != 0) {
            this.attributes = new AttributeInfo[count2];
            for (int i = 0; i < count2; ++i) {
                this.attributes[i] = new AttributeInfo();
                if (this.attributes[i].read(di, pool)) continue;
                return false;
            }
        }
        return true;
    }

    public void write(DataOutputStream dos, ConstantPoolInfo[] pool) throws IOException, Exception {
        dos.writeShort(this.accessFlags);
        dos.writeShort(ConstantPoolInfo.indexOf(this.name, pool));
        dos.writeShort(ConstantPoolInfo.indexOf(this.signature, pool));
        if (this.attributes == null) {
            dos.writeShort(0);
        } else {
            dos.writeShort(this.attributes.length);
            for (int i = 0; i < this.attributes.length; ++i) {
                this.attributes[i].write(dos, pool);
            }
        }
    }

    public String toString() {
        StringBuffer x = new StringBuffer();
        x.append(ClassFile.accessString(this.accessFlags));
        x.append(ClassFile.typeString(this.signature.toString(), this.name.toString()));
        if (this.attributes != null) {
            x.append(" = " + this.attributes[0].toString());
        }
        return x.toString();
    }

    public String toString(ConstantPoolInfo[] pool) {
        StringBuffer x = new StringBuffer();
        x.append(ClassFile.accessString(this.accessFlags));
        String mytype = ClassFile.typeString(this.signature.toString(), this.name.toString());
        x.append(mytype);
        if (this.attributes != null) {
            if (mytype.startsWith("boolean")) {
                x.append(" " + this.attributes[0].toBoolean(pool));
            } else {
                x.append(" " + this.attributes[0].toString(pool));
            }
        }
        return x.toString();
    }
}

