/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.common.util;

import com.argo21.common.util.AttributeInfo;
import com.argo21.common.util.ClassFile;
import com.argo21.common.util.ConstantPoolInfo;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class MethodInfo {
    short accessFlags;
    ConstantPoolInfo name;
    ConstantPoolInfo signature;
    AttributeInfo[] attributes;

    public boolean read(DataInputStream di, ConstantPoolInfo[] pool) throws IOException {
        this.accessFlags = di.readShort();
        this.name = pool[di.readShort()];
        this.signature = pool[di.readShort()];
        int count2 = di.readShort();
        if (count2 != 0) {
            this.attributes = new AttributeInfo[count2];
            for (int i = 0; i < count2; ++i) {
                this.attributes[i] = new AttributeInfo();
                if (this.attributes[i].read(di, pool)) continue;
                return false;
            }
        }
        return true;
    }

    public void write(DataOutputStream dos, ConstantPoolInfo[] pool) throws IOException, Exception {
        dos.writeShort(this.accessFlags);
        dos.writeShort(ConstantPoolInfo.indexOf(this.name, pool));
        dos.writeShort(ConstantPoolInfo.indexOf(this.signature, pool));
        if (this.attributes == null) {
            dos.writeShort(0);
        } else {
            dos.writeShort(this.attributes.length);
            for (int i = 0; i < this.attributes.length; ++i) {
                this.attributes[i].write(dos, pool);
            }
        }
    }

    public String toString(String className) {
        StringBuffer x = new StringBuffer();
        boolean isArray = false;
        boolean ndx = false;
        StringBuffer parameterList = new StringBuffer();
        char initialParameter = 'a';
        StringBuffer varName = new StringBuffer();
        String s = this.signature.strValue;
        String paramSig = s.substring(s.indexOf(40) + 1, s.indexOf(41));
        String returnSig = s.substring(s.indexOf(41) + 1);
        x.append(ClassFile.accessString(this.accessFlags));
        if (className != null && this.name.toString().startsWith("<init>")) {
            parameterList.append(className);
        } else {
            parameterList.append(this.name.toString());
        }
        parameterList.append("(");
        if (paramSig.length() > 0 && paramSig.charAt(0) != 'V') {
            while (paramSig.length() > 0) {
                varName.setLength(0);
                varName.append(initialParameter);
                initialParameter = (char)(initialParameter + '\u0001');
                parameterList.append(ClassFile.typeString(paramSig, varName.toString()));
                if ((paramSig = ClassFile.nextSig(paramSig)).length() <= 0) continue;
                parameterList.append(", ");
            }
        }
        parameterList.append(")");
        x.append(ClassFile.typeString(returnSig, parameterList.toString()));
        x.append(";");
        return x.toString();
    }

    public String toString() {
        return this.toString(null);
    }
}

