/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.common.util;

import com.argo21.common.log.AppMessage;
import com.argo21.common.log.BizTranException;
import com.argo21.common.util.BizTranUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.xml.bind.DatatypeConverter;

public class MultiProcessUtil {
    static File fLockFile = null;
    static FileChannel fcLockFile = null;
    static FileOutputStream fosLockFile = null;

    public static void lockOutputFile(String outputFile) throws BizTranException {
        try {
            String mapFolderName = BizTranUtil.getMappingFolderPath();
            File fOutputFile = new File(outputFile);
            String hexLockFileName = MultiProcessUtil.CreateLockFileNameWithoutExtention(fOutputFile);
            fLockFile = new File(mapFolderName.concat(File.separator).concat(hexLockFileName).concat(".lock"));
            fosLockFile = new FileOutputStream(fLockFile.getPath());
            fcLockFile = fosLockFile.getChannel();
            FileLock lock = fcLockFile.tryLock();
            while (lock == null) {
                Thread.sleep(500L);
                lock = fcLockFile.tryLock();
            }
        }
        catch (Exception e) {
            throw new BizTranException(AppMessage.EXCLUSIVE_EXCEPTION, (Throwable)e);
        }
    }

    public static void releaseOutputFile() {
        try {
            if (fosLockFile != null) {
                fosLockFile.close();
            }
            if (fcLockFile != null) {
                fcLockFile.close();
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (fLockFile != null && fLockFile.exists()) {
                try {
                    fLockFile.delete();
                }
                catch (Exception exception) {}
            }
        }
    }

    private static String CreateLockFileNameWithoutExtention(File fOutputFile) throws NoSuchAlgorithmException {
        String sHex = "";
        String outputFilePath = fOutputFile.getAbsolutePath();
        MessageDigest md5 = null;
        md5 = MessageDigest.getInstance("MD5");
        byte[] result = md5.digest(outputFilePath.toLowerCase().getBytes());
        sHex = DatatypeConverter.printHexBinary((byte[])result);
        return sHex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isOutputTypeXML(String mapFilePath) {
        BufferedReader br = null;
        File mapFile = new File(mapFilePath);
        try {
            br = new BufferedReader(new FileReader(mapFile));
            while (br.ready()) {
                String lineParent = br.readLine();
                if (!lineParent.startsWith("[MSGDECL]")) continue;
                String type = "";
                String direction = "";
                while (br.ready()) {
                    String lineChild = br.readLine();
                    if (lineChild.startsWith("type=")) {
                        type = lineChild.substring("type=".length());
                    }
                    if (lineChild.startsWith("direction=")) {
                        direction = lineChild.substring("direction=".length());
                    }
                    if ("".equals(type) || "".equals(direction)) continue;
                    break;
                }
                if (!"XSD".equals(type) && !"XML".equals(type) || !"OUTPUT".equals(direction)) continue;
                boolean bl = true;
                return bl;
            }
            boolean lineParent = false;
            return lineParent;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

