/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.common.util;

import com.argo21.common.log.AppMessage;
import jp.co.argo21.nts.commons.passfile.PassFile;
import jp.co.argo21.nts.commons.passfile.PassFileArgumentException;
import jp.co.argo21.nts.commons.passfile.PassFileIOException;
import jp.co.argo21.nts.commons.passfile.PassFileIllegalException;

public class PassFileUtil {
    public static final byte[] DECODE_KEY = new byte[]{54, 56, 48, 49, 49, 53};
    public static final String PRODUCT_ID = "BIZTRN";
    public static final String PRODUCT_NAME = "BizTran";
    public static final String COPYRIGHT = "(C)2003-2018 Canon IT Solutions Inc. All Right Reserved.";
    public static final PassFileUtil VERSION_NO = new PassFileUtil(12, 5);
    private int beginIndex = 0;
    private int endIndex = 0;

    private PassFileUtil(int beginIndex, int endIndex) {
        this.beginIndex = beginIndex;
        this.endIndex = endIndex;
    }

    public int getBeginIndex() {
        return this.beginIndex;
    }

    public int getEndIndex() {
        return this.endIndex;
    }

    public static AppMessage readCheck() {
        AppMessage appMsg = null;
        try {
            PassFile.getInstance();
            if (!PassFileUtil.isBizTran()) {
                appMsg = AppMessage.PASSFILE_CONTENT_ILLEGAL;
            }
        }
        catch (PassFileIOException e) {
            appMsg = AppMessage.PASSFILE_NOT_FOUND;
        }
        catch (PassFileIllegalException e) {
            appMsg = AppMessage.PASSFILE_CONTENT_ILLEGAL;
        }
        return appMsg;
    }

    public static boolean isBizTran() {
        PassFile passFile = null;
        boolean isBizTran = false;
        try {
            passFile = PassFile.getInstance();
            isBizTran = passFile.isCorrectProductId(PRODUCT_ID);
        }
        catch (PassFileIOException e) {
            isBizTran = false;
        }
        catch (PassFileIllegalException e) {
            isBizTran = false;
        }
        catch (PassFileArgumentException e) {
            isBizTran = false;
        }
        return isBizTran;
    }
}

