/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.common.util;

import com.argo21.common.util.Property;

public class Properties {
    Property[] properties = null;
    int elementCount;

    public Properties() {
        this.properties = new Property[4];
        this.elementCount = 0;
    }

    public Properties(int size) {
        this.properties = new Property[size];
        this.elementCount = 0;
    }

    public Properties cloneProperties() {
        Properties ps1 = new Properties(this.elementCount);
        for (int i = 0; i < this.elementCount; ++i) {
            ps1.properties[i] = new Property(this.properties[i].name, this.properties[i].value);
        }
        ps1.elementCount = this.elementCount;
        return ps1;
    }

    private final synchronized void ensureCapacity(int minCapacity) {
        int oldCapacity = this.properties.length;
        if (minCapacity > oldCapacity) {
            Property[] oldData = this.properties;
            int newCapacity = oldCapacity + 4;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.properties = new Property[newCapacity];
            System.arraycopy(oldData, 0, this.properties, 0, this.elementCount);
        }
    }

    public void removeAll() {
        this.elementCount = 0;
    }

    public Property remove(String name2) {
        for (int i = 0; i < this.elementCount; ++i) {
            Property p = this.properties[i];
            if (!p.name.equals(name2)) continue;
            System.arraycopy(this.properties, i + 1, this.properties, i, this.elementCount - i - 1);
            --this.elementCount;
            return p;
        }
        return null;
    }

    public void append(String name2, String value) {
        this.ensureCapacity(this.elementCount + 1);
        this.properties[this.elementCount++] = new Property(name2, value);
    }

    public void append(String name2, String value, boolean decode) {
        this.ensureCapacity(this.elementCount + 1);
        if (decode && value != null) {
            value = Properties.parseSpecialChar(value);
        }
        this.properties[this.elementCount++] = new Property(name2, value);
    }

    public void append(Property property) {
        this.ensureCapacity(this.elementCount + 1);
        this.properties[this.elementCount++] = property;
    }

    public void repleace(String name2, String value) {
        if (value == null) {
            this.remove(name2);
        } else {
            Property p = this.getProperty(name2);
            if (p != null) {
                p.value = value;
            } else {
                this.append(name2, value);
            }
        }
    }

    public void repleace(String name2, String value, boolean decode) {
        if (value == null) {
            this.remove(name2);
        } else {
            Property p;
            if (decode && value != null) {
                value = Properties.parseSpecialChar(value);
            }
            if ((p = this.getProperty(name2)) != null) {
                p.value = value;
            } else {
                this.append(name2, value);
            }
        }
    }

    public int getSize() {
        return this.elementCount;
    }

    public String getName(int index) {
        if (index < this.elementCount) {
            return this.properties[index].name;
        }
        return null;
    }

    public Property getProperty(int index) {
        if (index < this.elementCount) {
            return this.properties[index];
        }
        return null;
    }

    public Property getProperty(String name2) {
        for (int i = 0; i < this.elementCount; ++i) {
            Property p = this.properties[i];
            if (!p.name.equals(name2)) continue;
            return p;
        }
        return null;
    }

    public String getValue(int index) {
        if (index < this.elementCount) {
            return this.properties[index].value;
        }
        return null;
    }

    public String getValue(String name2) {
        return this.getValue(name2, null);
    }

    public String getValue(String name2, String defalut) {
        for (int i = 0; i < this.elementCount; ++i) {
            Property p = this.properties[i];
            if (!p.name.equals(name2)) continue;
            if (p.value == null) {
                return defalut;
            }
            return p.value;
        }
        return defalut;
    }

    public int getInteger(String name2, int defalut) {
        for (int i = 0; i < this.elementCount; ++i) {
            Property p = this.properties[i];
            if (!p.name.equals(name2)) continue;
            if (p.value == null) {
                return defalut;
            }
            try {
                return Integer.parseInt(p.value);
            }
            catch (Exception e) {
                return defalut;
            }
        }
        return defalut;
    }

    public boolean getBoolean(String name2, boolean defalut) {
        for (int i = 0; i < this.elementCount; ++i) {
            Property p = this.properties[i];
            if (!p.name.equals(name2)) continue;
            if (p.value == null) {
                return defalut;
            }
            try {
                return Boolean.getBoolean(p.value);
            }
            catch (Exception e) {
                return defalut;
            }
        }
        return defalut;
    }

    public String[] listName() {
        String[] names = new String[this.elementCount];
        for (int i = 0; i < this.elementCount; ++i) {
            names[i] = this.properties[i].name;
        }
        return names;
    }

    public String[] listValue() {
        String[] values = new String[this.elementCount];
        for (int i = 0; i < this.elementCount; ++i) {
            values[i] = this.properties[i].value;
        }
        return values;
    }

    public boolean contain(String name2) {
        for (int i = 0; i < this.elementCount; ++i) {
            if (!name2.equals(this.properties[i].name)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.toString(null, true);
    }

    public String toString(String split) {
        return this.toString(split, true);
    }

    public String toString(String split, boolean encode) {
        if (split == null) {
            split = "\n";
            try {
                split = System.getProperty("line.separator", "\n");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.elementCount; ++i) {
            String s;
            Property p = this.properties[i];
            sb.append(p.name);
            sb.append('=');
            String string2 = s = encode ? Properties.makeSpecialChar(p.value) : p.value;
            if (s == null) {
                sb.append("null");
            } else {
                sb.append(s);
            }
            if (i >= this.elementCount - 1) continue;
            sb.append(split);
        }
        return sb.toString();
    }

    public String toString(String split, boolean encode, String maskingField) {
        if (split == null) {
            split = "\n";
            try {
                split = System.getProperty("line.separator", "\n");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.elementCount; ++i) {
            String s;
            Property p = this.properties[i];
            sb.append(p.name);
            sb.append('=');
            String string2 = s = encode ? Properties.makeSpecialChar(p.value) : p.value;
            if (p.name.equalsIgnoreCase(maskingField)) {
                if (s != null) {
                    for (int j = 0; j < s.length(); ++j) {
                        sb.append('*');
                    }
                }
            } else if (s == null) {
                sb.append("null");
            } else {
                sb.append(s);
            }
            if (i >= this.elementCount - 1) continue;
            sb.append(split);
        }
        return sb.toString();
    }

    public static String makeSpecialChar(String str) {
        int k;
        if (str == null) {
            return null;
        }
        int n = str.length();
        char c = '\u0000';
        for (k = 0; k < n && (c = str.charAt(k)) != '\r' && c != '\b' && c != '\n' && c != '\t' && c != '\f' && c != '\\'; ++k) {
        }
        if (k == n) {
            return str;
        }
        StringBuffer sb = new StringBuffer();
        if (k > 0) {
            sb.append(str.substring(0, k));
        }
        while (true) {
            switch (c) {
                case '\r': {
                    sb.append('\\');
                    sb.append('r');
                    break;
                }
                case '\n': {
                    sb.append('\\');
                    sb.append('n');
                    break;
                }
                case '\b': {
                    sb.append('\\');
                    sb.append('b');
                    break;
                }
                case '\t': {
                    sb.append('\\');
                    sb.append('t');
                    break;
                }
                case '\f': {
                    sb.append('\\');
                    sb.append('f');
                    break;
                }
                case '\\': {
                    sb.append('\\');
                    sb.append('\\');
                    break;
                }
                default: {
                    sb.append(c);
                }
            }
            if (++k >= n) break;
            c = str.charAt(k);
        }
        return sb.toString();
    }

    public static String parseSpecialChar(String str) {
        int k;
        if (str == null) {
            return null;
        }
        int n = str.length();
        char c = '\u0000';
        for (k = 0; k < n && (c = str.charAt(k)) != '\\'; ++k) {
        }
        if (k == n) {
            return str;
        }
        StringBuffer sb = new StringBuffer();
        if (k > 0) {
            sb.append(str.substring(0, k));
        }
        while (k < n) {
            c = str.charAt(k);
            if (c == '\\') {
                if (++k >= n) break;
                c = str.charAt(k);
                switch (c) {
                    case 'r': {
                        sb.append('\r');
                        break;
                    }
                    case 'n': {
                        sb.append('\n');
                        break;
                    }
                    case 'b': {
                        sb.append('\b');
                        break;
                    }
                    case 't': {
                        sb.append('\t');
                        break;
                    }
                    case 'f': {
                        sb.append('\f');
                        break;
                    }
                    case '\\': {
                        sb.append('\\');
                        break;
                    }
                    default: {
                        sb.append('\\');
                        sb.append(c);
                    }
                }
                ++k;
                continue;
            }
            sb.append(c);
            ++k;
        }
        return sb.toString();
    }
}

