/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.common.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class Repleacor {
    String path;
    FilenameFilter filter;
    String oldString;
    String newString;
    char[] buff = new char[2048];
    int count = 0;
    long linenum = 0L;
    long sizenum = 0L;
    long filenum = 0L;
    static String lineSeparator = System.getProperty("line.separator", "\n");
    static DateFormat datedf = DateFormat.getDateInstance(2);

    public Repleacor(String path) {
        this.path = path;
        this.filter = null;
    }

    public Repleacor(String path, FilenameFilter filter) {
        this.path = path;
        this.filter = filter;
    }

    public Repleacor(String path, String filter) {
        this.path = path;
        this.filter = new MyFilter(filter);
    }

    private void append(String s) {
        int n = s.length();
        int len = this.count + n;
        if (len > this.buff.length) {
            this.extendBuff(len);
        }
        char[] sbuf = s.toCharArray();
        System.arraycopy(sbuf, 0, this.buff, this.count, sbuf.length);
        this.count += sbuf.length;
    }

    private void extendBuff(int len) {
        char[] newValue = new char[len + 2048];
        System.arraycopy(this.buff, 0, newValue, 0, this.count);
        this.buff = newValue;
    }

    public void countLine(PrintWriter out) {
        File file = new File(this.path);
        if (!file.exists()) {
            return;
        }
        try {
            out.println("===============     \u30d7\u30ed\u30b0\u30e9\u30e0 \u30ea\u30b9\u30c8    ===================");
            out.print("\u30d5\u30a9\u30eb\u30c0\uff1a");
            out.println(this.path);
            this.linenum = 0L;
            this.sizenum = 0L;
            this.filenum = 0L;
            this.countLine(file, out);
            out.println("===============     \u7dcf\u8a08    ===================");
            out.print("\u30d5\u30a1\u30a4\u30eb\u6570\uff1a");
            out.println(this.filenum);
            out.print("\u7dcf\u884c\u6570\u3000\u3000\uff1a");
            out.println(this.linenum);
            out.print("\u7dcf\u30b5\u30a4\u30ba\u3000\uff1a");
            out.println(this.sizenum);
            out.println();
            out.print("\u65e5\u4ed8\uff1a");
            out.println(datedf.format(new Date()));
        }
        catch (Exception e) {
            System.out.println("\u51fa\u529b\u30d5\u30a1\u30a4\u30eb\u540d\u9055\u3046");
        }
    }

    void countLine(File file, PrintWriter out) {
        if (file.isFile()) {
            System.out.println(file.getPath());
            ++this.filenum;
            long size = file.length();
            this.sizenum += size;
            String s = file.getPath();
            int k = s.indexOf(this.path);
            if (s.startsWith(this.path)) {
                s = s.substring(this.path.length() + 1);
            }
            out.print(s);
            out.print("  Size=");
            out.print(size);
            BufferedReader reader = null;
            long num = 0L;
            try {
                String line;
                reader = new BufferedReader(new FileReader(file));
                while ((line = reader.readLine()) != null) {
                    ++num;
                }
                reader.close();
            }
            catch (Exception e) {
                try {
                    reader.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.linenum += num;
            out.print("  \u884c\u6570=");
            out.print(num);
            out.print("  \u65e5\u4ed8=");
            out.println(datedf.format(new Date(file.lastModified())));
            out.flush();
        } else if (file.isDirectory()) {
            String[] names = this.filter == null ? file.list() : file.list(this.filter);
            int n = names.length;
            for (int i = 0; i < n; ++i) {
                File file1 = new File(file, names[i]);
                this.countLine(file1, out);
            }
        }
    }

    public void repleaceString(String oldString, String newString) {
        this.oldString = oldString;
        this.newString = newString;
        File file = new File(this.path);
        if (!file.exists()) {
            return;
        }
        this.repleaceString(file);
    }

    private void repleaceString(File file) {
        if (file.isFile()) {
            int len = (int)file.length();
            if (len > this.buff.length) {
                this.extendBuff(len);
            }
            this.count = 0;
            System.out.println(file.getPath());
            BufferedReader reader = null;
            try {
                String line;
                reader = new BufferedReader(new FileReader(file));
                while ((line = reader.readLine()) != null) {
                    int pos = line.indexOf(this.oldString);
                    while (pos >= 0) {
                        line = line.substring(0, pos) + this.newString + line.substring(pos + this.oldString.length());
                        pos = line.indexOf(this.oldString);
                    }
                    this.append(line);
                    this.append(lineSeparator);
                }
                reader.close();
            }
            catch (Exception e) {
                try {
                    reader.close();
                }
                catch (Exception pos) {
                    // empty catch block
                }
            }
            FileWriter wr = null;
            try {
                wr = new FileWriter(file);
                ((Writer)wr).write(this.buff, 0, this.count);
                ((Writer)wr).close();
            }
            catch (Exception e) {
                try {
                    ((Writer)wr).close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.count = 0;
        } else if (file.isDirectory()) {
            String[] names = this.filter == null ? file.list() : file.list(this.filter);
            int n = names.length;
            for (int i = 0; i < n; ++i) {
                File file1 = new File(file, names[i]);
                this.repleaceString(file1);
            }
        }
    }

    public static File createFile(String baseDir, String name2) {
        File f = new File(baseDir);
        int k = name2.lastIndexOf("/");
        if (k < 0) {
            return new File(f, name2);
        }
        String falename = name2.substring(k + 1);
        String path = name2.substring(0, k);
        StringTokenizer st = new StringTokenizer(path, "/");
        while (st.hasMoreElements()) {
            String s = (String)st.nextElement();
            if ((f = new File(f, s)).exists()) continue;
            f.mkdir();
        }
        if (falename.length() > 0) {
            return new File(f, falename);
        }
        return null;
    }

    public static void extraZip(String zipname, String targetPath) {
        ZipFile zipfile = null;
        try {
            zipfile = new ZipFile(zipname);
        }
        catch (Exception e) {
            System.out.println(e);
            System.exit(0);
        }
        Enumeration<? extends ZipEntry> em = zipfile.entries();
        String baseDir = targetPath;
        byte[] buf = new byte[8192];
        while (em.hasMoreElements()) {
            ZipEntry item = em.nextElement();
            String name2 = item.getName();
            File file = Repleacor.createFile(baseDir, name2);
            if (file == null) continue;
            try {
                int n;
                InputStream in = zipfile.getInputStream(item);
                FileOutputStream out = new FileOutputStream(file);
                while ((n = in.read(buf)) > 0) {
                    ((OutputStream)out).write(buf, 0, n);
                }
                ((OutputStream)out).close();
            }
            catch (IOException in) {
                // empty catch block
            }
            long m = item.getSize();
            System.out.println(m);
            byte[] extra = item.getExtra();
            System.out.println(item);
        }
    }

    public static void main(String[] args) {
        Repleacor rep = new Repleacor("c:\\esooner2\\com\\woodland\\jxp\\xpath", "java");
        rep.repleaceString(".eval(node,", ".eval(");
    }

    public class MyFilter
    implements FilenameFilter {
        String ext;

        MyFilter(String ext) {
            this.ext = "." + ext;
        }

        @Override
        public boolean accept(File dir, String name2) {
            if (name2.endsWith(this.ext)) {
                return true;
            }
            try {
                File f = new File(dir, name2);
                if (f.isDirectory()) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }
    }
}

