/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.common.util;

import java.io.File;
import java.io.FilenameFilter;

public class SimpleFileFilter
implements FilenameFilter {
    private String[] extensions;

    public SimpleFileFilter(String ext) {
        this(new String[]{ext});
    }

    public SimpleFileFilter(String[] exts) {
        this.extensions = new String[exts.length];
        for (int i = 0; i < exts.length; ++i) {
            this.extensions[i] = exts[i].toLowerCase();
        }
    }

    @Override
    public boolean accept(File dir, String _name) {
        String name2 = _name.toLowerCase();
        for (int i = 0; i < this.extensions.length; ++i) {
            if (!name2.endsWith(this.extensions[i])) continue;
            return true;
        }
        return false;
    }

    public static String[] fileOrFiles(File f) {
        if (f == null) {
            return null;
        }
        File parent = new File(f.getParent());
        String fname = f.getName();
        if (fname.charAt(0) == '*') {
            String filter = fname.substring(1, fname.length());
            String[] files = parent.list(new SimpleFileFilter(filter));
            return files;
        }
        String[] files = new String[]{f.getPath()};
        return files;
    }
}

