/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.common.util;

import com.argo21.common.util.Properties;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.AttributeList;
import org.xml.sax.DocumentHandler;
import org.xml.sax.HandlerBase;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XmlProperties
extends Properties
implements DocumentHandler {
    StringBuffer sb = new StringBuffer();
    String path = "";
    private Writer out;

    public static void main(String[] argv) {
        try {
            XmlProperties xmlProperties = new XmlProperties("config/config.xml");
        }
        catch (IOException err) {
            System.out.println("   " + err.getMessage());
        }
        System.exit(0);
    }

    public XmlProperties(String url) throws IOException {
        if (url == null) {
            return;
        }
        if (url.indexOf(":") < 0) {
            File f = new File(url);
            this.load(new FileInputStream(f));
        } else {
            URL in = new URL(url);
            this.load(in.openStream());
        }
    }

    public synchronized void load(InputStream inStream) throws IOException {
        SAXParserFactory spf = SAXParserFactory.newInstance();
        String validation = System.getProperty("javax.xml.parsers.validation", "false");
        if (validation.equalsIgnoreCase("true")) {
            spf.setValidating(true);
        }
        try {
            SAXParser sp = spf.newSAXParser();
            Parser parser = sp.getParser();
            parser.setDocumentHandler(this);
            parser.setErrorHandler(new MyErrorHandler());
            InputSource in = new InputSource(inStream);
            parser.parse(in);
        }
        catch (SAXParseException err) {
            throw new IOException("** Parsing error, line " + err.getLineNumber() + ", uri " + err.getSystemId() + "   " + err.getMessage());
        }
        catch (SAXException e) {
            throw new IOException(e.getMessage());
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    @Override
    public void setDocumentLocator(Locator l) {
    }

    @Override
    public void startDocument() throws SAXException {
        try {
            this.out = new OutputStreamWriter((OutputStream)System.out, "UTF8");
        }
        catch (IOException e) {
            throw new SAXException("I/O error", e);
        }
    }

    @Override
    public void endDocument() throws SAXException {
        try {
            this.out.write(10);
            this.out.flush();
            this.out = null;
        }
        catch (IOException e) {
            throw new SAXException("I/O error", e);
        }
    }

    @Override
    public void startElement(String tag, AttributeList attrs) throws SAXException {
        this.emit("<");
        this.emit(tag);
        if (attrs != null) {
            for (int i = 0; i < attrs.getLength(); ++i) {
                this.emit(" ");
                this.emit(attrs.getName(i));
                this.emit("\"");
                this.emit(attrs.getValue(i));
                this.emit("\"");
            }
        }
        this.emit(">");
        this.path = this.path != null && this.path.length() > 0 ? this.path + "." + tag : tag;
    }

    @Override
    public void endElement(String name2) throws SAXException {
        int k;
        this.emit("</");
        this.emit(name2);
        this.emit(">");
        if (this.sb.length() > 0) {
            this.emit(this.path + "=" + this.sb.toString());
            if (this.sb.length() > 0) {
                this.sb.setLength(0);
            }
        }
        if ((k = this.path.lastIndexOf(".")) > 0) {
            this.path = this.path.substring(0, k);
        }
    }

    @Override
    public void characters(char[] buf, int offset, int len) throws SAXException {
        char c;
        int first;
        try {
            this.out.write("++");
            this.out.write(buf, offset, len);
        }
        catch (IOException e) {
            throw new SAXException("I/O error", e);
        }
        int last2 = len + offset - 1;
        for (first = offset; first <= last2 && ((c = buf[first]) == '\b' || c == '\n' || c == '\r' || c == ' '); ++first) {
        }
        while (first <= last2 && ((c = buf[last2]) == '\b' || c == '\n' || c == '\r' || c == ' ')) {
            --last2;
        }
        while (first <= last2) {
            this.sb.append(buf[first++]);
        }
    }

    @Override
    public void ignorableWhitespace(char[] buf, int offset, int len) throws SAXException {
        try {
            this.out.write(buf, offset, len);
        }
        catch (IOException e) {
            throw new SAXException("I/O error", e);
        }
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        this.emit("<?");
        this.emit(target);
        this.emit(" ");
        this.emit(data);
        this.emit("?>");
    }

    private void emit(String s) throws SAXException {
        try {
            this.out.write(s);
            this.out.flush();
        }
        catch (IOException e) {
            throw new SAXException("I/O error", e);
        }
    }

    static class MyErrorHandler
    extends HandlerBase {
        MyErrorHandler() {
        }

        @Override
        public void error(SAXParseException e) throws SAXParseException {
            throw e;
        }

        @Override
        public void warning(SAXParseException err) throws SAXParseException {
            System.out.println("** Warning, line " + err.getLineNumber() + ", uri " + err.getSystemId());
            System.out.println("   " + err.getMessage());
        }
    }
}

