/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.js;

import com.argo21.common.io.Debug;
import com.argo21.common.io.XReader;
import com.argo21.common.lang.Function;
import com.argo21.common.lang.MessageCatalog;
import com.argo21.common.lang.ObjectManager;
import com.argo21.common.lang.Operand;
import com.argo21.common.lang.Variable;
import com.argo21.common.lang.VariableReference;
import com.argo21.common.lang.XData;
import com.argo21.common.lang.XDataException;
import com.argo21.common.lang.XDataMultipleException;
import com.argo21.common.lang.XDate;
import com.argo21.common.lang.XMath;
import com.argo21.common.util.BizTranCache;
import com.argo21.js.AssignmentStatement;
import com.argo21.js.BaseStatement;
import com.argo21.js.BreakStatement;
import com.argo21.js.CompileExceptionListener;
import com.argo21.js.ContinueStatement;
import com.argo21.js.DebugStatusListener;
import com.argo21.js.Debuger;
import com.argo21.js.DoWhileStatement;
import com.argo21.js.ForStatement;
import com.argo21.js.FunctionStatement;
import com.argo21.js.GotoStatement;
import com.argo21.js.IfthenStatement;
import com.argo21.js.JsParser;
import com.argo21.js.ReturnStatement;
import com.argo21.js.ScriptEngine;
import com.argo21.js.ScriptException;
import com.argo21.js.Statement;
import com.argo21.js.SwitchStatement;
import com.argo21.js.VariableTable;
import com.argo21.js.WhileStatement;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.net.URL;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class JsEngine
extends ScriptEngine
implements VariableReference {
    public static final String VARIABLE_IGNORECASE = "JSR_IGNORECASE";
    public static final int COMMAND_NON = 0;
    public static final int COMMAND_RUN = 1;
    public static final int COMMAND_DEBUGRUN = 2;
    public static final int COMMAND_CONTINUE = 4;
    public static final int COMMAND_STEP = 8;
    public static final int COMMAND_STEPOVER = 16;
    public static final int COMMAND_STOP = 32;
    public static final int COMMAND_TERMINATE = 64;
    public static final int COMMANDCMD_SETBREKER = 128;
    public static final int COMMAND_RESBREKER = 256;
    public static final int COMMAND_CLR_BREKER = 1024;
    private MyDebuger debuger = null;
    private int lastExcuteLine = -1;
    static MessageCatalog msgCatalog;
    private Hashtable refClass = new Hashtable(11);
    Hashtable functionTable;
    Statement[] statements;
    VariableTable global;
    VariableTable local;
    int pc = 0;
    int count = 0;
    int start = 0;
    XData result = null;
    private String publicId = null;
    private String systemId = null;
    private boolean initialized = false;
    private int firstLine = 0;
    private int totalLines = 0;
    private int status = 0;
    private String contents;
    Exception laseError;
    ErrorHandler handler;
    private Vector listenerList = new Vector(1);

    private void setStatus(int newStatus) {
        if (this.status != newStatus) {
            int oldStatus = this.status;
            this.status = newStatus;
            for (int i = 0; i < this.listenerList.size(); ++i) {
                DebugStatusListener listener = (DebugStatusListener)this.listenerList.elementAt(i);
                listener.statusChanged(oldStatus, newStatus);
            }
        }
    }

    public static JsEngine getJsRuntime() {
        return new JsEngine();
    }

    public JsEngine() {
        this.init();
    }

    @Override
    public void init() {
        if (!this.initialized) {
            this.statements = new Statement[100];
            this.global = new VariableTable();
            this.local = null;
            this.functionTable = new Hashtable(11);
            this.count = 0;
            this.start = 0;
            this.lastExcuteLine = -1;
            this.result = null;
            this.registerObjectRefrence("Date", new XDate(null));
            this.registerObjectRefrence("Math", new XMath());
            this.registerObjectRefrence("Debug", new Debug());
            this.initialized = true;
            this.setStatus(0);
        }
    }

    @Override
    public void reset() {
        this.pc = this.start;
        this.lastExcuteLine = -1;
        this.local = null;
        this.global.releaseVariables();
        this.result = null;
        if (this.status >= 2) {
            this.setStatus(2);
        }
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    @Override
    public String getStatusMessage() {
        switch (this.getStatus()) {
            case 0: {
                return msgCatalog.getMessage("STATE_UNLOAD");
            }
            case 1: {
                return msgCatalog.getMessage("STATE_LOADING");
            }
            case 2: {
                return msgCatalog.getMessage("STATE_READY");
            }
            case 3: {
                return msgCatalog.getMessage("STATE_RUNNING");
            }
            case 5: {
                return msgCatalog.getMessage("STATE_STOP");
            }
        }
        return msgCatalog.getMessage("STATE_TERMINATE");
    }

    @Override
    public void registerObjectRefrence(String name2, Object obj) {
        this.refClass.put(name2, obj);
    }

    @Override
    public Object getObjectRefrence(String name2) {
        return this.refClass.get(name2);
    }

    @Override
    public Object[] getObjectRefrences() {
        int n = this.refClass.size();
        Object[] res = new Object[n];
        Enumeration em = this.refClass.elements();
        int k = 0;
        while (em.hasMoreElements()) {
            res[k++] = em.nextElement();
        }
        return res;
    }

    @Override
    public String getPublicId() {
        return this.publicId;
    }

    @Override
    public String getSystemId() {
        return this.systemId;
    }

    @Override
    public int getFirstLine() {
        return this.firstLine;
    }

    @Override
    public int getTotalLines() {
        return this.totalLines;
    }

    @Override
    public String getContents() {
        return this.contents;
    }

    @Override
    public void loadScripts(XReader in) throws ScriptException {
        this.start = 0;
        this.count = 0;
        this.lastExcuteLine = -1;
        this.functionTable.clear();
        this.setStatus(1);
        this.publicId = in.getPublicId();
        this.systemId = in.getSystemId();
        this.firstLine = in.getLineNumber();
        this.local = null;
        JsParser parser = new JsParser(this);
        in.startRemembering();
        try {
            if (!parser.parseScript(in, this.exceptionListner)) {
                this.initialized = false;
                this.start = 0;
                this.count = 0;
                this.totalLines = 0;
                this.firstLine = 0;
                this.lastExcuteLine = -1;
                this.functionTable.clear();
                this.setStatus(0);
                return;
            }
            this.contents = in.rememberText();
        }
        catch (ScriptException e) {
            this.initialized = false;
            this.start = 0;
            this.count = 0;
            this.totalLines = 0;
            this.firstLine = 0;
            this.lastExcuteLine = -1;
            this.functionTable.clear();
            this.setStatus(0);
            this.contents = in.rememberText();
            throw e;
        }
        this.totalLines = in.getLineNumber() - this.firstLine;
        this.setStatus(2);
    }

    @Override
    public void parseScripts(String text) throws ScriptException {
        XReader in = XReader.createReader(text.toCharArray(), null);
        this.start = 0;
        this.count = 0;
        this.lastExcuteLine = -1;
        this.setStatus(1);
        this.publicId = in.getPublicId();
        this.systemId = in.getSystemId();
        this.firstLine = in.getLineNumber();
        JsParser parser = new JsParser(this);
        try {
            if (!parser.parseScript(in, this.exceptionListner)) {
                this.initialized = false;
                this.start = 0;
                this.count = 0;
                this.totalLines = 0;
                this.firstLine = 0;
                this.lastExcuteLine = -1;
                this.functionTable.clear();
                this.setStatus(0);
                return;
            }
        }
        catch (ScriptException e) {
            this.initialized = false;
            this.start = 0;
            this.count = 0;
            this.totalLines = 0;
            this.firstLine = 0;
            this.lastExcuteLine = -1;
            this.setStatus(0);
            throw e;
        }
        this.totalLines = in.getLineNumber() - this.firstLine;
        this.setStatus(2);
    }

    @Override
    public Operand parseExpression(String text) throws ScriptException {
        XReader in = XReader.createReader(text.toCharArray(), null);
        JsParser parser = new JsParser(this);
        return parser.parseExpression(in);
    }

    private final synchronized void ensureCapacity(int minCapacity) {
        int oldCapacity = this.statements.length;
        if (minCapacity > oldCapacity) {
            Statement[] oldData = this.statements;
            int newCapacity = oldCapacity + 8;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.statements = new Statement[newCapacity];
            System.arraycopy(oldData, 0, this.statements, 0, this.count);
        }
    }

    void appendStatement(Statement statement) {
        this.ensureCapacity(this.count + 1);
        this.statements[this.count++] = statement;
    }

    int getLabelPosition(String label) {
        try {
            return Integer.parseInt(label);
        }
        catch (Exception exception) {
            return -1;
        }
    }

    boolean rigisterFunction(FunctionStatement function) {
        String key = function.name + '(' + String.valueOf(function.getParameterNumber()) + ')';
        if (this.functionTable.containsKey(key)) {
            return false;
        }
        this.functionTable.put(key, function);
        return true;
    }

    FunctionStatement getFunction(String name2, int num) {
        String key = name2 + '(' + String.valueOf(num) + ')';
        return (FunctionStatement)this.functionTable.get(key);
    }

    Function getFunctionCall(String name2, Operand[] parameters) {
        String key = name2 + '(' + String.valueOf(parameters.length) + ')';
        FunctionStatement statement = (FunctionStatement)this.functionTable.get(key);
        if (statement == null) {
            return null;
        }
        return new FunctionCall(statement, parameters);
    }

    @Override
    public void execute() throws SAXException {
        BizTranCache.init();
        if (this.status < 2) {
            String param1 = this.getStatusMessage();
            String param2 = msgCatalog.getMessage("CMD_RUN");
            this.fatal("CANT_CMD_ON", 0, new Object[]{param1, param2});
        }
        this.pc = this.start;
        this.setStatus(3);
        while (this.pc < this.count) {
            String next = this.execute(this.pc);
            if (next == null) continue;
            if (next.equals("return")) break;
            int tmp = this.getLabelPosition(next);
            if (tmp < 0) {
                Statement st = this.statements[this.pc];
                int line = st.getLine();
                this.fatal("CANT_GO_LABEL", line);
                continue;
            }
            this.pc = tmp;
        }
        this.pc = this.start;
        this.setStatus(4);
    }

    @Override
    public Debuger getDebuger() {
        if (this.debuger == null) {
            this.debuger = new MyDebuger();
        }
        return this.debuger;
    }

    public XData getResult() {
        return this.result;
    }

    boolean hasLocal() {
        return this.local != null;
    }

    void setLocal(VariableTable table) {
        this.local = table;
    }

    void releaseLocal() {
        this.local = null;
    }

    @Override
    public Variable getVariable(String name2) {
        Variable result = this.local != null ? this.local.get(name2) : null;
        return result != null ? result : this.global.get(name2);
    }

    @Override
    public void setVariable(Variable item) {
        if (this.local != null && this.local.set(item.name, item)) {
            return;
        }
        this.global.set(item.name, item);
    }

    @Override
    public void putVariable(Variable item) {
        if (this.local != null) {
            this.local.put(item.name, item);
        } else {
            this.global.put(item.name, item);
        }
    }

    @Override
    public void putFixVariable(Variable item) {
        this.global.putfix(item.name, item);
    }

    @Override
    public boolean isFixVariable(Variable item) {
        return this.global.isfix(item.name);
    }

    public boolean allocateGlobal(Variable item) {
        if (this.global.containsKey(item.name)) {
            return false;
        }
        this.global.put(item.name, item);
        return true;
    }

    public boolean allocateLocal(Variable item) {
        if (this.local != null) {
            if (this.local.containsKey(item.name)) {
                return false;
            }
            this.local.put(item.name, item);
            return true;
        }
        if (this.global.containsKey(item.name)) {
            return false;
        }
        this.global.put(item.name, item);
        return true;
    }

    @Override
    public XData getData(String name2) {
        Variable v = this.getVariable(name2);
        return v == null ? null : v.getData();
    }

    @Override
    public void setData(String name2, XData data) {
        Variable v = this.getVariable(name2);
        if (v != null) {
            v.setData(data);
        }
    }

    @Override
    public void putData(String name2, XData data) {
        Variable v = this.getVariable(name2);
        if (v == null) {
            v = new Variable(name2, data);
            this.putVariable(v);
        } else {
            v.setData(data);
        }
    }

    public int localSize() {
        return this.local == null ? 0 : this.local.size();
    }

    public int globalSize() {
        return this.global.size();
    }

    @Override
    public int getLength() {
        int n = this.local == null ? 0 : this.local.size();
        return n + this.global.size();
    }

    @Override
    public boolean definedVariable(String name2) {
        if (this.local != null && this.local.containsKey(name2)) {
            return true;
        }
        return this.global.containsKey(name2);
    }

    public String[] localNames() {
        if (this.local == null) {
            return new String[0];
        }
        int n = this.local.size();
        String[] result = new String[n];
        int k = 0;
        Enumeration e = this.local.keys();
        while (e.hasMoreElements()) {
            result[k++] = (String)e.nextElement();
        }
        return result;
    }

    public String[] globalNames() {
        int n = this.global.size();
        String[] result = new String[n];
        int k = 0;
        Enumeration e = this.global.keys();
        while (e.hasMoreElements()) {
            result[k++] = (String)e.nextElement();
        }
        return result;
    }

    @Override
    public String[] names() {
        Enumeration e;
        int n = this.local == null ? 0 : this.local.size();
        Object[] result = new String[n += this.global.size()];
        int k = 0;
        if (this.local != null) {
            e = this.local.keys();
            while (e.hasMoreElements()) {
                result[k++] = (String)e.nextElement();
            }
        }
        e = this.global.keys();
        while (e.hasMoreElements()) {
            result[k++] = (String)e.nextElement();
        }
        Arrays.sort(result);
        return result;
    }

    @Override
    public Variable[] getVariables() {
        String name2;
        Enumeration e;
        int n = this.local == null ? 0 : this.local.size();
        Variable[] result = new Variable[n += this.global.size()];
        int k = 0;
        if (this.local != null) {
            e = this.local.keys();
            while (e.hasMoreElements()) {
                name2 = (String)e.nextElement();
                result[k++] = this.local.get(name2);
            }
        }
        e = this.global.keys();
        while (e.hasMoreElements()) {
            while (e.hasMoreElements()) {
                name2 = (String)e.nextElement();
                result[k++] = this.global.get(name2);
            }
        }
        return result;
    }

    @Override
    public void dumpAllVaribles(Writer out) throws IOException {
        String eol = "\n";
        Variable[] vs = this.getVariables();
        for (int i = 0; i < vs.length; ++i) {
            Variable v = vs[i];
            out.write(v.name);
            out.write("=");
            v.getData().dump(out);
            out.write(eol);
        }
    }

    @Override
    public VariableReference getVariableReference() {
        return this;
    }

    private String execute(int pc) throws SAXException {
        this.pc = pc;
        if (this.debuger != null) {
            return this.execute(this.debuger.getStatement(pc));
        }
        return this.execute(this.statements[pc]);
    }

    private String execute(Statement st) throws SAXException {
        int type = st.getType();
        try {
            switch (type) {
                case 0: {
                    ++this.pc;
                    return null;
                }
                case 1: {
                    return this.executeAssignment((AssignmentStatement)st);
                }
                case 10: {
                    return this.executeReturn((ReturnStatement)st);
                }
                case 3: {
                    return this.executeIfthen((IfthenStatement)st);
                }
                case 4: {
                    return this.executeSwitch((SwitchStatement)st);
                }
                case 5: {
                    return this.executeWhile((WhileStatement)st);
                }
                case 6: {
                    return this.executeFor((ForStatement)st);
                }
                case 7: {
                    return this.executeDoWhile((DoWhileStatement)st);
                }
                case 8: {
                    return this.executeBreak((BreakStatement)st);
                }
                case 9: {
                    return this.executeContinue((ContinueStatement)st);
                }
                case 2: {
                    return this.executeGoto((GotoStatement)st);
                }
                case 11: {
                    ++this.pc;
                    return null;
                }
                case 12: {
                    ++this.pc;
                    return null;
                }
            }
        }
        catch (XDataException e) {
            this.fatal(st.getLine(), e);
        }
        catch (ScriptException se) {
            throw se;
        }
        return null;
    }

    private String executeReturn(ReturnStatement st) throws SAXException {
        if (st.result != null) {
            try {
                this.result = st.result.getData();
            }
            catch (XDataException e) {
                this.fatal(st.getLine(), e);
            }
        }
        return "return";
    }

    private String executeAssignment(AssignmentStatement st) throws ScriptException, XDataException {
        try {
            if (st.source != null) {
                XData tmp = st.source.getData();
                if (st.target != null) {
                    st.target.setData(tmp);
                }
            }
            String string2 = null;
            return string2;
        }
        finally {
            ++this.pc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String executeFor(ForStatement st) throws SAXException {
        this.pc = st.initPosition;
        while (this.pc < st.incPosition) {
            this.execute(this.pc);
        }
        try {
            XData tmpdata = st.condition.getData();
            while (tmpdata.booleanValue()) {
                this.pc = st.startPosition;
                while (this.pc < st.endPosition) {
                    String next = this.execute(this.pc);
                    if (next == null) continue;
                    int pos = this.getLabelPosition(next);
                    if (next.equals("break")) {
                        this.pc = st.endPosition;
                        String string2 = null;
                        return string2;
                    }
                    if (next.equals("continue")) break;
                    if (pos >= st.startPosition && pos < st.endPosition) {
                        this.pc = pos;
                        continue;
                    }
                    String string3 = next;
                    return string3;
                }
                this.pc = st.incPosition;
                while (this.pc < st.startPosition) {
                    this.execute(this.pc);
                }
                tmpdata = st.condition.getData();
            }
            String string4 = null;
            return string4;
        }
        finally {
            this.pc = st.endPosition;
        }
    }

    private String executeIfthen(IfthenStatement st) throws SAXException {
        String next;
        boolean booltmp = false;
        try {
            XData tmpdata = st.condition.getData();
            booltmp = tmpdata.booleanValue();
        }
        catch (XDataException e) {
            this.fatal(st.getLine(), e);
        }
        if (booltmp) {
            this.pc = st.thenPosition;
            while (this.pc < st.elsePosition) {
                next = this.execute(this.pc);
                if (next == null) continue;
                int tmp = this.getLabelPosition(next);
                if (tmp >= st.thenPosition && tmp < st.elsePosition) {
                    this.pc = tmp;
                    continue;
                }
                return next;
            }
        } else {
            this.pc = st.elsePosition;
            while (this.pc < st.endPosition) {
                next = this.execute(this.pc);
                if (next == null) continue;
                int tmp = this.getLabelPosition(next);
                if (tmp >= st.elsePosition && tmp < st.endPosition) {
                    this.pc = tmp;
                    continue;
                }
                return next;
            }
        }
        this.pc = st.endPosition;
        return null;
    }

    private String executeSwitch(SwitchStatement st) throws SAXException {
        try {
            XData tmpdata = st.condition.getData();
            int num = st.getCaseNumber();
            for (int i = 0; i < num; ++i) {
                Operand match = st.getMatch(i);
                try {
                    int start;
                    XData matchdata = match.getData();
                    if (!matchdata.equals(tmpdata)) continue;
                    this.pc = start = st.getStartPosition(i);
                    while (this.pc < st.endPosition) {
                        String next = this.execute(this.pc);
                        if (next == null) continue;
                        if (next.equals("break")) break;
                        int tmp = this.getLabelPosition(next);
                        if (tmp >= start && tmp < st.endPosition) {
                            this.pc = tmp;
                            continue;
                        }
                        return next;
                    }
                    this.pc = st.endPosition;
                    return null;
                }
                catch (XDataException e) {
                    this.fatal(st.getLine(), e);
                }
            }
        }
        catch (XDataException e) {
            this.fatal(st.getLine(), e);
        }
        if (st.defaultPosition >= 0) {
            int start;
            this.pc = start = st.defaultPosition;
            while (this.pc < st.endPosition) {
                String next = this.execute(this.pc);
                if (next == null) continue;
                if (next.equals("break")) break;
                int tmp = this.getLabelPosition(next);
                if (tmp >= start && tmp < st.endPosition) {
                    this.pc = tmp;
                    continue;
                }
                return next;
            }
            return null;
        }
        this.pc = st.endPosition;
        return null;
    }

    private String executeGoto(GotoStatement st) throws SAXException {
        int tmp = this.getLabelPosition(st.labelref);
        if (tmp < 0) {
            this.fatal("CANT_GO_LABEL", st.line);
        }
        return st.labelref;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String executeWhile(WhileStatement st) throws SAXException {
        try {
            XData tmpdata = st.condition.getData();
            boolean tmp = tmpdata.booleanValue();
            while (tmp) {
                this.pc = st.startPosition;
                while (this.pc < st.endPosition) {
                    String next = this.execute(this.pc);
                    if (next == null) continue;
                    int pos = this.getLabelPosition(next);
                    if (pos >= st.startPosition && pos < st.endPosition) {
                        this.pc = pos;
                        continue;
                    }
                    if (next.equals("break")) {
                        String string2 = null;
                        return string2;
                    }
                    if (next.equals("continue")) break;
                    String string3 = next;
                    return string3;
                }
                tmpdata = st.condition.getData();
                tmp = tmpdata.booleanValue();
            }
            String string4 = null;
            return string4;
        }
        finally {
            this.pc = st.endPosition;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String executeDoWhile(DoWhileStatement st) throws SAXException {
        try {
            boolean tmp = true;
            while (tmp) {
                this.pc = st.startPosition;
                while (this.pc < st.endPosition) {
                    String next = this.execute(this.pc);
                    if (next == null) continue;
                    int pos = this.getLabelPosition(next);
                    if (pos >= st.startPosition && pos < st.endPosition) {
                        this.pc = pos;
                        continue;
                    }
                    if (next.equals("break")) {
                        String string2 = null;
                        return string2;
                    }
                    if (next.equals("continue")) break;
                    String string3 = next;
                    return string3;
                }
                XData tmpdata = st.condition.getData();
                tmp = tmpdata.booleanValue();
            }
            String string4 = null;
            return string4;
        }
        finally {
            this.pc = st.endPosition;
        }
    }

    private String executeBreak(BreakStatement st) throws ScriptException {
        if (st.labelref == null) {
            return "break";
        }
        return st.labelref;
    }

    private String executeContinue(ContinueStatement st) throws ScriptException {
        if (st.labelref == null) {
            return "continue";
        }
        return st.labelref;
    }

    @Override
    public void setErrorHandler(ErrorHandler handler) {
        this.handler = handler;
    }

    private void fatal(String msgID, int line) throws SAXException {
        this.fatal(msgID, line, new Object[0]);
    }

    private void fatal(String msgID, int line, String s) throws SAXException {
        this.fatal(msgID, line, new Object[]{s});
    }

    private void fatal(String msgID, int line, Object[] parameters) throws SAXException {
        String msg = msgCatalog.getMessage(msgID, parameters);
        ScriptException e = new ScriptException(msg, this.publicId, this.systemId, line, 0);
        e.msgID = msgID;
        if (this.handler == null) {
            throw e;
        }
        this.handler.error(e);
    }

    private void fatal(int line, XDataException e) throws SAXException {
        XDataException[] exceptions = e instanceof XDataMultipleException ? ((XDataMultipleException)e).getExceptions() : new XDataException[]{e};
        int n = exceptions.length;
        for (int i = 0; i < n; ++i) {
            Exception e1 = exceptions[i].getException();
            if (e1 instanceof ScriptException) {
                throw (ScriptException)e1;
            }
            String msg = exceptions[i].getMessage();
            ScriptException exception = new ScriptException(msg, this.publicId, this.systemId, line, 0, exceptions[i]);
            boolean throwException = exceptions[i].isThrowException();
            if (!throwException) {
                if (this.handler != null) {
                    this.handler.warning(exception);
                    continue;
                }
                Debug.println(msg);
                continue;
            }
            if (this.handler != null) {
                this.handler.error(exception);
                continue;
            }
            throw exception;
        }
    }

    static {
        String lang = System.getProperty("user.msg.lang", null);
        if (lang == null) {
            lang = Locale.getDefault().getLanguage();
        }
        String classbase = JsEngine.class.getName();
        int k = classbase.lastIndexOf(".");
        classbase = classbase.substring(0, k + 1) + "MessageCatalog_";
        try {
            msgCatalog = (MessageCatalog)Class.forName(classbase + lang).newInstance();
        }
        catch (Exception e) {
            try {
                msgCatalog = (MessageCatalog)Class.forName(classbase + "en").newInstance();
            }
            catch (Exception e1) {
                System.out.println(e1);
                System.exit(1);
            }
        }
        ObjectManager.registBasicDataObject();
        if (!ObjectManager.isRegisted(Debug.class)) {
            Debug.registObject();
        }
    }

    class MyDebuger
    implements Runnable,
    Debuger {
        private int command = 0;
        private Thread runner = null;
        private int timer = 0;

        MyDebuger() {
        }

        @Override
        public void addDebugStatusListener(DebugStatusListener listener) {
            if (!JsEngine.this.listenerList.contains(listener)) {
                JsEngine.this.listenerList.add(listener);
            }
        }

        @Override
        public void removeDebugStatusListener(DebugStatusListener listener) {
            JsEngine.this.listenerList.remove(listener);
        }

        @Override
        public void setCompileExceptionListener(CompileExceptionListener exceptionListner) {
            JsEngine.this.setCompileExceptionListener(exceptionListner);
        }

        @Override
        public void loadScripts(URL url) throws ScriptException, IOException {
            this.loadScripts(XReader.createReader(url, false));
        }

        @Override
        public void loadScripts(File file) throws ScriptException, IOException {
            this.loadScripts(XReader.createReader(file));
        }

        @Override
        public void loadScripts(InputSource is) throws ScriptException, IOException {
            this.loadScripts(XReader.createReader(is));
        }

        @Override
        public void loadScripts(XReader in) throws ScriptException {
            JsEngine.this.loadScripts(in);
        }

        @Override
        public String getContents() {
            return JsEngine.this.contents;
        }

        @Override
        public void reset() {
            JsEngine.this.reset();
        }

        @Override
        public void init() {
            JsEngine.this.init();
        }

        @Override
        public int getStatus() {
            return JsEngine.this.getStatus();
        }

        @Override
        public String getStatusMessage() {
            return JsEngine.this.getStatusMessage();
        }

        @Override
        public String getPublicId() {
            return JsEngine.this.getPublicId();
        }

        @Override
        public String getSystemId() {
            return JsEngine.this.getPublicId();
        }

        @Override
        public int getFirstLine() {
            return JsEngine.this.getFirstLine();
        }

        @Override
        public int getTotalLines() {
            return JsEngine.this.getTotalLines();
        }

        @Override
        public VariableReference getVariableReference() {
            return JsEngine.this.getVariableReference();
        }

        @Override
        public void registerObjectRefrence(String name2, Object obj) {
            JsEngine.this.registerObjectRefrence(name2, obj);
        }

        @Override
        public Object getObjectRefrence(String name2) {
            return JsEngine.this.getObjectRefrence(name2);
        }

        @Override
        public Object[] getObjectRefrences() {
            return JsEngine.this.getObjectRefrences();
        }

        @Override
        public void setErrorHandler(ErrorHandler handler) {
            JsEngine.this.setErrorHandler(handler);
        }

        @Override
        public Exception getLastException() {
            return JsEngine.this.laseError;
        }

        @Override
        public synchronized void execute() throws SAXException {
            if (JsEngine.this.status == 2 || JsEngine.this.status == 4) {
                if (JsEngine.this.status == 4) {
                    this.reset();
                }
                this.command = 2;
                JsEngine.this.setStatus(3);
                JsEngine.this.pc = JsEngine.this.start;
                this.runner = new Thread(this);
                this.runner.setDaemon(true);
                this.runner.setPriority(1);
                this.runner.start();
            } else {
                String param1 = this.getStatusMessage();
                String param2 = msgCatalog.getMessage("CMD_DEBUGRUN");
                JsEngine.this.fatal("CANT_CMD_ON", 0, new Object[]{param1, param2});
            }
        }

        @Override
        public synchronized void continued() throws SAXException {
            if (JsEngine.this.status == 5) {
                this.command = 4;
                this.notifyAll();
                JsEngine.this.setStatus(3);
                JsEngine.this.laseError = null;
            } else {
                String param1 = this.getStatusMessage();
                String param2 = msgCatalog.getMessage("CMD_CONTINUE");
                JsEngine.this.fatal("CANT_CMD_ON", 0, new Object[]{param1, param2});
            }
        }

        @Override
        public synchronized void step() throws SAXException {
            int tmp = JsEngine.this.status;
            if (tmp == 2 || tmp == 4) {
                this.command = 8;
                JsEngine.this.setStatus(3);
                JsEngine.this.pc = JsEngine.this.start;
                if (tmp == 4) {
                    this.reset();
                }
                this.runner = new Thread(this);
                this.runner.setDaemon(true);
                this.runner.setPriority(1);
                this.runner.start();
            } else if (JsEngine.this.status == 5) {
                this.command = 8;
                this.notifyAll();
                JsEngine.this.setStatus(3);
                JsEngine.this.laseError = null;
            } else {
                String param1 = this.getStatusMessage();
                String param2 = msgCatalog.getMessage("CMD_STEP");
                JsEngine.this.fatal("CANT_CMD_ON", 0, new Object[]{param1, param2});
            }
        }

        @Override
        public synchronized void stepOver() throws SAXException {
            int tmp = JsEngine.this.status;
            if (tmp == 2 || tmp == 4) {
                this.command = 16;
                JsEngine.this.setStatus(3);
                JsEngine.this.pc = JsEngine.this.start;
                if (tmp == 4) {
                    this.reset();
                }
                this.runner = new Thread(this);
                this.runner.setDaemon(true);
                this.runner.setPriority(1);
                this.runner.start();
            } else if (tmp == 5) {
                this.command = 16;
                this.notifyAll();
                JsEngine.this.setStatus(3);
                JsEngine.this.laseError = null;
            } else {
                String param1 = this.getStatusMessage();
                String param2 = msgCatalog.getMessage("CMD_STEPOVER");
                JsEngine.this.fatal("CANT_CMD_ON", 0, new Object[]{param1, param2});
            }
        }

        @Override
        public synchronized void debugstop() throws SAXException {
            if (JsEngine.this.status == 3 || JsEngine.this.status == 5) {
                this.command = 32;
                if (JsEngine.this.status == 5) {
                    this.notifyAll();
                }
                JsEngine.this.setStatus(3);
                JsEngine.this.laseError = null;
            } else {
                String param1 = this.getStatusMessage();
                String param2 = msgCatalog.getMessage("CMD_STOP");
                JsEngine.this.fatal("CANT_CMD_ON", 0, new Object[]{param1, param2});
            }
        }

        @Override
        public synchronized void debugexit() throws SAXException {
            if (JsEngine.this.status >= 2) {
                this.command = 64;
                if (JsEngine.this.status == 5) {
                    this.notifyAll();
                }
                JsEngine.this.setStatus(3);
                JsEngine.this.laseError = null;
            } else {
                String param1 = this.getStatusMessage();
                String param2 = msgCatalog.getMessage("CMD_TERMINATE");
                JsEngine.this.fatal("CANT_CMD_ON", 0, new Object[]{param1, param2});
            }
        }

        @Override
        public boolean addBreaker(int breakPointer) throws SAXException {
            if (JsEngine.this.status < 2) {
                String param1 = this.getStatusMessage();
                String param2 = msgCatalog.getMessage("CMD_SET_BREKER");
                JsEngine.this.fatal("CANT_CMD_ON", 0, new Object[]{param1, param2});
            }
            for (int i = 0; i < JsEngine.this.count; ++i) {
                BaseStatement st = (BaseStatement)JsEngine.this.statements[i];
                if (st.line != breakPointer) continue;
                st.breaker = true;
                return true;
            }
            return false;
        }

        @Override
        public boolean clearBreaker(int breakPointer) throws SAXException {
            if (JsEngine.this.status < 2) {
                String param1 = this.getStatusMessage();
                String param2 = msgCatalog.getMessage("CMD_RES_BREKER");
                JsEngine.this.fatal("CANT_CMD_ON", 0, new Object[]{param1, param2});
            }
            for (int i = 0; i < JsEngine.this.count; ++i) {
                BaseStatement st = (BaseStatement)JsEngine.this.statements[i];
                if (st.line != breakPointer) continue;
                st.breaker = false;
                return true;
            }
            return false;
        }

        @Override
        public void clearAllBreaker() throws SAXException {
            if (JsEngine.this.status < 2) {
                String param1 = this.getStatusMessage();
                String param2 = msgCatalog.getMessage("CMD_CLR_BREKER");
                JsEngine.this.fatal("CANT_CMD_ON", 0, new Object[]{param1, param2});
            }
            for (int i = 0; i < JsEngine.this.count; ++i) {
                ((BaseStatement)JsEngine.this.statements[i]).breaker = false;
            }
        }

        @Override
        public int[] getBreakers() {
            int n = 0;
            for (int i = 0; i < JsEngine.this.count; ++i) {
                BaseStatement st = (BaseStatement)JsEngine.this.statements[i];
                if (!st.breaker) continue;
                ++n;
            }
            int[] res = new int[n];
            n = 0;
            for (int i = 0; i < JsEngine.this.count; ++i) {
                BaseStatement st = (BaseStatement)JsEngine.this.statements[i];
                if (!st.breaker) continue;
                res[n++] = i;
            }
            return res;
        }

        @Override
        public boolean isBraker(int line) {
            for (int i = 0; i < JsEngine.this.count; ++i) {
                BaseStatement st = (BaseStatement)JsEngine.this.statements[i];
                if (line != st.getLine()) continue;
                return st.breaker;
            }
            return false;
        }

        @Override
        public synchronized int getCurrentLine() {
            if (JsEngine.this.pc < JsEngine.this.count) {
                return JsEngine.this.statements[JsEngine.this.pc].getLine();
            }
            return -1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int waitCommand() {
            MyDebuger myDebuger = this;
            synchronized (myDebuger) {
                JsEngine.this.setStatus(5);
                this.command = 0;
                while (this.command == 0 || this.command == 32) {
                    try {
                        this.wait();
                    }
                    catch (Exception exception) {}
                }
            }
            return this.command;
        }

        Statement getStatement(int pc) {
            if (this.runner == null) {
                JsEngine.this.pc = pc;
                return JsEngine.this.statements[pc];
            }
            int cmd = 0;
            int line = JsEngine.this.statements[pc].getLine();
            if (this.command == 2 || this.command == 4) {
                if (JsEngine.this.statements[pc].isBreaker() && line != JsEngine.this.lastExcuteLine) {
                    cmd = this.waitCommand();
                }
            } else if (this.command == 8) {
                if (line != JsEngine.this.lastExcuteLine) {
                    cmd = this.waitCommand();
                }
            } else if (this.command == 16) {
                if (JsEngine.this.statements[pc].isBreaker()) {
                    if (line != JsEngine.this.lastExcuteLine) {
                        cmd = this.waitCommand();
                    }
                } else if (pc >= JsEngine.this.start && line != JsEngine.this.lastExcuteLine) {
                    cmd = this.waitCommand();
                }
            } else if (this.command == 32) {
                cmd = this.waitCommand();
            } else if (this.command == 64) {
                cmd = 64;
            } else {
                if (pc > JsEngine.this.count) {
                    cmd = 64;
                    JsEngine.this.lastExcuteLine = -1;
                    return new ReturnStatement(0, null);
                }
                JsEngine.this.pc = pc;
                JsEngine.this.lastExcuteLine = line;
                return JsEngine.this.statements[pc];
            }
            if (cmd == 64) {
                JsEngine.this.lastExcuteLine = -1;
                return new ReturnStatement(0, null);
            }
            if (pc > JsEngine.this.count) {
                cmd = 64;
                JsEngine.this.lastExcuteLine = -1;
                return new ReturnStatement(0, null);
            }
            JsEngine.this.pc = pc;
            JsEngine.this.lastExcuteLine = line;
            return JsEngine.this.statements[pc];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Thread thisThread = Thread.currentThread();
            JsEngine.this.laseError = null;
            while (this.runner == thisThread && JsEngine.this.pc < JsEngine.this.count && this.command != 64) {
                String next = null;
                try {
                    next = JsEngine.this.execute(this.getStatement(JsEngine.this.pc));
                    if (next == null) continue;
                    if (next.equals("return")) {
                        JsEngine.this.laseError = null;
                        break;
                    }
                    int tmp = JsEngine.this.getLabelPosition(next);
                    if (tmp < 0) {
                        Statement st = JsEngine.this.statements[JsEngine.this.pc];
                        int line = st.getLine();
                        JsEngine.this.fatal("CANT_GO_LABEL", line);
                        continue;
                    }
                    JsEngine.this.pc = tmp;
                }
                catch (SAXException e) {
                    JsEngine.this.laseError = e;
                    break;
                }
            }
            MyDebuger myDebuger = this;
            synchronized (myDebuger) {
                JsEngine.this.pc = JsEngine.this.start;
                JsEngine.this.setStatus(4);
            }
        }
    }

    class FunctionCall
    extends Function {
        FunctionStatement statement;

        FunctionCall(FunctionStatement statement, Operand[] parameters) {
            super(statement.name);
            this.statement = statement;
            this.parameters = parameters;
        }

        @Override
        public XData getData() throws XDataException {
            int savePc = JsEngine.this.pc;
            VariableTable local = this.statement.localVariables;
            int n = this.statement.getParameterNumber();
            for (int i = 0; i < n; ++i) {
                Operand op = this.parameters[i];
                XData data = op.getData();
                this.statement.repleaceParameter(i, data);
            }
            JsEngine.this.setLocal(this.statement.localVariables);
            int startpos = this.statement.startPosition;
            int endpos = this.statement.endPosition;
            JsEngine.this.pc = startpos;
            while (JsEngine.this.pc < endpos) {
                try {
                    String next = JsEngine.this.debuger != null ? JsEngine.this.execute(JsEngine.this.debuger.getStatement(JsEngine.this.pc)) : JsEngine.this.execute(JsEngine.this.pc);
                    if (next == null) continue;
                    if (next.equals("return") || next.equals("exit")) break;
                    int pos = JsEngine.this.getLabelPosition(next);
                    if (pos >= startpos && pos < endpos) {
                        JsEngine.this.pc = pos;
                        continue;
                    }
                    JsEngine.this.fatal("CANT_GO_LABEL", this.statement.line);
                }
                catch (Exception e) {
                    XData.error(e, true);
                }
            }
            XData tmp = JsEngine.this.result;
            JsEngine.this.result = null;
            local.releaseVariables();
            JsEngine.this.releaseLocal();
            JsEngine.this.pc = savePc;
            return tmp;
        }

        @Override
        public String getEncoding() {
            return null;
        }
    }
}

