/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.js;

import com.argo21.common.io.XReader;
import com.argo21.common.lang.ArithmeticOperate;
import com.argo21.common.lang.BitOperate;
import com.argo21.common.lang.CompareOperate;
import com.argo21.common.lang.Constant;
import com.argo21.common.lang.ExtOperand;
import com.argo21.common.lang.ExtOperandParser;
import com.argo21.common.lang.Function;
import com.argo21.common.lang.IncOrDecOperate;
import com.argo21.common.lang.Index;
import com.argo21.common.lang.Method;
import com.argo21.common.lang.MixOperate;
import com.argo21.common.lang.Operand;
import com.argo21.common.lang.Operate;
import com.argo21.common.lang.Property;
import com.argo21.common.lang.ReverseOperate;
import com.argo21.common.lang.ShiftOperate;
import com.argo21.common.lang.Variable;
import com.argo21.common.lang.XBoolean;
import com.argo21.common.lang.XData;
import com.argo21.common.lang.XDouble;
import com.argo21.common.lang.XFloat;
import com.argo21.common.lang.XInteger;
import com.argo21.common.lang.XLong;
import com.argo21.common.lang.XNull;
import com.argo21.common.lang.XObject;
import com.argo21.common.lang.XString;
import com.argo21.js.AssignmentStatement;
import com.argo21.js.BaseStatement;
import com.argo21.js.BreakStatement;
import com.argo21.js.CompileExceptionListener;
import com.argo21.js.ContinueStatement;
import com.argo21.js.DoWhileStatement;
import com.argo21.js.EmptyStatement;
import com.argo21.js.ForStatement;
import com.argo21.js.FunctionStatement;
import com.argo21.js.GotoStatement;
import com.argo21.js.IfthenStatement;
import com.argo21.js.JsEngine;
import com.argo21.js.ReturnStatement;
import com.argo21.js.ScriptException;
import com.argo21.js.Statement;
import com.argo21.js.SwitchStatement;
import com.argo21.js.WhileStatement;
import java.util.Hashtable;
import java.util.Vector;

public final class JsParser {
    public static final int KEY_boolean = 1;
    public static final int KEY_break = 2;
    public static final int KEY_byte = 3;
    public static final int KEY_case = 4;
    public static final int KEY_cast = 5;
    public static final int KEY_char = 6;
    public static final int KEY_class = 7;
    public static final int KEY_const = 8;
    public static final int KEY_continue = 9;
    public static final int KEY_default = 10;
    public static final int KEY_do = 11;
    public static final int KEY_double = 12;
    public static final int KEY_else = 13;
    public static final int KEY_ext = 14;
    public static final int KEY_extends = 15;
    public static final int KEY_false = 16;
    public static final int KEY_float = 17;
    public static final int KEY_for = 18;
    public static final int KEY_function = 19;
    public static final int KEY_goto = 20;
    public static final int KEY_if = 21;
    public static final int KEY_in = 22;
    public static final int KEY_int = 23;
    public static final int KEY_long = 24;
    public static final int KEY_new = 25;
    public static final int KEY_null = 26;
    public static final int KEY_return = 27;
    public static final int KEY_short = 28;
    public static final int KEY_switch = 29;
    public static final int KEY_this = 30;
    public static final int KEY_to = 31;
    public static final int KEY_true = 32;
    public static final int KEY_typeof = 33;
    public static final int KEY_var = 34;
    public static final int KEY_while = 35;
    public static final char ObjectOrientation_SPLIT = '.';
    private static final String[] RESERVATION = new String[]{"boolean", "break", "byte", "case", "cast", "char", "class", "const", "continue", "default", "do", "double", "else", "ext", "extends", "false", "float", "for", "function", "goto", "if", "in", "int", "long", "new", "null", "return", "short", "switch", "this", "to", "true", "typeof", "var", "while"};
    private static final int[] STATEMENT_ID = new int[]{0, 0, 8, 0, 0, 0, 0, 0, 0, 9, 0, 7, 0, 0, 0, 0, 0, 0, 6, 12, 2, 3, 0, 0, 0, 0, 0, 10, 0, 4, 0, 0, 0, 0, 11, 5};
    private static final Hashtable KEY_TABLE = new Hashtable(44);
    private XReader in;
    private OperateStack operate_stack;
    private OperandStack operand_stack;
    private int interLayer = 0;
    private int interLoop = 0;
    private int interSwitch = 0;
    private boolean isFunction = false;
    private JsEngine jsEngine;
    private char[] buf = new char[64];
    private Hashtable labelTable;

    public static int getKeyId(String key) {
        Integer obj = (Integer)KEY_TABLE.get(key);
        return obj == null ? 0 : obj;
    }

    public static boolean isReservation(String key) {
        return KEY_TABLE.containsKey(key);
    }

    static int getStatementID(int keyId) {
        return STATEMENT_ID[keyId];
    }

    JsParser(JsEngine jsEngine) {
        this.jsEngine = jsEngine;
    }

    boolean parseScript(XReader in) throws ScriptException {
        return this.parseScript(in, null);
    }

    boolean parseScript(XReader in, CompileExceptionListener listner) throws ScriptException {
        this.in = in;
        in.peekWhitespace();
        this.operate_stack = new OperateStack();
        this.operand_stack = new OperandStack();
        this.labelTable = new Hashtable(11);
        this.interLayer = 0;
        this.interLoop = 0;
        this.interSwitch = 0;
        boolean b = false;
        if (in.isEOF()) {
            this.fatal("EMPTY_SCRIPT");
        }
        if (listner != null) {
            while (!in.isEOF()) {
                boolean hasErr = false;
                try {
                    b = this.parseStatementBlock();
                }
                catch (ScriptException e) {
                    hasErr = true;
                    listner.exceptionHappened(e);
                }
                if (in.isEOF()) continue;
                in.readToEol();
                in.peekWhitespace();
            }
        } else {
            b = this.parseStatementBlock();
        }
        this.resolveLabel(this.jsEngine.start, this.jsEngine.count);
        this.operate_stack = null;
        this.operand_stack = null;
        this.labelTable = null;
        this.in = null;
        return b;
    }

    Operand parseExpression(XReader in) throws ScriptException {
        this.in = in;
        in.peekWhitespace();
        this.operate_stack = new OperateStack();
        this.operand_stack = new OperandStack();
        Operand opd = this.parseExpression(0, 0, 0);
        if (!in.isEOF()) {
            this.fatal("INVALID_CHAR", in.lookupWord());
        }
        return opd;
    }

    private boolean parseStatementBlock() throws ScriptException {
        char c;
        this.in.peekWhitespace();
        while ((c = this.in.getc()) != '\u0000') {
            if (c == '/') {
                if (this.in.peekc('/')) {
                    this.in.skipLine();
                } else if (this.in.peekc('*')) {
                    this.in.skipTo("*/");
                } else {
                    this.in.ungetc();
                    this.fatal("INVALID_CHAR", this.in.lookupWord());
                }
            } else if (c != ';') {
                if (c == '}') {
                    this.in.ungetc();
                    if (this.interLayer != 0 || this.isFunction) break;
                    this.fatal("INVALID_CHAR", "}");
                } else {
                    if (c > '\u0000') {
                        this.in.ungetc();
                    }
                    String label = null;
                    String str = this.in.peekName();
                    if (str != null) {
                        boolean b = this.in.peekWhitespace();
                        if (this.in.peekc(':')) {
                            this.in.peekWhitespace();
                            if (JsParser.getKeyId(str) != 0) {
                                this.fatal("INVALID_LABEL", str);
                            }
                            label = str;
                            str = this.in.peekName();
                        } else if (b && c > '\u0000') {
                            this.in.ungetc();
                        }
                    }
                    if (label != null) {
                        if (this.definedLabel(label)) {
                            this.fatal("DOUBLE_LABEL", label);
                        }
                        this.rigisterLabel(label);
                    }
                    if (!this.parseStatement(str)) {
                        return false;
                    }
                }
            }
            this.in.peekWhitespace();
        }
        return true;
    }

    private void parseInternalStatements() throws ScriptException {
        char c;
        this.in.peekWhitespace();
        boolean multi = false;
        while ((c = this.in.getc()) != '\u0000') {
            if (c == '/') {
                if (this.in.peekc('/')) {
                    this.in.skipLine();
                } else if (this.in.peekc('*')) {
                    this.in.skipTo("*/");
                } else {
                    this.in.ungetc();
                    this.fatal("INVALID_CHAR", this.in.lookupWord());
                }
            } else {
                if (c == ';') {
                    return;
                }
                if (c == '{') {
                    multi = true;
                    break;
                }
                this.in.ungetc();
                break;
            }
            this.in.peekWhitespace();
        }
        if (multi) {
            ++this.interLayer;
            this.parseStatementBlock();
            --this.interLayer;
            if (!this.in.peekc('}')) {
                this.fatal("MUSTBE_CHAR", "}");
            }
        } else {
            String str = this.in.peekName();
            this.parseStatement(str);
        }
    }

    private boolean parseStatement(String nameKey) throws ScriptException {
        if (nameKey != null) {
            int keyid = JsParser.getKeyId(nameKey);
            if (keyid == 0 || keyid == 30) {
                return this.parseAssignmentStatement(nameKey, ';');
            }
            if (keyid == 25) {
                return this.parseAssignmentStatement(27, ';');
            }
            int statement = STATEMENT_ID[keyid];
            switch (statement) {
                case 2: {
                    return this.parseGotoStatement();
                }
                case 3: {
                    return this.parseIfthenStatement();
                }
                case 4: {
                    return this.parseSwithStatement();
                }
                case 5: {
                    return this.parseWhileStatement();
                }
                case 6: {
                    return this.parseForStatement();
                }
                case 7: {
                    return this.parseDoWhileStatement();
                }
                case 8: {
                    if (this.interLoop == 0 && this.interSwitch == 0) {
                        this.fatal("CANT_USE_ON_MAIN", "break");
                    }
                    return this.parseBreakStatement();
                }
                case 9: {
                    if (this.interLoop == 0) {
                        this.fatal("CANT_USE_ON_MAIN", "continue");
                    }
                    return this.parseContinueStatement();
                }
                case 10: {
                    return this.parseReturnStatement();
                }
                case 11: {
                    return this.parseVarStatement();
                }
                case 12: {
                    if (this.interLayer != 0 || this.interLoop != 0 || this.isFunction || this.interSwitch != 0) {
                        this.fatal("MUST_USE_ON_MAIN", "function");
                    }
                    return this.parseFunctionStatement();
                }
            }
            this.fatal("INVALID_VARIABLE", nameKey);
            return false;
        }
        String optKey = this.maybeGetOperateKey();
        if (optKey == null) {
            this.fatal("INVALID_CHAR", this.in.lookupWord());
            return false;
        }
        if (optKey.equals("++")) {
            return this.parseAssignmentStatement(22, ';');
        }
        if (optKey.equals("--")) {
            return this.parseAssignmentStatement(23, ';');
        }
        this.fatal("INVALID_CHAR", optKey);
        return false;
    }

    private boolean parseIfthenStatement() throws ScriptException {
        int num = this.in.getLineNumber();
        this.in.peekWhitespace();
        if (!this.in.peekc('(')) {
            this.fatal("MUSTBE_CHAR_AFTER", new Object[]{"if", "("});
        }
        this.in.peekWhitespace();
        Operand condition = this.parseCondition();
        if (condition == null) {
            this.fatal("INVALID_CONDITION");
        }
        this.in.peekWhitespace();
        if (!this.in.peekc(')')) {
            this.fatal("MUSTBE_CHAR", ")");
        }
        IfthenStatement statement = new IfthenStatement(num, condition);
        this.jsEngine.appendStatement(statement);
        statement.thenPosition = this.jsEngine.count;
        this.in.peekWhitespace();
        this.parseInternalStatements();
        statement.elsePosition = this.jsEngine.count;
        this.in.peekWhitespace();
        if (this.in.peek("else")) {
            this.parseInternalStatements();
        }
        statement.endPosition = this.jsEngine.count;
        return true;
    }

    private boolean parseWhileStatement() throws ScriptException {
        int num = this.in.getLineNumber();
        this.in.peekWhitespace();
        if (!this.in.peekc('(')) {
            this.fatal("MUSTBE_CHAR_AFTER", new Object[]{"while", "("});
        }
        this.in.peekWhitespace();
        Operand condition = this.parseCondition();
        if (condition == null) {
            this.fatal("INVALID_CONDITION");
        }
        this.in.peekWhitespace();
        if (!this.in.peekc(')')) {
            this.fatal("MUSTBE_CHAR", ")");
        }
        WhileStatement statement = new WhileStatement(num, condition);
        this.jsEngine.appendStatement(statement);
        this.in.peekWhitespace();
        statement.startPosition = this.jsEngine.count;
        ++this.interLoop;
        this.parseInternalStatements();
        --this.interLoop;
        statement.endPosition = this.jsEngine.count;
        return true;
    }

    private boolean parseForStatement() throws ScriptException {
        int num = this.in.getLineNumber();
        this.in.peekWhitespace();
        if (!this.in.peekc('(')) {
            this.fatal("MUSTBE_CHAR_AFTER", new Object[]{"for", "("});
        }
        this.in.peekWhitespace();
        ForStatement statement = new ForStatement(num);
        this.jsEngine.appendStatement(statement);
        statement.initPosition = this.jsEngine.count;
        this.parseAssignmentStatement(';');
        this.in.peekWhitespace();
        statement.condition = this.parseCondition();
        this.in.peekWhitespace();
        if (!this.in.peekc(';')) {
            this.fatal("MUSTBE_CHAR", ";");
        }
        this.in.peekWhitespace();
        statement.incPosition = this.jsEngine.count;
        this.parseAssignmentStatement(')');
        if (!this.in.peekc(')')) {
            this.fatal("MUSTBE_CHAR", ")");
        }
        statement.startPosition = this.jsEngine.count;
        ++this.interLoop;
        this.parseInternalStatements();
        --this.interLoop;
        statement.endPosition = this.jsEngine.count;
        return true;
    }

    private boolean parseReturnStatement() throws ScriptException {
        Operand ret = null;
        int line = this.in.getLineNumber();
        this.in.peekWhitespace();
        if (!this.in.peekc(';')) {
            ret = this.parseExpression(0, 0, 0);
            this.in.peekWhitespace();
            if (!this.in.peekc(';')) {
                this.fatal("MUSTBE_CHAR_END", ";");
            }
        }
        ReturnStatement statement = new ReturnStatement(line, ret);
        this.jsEngine.appendStatement(statement);
        return true;
    }

    private boolean parseSwithStatement() throws ScriptException {
        int line = this.in.getLineNumber();
        this.in.peekWhitespace();
        if (!this.in.peekc('(')) {
            this.fatal("MUSTBE_CHAR_AFTER", new Object[]{"switch", "("});
        }
        this.in.peekWhitespace();
        Operand condition = this.parseExpression(0, 0, 0);
        if (condition == null) {
            this.fatal("INVALID_CONDITION");
        }
        this.in.peekWhitespace();
        if (!this.in.peekc(')')) {
            this.fatal("MUSTBE_CHAR", ")");
        }
        SwitchStatement statement = new SwitchStatement(line, condition);
        this.jsEngine.appendStatement(statement);
        this.in.peekWhitespace();
        if (!this.in.peekc('{')) {
            this.fatal("MUSTBE_CHAR", "{");
        }
        while (true) {
            this.in.peekWhitespace();
            if (this.in.peek("case")) {
                this.in.peekWhitespace();
                Operand match = this.parseSimpleOperand();
                if (match == null) {
                    this.fatal("MUST_VALUE_AFTER", "case");
                }
                this.in.peekWhitespace();
                if (!this.in.peekc(':')) {
                    this.fatal("MUSTBE_CHAR", ":");
                }
                this.in.peekWhitespace();
                statement.addCase(match, this.jsEngine.count);
                this.parseCaseStatements();
                continue;
            }
            if (this.in.peek("default")) {
                this.in.peekWhitespace();
                if (!this.in.peekc(':')) {
                    this.fatal("MUSTBE_CHAR", ":");
                }
                this.in.peekWhitespace();
                statement.defaultPosition = this.jsEngine.count;
                this.parseCaseStatements();
                continue;
            }
            if (this.in.peekc('}')) break;
            this.fatal("NEED_CHAR", "}");
        }
        statement.endPosition = this.jsEngine.count;
        return true;
    }

    private boolean parseCaseStatements() throws ScriptException {
        char c;
        ++this.interSwitch;
        this.in.peekWhitespace();
        if (this.in.isChar('{')) {
            this.parseInternalStatements();
            --this.interSwitch;
            return true;
        }
        while ((c = this.in.getc()) != '\u0000') {
            if (c == '/') {
                if (this.in.peekc('/')) {
                    this.in.skipLine();
                } else if (this.in.peekc('*')) {
                    this.in.skipTo("*/");
                } else {
                    this.in.ungetc();
                    this.fatal("INVALID_CHAR", this.in.lookupWord());
                }
            } else if (c != ';') {
                if (c == '}') {
                    this.in.ungetc();
                    break;
                }
                this.in.ungetc();
                String label = null;
                String str = this.in.peekName();
                if (str.equals("case") || str.equals("default")) {
                    this.in.back(str.length());
                    break;
                }
                if (str != null) {
                    boolean b = this.in.peekWhitespace();
                    if (this.in.peekc(':')) {
                        this.in.peekWhitespace();
                        if (JsParser.getKeyId(str) != 0) {
                            this.fatal("INVALID_LABEL", str);
                        }
                        label = str;
                        str = this.in.peekName();
                    } else if (b) {
                        this.in.ungetc();
                    }
                }
                if (label != null) {
                    if (this.definedLabel(label)) {
                        this.fatal("DOUBLE_LABEL", label);
                    }
                    this.rigisterLabel(label);
                }
                if (!this.parseStatement(str)) {
                    --this.interSwitch;
                    return false;
                }
            }
            this.in.peekWhitespace();
        }
        --this.interSwitch;
        return true;
    }

    private boolean parseDoWhileStatement() throws ScriptException {
        this.in.peekWhitespace();
        int num = this.in.getLineNumber();
        DoWhileStatement statement = new DoWhileStatement(num);
        this.jsEngine.appendStatement(statement);
        statement.startPosition = this.jsEngine.count;
        ++this.interLoop;
        this.parseInternalStatements();
        --this.interLoop;
        statement.endPosition = this.jsEngine.count;
        this.in.peekWhitespace();
        String key = this.in.peekName();
        if (key != null && key.equals("while")) {
            this.in.peekWhitespace();
            if (!this.in.peekc('(')) {
                this.fatal("MUSTBE_CHAR_AFTER", new Object[]{"while", "("});
            }
            this.in.peekWhitespace();
            Operand condition = this.parseCondition();
            if (condition == null) {
                this.fatal("INVALID_CONDITION");
            }
            this.in.peekWhitespace();
            if (!this.in.peekc(')')) {
                this.fatal("MUSTBE_CHAR", ")");
            }
            statement.condition = condition;
            this.in.peekWhitespace();
            if (!this.in.peekc(';')) {
                this.fatal("MUSTBE_CHAR", ";");
            }
        } else {
            if (key != null) {
                this.in.back(key.length());
            }
            statement.condition = new Constant(true);
        }
        return true;
    }

    private boolean parseContinueStatement() throws ScriptException {
        int num = this.in.getLineNumber();
        String labRef = null;
        this.in.peekWhitespace();
        if (!this.in.peekc(';')) {
            labRef = this.in.peekName();
            if (labRef == null) {
                this.fatal("MUSTBE_CHAR_END", ";");
            }
            this.in.peekWhitespace();
            if (!this.in.peekc(';')) {
                this.fatal("MUSTBE_CHAR_END", ";");
            }
        }
        ContinueStatement statement = new ContinueStatement(num, labRef);
        this.jsEngine.appendStatement(statement);
        return true;
    }

    private boolean parseBreakStatement() throws ScriptException {
        int num = this.in.getLineNumber();
        String labRef = null;
        this.in.peekWhitespace();
        if (!this.in.peekc(';')) {
            labRef = this.in.peekName();
            if (labRef == null) {
                this.fatal("MUSTBE_CHAR_END", ";");
            }
            this.in.peekWhitespace();
            if (!this.in.peekc(';')) {
                this.fatal("MUSTBE_CHAR_END", ";");
            }
        }
        BreakStatement statement = new BreakStatement(num, labRef);
        this.jsEngine.appendStatement(statement);
        return true;
    }

    private boolean parseVarStatement() throws ScriptException {
        Variable target;
        int num = this.in.getLineNumber();
        this.in.peekWhitespace();
        String name2 = this.in.peekName();
        if (name2 == null) {
            this.fatal("MUST_VARIABLE_AFTER", "var");
        }
        if (!this.jsEngine.allocateLocal(target = new Variable(name2, new XNull()))) {
            this.fatal("DOUBLE_VARIABLE", name2);
        }
        this.in.peekWhitespace();
        if (this.in.peekc('=')) {
            this.in.peekWhitespace();
            Operand source = this.parseExpression(0, 0, 0);
            if (source == null) {
                this.fatal("NEED_SET_VALUE", name2);
            }
            if (target.getType() == 2) {
                target.setReference(source.getReference());
                target.setDataType(source.getDataType());
            }
            AssignmentStatement statement = new AssignmentStatement(num, source, target);
            this.jsEngine.appendStatement(statement);
        }
        if (!this.in.peekc(';')) {
            this.fatal("MUSTBE_CHAR_END", ";");
        }
        return true;
    }

    private boolean parseGotoStatement() throws ScriptException {
        int num = this.in.getLineNumber();
        this.in.peekWhitespace();
        String refLabel = this.in.peekName();
        if (refLabel == null) {
            this.fatal("MUST_LABEL", "goto");
        }
        if (JsParser.isReservation(refLabel)) {
            this.fatal("INVALID_LABEL");
        }
        this.in.peekWhitespace();
        if (!this.in.peekc(';')) {
            this.fatal("MUSTBE_CHAR_END", ";");
        }
        GotoStatement gotostate = new GotoStatement(num, refLabel);
        this.jsEngine.appendStatement(gotostate);
        return true;
    }

    private boolean parseFunctionStatement() throws ScriptException {
        if (this.isFunction) {
            this.fatal("CANT_FUNC_IN");
        }
        if (this.jsEngine.start != this.jsEngine.count) {
            this.fatal("FUNC_MAST_BEFORE");
        }
        int num = this.in.getLineNumber();
        this.in.peekWhitespace();
        String name2 = this.in.peekName();
        if (name2 == null) {
            this.fatal("MAST_FUNC_NAME");
        }
        FunctionStatement statement = new FunctionStatement(num, name2);
        this.in.peekWhitespace();
        if (!this.in.peekc('(')) {
            this.fatal("MUSTBE_CHAR", "(");
        }
        this.in.peekWhitespace();
        if (!this.in.peekc(')')) {
            while (true) {
                Variable v;
                String param;
                if ((param = this.in.peekName()) == null) {
                    this.fatal("INVALID_PARAM");
                }
                if (!statement.addParameters(v = new Variable(param, new XNull()))) {
                    this.fatal("DOUBLE_VARIABLE", param);
                }
                this.in.peekWhitespace();
                if (this.in.peekc(',')) {
                    this.in.peekWhitespace();
                    continue;
                }
                if (this.in.peekc(')')) break;
                this.fatal("MUSTBE_CHAR", ")");
            }
        }
        if (!this.jsEngine.rigisterFunction(statement)) {
            this.fatal("DOUBLE_FUNC", name2);
        }
        this.jsEngine.setLocal(statement.localVariables);
        Hashtable saveLabelTable = this.labelTable;
        this.labelTable = new Hashtable(11);
        statement.startPosition = this.jsEngine.count;
        this.in.peekWhitespace();
        if (!this.in.peekc('{')) {
            this.fatal("MUSTBE_CHAR", "{");
        }
        this.in.peekWhitespace();
        this.isFunction = true;
        this.parseStatementBlock();
        this.isFunction = false;
        this.in.peekWhitespace();
        if (!this.in.peekc('}')) {
            this.fatal("MUSTBE_CHAR", "}");
        }
        statement.endPosition = this.jsEngine.count;
        this.resolveLabel(statement.startPosition, statement.endPosition);
        this.jsEngine.start = this.jsEngine.count;
        this.jsEngine.releaseLocal();
        this.labelTable = saveLabelTable;
        return true;
    }

    private boolean parseAssignmentStatement(char endChar) throws ScriptException {
        Object statement = null;
        this.in.peekWhitespace();
        if (this.in.peekc(endChar)) {
            this.jsEngine.appendStatement(new EmptyStatement(this.in.getLineNumber()));
            return true;
        }
        String nameKey = this.in.peekName();
        if (nameKey != null) {
            int keyid = JsParser.getKeyId(nameKey);
            if (keyid == 0) {
                return this.parseAssignmentStatement(nameKey, endChar);
            }
            if (keyid == 25) {
                return this.parseAssignmentStatement(27, endChar);
            }
        } else {
            int optid;
            boolean b;
            String optKey = this.maybeGetOperateKey();
            if (optKey == null) {
                this.fatal("INVALID_CHAR", this.in.lookupWord());
            }
            if (!(b = this.parseAssignmentStatement(optid = Operate.getOPT(optKey), endChar))) {
                this.fatal("INVALID_OPT", String.valueOf(optKey));
            }
            return b;
        }
        this.fatal("INVALID_VARIABLE", nameKey);
        return true;
    }

    private boolean parseAssignmentStatement(int optid, char endChar) throws ScriptException {
        AssignmentStatement statement = null;
        int num = this.in.getLineNumber();
        if (optid == 22) {
            this.in.peekWhitespace();
            String name2 = this.in.peekName();
            if (name2 == null) {
                this.fatal("MUST_ROPRAND", "++");
            }
            Operand target = this.parseExtendVariable(name2, 0, 0, true);
            this.maybeVariableAndExists(target);
            this.maybeChangeVariable(target);
            IncOrDecOperate operate = new IncOrDecOperate(22, null, target);
            statement = new AssignmentStatement(num, operate, null);
        } else if (optid == 23) {
            this.in.peekWhitespace();
            String name3 = this.in.peekName();
            if (name3 == null) {
                this.fatal("MUST_ROPRAND", "--");
            }
            Operand target = this.parseExtendVariable(name3, 0, 0, true);
            this.maybeVariableAndExists(target);
            this.maybeChangeVariable(target);
            IncOrDecOperate operate = new IncOrDecOperate(23, null, target);
            statement = new AssignmentStatement(num, operate, null);
        } else if (optid == 27) {
            this.in.peekWhitespace();
            Operand oprand = this.parseConstructer();
            statement = new AssignmentStatement(num, oprand, null);
        }
        if (statement != null) {
            this.in.peekWhitespace();
            if (endChar == ';') {
                if (!this.in.peekc(endChar)) {
                    this.fatal("MUSTBE_CHAR", ";");
                }
            } else if (!this.in.isChar(endChar)) {
                this.fatal("MUSTBE_CHAR", ";");
            }
            this.jsEngine.appendStatement(statement);
            return true;
        }
        return false;
    }

    private boolean parseAssignmentStatement(String name2, char endChar) throws ScriptException {
        AssignmentStatement statement = null;
        int num = this.in.getLineNumber();
        this.in.peekWhitespace();
        Operand target = this.parseExtendVariable(name2, 0, 0, true);
        this.in.peekWhitespace();
        if (target == null) {
            this.fatal("INVALID_OPRAND", name2);
            return false;
        }
        int type = target.getType();
        if (type == 1) {
            this.fatal("UNCH_CONST");
            return false;
        }
        if (type == 3) {
            this.fatal("INVALID_ASSIGN");
            return false;
        }
        if (type == 5 || type == 7) {
            this.in.peekSpace();
            if (endChar == ';') {
                if (!this.in.peekc(endChar)) {
                    this.fatal("MUSTBE_CHAR", ";");
                }
            } else if (!this.in.isChar(endChar)) {
                this.fatal("MUSTBE_CHAR", String.valueOf(endChar));
            }
            statement = new AssignmentStatement(num, target, null);
            this.jsEngine.appendStatement(statement);
            return true;
        }
        String s = this.maybeGetOperateKey();
        if (s == null) {
            this.fatal("INVALID_CHAR", this.in.lookupWord());
        }
        if (s.equals("++")) {
            this.maybeVariableAndExists(target);
            this.maybeChangeVariable(target);
            IncOrDecOperate operate = new IncOrDecOperate(22, target, null);
            statement = new AssignmentStatement(num, operate, null);
        } else if (s.equals("--")) {
            this.maybeVariableAndExists(target);
            this.maybeChangeVariable(target);
            IncOrDecOperate operate = new IncOrDecOperate(23, target, null);
            statement = new AssignmentStatement(num, operate, null);
        } else if (s.endsWith("=")) {
            this.maybeChangeVariable(target);
            String ss = s.substring(0, s.length() - 1);
            Operand source = this.parseExpression(0, 0, 0);
            if (source == null) {
                this.fatal("MUST_ROPRAND", s);
            }
            if (ss.equals("")) {
                if (target.getType() == 2) {
                    Variable v1 = this.jsEngine.getVariable(((Variable)target).name);
                    if (v1 != null) {
                        target = v1;
                    } else {
                        this.jsEngine.allocateGlobal((Variable)target);
                    }
                }
                if (target.getType() == 2) {
                    target.setReference(source.getReference());
                    target.setDataType(source.getDataType());
                }
                statement = new AssignmentStatement(num, source, target);
            } else {
                int optcode = Operate.getOPT(ss);
                if (Operate.canAssignOperate(optcode)) {
                    this.maybeVariableAndExists(target);
                    Operate operate = null;
                    if (Operate.isArithmeticOperate(optcode)) {
                        operate = new ArithmeticOperate(optcode, target, source);
                    } else if (Operate.isBitOperate(optcode)) {
                        operate = new BitOperate(optcode, target, source);
                    } else if (Operate.isShiftOperate(optcode)) {
                        operate = new ShiftOperate(optcode, target, source);
                    } else {
                        this.fatal("INVALID_OPT", s);
                    }
                    statement = new AssignmentStatement(num, operate, target);
                } else {
                    this.fatal("INVALID_OPT", s);
                }
            }
        } else {
            this.fatal("INVALID_OPT", s);
        }
        if (statement != null) {
            this.in.peekSpace();
            if (endChar == ';') {
                if (!this.in.peekc(endChar)) {
                    this.fatal("MUSTBE_CHAR", ";");
                }
            } else if (!this.in.isChar(endChar)) {
                this.fatal("MUSTBE_CHAR", String.valueOf(endChar));
            }
            this.jsEngine.appendStatement(statement);
            return true;
        }
        return false;
    }

    private void maybeVariableAndExists(Operand operand) throws ScriptException {
        if (operand.getType() == 2) {
            Variable varible = (Variable)operand;
            if (this.jsEngine.getVariable(varible.name) == null) {
                this.fatal("UNDEF_VARIABLE", varible.name);
            }
        }
    }

    private void maybeChangeVariable(Operand operand) throws ScriptException {
        Variable varible;
        if (operand.getType() == 2 && this.jsEngine.isFixVariable(varible = (Variable)operand)) {
            this.fatal("CANT_SET_VALUE", varible.name);
        }
    }

    private Operand parseCondition() throws ScriptException {
        this.operate_stack = new OperateStack();
        this.operand_stack = new OperandStack();
        return this.parseExpression(0, 0, 0);
    }

    private Operand parseExpression() throws ScriptException {
        this.operate_stack.elementCount = 0;
        this.operand_stack.elementCount = 0;
        return this.parseExpression(0, 0, 0);
    }

    private Operand parseExpression(int operate_num, int operand_num, int priority) throws ScriptException {
        char c;
        this.in.peekWhitespace();
        int mark = 0;
        while ((c = this.in.getc()) != '\u0000' && c != ';' && c != ')' && c != ']' && c != ':' && c != ',') {
            if (c == '(') {
                this.in.peekWhitespace();
                Operand operand = this.parseExpression(this.operate_stack.size(), this.operand_stack.size(), 0);
                if (operand == null) {
                    this.fatal("INVALID_CHAR", "(");
                }
                this.in.peekWhitespace();
                if (!this.in.peekc(')')) {
                    this.fatal("MUSTBE_CHAR", ")");
                }
                this.in.peekWhitespace();
                this.operand_stack.push(operand);
                mark = 2;
            } else {
                Operand tmp;
                this.in.ungetc();
                String nameKey = this.in.peekName();
                if (nameKey != null) {
                    int keyid = JsParser.getKeyId(nameKey);
                    if (keyid == 25) {
                        Operand operand = this.parseConstructer();
                        this.operand_stack.push(operand);
                        mark = 2;
                    } else if (keyid == 33) {
                        Operand right = this.parseExpression(this.operate_stack.size(), this.operand_stack.size(), Operate.PRIORITY[29]);
                        if (right == null) {
                            this.fatal("MUST_ROPRAND", nameKey);
                        }
                        MixOperate operand = new MixOperate(29, null, right);
                        this.operand_stack.push(operand);
                        mark = 2;
                    } else if (keyid == 22) {
                        if (mark != 2) {
                            this.fatal("INVALID_OPT", nameKey);
                        }
                        this.operate_stack.push(28);
                        mark = 1;
                    } else if (keyid == 14) {
                        if (mark != 2) {
                            this.fatal("INVALID_OPT", nameKey);
                        }
                        this.operate_stack.push(30);
                        mark = 1;
                    } else if (keyid == 26) {
                        if (mark == 2) {
                            this.fatal("MUST_LOPT", nameKey);
                        }
                        Constant operand = new Constant(XData.XNULL);
                        this.operand_stack.push(operand);
                        mark = 2;
                    } else if (keyid == 32 || keyid == 16) {
                        if (mark == 2) {
                            this.fatal("MUST_LOPT", nameKey);
                        }
                        Constant operand = new Constant(keyid == 32);
                        this.operand_stack.push(operand);
                        mark = 2;
                    } else {
                        if (keyid != 0 && keyid != 30) break;
                        if (mark == 2) {
                            this.fatal("MUST_LOPT", nameKey);
                        }
                        Operand operand = this.parseExtendVariable(nameKey, operate_num, operand_num, false);
                        this.maybeVariableAndExists(operand);
                        this.in.peekWhitespace();
                        this.operand_stack.push(operand);
                        mark = 2;
                    }
                } else if (mark != 2 && (tmp = this.parseConst()) != null) {
                    this.operand_stack.push(tmp);
                    mark = 2;
                } else {
                    int optid;
                    String optKey = this.maybeGetOperateKey();
                    if (optKey == null) {
                        this.fatal("INVALID_CHAR", this.in.lookupWord());
                    }
                    if ((optid = Operate.getOPT(optKey)) <= 0) break;
                    if (Operate.PRIORITY[optid] <= priority) {
                        this.exhaustOperate(operate_num, operand_num, Operate.PRIORITY[optid]);
                        this.in.back(optKey.length());
                        return this.operand_stack.pop(operand_num);
                    }
                    switch (mark) {
                        case 0: {
                            Operate opt;
                            Operand right;
                            if (Operate.isReverseOperate(optid)) {
                                right = this.parseExpression(this.operate_stack.size(), this.operand_stack.size(), Operate.PRIORITY[optid]);
                                if (right == null) {
                                    this.fatal("MUST_ROPRAND", optKey);
                                }
                                opt = new ReverseOperate(optid, right);
                                this.operand_stack.push(opt);
                                mark = 2;
                                break;
                            }
                            if (Operate.isIncOrDecOperate(optid)) {
                                right = this.parseExpression(this.operate_stack.size(), this.operand_stack.size(), Operate.PRIORITY[optid]);
                                if (right == null) {
                                    this.fatal("MUST_ROPRAND", optKey);
                                }
                                opt = new IncOrDecOperate(optid, null, right);
                                this.operand_stack.push(opt);
                                mark = 2;
                                break;
                            }
                            this.fatal("MUST_LOPRAND", optKey);
                            break;
                        }
                        case 1: {
                            Operate opt;
                            Operand right;
                            if (Operate.isReverseOperate(optid)) {
                                right = this.parseExpression(this.operate_stack.size(), this.operand_stack.size(), Operate.PRIORITY[optid]);
                                if (right == null) {
                                    this.fatal("MUST_ROPRAND", optKey);
                                }
                                opt = new ReverseOperate(optid, right);
                                this.operand_stack.push(opt);
                                mark = 2;
                                break;
                            }
                            this.fatal("INVALID_OPT", optKey);
                            break;
                        }
                        default: {
                            Operate opt;
                            if (Operate.isIncOrDecOperate(optid)) {
                                Operand left = this.operand_stack.pop(operand_num);
                                if (left == null) {
                                    this.fatal("MUST_LOPRAND", optKey);
                                }
                                opt = new IncOrDecOperate(optid, left, null);
                                this.operand_stack.push(opt);
                                mark = 2;
                                break;
                            }
                            if (optid == 12 || optid == 13 || optid == 29) {
                                this.fatal("INVALID_OPT", optKey);
                                mark = 2;
                                break;
                            }
                            if (optid == 25) {
                                Operand operand2;
                                Operand operand1;
                                Operand condition = this.operand_stack.pop(operand_num);
                                if (condition == null) {
                                    this.fatal("MUST_LOPRAND", optKey);
                                }
                                if ((operand1 = this.parseExpression(this.operate_stack.size(), this.operand_stack.size(), 0)) == null) {
                                    this.fatal("MUST_ROPRAND", optKey);
                                }
                                this.in.peekWhitespace();
                                if (!this.in.peekc(':')) {
                                    this.fatal("MUSTBE_CHAR", ":");
                                }
                                if ((operand2 = this.parseExpression(this.operate_stack.size(), this.operand_stack.size(), 0)) == null) {
                                    this.fatal("MUST_ROPRAND", ":");
                                }
                                MixOperate opt2 = new MixOperate(condition, operand1, operand2);
                                this.operand_stack.push(opt2);
                                mark = 2;
                                break;
                            }
                            this.exhaustOperate(operate_num, operand_num, Operate.PRIORITY[optid]);
                            this.operate_stack.push(optid);
                            mark = 1;
                        }
                    }
                }
            }
            this.in.peekWhitespace();
        }
        this.exhaustOperate(operate_num, operand_num, 0);
        if (c != '\u0000') {
            this.in.ungetc();
        }
        return this.operand_stack.pop(operand_num);
    }

    private void exhaustOperate(int operate_num, int operand_num, int priority) throws ScriptException {
        int optid;
        while (this.operate_stack.size() > operate_num && Operate.PRIORITY[optid = this.operate_stack.peek()] >= priority) {
            Operate operate;
            this.operate_stack.pop(operate_num);
            Operand right = this.operand_stack.pop(operand_num);
            Operand left = this.operand_stack.pop(operand_num);
            if (Operate.isArithmeticOperate(optid)) {
                operate = new ArithmeticOperate(optid, left, right);
            } else if (Operate.isBitOperate(optid)) {
                operate = new BitOperate(optid, left, right);
            } else if (Operate.isShiftOperate(optid)) {
                operate = new ShiftOperate(optid, left, right);
            } else if (Operate.isCompareOperate(optid)) {
                XData tmp = this.jsEngine.getData("JSR_IGNORECASE");
                boolean b = false;
                if (tmp != null) {
                    try {
                        tmp.booleanValue();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                operate = new CompareOperate(optid, left, right, b);
            } else {
                operate = new MixOperate(optid, left, right);
            }
            this.operand_stack.push(operate);
        }
    }

    private Operand parseConst() throws ScriptException {
        XData data;
        int type = 0;
        if (this.in.peekc('{')) {
            Vector<XData> parm = new Vector<XData>();
            while (!this.in.isEOF()) {
                this.in.peekWhitespace();
                data = this.parseString();
                if (data != null) {
                    parm.addElement(data);
                    if (type < 6) {
                        type = 6;
                    }
                } else {
                    data = this.parseNumber();
                    if (data != null) {
                        parm.addElement(data);
                        int tmp = data.getPrimitiveType();
                        if (type < tmp) {
                            type = tmp;
                        }
                    } else {
                        data = this.parseBooleanOrNull();
                        if (data != null) {
                            parm.addElement(data);
                            if (type < 6) {
                                type = 5;
                            }
                        } else {
                            this.fatal("MUSTBE_CHAR", "}");
                        }
                    }
                }
                this.in.peekWhitespace();
                if (this.in.peekc('}')) break;
                if (this.in.peekc(',')) continue;
                this.fatal("MUSTBE_CHAR", ",");
            }
            if (parm.size() > 0 && type >= 1 && type <= 6) {
                return new Constant(parm, type);
            }
            this.fatal("INVALID_ARRAY");
        }
        if ((data = this.parseString()) != null) {
            return new Constant(data);
        }
        data = this.parseNumber();
        if (data != null) {
            return new Constant(data);
        }
        data = this.parseBooleanOrNull();
        if (data != null) {
            return new Constant(data);
        }
        return null;
    }

    private XData parseNumber() throws ScriptException {
        int radix = 10;
        int type = 0;
        char c = this.in.getc();
        int num = 1;
        int k = 0;
        if (c == '-') {
            this.buf[k++] = c;
            c = this.in.getc();
            ++num;
            if (c < '0' || c > '9') {
                this.in.back(num);
                return null;
            }
        }
        if (c == '0') {
            this.buf[k++] = c;
            c = this.in.getc();
            if (c == 'x' || c == 'X') {
                radix = 16;
                c = this.in.getc();
            }
        } else if (c < '0' || c > '9') {
            this.in.back(num);
            return null;
        }
        if (radix == 10) {
            while (c != '\u0000') {
                if (k >= this.buf.length) {
                    this.extendsBuf();
                }
                if (c >= '0' && c <= '9') {
                    this.buf[k++] = c;
                } else if (c == '.') {
                    if (type < 2) {
                        type = 3;
                    }
                    this.buf[k++] = c;
                } else {
                    if (c != 'e' && c != 'E') {
                        if (c == 'l' || c == 'L') {
                            type = 1;
                        } else if (c == 'f' || c == 'F') {
                            type = 2;
                        } else if (c == 'd' || c == 'D') {
                            type = 3;
                        } else {
                            this.in.ungetc();
                        }
                        break;
                    }
                    if (type < 2) {
                        type = 3;
                    }
                    this.buf[k++] = c;
                    if (this.in.peekc('+')) {
                        this.buf[k++] = 43;
                    }
                    if (this.in.peekc('-')) {
                        this.buf[k++] = 45;
                    }
                }
                c = this.in.getc();
            }
        } else {
            while (c != '\u0000') {
                if (k >= this.buf.length) {
                    this.extendsBuf();
                }
                if (c >= '0' && c <= '9') {
                    this.buf[k++] = c;
                } else {
                    if (!(c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F')) {
                        if (c >= 'l' && c <= 'L') {
                            type = 1;
                        } else {
                            this.in.ungetc();
                        }
                        break;
                    }
                    this.buf[k++] = c;
                }
                c = this.in.getc();
            }
        }
        String s = new String(this.buf, 0, k);
        XData result = null;
        try {
            switch (type) {
                case 1: {
                    result = new XLong(Long.parseLong(s, radix));
                    break;
                }
                case 2: {
                    result = new XFloat(Float.parseFloat(s));
                    break;
                }
                case 3: {
                    result = new XDouble(Double.parseDouble(s));
                    break;
                }
                default: {
                    try {
                        result = new XInteger(Integer.parseInt(s, radix));
                    }
                    catch (Exception e) {
                        result = new XLong(Long.parseLong(s, radix));
                    }
                    break;
                }
            }
        }
        catch (Exception e) {
            this.fatal("INVALID_CONST", s);
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     */
    private XData parseBooleanOrNull() {
        if (this.in.peek("true")) {
            char c = this.in.getc();
            if (!Character.isLetter(c) && c != '_') {
                this.in.ungetc();
                return new XBoolean(true);
            }
            this.in.back(5);
            return null;
        }
        if (this.in.peek("false")) {
            char c = this.in.getc();
            if (!Character.isLetter(c) && c != '_') {
                this.in.ungetc();
                return new XBoolean(false);
            }
            this.in.back(6);
            return null;
        }
        if (!this.in.peek("null")) return null;
        char c = this.in.getc();
        if (!Character.isLetter(c) && c != '_') {
            this.in.ungetc();
            return new XNull();
        }
        this.in.back(5);
        return null;
    }

    private XData parseString() {
        char c;
        char quote = this.in.getc();
        if (quote != '\'' && quote != '\"') {
            if (quote != '\u0000') {
                this.in.ungetc();
            }
            return null;
        }
        int k = 0;
        block12: while ((c = this.in.getc()) != quote) {
            if (k >= this.buf.length) {
                this.extendsBuf();
            }
            if (c == '\u0000') break;
            if (c == '\\') {
                int i;
                int num;
                c = this.in.getc();
                switch (c) {
                    case 'b': {
                        this.buf[k++] = 8;
                        continue block12;
                    }
                    case 't': {
                        this.buf[k++] = 9;
                        continue block12;
                    }
                    case 'n': {
                        this.buf[k++] = 10;
                        continue block12;
                    }
                    case 'f': {
                        this.buf[k++] = 12;
                        continue block12;
                    }
                    case 'r': {
                        this.buf[k++] = 13;
                        continue block12;
                    }
                    case '\"': {
                        this.buf[k++] = 34;
                        continue block12;
                    }
                    case '\'': {
                        this.buf[k++] = 39;
                        continue block12;
                    }
                    case '\\': {
                        this.buf[k++] = 92;
                        continue block12;
                    }
                    case 'u': {
                        num = 0;
                        for (i = 0; i < 4; ++i) {
                            c = this.in.getc();
                            if (c >= '0' && c <= '9') {
                                num = num * 16 + (c - 48);
                                continue;
                            }
                            if (c >= 'A' && c <= 'F') {
                                num = num * 16 + (c - 65);
                                continue;
                            }
                            if (c >= 'a' && c <= 'f') {
                                num = num * 16 + (c - 97);
                                continue;
                            }
                            this.in.ungetc();
                            break;
                        }
                        if (i <= 0) continue block12;
                        this.buf[k++] = (char)num;
                        continue block12;
                    }
                    case '\u0000': {
                        continue block12;
                    }
                }
                num = 0;
                for (i = 0; i < 3; ++i) {
                    c = this.in.getc();
                    if (c < '0' || c > '7') {
                        this.in.ungetc();
                        break;
                    }
                    num = num * 16 + (c - 48);
                }
                if (i <= 0) continue;
                this.buf[k++] = (char)num;
                continue;
            }
            this.buf[k++] = c;
        }
        String s = new String(this.buf, 0, k);
        return new XString(s);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Operand parseSimpleOperand() throws ScriptException {
        Operand tmp = this.parseConst();
        if (tmp != null) {
            return tmp;
        }
        String nameKey = this.in.peekName();
        if (nameKey != null) {
            Variable refOperand;
            int keyid = JsParser.getKeyId(nameKey);
            if (keyid > 0) {
                this.fatal("INVALID_VARIABLE", nameKey);
            }
            if ((refOperand = this.jsEngine.getVariable(nameKey)) != null) return refOperand;
            this.fatal("UNDEF_VARIABLE", nameKey);
            return null;
        } else {
            this.fatal("INVALID_CHAR", this.in.lookupWord());
        }
        return null;
    }

    private Operand parseOperand(boolean write) throws ScriptException {
        Operand tmp = this.parseConst();
        if (tmp == null) {
            return tmp;
        }
        String nameKey = this.in.peekName();
        if (nameKey != null) {
            int keyid = JsParser.getKeyId(nameKey);
            if (keyid > 0) {
                this.fatal("INVALID_VARIABLE", nameKey);
            }
            tmp = this.parseExtendVariable(nameKey, 0, 0, write);
            this.maybeVariableAndExists(tmp);
            return tmp;
        }
        this.fatal("INVALID_CHAR", this.in.lookupWord());
        return null;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Operand parseExtendVariable(String name2, int operate_num, int operand_num, boolean write) throws ScriptException {
        void var10_20;
        Variable refOperand;
        Variable thisref;
        char c = this.in.getc();
        if (ExtOperand.isExtOperandSplit(c)) {
            void var10_18;
            Variable refOperand2;
            Variable orientOperand = this.jsEngine.getVariable(name2);
            if (orientOperand == null) {
                this.fatal("UNDEF_VARIABLE", name2);
                return null;
            }
            String refStr = orientOperand.getReference();
            int k = refStr.indexOf(String.valueOf(c));
            if (k > 0) {
                String string2 = refStr.substring(0, k);
                refOperand2 = this.jsEngine.getVariable(string2);
                if (refOperand2 == null) {
                    refOperand2 = orientOperand;
                }
            } else {
                refOperand2 = orientOperand;
            }
            Object var10_16 = null;
            try {
                Object object = refOperand2.getData().objectValue();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (var10_18 != null && var10_18 instanceof ExtOperandParser) {
                ExtOperandParser parser = (ExtOperandParser)var10_18;
                ExtOperand operand = null;
                try {
                    return parser.parseOperand(orientOperand, this.jsEngine.getVariableReference(), this.in);
                }
                catch (Exception e) {
                    throw new ScriptException(null, this.in, e);
                }
            }
            this.fatal("CANT_EXOPRAND", name2);
            return null;
        }
        if (c == '.') {
            boolean st;
            Variable refOperand3;
            Object orient = this.jsEngine.getObjectRefrence(name2);
            if (orient != null) {
                XData ref = orient instanceof XData ? (XData)orient : new XObject(orient);
                refOperand3 = new Variable(name2, ref);
                st = true;
            } else {
                refOperand3 = this.jsEngine.getVariable(name2);
                st = false;
            }
            if (refOperand3 == null) {
                this.fatal("UNDEF_VARIABLE", name2);
                return null;
            }
            Operand operand = this.parseMethodOrProperty(refOperand3, st, write);
            while (this.in.peekc('.')) {
                operand = this.parseMethodOrProperty(operand, false, write);
            }
            return operand;
        }
        if (c == '(') {
            this.in.ungetc();
            return this.parseFuncCall(name2);
        }
        if (c > '\u0000') {
            this.in.ungetc();
        }
        if ((thisref = this.jsEngine.getVariable("this")) != null) {
            Object object = null;
            try {
                object = thisref.getData().objectValue();
            }
            catch (Exception orient) {
                // empty catch block
            }
            if (object != null && Property.contain(object, name2, false)) {
                return new Property(thisref, name2);
            }
        }
        if ((refOperand = this.jsEngine.getVariable(name2)) == null) {
            return new Variable(name2, new XNull());
        }
        if (!this.in.peekc('[')) return refOperand;
        this.in.peekWhitespace();
        Operand operand1 = this.parseExpression(this.operate_stack.size(), this.operand_stack.size(), 0);
        if (operand1 == null) {
            this.fatal("INVALID_CHAR", "[");
        }
        this.in.peekWhitespace();
        Operand operand2 = null;
        if (this.in.peekc(':')) {
            this.in.peekWhitespace();
            operand2 = this.parseExpression(this.operate_stack.size(), this.operand_stack.size(), 0);
            if (operand2 == null) {
                this.fatal("INVALID_CHAR", ":");
            }
            this.in.peekWhitespace();
        }
        if (!this.in.peekc(']')) {
            this.fatal("MUSTBE_CHAR", "]");
        }
        Index index = new Index(refOperand, operand1, operand2);
        while (this.in.peekc('.')) {
            Operand operand = this.parseMethodOrProperty((Operand)var10_20, false, write);
        }
        return var10_20;
    }

    private Operand parseFuncCall(String name2) throws ScriptException {
        Function func;
        Variable thisref;
        if (!this.in.peekc('(')) {
            return null;
        }
        this.in.peekWhitespace();
        Operand[] parameters = new Operand[]{};
        if (!this.in.peekc(')')) {
            while (true) {
                Operand param;
                if ((param = this.parseExpression(this.operate_stack.elementCount, this.operand_stack.elementCount, 0)) == null) {
                    this.fatal("INVALID_PARAM", name2);
                }
                Operand[] tmp = parameters;
                parameters = new Operand[tmp.length + 1];
                System.arraycopy(tmp, 0, parameters, 0, tmp.length);
                parameters[tmp.length] = param;
                this.in.peekWhitespace();
                if (this.in.peekc(',')) {
                    this.in.peekWhitespace();
                    continue;
                }
                if (this.in.peekc(')')) break;
                this.fatal("INVALID_CHAR", ")");
            }
        }
        if ((thisref = this.jsEngine.getVariable("this")) != null) {
            Object object = null;
            try {
                object = thisref.getData().objectValue();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (object != null && Method.contain(object, name2, parameters.length)) {
                return new Method((Operand)thisref, name2, parameters);
            }
        }
        if ((func = this.jsEngine.getFunctionCall(name2, parameters)) == null) {
            this.fatal("INVALID_FUNCCALL", name2);
        }
        return func;
    }

    private Operand parseMethodOrProperty(Operand orient, boolean st, boolean write) throws ScriptException {
        String name2 = this.in.peekName();
        if (name2 == null) {
            this.fatal("INVALID_CHAR", ".");
        }
        if (this.in.peekc('(')) {
            Method method = new Method(orient, name2, st);
            this.in.peekWhitespace();
            if (this.in.peekc(')')) {
                return method;
            }
            while (true) {
                Operand parameter;
                if ((parameter = this.parseExpression(this.operate_stack.elementCount, this.operand_stack.elementCount, 0)) == null) {
                    this.fatal("INVALID_PARAM", name2);
                }
                method.addParameters(parameter);
                this.in.peekWhitespace();
                if (this.in.peekc(',')) {
                    this.in.peekWhitespace();
                    continue;
                }
                if (this.in.peekc(')')) break;
                this.fatal("INVALID_CHAR", ")");
            }
            return method;
        }
        Operand index = null;
        if (this.in.peekc('[')) {
            this.in.peekSpace();
            index = this.parseExpression(this.operate_stack.elementCount, this.operand_stack.elementCount, 0);
            if (index == null) {
                this.fatal("INVAILD_PROPERTY_INDEX", name2);
            }
            this.in.peekSpace();
            if (!this.in.peekc(']')) {
                this.fatal("MUSTBE_CHAR", "]");
            }
        }
        return new Property(orient, name2, index, st, write);
    }

    private Operand parseConstructer() throws ScriptException {
        Object orient;
        this.in.peekWhitespace();
        String name2 = this.in.peekName();
        if (name2 == null) {
            this.fatal("MUST_VARIABLE_AFTER", "new");
        }
        if (!this.in.peekc('(')) {
            this.fatal("INVALID_CHAR", "(");
        }
        if ((orient = this.jsEngine.getObjectRefrence(name2)) == null) {
            this.fatal("CANT_NEW_BY", name2);
        }
        XData ref = orient instanceof XData ? (XData)orient : new XObject(orient);
        Method method = new Method((Operand)new Variable(name2, ref), name2, true);
        this.in.peekWhitespace();
        if (this.in.peekc(')')) {
            return method;
        }
        while (true) {
            Operand parameter;
            if ((parameter = this.parseExpression(this.operate_stack.elementCount, this.operand_stack.elementCount, 0)) == null) {
                this.fatal("INVALID_PARAM", name2);
            }
            method.addParameters(parameter);
            this.in.peekWhitespace();
            if (this.in.peekc(',')) {
                this.in.peekWhitespace();
                continue;
            }
            if (this.in.peekc(')')) break;
            this.fatal("INVALID_CHAR", ")");
        }
        return method;
    }

    private String maybeGetName() {
        char c = this.in.getc();
        if (!Character.isLetter(c) && c != '_') {
            this.in.ungetc();
            return null;
        }
        int k = 0;
        this.buf[k++] = c;
        while ((c = this.in.getc()) != '\u0000') {
            if (!Character.isLetterOrDigit(c) && c != '_') {
                this.in.ungetc();
                break;
            }
            this.buf[k++] = c;
        }
        return new String(this.buf, 0, k);
    }

    private String maybeGetOperateKey() {
        char c = this.in.getc();
        if (c == '(' || c == ')' || c == '[' || c == ']' || c == '?' || c == '~' || c == ':') {
            return String.valueOf(c);
        }
        if (c == '=') {
            return this.in.peekc('=') ? "==" : "=";
        }
        if (c == '>') {
            this.buf[0] = c;
            int i = 1;
            if (this.in.peekc('>')) {
                this.buf[i++] = 62;
                if (this.in.peekc('>')) {
                    this.buf[i++] = 62;
                }
            }
            if (this.in.peekc('=')) {
                this.buf[i++] = 61;
            }
            return new String(this.buf, 0, i);
        }
        if (c == '<') {
            this.buf[0] = c;
            int i = 1;
            if (this.in.peekc('<')) {
                this.buf[i++] = 60;
            }
            if (this.in.peekc('=')) {
                this.buf[i++] = 61;
            }
            return new String(this.buf, 0, i);
        }
        if (c == '%' || c == '/' || c == '*' || c == '!' || c == '^') {
            return this.in.peekc('=') ? String.valueOf(new char[]{c, '='}) : String.valueOf(c);
        }
        if (c == '&' || c == '|' || c == '+' || c == '-') {
            if (this.in.peekc('=')) {
                return String.valueOf(new char[]{c, '='});
            }
            if (this.in.peekc(c)) {
                return String.valueOf(new char[]{c, c});
            }
            return String.valueOf(c);
        }
        this.in.ungetc();
        return null;
    }

    boolean definedLabel(String label) {
        return this.labelTable.containsKey(label);
    }

    void rigisterLabel(String label) {
        this.labelTable.put(label, new Integer(this.jsEngine.count));
    }

    void resolveLabel(int first, int last2) throws ScriptException {
        Statement[] statements = this.jsEngine.statements;
        for (int i = first; i < last2; ++i) {
            Object obj;
            BaseStatement st;
            int type = statements[i].getType();
            if (type == 2) {
                st = (GotoStatement)statements[i];
                if (st.labelref == null) continue;
                obj = this.labelTable.get(st.labelref);
                if (obj == null) {
                    this.fatal("UNDEF_LABEL", st.labelref);
                    continue;
                }
                st.labelref = obj.toString();
                continue;
            }
            if (type == 8) {
                st = (BreakStatement)statements[i];
                if (((BreakStatement)st).labelref == null) continue;
                obj = this.labelTable.get(((BreakStatement)st).labelref);
                if (obj == null) {
                    this.fatal("UNDEF_LABEL", ((BreakStatement)st).labelref);
                    continue;
                }
                ((BreakStatement)st).labelref = obj.toString();
                continue;
            }
            if (type != 9) continue;
            st = (ContinueStatement)statements[i];
            if (((ContinueStatement)st).labelref == null) continue;
            obj = this.labelTable.get(((ContinueStatement)st).labelref);
            if (obj == null) {
                this.fatal("UNDEF_LABEL", ((ContinueStatement)st).labelref);
                continue;
            }
            ((ContinueStatement)st).labelref = obj.toString();
        }
    }

    private void extendsBuf() {
        char[] tmp = new char[this.buf.length + 64];
        System.arraycopy(this.buf, 0, tmp, 0, this.buf.length);
        this.buf = tmp;
    }

    protected void fatal(Exception e) throws ScriptException {
        throw new ScriptException(null, this.in, e);
    }

    protected void fatal(String msgID) throws ScriptException {
        this.fatal(msgID, new Object[0]);
    }

    protected void fatal(String msgID, String s) throws ScriptException {
        this.fatal(msgID, new Object[]{s});
    }

    protected void fatal(String msgID, Object[] parameters) throws ScriptException {
        String msg = JsEngine.msgCatalog.getMessage(msgID, parameters);
        ScriptException e = new ScriptException(msg, this.in);
        e.msgID = msgID;
        throw e;
    }

    static {
        for (int i = 0; i < RESERVATION.length; ++i) {
            KEY_TABLE.put(RESERVATION[i], new Integer(i + 1));
        }
    }

    static class OperandStack {
        Operand[] elementData = new Operand[4];
        int elementCount = 0;

        private final synchronized void ensureCapacity(int minCapacity) {
            int oldCapacity = this.elementData.length;
            if (minCapacity > oldCapacity) {
                Operand[] oldData = this.elementData;
                int newCapacity = oldCapacity + 4;
                if (newCapacity < minCapacity) {
                    newCapacity = minCapacity;
                }
                this.elementData = new Operand[newCapacity];
                System.arraycopy(oldData, 0, this.elementData, 0, this.elementCount);
            }
        }

        OperandStack() {
        }

        final boolean isEmpty() {
            return this.elementCount == 0;
        }

        final int size() {
            return this.elementCount;
        }

        synchronized Operand push(Operand item) {
            this.ensureCapacity(this.elementCount + 1);
            this.elementData[this.elementCount++] = item;
            return item;
        }

        synchronized Operand pop() {
            if (this.elementCount == 0) {
                return null;
            }
            Operand item = this.elementData[this.elementCount - 1];
            --this.elementCount;
            return item;
        }

        synchronized Operand pop(int num) {
            if (this.elementCount <= num) {
                return null;
            }
            Operand item = this.elementData[this.elementCount - 1];
            --this.elementCount;
            return item;
        }

        synchronized Operand peek() {
            if (this.elementCount == 0) {
                return null;
            }
            return this.elementData[this.elementCount - 1];
        }
    }

    static class OperateStack {
        int[] elementData = new int[4];
        int elementCount = 0;

        private final synchronized void ensureCapacity(int minCapacity) {
            int oldCapacity = this.elementData.length;
            if (minCapacity > oldCapacity) {
                int[] oldData = this.elementData;
                int newCapacity = oldCapacity + 4;
                if (newCapacity < minCapacity) {
                    newCapacity = minCapacity;
                }
                this.elementData = new int[newCapacity];
                System.arraycopy(oldData, 0, this.elementData, 0, this.elementCount);
            }
        }

        OperateStack() {
        }

        final boolean isEmpty() {
            return this.elementCount == 0;
        }

        final int size() {
            return this.elementCount;
        }

        synchronized int push(int item) {
            this.ensureCapacity(this.elementCount + 1);
            this.elementData[this.elementCount++] = item;
            return item;
        }

        synchronized int pop() {
            if (this.elementCount == 0) {
                return -1;
            }
            int item = this.elementData[this.elementCount - 1];
            --this.elementCount;
            return item;
        }

        synchronized int pop(int num) {
            if (this.elementCount <= num) {
                return -1;
            }
            int item = this.elementData[this.elementCount - 1];
            --this.elementCount;
            return item;
        }

        synchronized int peek() {
            if (this.elementCount == 0) {
                return -1;
            }
            return this.elementData[this.elementCount - 1];
        }
    }
}

