/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.js;

import com.argo21.common.io.Debug;
import com.argo21.common.io.XReader;
import com.argo21.common.lang.Operand;
import com.argo21.common.lang.VariableReference;
import com.argo21.common.lang.XData;
import com.argo21.common.lang.XDataException;
import com.argo21.common.lang.XString;
import com.argo21.js.CompileExceptionListener;
import com.argo21.js.Debuger;
import com.argo21.js.JsEngine;
import com.argo21.js.ScriptException;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Properties;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class ScriptEngine {
    public static final int STATE_UNLOAD = 0;
    public static final int STATE_LOADING = 1;
    public static final int STATE_READY = 2;
    public static final int STATE_RUNNING = 3;
    public static final int STATE_TERMINATE = 4;
    public static final int STATE_STOP = 5;
    CompileExceptionListener exceptionListner = null;

    public static final ScriptEngine getScriptEngine() {
        String s = System.getProperty("script.engine", null);
        try {
            if (s != null) {
                return (ScriptEngine)Class.forName(s).newInstance();
            }
            return new JsEngine();
        }
        catch (Exception e) {
            System.out.println(e);
            System.exit(1);
            return null;
        }
    }

    public static final Debuger getDebugEngine() {
        ScriptEngine se = ScriptEngine.getScriptEngine();
        return se.getDebuger();
    }

    public void setCompileExceptionListener(CompileExceptionListener exceptionListner) {
        this.exceptionListner = exceptionListner;
    }

    public void loadScripts(URL url) throws ScriptException, IOException {
        this.loadScripts(XReader.createReader(url, false));
    }

    public void loadScripts(File file) throws ScriptException, IOException {
        this.loadScripts(XReader.createReader(file));
    }

    public void loadScripts(InputSource is) throws ScriptException, IOException {
        this.loadScripts(XReader.createReader(is));
    }

    public abstract void loadScripts(XReader var1) throws ScriptException;

    public abstract void parseScripts(String var1) throws ScriptException;

    public abstract Operand parseExpression(String var1) throws ScriptException;

    public XData evalExpression(String text) throws XDataException, ScriptException {
        Operand opd = this.parseExpression(text);
        return opd == null ? XData.XNULL : opd.getData();
    }

    public abstract void registerObjectRefrence(String var1, Object var2);

    public abstract Object getObjectRefrence(String var1);

    public abstract Object[] getObjectRefrences();

    public abstract String getContents();

    public abstract void reset();

    public abstract void init();

    public abstract int getStatus();

    public abstract String getStatusMessage();

    public abstract void execute() throws SAXException;

    public abstract String getPublicId();

    public abstract String getSystemId();

    public abstract int getFirstLine();

    public abstract int getTotalLines();

    public abstract VariableReference getVariableReference();

    public abstract void setErrorHandler(ErrorHandler var1);

    protected abstract Debuger getDebuger();

    static void main(String[] args) {
        ScriptEngine.test1();
    }

    static void test1() {
        Debug.enDebug = true;
        ScriptEngine jr = ScriptEngine.getScriptEngine();
        System.out.print(jr.getStatus());
        VariableReference vref = jr.getVariableReference();
        vref.putData("abc", new XString("12345"));
        try {
            jr.loadScripts(new File("Example1.jsp"));
            jr.execute();
            OutputStreamWriter out = new OutputStreamWriter(System.out);
            vref.dumpAllVaribles(out);
            ((Writer)out).flush();
            boolean bl = false;
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    static void test2() {
        Debug.enDebug = true;
        Properties o = System.getProperties();
        Debuger jr = ScriptEngine.getDebugEngine();
        System.out.print(jr.getStatus());
        VariableReference vref = jr.getVariableReference();
        vref.putData("abc", new XString("12345"));
        try {
            int st;
            jr.loadScripts(new File("Example1.jsp"));
            jr.addBreaker(11);
            jr.execute();
            while ((st = jr.getStatus()) != 5) {
                Thread.sleep(100L);
            }
            System.out.println(st);
            jr.debugexit();
            while ((st = jr.getStatus()) != 4) {
                Thread.sleep(100L);
            }
            System.out.println(st);
            OutputStreamWriter out = new OutputStreamWriter(System.out);
            vref.dumpAllVaribles(out);
            ((Writer)out).flush();
            boolean bl = false;
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }
}

