/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.js;

import com.argo21.common.lang.Variable;
import java.util.Enumeration;

public class VariableTable
implements Enumeration {
    private Entry[] table;
    private Entry current = null;
    private int currentBucket = 0;
    private int count;
    private int threshold;
    private static final float loadFactor = 0.75f;

    public VariableTable(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + initialCapacity);
        }
        if (initialCapacity == 0) {
            initialCapacity = 1;
        }
        this.table = new Entry[initialCapacity];
        this.threshold = (int)((float)initialCapacity * 0.75f);
    }

    public VariableTable() {
        this(11);
    }

    public void clear() {
        this.count = 0;
        this.currentBucket = 0;
        this.current = null;
        for (int i = 0; i < this.table.length; ++i) {
            this.table[i] = null;
        }
    }

    public void releaseVariables() {
        for (int i = 0; i < this.table.length; ++i) {
            if (this.table[i] == null) continue;
            Variable tmp = this.table[i].value;
            if (!this.table[i].fix) {
                tmp.setData(null);
            }
            Entry next = this.table[i].next;
            while (next != null) {
                if (!next.fix) {
                    next.value.setData(null);
                }
                next = next.next;
            }
        }
    }

    public int size() {
        return this.count;
    }

    public Enumeration keys() {
        this.currentBucket = 0;
        this.current = null;
        return this;
    }

    @Override
    public boolean hasMoreElements() {
        if (this.current != null) {
            return true;
        }
        while (this.currentBucket < this.table.length) {
            this.current = this.table[this.currentBucket++];
            if (this.current == null) continue;
            return true;
        }
        return false;
    }

    public Object nextElement() {
        if (this.current == null) {
            throw new IllegalStateException();
        }
        String retval = this.current.key;
        this.current = this.current.next;
        return retval;
    }

    public boolean containsKey(String key) {
        Entry[] tab = this.table;
        int hash = key.hashCode();
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        Entry e = tab[index];
        while (e != null) {
            if (e.hash == hash && e.key.equals(key)) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    public Variable get(String key) {
        Entry[] tab = this.table;
        int hash = key.hashCode();
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        Entry e = tab[index];
        while (e != null) {
            if (e.hash == hash && e.key.equals(key)) {
                return e.value;
            }
            e = e.next;
        }
        return null;
    }

    public boolean set(String key, Variable value) {
        Entry[] tab = this.table;
        int hash = key.hashCode();
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        Entry e = tab[index];
        while (e != null) {
            if (e.hash == hash && e.key.equals(key)) {
                e.value = value;
                return true;
            }
            e = e.next;
        }
        return false;
    }

    private void rehash() {
        int oldCapacity = this.table.length;
        Entry[] oldMap = this.table;
        int newCapacity = oldCapacity * 2 + 1;
        Entry[] newMap = new Entry[newCapacity];
        this.threshold = (int)((float)newCapacity * 0.75f);
        this.table = newMap;
        int i = oldCapacity;
        while (i-- > 0) {
            Entry old = oldMap[i];
            while (old != null) {
                Entry e = old;
                old = old.next;
                int index = (e.hash & Integer.MAX_VALUE) % newCapacity;
                e.next = newMap[index];
                newMap[index] = e;
            }
        }
    }

    public Object put(String key, Variable value) {
        if (value == null) {
            throw new NullPointerException();
        }
        Entry[] tab = this.table;
        int hash = key.hashCode();
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        Entry e = tab[index];
        while (e != null) {
            if (e.hash == hash && e.key.equals(key)) {
                Variable old = e.value;
                e.value = value;
                return old;
            }
            e = e.next;
        }
        if (this.count >= this.threshold) {
            this.rehash();
            tab = this.table;
            index = (hash & Integer.MAX_VALUE) % tab.length;
        }
        tab[index] = e = new Entry(hash, key, value, tab[index]);
        ++this.count;
        return null;
    }

    public boolean isfix(String key) {
        Entry[] tab = this.table;
        int hash = key.hashCode();
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        Entry e = tab[index];
        while (e != null) {
            if (e.hash == hash && e.key.equals(key)) {
                return e.fix;
            }
            e = e.next;
        }
        return false;
    }

    public Object putfix(String key, Variable value) {
        if (value == null) {
            throw new NullPointerException();
        }
        Entry[] tab = this.table;
        int hash = key.hashCode();
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        Entry e = tab[index];
        while (e != null) {
            if (e.hash == hash && e.key.equals(key)) {
                Variable old = e.value;
                e.value = value;
                e.fix = true;
                return old;
            }
            e = e.next;
        }
        if (this.count >= this.threshold) {
            this.rehash();
            tab = this.table;
            index = (hash & Integer.MAX_VALUE) % tab.length;
        }
        e = new Entry(hash, key, value, tab[index]);
        e.fix = true;
        tab[index] = e;
        ++this.count;
        return null;
    }

    private static class Entry {
        int hash;
        String key;
        boolean fix;
        Variable value;
        Entry next;

        protected Entry(int hash, String key, Variable value, Entry next) {
            this.hash = hash;
            this.key = key;
            this.value = value;
            this.next = next;
            this.fix = false;
        }
    }
}

