/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.jxp.dtd;

import com.argo21.common.io.XReader;
import com.argo21.common.lang.DataTypeDecl;
import com.argo21.common.lang.XmlChars;
import com.argo21.jxp.dtd.AttDef;
import com.argo21.jxp.dtd.AttDefault;
import com.argo21.jxp.dtd.AttDefaultImpl;
import com.argo21.jxp.dtd.AttType;
import com.argo21.jxp.dtd.AttTypeImpl;
import com.argo21.jxp.dtd.AttlistDeclNode;
import com.argo21.jxp.dtd.DTDDecl;
import com.argo21.jxp.dtd.DTDDocument;
import com.argo21.jxp.dtd.DTDException;
import com.argo21.jxp.dtd.DeclNode;
import com.argo21.jxp.dtd.EntityDecl;
import java.util.Vector;
import org.xml.sax.Locator;

public class AttDefNode
implements AttDef {
    AttType attType;
    AttDefault attDefault;
    String name;
    String elementname;
    DTDDecl dtd = null;
    DataTypeDecl dtDecl;
    boolean isEntityRef = false;
    private XReader in = null;

    public AttDefNode(String elementName, String attributeName, AttType attType, AttDefault attDefault) {
        this(null, elementName, attributeName, attType, attDefault);
    }

    public AttDefNode(DTDDecl dtd, String elementName, String attributeName, AttType attType, AttDefault attDefault) {
        this.elementname = elementName;
        this.name = attributeName;
        this.attType = attType;
        this.attDefault = attDefault;
        this.isEntityRef = false;
        this.dtd = dtd;
    }

    public AttDefNode(DTDDecl dtd, String elementName, String entityName) {
        this.elementname = elementName;
        this.name = entityName;
        this.attType = null;
        this.attDefault = null;
        this.isEntityRef = true;
        this.dtd = dtd;
    }

    AttDefNode(DTDDecl dtd, String elementName, XReader in) throws DTDException {
        this.dtd = dtd;
        this.elementname = elementName;
        this.in = in;
        this.parseAttDef();
        this.in = null;
    }

    @Override
    public String getNodeTypeName() {
        return "AttList";
    }

    @Override
    public int getNodeType() {
        return 22;
    }

    @Override
    public String getNodeName() {
        return this.name;
    }

    @Override
    public String getElementName() {
        return this.elementname;
    }

    @Override
    public boolean isEntityRef() {
        return this.isEntityRef;
    }

    public String getEntityName() {
        return this.name;
    }

    public void setEntityName(String name2) {
        if (this.isEntityRef) {
            this.name = name2;
        }
    }

    private void parseAttDef() throws DTDException {
        this.in.peekWhitespace();
        if (this.in.peekc('%')) {
            String entityName = this.in.peekXmlName();
            if (entityName == null) {
                DTDDocument.fatal("NEED_ENTITY_REF", (Locator)this.in, "%");
            }
            if (!this.in.peekc(';')) {
                DTDDocument.fatal("INVALID_ENTITY_REF", (Locator)this.in, new Object[]{entityName, ";"});
            }
            this.name = entityName;
            this.attType = null;
            this.attDefault = null;
            this.isEntityRef = true;
        } else {
            this.name = this.in.peekXmlName();
            if (this.name == null) {
                DTDDocument.fatal("NEED_ATTR_NAME", (Locator)this.in);
            }
            if (!this.in.peekWhitespace()) {
                DTDDocument.fatal("NEED_ATTR_NAME", (Locator)this.in);
            }
            this.attType = this.parseAttType();
            this.in.peekWhitespace();
            this.attDefault = this.parseAttDefault(this.attType);
            this.isEntityRef = false;
        }
    }

    private AttType parseAttType() throws DTDException {
        int typecode;
        if (this.in.peek("CDATA")) {
            typecode = 0;
        } else if (this.in.peek("IDREFS")) {
            typecode = 3;
        } else if (this.in.peek("IDREF")) {
            typecode = 2;
        } else if (this.in.peek("ID")) {
            typecode = 1;
        } else if (this.in.peek("ENTITY")) {
            typecode = 4;
        } else if (this.in.peek("ENTITIES")) {
            typecode = 5;
        } else if (this.in.peek("NMTOKENS")) {
            typecode = 7;
        } else if (this.in.peek("NMTOKEN")) {
            typecode = 6;
        } else {
            return this.parseEnumeratedType();
        }
        return new AttTypeImpl(typecode, (Vector)null);
    }

    private AttType parseEnumeratedType() throws DTDException {
        int typecode = this.in.peek("NOTATION") ? 9 : 8;
        if (this.in.peekc('(')) {
            this.in.peekWhitespace();
            Vector<String> v = new Vector<String>();
            do {
                boolean isentity = this.in.peekc('%');
                String nmtoken = this.in.peekNmtoken();
                if (isentity) {
                    if (nmtoken == null) {
                        DTDDocument.fatal("NEED_ENTITY_REF", (Locator)this.in, "%");
                    }
                    if (!this.in.peekc(';')) {
                        DTDDocument.fatal("INVALID_ENTITY_REF", (Locator)this.in, new Object[]{nmtoken, ";"});
                    }
                    v.addElement("%" + nmtoken);
                } else {
                    if (nmtoken == null) {
                        DTDDocument.fatal("INVALID_ATTTYPE", (Locator)this.in);
                    }
                    v.addElement(nmtoken);
                }
                this.in.peekWhitespace();
                if (!this.in.peekc('|')) continue;
                this.in.peekWhitespace();
            } while (!this.in.peekc(')') && !this.in.isEOF());
            return new AttTypeImpl(typecode, v);
        }
        if (this.in.peekc('%')) {
            String nmtoken = this.in.peekNmtoken();
            if (nmtoken == null) {
                DTDDocument.fatal("NEED_ENTITY_REF", (Locator)this.in, "%");
            }
            if (!this.in.peekc(';')) {
                DTDDocument.fatal("INVALID_ENTITY_REF", (Locator)this.in, new Object[]{nmtoken, ";"});
            }
            return new AttTypeImpl(typecode, nmtoken);
        }
        DTDDocument.fatal("INVALID_CHAR", (Locator)this.in, String.valueOf(this.in.getc()));
        return null;
    }

    private AttDefault parseAttDefault(AttType attType) throws DTDException {
        int typecode;
        int quote = 34;
        String attvalue = null;
        if (this.in.peek("#REQUIRED")) {
            typecode = 3;
        } else if (this.in.peek("#IMPLIED")) {
            typecode = 2;
        } else {
            if (this.in.peek("#FIXED")) {
                if (!this.in.peekWhitespace()) {
                    DTDDocument.fatal("INVALID_ATTVALUE", (Locator)this.in);
                }
                typecode = 1;
            } else {
                typecode = 0;
            }
            attvalue = attType.getDataType() != 0 ? AttDefNode.normalize(this.parseAttValue(), false) : this.parseAttValue();
            if (attvalue == null) {
                DTDDocument.fatal("INVALID_ATTVALUE", (Locator)this.in);
            }
        }
        return new AttDefaultImpl(typecode, attvalue);
    }

    private String parseAttValue() throws DTDException {
        char c;
        char quote = this.in.getc();
        if (quote != '\'' && quote != '\"') {
            DTDDocument.fatal("NEED_QUOTE", (Locator)this.in);
        }
        StringBuffer strTmp = new StringBuffer();
        while (!this.in.isEOF() && (c = this.in.getc()) != quote) {
            if (c == '&') {
                if (this.in.peekc('#')) {
                    int tmp = this.in.peekCharNumber();
                    if (tmp < 0) {
                        DTDDocument.fatal("NEED_NUM_AFTER", (Locator)this.in, "&#");
                    }
                    if (tmp > 65535) {
                        if (tmp <= 0x10FFFF) {
                            strTmp.append((char)(0xD800 | (tmp -= 65536) >> 10 & 0x3FF));
                            strTmp.append((char)(0xDC00 | tmp & 0x3FF));
                            continue;
                        }
                        String s = "&#x" + Integer.toHexString(tmp);
                        DTDDocument.fatal("INVALID_CHAR", (Locator)this.in, s);
                        continue;
                    }
                    strTmp.append((char)tmp);
                    continue;
                }
                String entityName = this.in.peekXmlName();
                if (entityName != null) {
                    if (!this.in.peekc(';')) {
                        DTDDocument.fatal("INVALID_ENTITY_REF", (Locator)this.in, new Object[]{entityName, ";"});
                    }
                    strTmp.append('&');
                    strTmp.append(entityName);
                    strTmp.append(';');
                    continue;
                }
                DTDDocument.fatal("NEED_ENTITY_REF", (Locator)this.in, "&");
                continue;
            }
            if (c == ' ' || c == '\t' || c == '\n' || c == '\r') {
                strTmp.append(' ');
                continue;
            }
            if (c == '<') {
                DTDDocument.fatal("INVALID_CHAR", (Locator)this.in, "<");
            }
            strTmp.append(c);
        }
        return strTmp.toString();
    }

    protected static void makeAttType(StringBuffer sb, AttType attType) {
        int typecode = attType.getDataType();
        if (typecode == 0) {
            sb.append("CDATA");
        } else if (typecode == 3) {
            sb.append("IDREFS");
        } else if (typecode == 2) {
            sb.append("IDREF");
        } else if (typecode == 1) {
            sb.append("ID");
        } else if (typecode == 4) {
            sb.append("ENTITY");
        } else if (typecode == 5) {
            sb.append("ENTITIES");
        } else if (typecode == 7) {
            sb.append("NMTOKENS");
        } else if (typecode == 6) {
            sb.append("NMTOKEN");
        } else if (typecode == 8 || typecode == 9) {
            Vector names;
            if (typecode == 9) {
                sb.append("NOTATION");
            }
            if ((names = attType.getNames()) != null) {
                int n = names.size();
                if (((AttTypeImpl)attType).isEntityRef && n >= 1) {
                    String s = (String)names.elementAt(0);
                    sb.append('%');
                    sb.append(s);
                    sb.append(';');
                    return;
                }
                sb.append(" (");
                for (int i = 0; i < n; ++i) {
                    sb.append((String)names.elementAt(i));
                    if (i >= n - 1) continue;
                    sb.append(" | ");
                }
                sb.append(')');
            }
        }
    }

    static void makeAttDefault(StringBuffer sb, AttDefault defaultDecl) {
        int typecode = defaultDecl.getType();
        if (typecode == 3) {
            sb.append("#REQUIRED");
        } else if (typecode == 2) {
            sb.append("#IMPLIED");
        } else if (typecode == 1) {
            sb.append("#FIXED");
            sb.append(' ');
            String s = defaultDecl.getValue();
            if (s == null) {
                s = "null";
            }
            char quote = s.indexOf("\"") < 0 ? (char)'\"' : '\'';
            sb.append(quote);
            sb.append(s);
            sb.append(quote);
        } else {
            sb.append(' ');
            String s = defaultDecl.getValue();
            if (s == null) {
                s = "null";
            }
            char quote = s.indexOf("\"") < 0 ? (char)'\"' : '\'';
            sb.append(quote);
            sb.append(s);
            sb.append(quote);
        }
    }

    @Override
    public void repleaceEntity() throws DTDException {
        if (this.dtd == null || this.name == null) {
            return;
        }
        if (this.isEntityRef) {
            EntityDecl decl = this.dtd.getEntityDecl(this.name);
            String s = decl.getEntityValue();
            AttlistDeclNode attlist = new AttlistDeclNode(this.dtd, this.elementname, s);
            int n = attlist.getSize();
            for (int i = 0; i < n; ++i) {
                AttDef att = attlist.getAttDef(i);
                this.dtd.insertBefore((DeclNode)att, this);
            }
            this.dtd.removeChild(this);
            this.isEntityRef = false;
        } else {
            ((AttTypeImpl)this.attType).repleaceEntity(this.dtd);
        }
    }

    @Override
    public AttDefault getAttDefault() {
        return this.attDefault;
    }

    @Override
    public AttType getAttType() {
        return this.attType;
    }

    @Override
    public DataTypeDecl getDataTypeDecl() {
        return this.dtDecl;
    }

    public void setDataTypeDecl(DataTypeDecl dtDecl) {
        this.dtDecl = dtDecl;
    }

    @Override
    public String getAttributeName() {
        return this.name;
    }

    @Override
    public DeclNode getParentDecl() {
        return null;
    }

    public String getXML() {
        return "<!ATTLIST " + this.elementname + " " + this.makeDeclContent() + ">";
    }

    public String toString() {
        return "<!ATTLIST " + this.elementname + " " + this.makeDeclContent() + ">";
    }

    String makeDeclContent() {
        if (this.isEntityRef) {
            return "%" + this.name + ";";
        }
        StringBuffer sb = new StringBuffer();
        sb.append(this.name);
        sb.append(' ');
        AttDefNode.makeAttType(sb, this.attType);
        sb.append(' ');
        AttDefNode.makeAttDefault(sb, this.attDefault);
        return sb.toString();
    }

    @Override
    public DeclNode getOwner() {
        return this.dtd;
    }

    static String normalize(String s, boolean invalidIfNeeded) {
        String s2 = s.trim();
        boolean didStrip = false;
        if (s != s2) {
            s = s2;
            s2 = null;
            didStrip = true;
        }
        StringBuffer strTmp = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (!XmlChars.isSpace(c)) {
                strTmp.append(c);
                continue;
            }
            strTmp.append(' ');
            while (++i < s.length() && XmlChars.isSpace(s.charAt(i))) {
                didStrip = true;
            }
            --i;
        }
        if (invalidIfNeeded && (s2 == null || didStrip)) {
            return null;
        }
        if (didStrip) {
            return strTmp.toString();
        }
        return s;
    }
}

