/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.jxp.dtd;

import com.argo21.jxp.dtd.AttType;
import com.argo21.jxp.dtd.DTDDecl;
import com.argo21.jxp.dtd.DTDException;
import com.argo21.jxp.dtd.EntityDeclNode;
import java.util.StringTokenizer;
import java.util.Vector;

public class AttTypeImpl
implements AttType {
    int dataType;
    Vector names;
    boolean isEntityRef = false;

    public AttTypeImpl(String dataType, Vector names) {
        if (dataType.equals("CDATA")) {
            this.dataType = 0;
        } else if (dataType.equals("ID")) {
            this.dataType = 1;
        } else if (dataType.equals("IDREF")) {
            this.dataType = 2;
        } else if (dataType.equals("IDREFS")) {
            this.dataType = 3;
        } else if (dataType.equals("ENTITY")) {
            this.dataType = 4;
        } else if (dataType.equals("ENTITIES")) {
            this.dataType = 5;
        } else if (dataType.equals("NMTOKEN")) {
            this.dataType = 6;
        } else if (dataType.equals("NMTOKENS")) {
            this.dataType = 7;
        } else if (dataType.equals("ENUMERATION")) {
            this.dataType = 8;
        } else if (dataType.equals("NOTATION")) {
            this.dataType = 9;
        }
        this.names = names;
        this.isEntityRef = false;
    }

    public AttTypeImpl(int dataType, String entityName) {
        this(dataType, (Vector)null);
        this.names = new Vector(1);
        this.names.addElement(entityName);
        this.isEntityRef = true;
    }

    @Override
    public String getEntityName() {
        if (this.isEntityRef && this.names != null && this.names.size() > 0) {
            return (String)this.names.elementAt(0);
        }
        return null;
    }

    public AttTypeImpl(int dataType, Vector names) {
        this.dataType = dataType;
        this.names = names;
    }

    @Override
    public Vector getNames() {
        return this.names;
    }

    @Override
    public int getDataType() {
        return this.dataType;
    }

    @Override
    public boolean isEntityRef() {
        return this.isEntityRef;
    }

    public void repleaceEntity(DTDDecl dtd) throws DTDException {
        if (this.names == null) {
            return;
        }
        int n = this.names.size();
        if (n == 0) {
            return;
        }
        if (this.isEntityRef) {
            String entity = (String)this.names.elementAt(0);
            EntityDeclNode decl = (EntityDeclNode)dtd.getEntityDecl(entity);
            String value = decl.getEntityValue();
            if (value.startsWith("(") && value.endsWith(")")) {
                value = value.substring(1, value.length() - 1);
            }
            if (value != null) {
                StringTokenizer st = new StringTokenizer(value, "|");
                this.names.removeAllElements();
                while (st.hasMoreElements()) {
                    this.names.addElement(st.nextElement());
                }
            }
            this.isEntityRef = false;
        } else {
            int i = 0;
            while (i < n) {
                String enyity;
                EntityDeclNode decl;
                String value;
                String s = (String)this.names.elementAt(i);
                if (s.charAt(0) == '%' && (value = (decl = (EntityDeclNode)dtd.getEntityDecl(enyity = s.substring(1))).getEntityValue()) != null) {
                    this.names.removeElementAt(i);
                    StringTokenizer st = new StringTokenizer(value, "|");
                    while (st.hasMoreElements()) {
                        this.names.insertElementAt(st.nextElement(), i);
                        ++i;
                    }
                    n = this.names.size();
                    continue;
                }
                ++i;
            }
        }
    }
}

