/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.jxp.dtd;

import com.argo21.common.io.XReader;
import com.argo21.common.lang.DataTypeDecl;
import com.argo21.jxp.dtd.AttDef;
import com.argo21.jxp.dtd.AttDefNode;
import com.argo21.jxp.dtd.AttlistDecl;
import com.argo21.jxp.dtd.DTDDecl;
import com.argo21.jxp.dtd.DTDDocument;
import com.argo21.jxp.dtd.DTDException;
import com.argo21.jxp.dtd.DeclNode;
import org.xml.sax.Locator;

public class AttlistDeclNode
implements AttlistDecl {
    String elemName;
    private AttDefNode[] attdefs = new AttDefNode[2];
    private int elementCount = 0;
    DTDDecl dtd = null;
    private XReader in = null;

    AttlistDeclNode(DTDDecl dtd, String elemName, String declContents) throws DTDException {
        this(dtd, elemName, declContents.toCharArray());
    }

    AttlistDeclNode(DTDDecl dtd, String elemName, char[] declContents) throws DTDException {
        this.dtd = dtd;
        this.elemName = elemName;
        this.in = XReader.createReader(declContents, null);
        this.parseDeclContent();
        this.in = null;
    }

    AttlistDeclNode(DTDDecl dtd, XReader in) throws DTDException {
        this.dtd = dtd;
        this.in = in;
        this.elemName = in.peekXmlName();
        if (this.elemName != null) {
            if (!in.peekWhitespace()) {
                DTDDocument.fatal("NEED_ELEM_NAME", (Locator)in);
            }
            this.parseDeclContent();
        } else {
            DTDDocument.fatal("NEED_ELEM_NAME", (Locator)in);
        }
        this.in = null;
    }

    @Override
    public String getElementName() {
        return this.elemName;
    }

    @Override
    public int getNodeType() {
        return 21;
    }

    @Override
    public DataTypeDecl getDataTypeDecl() {
        return null;
    }

    @Override
    public DeclNode getParentDecl() {
        return this.dtd.getDeclNodeByKey(this.elemName);
    }

    @Override
    public String getNodeName() {
        String s = "";
        for (int i = 0; i < this.elementCount; ++i) {
            s = s + this.attdefs[i].getNodeName();
            if (i >= this.elementCount - 1) continue;
            s = s + ",";
        }
        return s;
    }

    @Override
    public AttDef getAttDef(int index) {
        if (index >= 0 && index < this.elementCount) {
            return this.attdefs[index];
        }
        return null;
    }

    @Override
    public int getSize() {
        return this.elementCount;
    }

    public String getXML() {
        return "<!ATTLIST " + this.elemName + " " + this.makeDeclContent() + ">";
    }

    public String toString() {
        return "<!ATTLIST " + this.elemName + " " + this.makeDeclContent() + ">";
    }

    private boolean parseDeclContent() throws DTDException {
        AttDefNode attdef;
        this.in.peekWhitespace();
        while (!this.in.isEOF() && (attdef = new AttDefNode(this.dtd, this.elemName, this.in)) != null) {
            this.ensureCapacity(this.elementCount + 1);
            this.attdefs[this.elementCount++] = attdef;
            if (this.in.peekWhitespace() && !this.in.isChar('>')) continue;
            break;
        }
        return true;
    }

    private String makeDeclContent() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.elementCount; ++i) {
            sb.append(this.attdefs[i].makeDeclContent());
            if (i >= this.elementCount - 1) continue;
            sb.append("\n\t\t");
        }
        return sb.toString();
    }

    private final synchronized void ensureCapacity(int minCapacity) {
        int oldCapacity = this.attdefs.length;
        if (minCapacity > oldCapacity) {
            AttDefNode[] oldData = this.attdefs;
            int newCapacity = oldCapacity + 2;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.attdefs = new AttDefNode[newCapacity];
            System.arraycopy(oldData, 0, this.attdefs, 0, this.elementCount);
        }
    }

    @Override
    public DeclNode getOwner() {
        return this.dtd;
    }

    public static void main(String[] args) {
        try {
            AttlistDeclNode al = new AttlistDeclNode(null, "AAA", "MMM (aaa | bbb | ccc) 'aaa' \n NNN  NMTOKEN #REQUIRED");
            System.out.println(al.toString());
        }
        catch (DTDException dTDException) {
            // empty catch block
        }
    }

    @Override
    public String getNodeTypeName() {
        return "AttList";
    }
}

