/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.jxp.dtd;

import com.argo21.common.io.XReader;
import com.argo21.common.lang.DataTypeDecl;
import com.argo21.jxp.dtd.Children;
import com.argo21.jxp.dtd.ContentParticle;
import com.argo21.jxp.dtd.ContentParticleImpl;
import com.argo21.jxp.dtd.DTDDecl;
import com.argo21.jxp.dtd.DTDDocument;
import com.argo21.jxp.dtd.DTDException;
import com.argo21.jxp.dtd.DeclNode;
import com.argo21.jxp.dtd.ElementDecl;
import com.argo21.jxp.dtd.ElementDeclNode;
import java.util.Vector;
import org.xml.sax.Locator;

public class ChildrenNode
implements Children {
    Vector cplist;
    int type;
    char occurrence;
    DeclNode parent = null;

    public ChildrenNode(int type, char occurrence, Vector cplist) {
        this.type = type;
        this.occurrence = occurrence;
        this.cplist = cplist;
        this.setCplistParent(this);
    }

    public ChildrenNode(ElementDecl elementdecl, String contentspec) throws DTDException {
        this(elementdecl, contentspec.toCharArray());
    }

    ChildrenNode(ElementDecl elementdecl, char[] contentspec) throws DTDException {
        XReader in = XReader.createReader(contentspec, null);
        DTDDecl dtd = (DTDDecl)elementdecl.getOwner();
        if (dtd != null && dtd instanceof DTDDocument) {
            DTDDocument dtd1 = (DTDDocument)dtd;
            in.setPublicId(dtd1.publicId);
            in.setSystemId(dtd1.systemId);
            in.setEncoding(dtd1.getEncoding());
        }
        this.parseChildren(in);
        if (elementdecl instanceof ElementDeclNode) {
            ((ElementDeclNode)elementdecl).type = 3;
            ((ElementDeclNode)elementdecl).children = this;
        }
        this.setCplistParent(this);
        this.parent = elementdecl;
    }

    ChildrenNode(DeclNode parentdecl, XReader in) throws DTDException {
        this.parseChildren(in);
        if (parentdecl instanceof ElementDeclNode) {
            ((ElementDeclNode)parentdecl).type = 3;
            ((ElementDeclNode)parentdecl).children = this;
        } else if (parentdecl instanceof ContentParticleImpl) {
            ((ContentParticleImpl)parentdecl).children = this;
            ((ContentParticleImpl)parentdecl).name = null;
        }
        this.setCplistParent(this);
        this.parent = parentdecl;
    }

    void setCplistParent(ChildrenNode child) {
        Vector list = child.getCPList();
        if (list == null) {
            return;
        }
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            ContentParticleImpl cp = (ContentParticleImpl)list.elementAt(i);
            cp.parent = child;
            ChildrenNode child1 = (ChildrenNode)cp.getChildren();
            if (child1 == null) continue;
            this.setCplistParent(child1);
            child1.parent = child;
        }
    }

    private final boolean parseChildren(XReader in) throws DTDException {
        in.peekWhitespace();
        this.cplist = this.parseChoiceOrSeq(in);
        if (this.cplist == null) {
            return false;
        }
        this.occurrence = this.getFrequency(in);
        return true;
    }

    private final Vector parseChoiceOrSeq(XReader in) throws DTDException {
        if (!in.peekc('(')) {
            DTDDocument.fatal("NEED_CHAR", (Locator)in, "(");
        }
        in.peekWhitespace();
        Vector<ContentParticle> v = new Vector<ContentParticle>();
        ContentParticle cp = this.parseCp(in);
        v.addElement(cp);
        in.peekWhitespace();
        boolean hasChoice = false;
        if (in.isChar('|')) {
            while (in.peekc('|')) {
                in.peekWhitespace();
                cp = this.parseCp(in);
                v.addElement(cp);
                in.peekWhitespace();
            }
            this.type = 0;
        } else if (in.isChar(',')) {
            while (in.peekc(',')) {
                in.peekWhitespace();
                cp = this.parseCp(in);
                v.addElement(cp);
                in.peekWhitespace();
            }
            this.type = 1;
        } else {
            this.type = 1;
        }
        if (!in.peekc(')')) {
            DTDDocument.fatal("NEED_CHAR", (Locator)in, ")");
        }
        return v;
    }

    private final ContentParticle parseCp(XReader in) throws DTDException {
        if (in.isChar('(')) {
            int svType = this.type;
            Vector v = this.parseChoiceOrSeq(in);
            char temp = this.getFrequency(in);
            ChildrenNode child = new ChildrenNode(this.type, temp, v);
            this.type = svType;
            return new ContentParticleImpl(temp, child);
        }
        if (in.peekc('%')) {
            String entity = in.peekXmlName();
            if (entity == null) {
                DTDDocument.fatal("NEED_ENTITY_NAME", (Locator)in);
            }
            if (!in.peekc(';')) {
                DTDDocument.fatal("INVALID_ENTITY_REF", (Locator)in, new Object[]{entity, ";"});
            }
            return new ContentParticleImpl(entity);
        }
        String tag = in.peekXmlName();
        if (tag == null) {
            DTDDocument.fatal("NEED_ELEM_NAME", (Locator)in);
        }
        char temp = this.getFrequency(in);
        return new ContentParticleImpl(temp, tag);
    }

    private char getFrequency(XReader in) {
        char c = in.getc();
        if (c == '?' || c == '+' || c == '*') {
            return c;
        }
        in.ungetc();
        return '\u0000';
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        this.makeChildren(sb);
        return sb.toString();
    }

    void makeChildren(StringBuffer sb) {
        String slipt;
        if (this.type == 0) {
            slipt = " | ";
        } else if (this.type == 1) {
            slipt = " , ";
        } else {
            return;
        }
        if (this.cplist == null) {
            return;
        }
        int n = this.cplist.size();
        sb.append('(');
        for (int i = 0; i < n; ++i) {
            try {
                ContentParticle cp = (ContentParticle)this.cplist.elementAt(i);
                this.makeCp(cp, sb);
                if (i >= n - 1) continue;
                sb.append(slipt);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        sb.append(')');
        if (this.occurrence != '\u0000') {
            sb.append(this.occurrence);
        }
    }

    @Override
    public String getSubTags() {
        if (this.cplist == null) {
            return null;
        }
        int n = this.cplist.size();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            ContentParticle cp = (ContentParticle)this.cplist.elementAt(i);
            ChildrenNode child = (ChildrenNode)cp.getChildren();
            if (child != null) {
                sb.append(child.getSubTags());
            } else {
                sb.append(cp.getName());
            }
            if (i >= n - 1) continue;
            sb.append(',');
        }
        return sb.toString();
    }

    public void getSubTags(Vector taglist) {
        if (this.cplist == null) {
            return;
        }
        int n = this.cplist.size();
        for (int i = 0; i < n; ++i) {
            ContentParticle cp = (ContentParticle)this.cplist.elementAt(i);
            ChildrenNode child = (ChildrenNode)cp.getChildren();
            if (child != null) {
                child.getSubTags(taglist);
                continue;
            }
            taglist.addElement(cp.getName());
        }
    }

    @Override
    public boolean containsTag(String name2) {
        if (this.cplist == null) {
            return false;
        }
        int n = this.cplist.size();
        for (int i = 0; i < n; ++i) {
            ContentParticle cp = (ContentParticle)this.cplist.elementAt(i);
            ChildrenNode child = (ChildrenNode)cp.getChildren();
            if (!(child != null ? child.containsTag(name2) : name2.equals(cp.getName()))) continue;
            return true;
        }
        return false;
    }

    public ContentParticle getContentParticle(String name2) {
        if (this.cplist == null) {
            return null;
        }
        int n = this.cplist.size();
        for (int i = 0; i < n; ++i) {
            ContentParticle cp = (ContentParticle)this.cplist.elementAt(i);
            ChildrenNode child = (ChildrenNode)cp.getChildren();
            if (child != null) {
                ContentParticle cp1 = child.getContentParticle(name2);
                if (cp1 == null) continue;
                return cp1;
            }
            if (!name2.equals(cp.getName())) continue;
            return cp;
        }
        return null;
    }

    private final void makeCp(ContentParticle cp, StringBuffer sb) {
        Children child = cp.getChildren();
        if (child != null) {
            sb.append(child.toString());
        } else {
            String tag = cp.getName();
            if (tag != null) {
                if (cp.isEntityRef()) {
                    sb.append('%');
                    sb.append(tag);
                    sb.append(';');
                } else {
                    sb.append(tag);
                    char c = cp.getOccurrence();
                    if (c != '\u0000') {
                        sb.append(c);
                    }
                }
            }
        }
    }

    @Override
    public Vector getCPList() {
        return this.cplist;
    }

    @Override
    public int getOccurrence() {
        return this.occurrence;
    }

    public void setOccurrence(char occurrence) {
        this.occurrence = occurrence;
    }

    @Override
    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public boolean insertChild(String tagname, String refname) {
        return this.insertChild(tagname, refname, true);
    }

    public boolean insertChild(String tagname, String refname, boolean canAdd) {
        if (this.cplist == null) {
            this.cplist = new Vector();
            this.cplist.addElement(new ContentParticleImpl('\u0000', tagname));
            return true;
        }
        if (refname == null) {
            this.cplist.addElement(new ContentParticleImpl('\u0000', tagname));
            return true;
        }
        int n = this.cplist.size();
        for (int i = 0; i < n; ++i) {
            ContentParticleImpl cp = (ContentParticleImpl)this.cplist.elementAt(i);
            if (cp.hasChildren()) {
                ChildrenNode child = (ChildrenNode)cp.getChildren();
                if (!child.insertChild(tagname, refname, false)) continue;
                return true;
            }
            if (!refname.equals(cp.getName())) continue;
            this.cplist.insertElementAt(new ContentParticleImpl('\u0000', tagname), i);
            return true;
        }
        if (canAdd) {
            this.cplist.addElement(new ContentParticleImpl('\u0000', tagname));
            return true;
        }
        return false;
    }

    public boolean removeChild(String tagname) {
        if (this.cplist == null) {
            return false;
        }
        int n = this.cplist.size();
        for (int i = 0; i < n; ++i) {
            ContentParticleImpl cp = (ContentParticleImpl)this.cplist.elementAt(i);
            if (cp.hasChildren()) {
                ChildrenNode child = (ChildrenNode)cp.getChildren();
                if (!child.removeChild(tagname)) continue;
                return true;
            }
            if (!tagname.equals(cp.getName())) continue;
            this.cplist.removeElementAt(i);
            return true;
        }
        return false;
    }

    @Override
    public int getNodeType() {
        return 30;
    }

    @Override
    public String getNodeName() {
        return "";
    }

    @Override
    public DataTypeDecl getDataTypeDecl() {
        return null;
    }

    @Override
    public DeclNode getParentDecl() {
        return this.parent;
    }

    @Override
    public DeclNode getOwner() {
        return null;
    }

    public static void main(String[] args) {
        try {
            new ChildrenNode(null, "(#PCDATA | %PresInCont;)*");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public String getNodeTypeName() {
        return "Children";
    }
}

