/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.jxp.dtd;

import com.argo21.common.io.Debug;
import com.argo21.common.io.MIME2Java;
import com.argo21.common.io.XReader;
import com.argo21.common.lang.DataTypeDecl;
import com.argo21.common.lang.MessageCatalog;
import com.argo21.common.util.Properties;
import com.argo21.jxp.dtd.AttDef;
import com.argo21.jxp.dtd.AttDefNode;
import com.argo21.jxp.dtd.AttlistDecl;
import com.argo21.jxp.dtd.AttlistDeclNode;
import com.argo21.jxp.dtd.ChildrenNode;
import com.argo21.jxp.dtd.CommentDecl;
import com.argo21.jxp.dtd.CommentDeclNode;
import com.argo21.jxp.dtd.ContentParticle;
import com.argo21.jxp.dtd.ContentParticleImpl;
import com.argo21.jxp.dtd.DTDDecl;
import com.argo21.jxp.dtd.DTDException;
import com.argo21.jxp.dtd.DTDExtractor;
import com.argo21.jxp.dtd.DeclNode;
import com.argo21.jxp.dtd.DeclNodeList;
import com.argo21.jxp.dtd.DeclNodeListImpl;
import com.argo21.jxp.dtd.ElementDecl;
import com.argo21.jxp.dtd.ElementDeclNode;
import com.argo21.jxp.dtd.EntityDecl;
import com.argo21.jxp.dtd.EntityDeclNode;
import com.argo21.jxp.dtd.NotationDecl;
import com.argo21.jxp.dtd.NotationDeclNode;
import com.argo21.jxp.dtd.PERefDecl;
import com.argo21.jxp.dtd.PERefDeclNode;
import com.argo21.jxp.dtd.PIDeclNode;
import com.argo21.jxp.dtd.SchemaDecl;
import com.argo21.jxp.parser.IXmlParser;
import com.argo21.jxp.parser.XmlParser;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class DTDDocument
implements DTDDecl,
SchemaDecl {
    protected DeclNodeListImpl nodes = new DeclNodeListImpl(40);
    protected Hashtable elementDecls = new Hashtable(11);
    protected Hashtable entityDecls = new Hashtable(11);
    protected Document doc = null;
    protected String name = null;
    protected String publicId = null;
    protected String systemId = null;
    protected String url = null;
    protected Exception lastErr = null;
    protected Properties properties = new Properties();
    protected static String eol;
    private XReader docReader = null;
    static MessageCatalog msgCatalog;
    private ElementDeclNode rootElement = null;

    public static String getErrorMessage(String msgId, Object[] paraments) {
        return msgCatalog.getMessage(msgId, paraments);
    }

    public DTDDocument() {
        this(null, null);
    }

    public DTDDocument(String name2) {
        this(name2, null);
    }

    public DTDDocument(String name2, String url) {
        this.name = name2;
        this.url = url;
    }

    public static ElementDecl createElementDecl(DTDDocument dtd, String eleName, String contentspec) throws DTDException {
        return new ElementDeclNode((DTDDecl)dtd, eleName, contentspec.toCharArray());
    }

    public static AttlistDecl createAttlistDecl(DTDDocument dtd, String eleName, String attDef) throws DTDException {
        return new AttlistDeclNode((DTDDecl)dtd, eleName, attDef.toCharArray());
    }

    public static EntityDecl createEntityDecl(DTDDocument dtd, String entityName, String entityDef, boolean pedecl) throws DTDException {
        EntityDeclNode decl = new EntityDeclNode((DTDDecl)dtd, entityName, entityDef, pedecl);
        return decl;
    }

    public static NotationDecl createNotationDecl(DTDDocument dtd, String notationName, String notationContents) throws DTDException {
        NotationDeclNode decl = new NotationDeclNode(dtd, notationName, notationContents);
        return decl;
    }

    public static CommentDecl createCommentDecl(DTDDocument dtd, String text) throws DTDException {
        CommentDeclNode decl = new CommentDeclNode(dtd, text);
        return decl;
    }

    @Override
    public ElementDecl createElementDecl(String eleName, String contentspec) throws DTDException {
        ElementDeclNode decl = new ElementDeclNode((DTDDecl)this, eleName, contentspec.toCharArray());
        return decl;
    }

    @Override
    public AttlistDecl createAttListDecl(String eleName, String attDef) throws DTDException {
        return DTDDocument.createAttlistDecl(this, eleName, attDef);
    }

    @Override
    public EntityDecl createEntityDecl(String entityName, String entityDef, boolean pedecl) throws DTDException {
        return DTDDocument.createEntityDecl(this, entityName, entityDef, pedecl);
    }

    @Override
    public NotationDecl createNotationDecl(String notationName, String notationContents) throws DTDException {
        return DTDDocument.createNotationDecl(this, notationName, notationContents);
    }

    public CommentDecl createCommentDecl(String text) throws DTDException {
        return new CommentDeclNode(this, text);
    }

    @Override
    public void appendChild(DeclNode newChild) throws DTDException {
        int type = newChild.getNodeType();
        if (type == 20) {
            String s = newChild.getNodeName();
            ElementDeclNode elemdecl = (ElementDeclNode)this.elementDecls.get(s);
            if (elemdecl != null) {
                ((ElementDeclNode)newChild).attributeDefs = elemdecl.attributeDefs;
            }
            this.elementDecls.put(s, newChild);
            this.nodes.addElement(newChild);
        } else if (type == 21) {
            ElementDeclNode elemdecl;
            AttlistDeclNode attlist = (AttlistDeclNode)newChild;
            int n = attlist.getSize();
            if (n == 0) {
                return;
            }
            String elem = attlist.getElementName();
            if (elem == null) {
                DTDDocument.fatal("ATTR_NEED_ELEM", this, new Object[]{attlist.getAttDef(0).getNodeName()});
            }
            if ((elemdecl = (ElementDeclNode)this.getElementDecl(elem)) == null) {
                elemdecl = new ElementDeclNode((DTDDecl)this, elem, 0);
                this.elementDecls.put(elem, elemdecl);
            }
            for (int i = 0; i < n; ++i) {
                AttDef attdef = attlist.getAttDef(i);
                elemdecl.addAttDef(attdef);
                this.nodes.addElement(attdef);
            }
        } else if (type == 22) {
            ElementDeclNode elemdecl;
            AttDef attdef = (AttDef)newChild;
            String elem = attdef.getElementName();
            if (elem == null) {
                DTDDocument.fatal("ATTR_NEED_ELEM", this, new Object[]{attdef.getNodeName()});
            }
            if ((elemdecl = (ElementDeclNode)this.getElementDecl(elem)) == null) {
                elemdecl = new ElementDeclNode((DTDDecl)this, elem, 0);
                this.elementDecls.put(elem, elemdecl);
            }
            elemdecl.addAttDef(attdef);
            this.nodes.addElement(newChild);
        } else if (type == 6) {
            String entityName = newChild.getNodeName();
            if (this.entityDecls.contains(entityName)) {
                DTDDocument.fatal("DOBULE_ENTITY", this, new Object[]{entityName});
            }
            this.entityDecls.put(entityName, newChild);
            this.nodes.addElement(newChild);
        } else {
            this.nodes.addElement(newChild);
        }
    }

    @Override
    public String getURL() {
        return this.url;
    }

    @Override
    public void setURL(String url) {
        this.url = url;
    }

    @Override
    public DeclNode getFirstChild() {
        if (this.nodes.size() <= 0) {
            return null;
        }
        return this.nodes.elementAt(0);
    }

    @Override
    public DeclNode getLastChild() {
        if (this.nodes.size() <= 0) {
            return null;
        }
        return this.nodes.elementAt(this.nodes.size() - 1);
    }

    @Override
    public String getNodeName() {
        String s = this.properties.getValue("name");
        if (s != null) {
            return s;
        }
        if (this.name != null) {
            return this.name;
        }
        int n = this.nodes.size();
        for (int i = 0; i < n; ++i) {
            DeclNode node = this.nodes.elementAt(i);
            if (node.getNodeType() != 20) continue;
            return node.getNodeName();
        }
        return null;
    }

    @Override
    public ElementDecl getRootElement() {
        return this.rootElement;
    }

    @Override
    public int getNodeType() {
        return 27;
    }

    public int getDTDType() {
        return 0;
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties ps) {
        this.properties = ps;
    }

    @Override
    public String getPublicId() {
        return this.publicId;
    }

    @Override
    public String getSystemId() {
        return this.systemId;
    }

    @Override
    public void putProperty(String name2, String value) {
        this.properties.repleace(name2, value);
    }

    @Override
    public String getVersion() {
        return this.properties.getValue("version");
    }

    @Override
    public String getEncoding() {
        return this.properties.getValue("encoding");
    }

    @Override
    public Document getOwnerDocument() {
        return this.doc;
    }

    @Override
    public DeclNode getPreviousSibling() {
        return null;
    }

    @Override
    public DeclNode getNextSibling() {
        return null;
    }

    @Override
    public boolean hasChildNodes() {
        return this.nodes.size() > 0;
    }

    @Override
    public void insertBefore(DeclNode newChild, DeclNode refChild) throws DTDException {
        int index = this.nodes.indexOf(refChild);
        if (index < 0) {
            return;
        }
        this.insertBefore(newChild, index);
    }

    @Override
    public void insertBefore(DeclNode newChild, int index) throws DTDException {
        if (index < 0) {
            return;
        }
        int type = newChild.getNodeType();
        if (type == 20) {
            String s = newChild.getNodeName();
            ElementDeclNode elemdecl = (ElementDeclNode)this.elementDecls.get(s);
            if (elemdecl != null) {
                ((ElementDeclNode)newChild).attributeDefs = elemdecl.attributeDefs;
            }
            this.elementDecls.put(s, newChild);
            this.nodes.insertElementAt(newChild, index);
        } else if (type == 21) {
            ElementDeclNode elemdecl;
            AttlistDeclNode attlist = (AttlistDeclNode)newChild;
            int n = attlist.getSize();
            if (n == 0) {
                return;
            }
            String elem = attlist.getElementName();
            if (elem == null) {
                DTDDocument.fatal("ATTR_NEED_ELEM", this, new Object[]{attlist.getAttDef(0).getNodeName()});
            }
            if ((elemdecl = (ElementDeclNode)this.getElementDecl(elem)) == null) {
                elemdecl = new ElementDeclNode((DTDDecl)this, elem, 0);
                this.elementDecls.put(elem, elemdecl);
            }
            for (int i = 0; i < n; ++i) {
                AttDef attdef = attlist.getAttDef(i);
                elemdecl.addAttDef(attdef);
                this.nodes.insertElementAt(newChild, index);
                ++index;
            }
        } else if (type == 22) {
            ElementDeclNode elemdecl;
            AttDef attdef = (AttDef)newChild;
            String elem = attdef.getElementName();
            if (elem == null) {
                DTDDocument.fatal("ATTR_NEED_ELEM", this, new Object[]{attdef.getNodeName()});
            }
            if ((elemdecl = (ElementDeclNode)this.getElementDecl(elem)) == null) {
                elemdecl = new ElementDeclNode((DTDDecl)this, elem, 0);
                this.elementDecls.put(elem, elemdecl);
            }
            elemdecl.addAttDef(attdef);
            this.nodes.insertElementAt(newChild, index);
        } else if (type == 6) {
            String entityName = newChild.getNodeName();
            if (this.entityDecls.contains(entityName)) {
                DTDDocument.fatal("DOBULE_ENTITY", this, new Object[]{entityName});
            }
            this.entityDecls.put(entityName, newChild);
            this.nodes.insertElementAt(newChild, index);
        } else {
            this.nodes.insertElementAt(newChild, index);
        }
    }

    @Override
    public void removeChild(DeclNode refChild) {
        int type = refChild.getNodeType();
        if (type == 20) {
            String s = refChild.getNodeName();
            this.elementDecls.remove(s);
            this.nodes.removeElement(refChild);
        } else if (type == 21) {
            AttlistDeclNode attlist = (AttlistDeclNode)refChild;
            String elem = attlist.getElementName();
            if (elem == null) {
                return;
            }
            ElementDeclNode elemdecl = (ElementDeclNode)this.getElementDecl(elem);
            if (elemdecl == null) {
                return;
            }
            int n = attlist.getSize();
            for (int i = 0; i < n; ++i) {
                AttDef attdef = attlist.getAttDef(i);
                elemdecl.removeAttDef(attdef);
                this.nodes.removeElement(attdef);
            }
        } else if (type == 22) {
            AttDef attdef = (AttDef)refChild;
            String elem = attdef.getElementName();
            if (elem == null) {
                return;
            }
            ElementDeclNode elemdecl = (ElementDeclNode)this.getElementDecl(elem);
            if (elemdecl == null) {
                return;
            }
            elemdecl.removeAttDef(attdef);
            this.nodes.removeElement(attdef);
        } else if (type == 6) {
            String entityName = refChild.getNodeName();
            this.entityDecls.remove(entityName);
            this.nodes.removeElement(refChild);
        } else {
            this.nodes.removeElement(refChild);
        }
    }

    public String toString() {
        CharArrayWriter writer = new CharArrayWriter();
        try {
            this.write(writer);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return writer.toString();
    }

    @Override
    public DeclNode getPreviousChild(DeclNode refChild) {
        int index = this.nodes.indexOf(refChild);
        if (index < 0) {
            return null;
        }
        if (--index >= 0) {
            return this.nodes.elementAt(index);
        }
        return null;
    }

    @Override
    public DeclNode getNextChild(DeclNode refChild) {
        int index = this.nodes.indexOf(refChild);
        if (index < 0) {
            return null;
        }
        if (++index < this.nodes.size()) {
            return this.nodes.elementAt(index);
        }
        return null;
    }

    @Override
    public DeclNodeList getAllDeclNode() {
        return this.nodes;
    }

    @Override
    public Vector getAllDeclName() {
        int n = this.nodes.size();
        Vector<String> names = new Vector<String>(n);
        for (int i = 0; i < n; ++i) {
            DeclNode decl = this.nodes.elementAt(i);
            names.addElement(decl.getNodeName());
        }
        return names;
    }

    @Override
    public boolean containsKey(String key) {
        return this.elementDecls.containsKey(key);
    }

    @Override
    public DeclNode getDeclNodeByKey(String key) {
        return (DeclNode)this.elementDecls.get(key);
    }

    @Override
    public void write(Writer out) throws IOException {
        this.write(out, true);
    }

    @Override
    public void write(Writer out, boolean xmlPI) throws IOException {
        String s = this.properties.getValue("version");
        String s1 = this.properties.getValue("encoding");
        if (xmlPI && (s != null || s1 != null)) {
            out.write("<?xml ");
            if (s != null) {
                out.write("version=\"");
                out.write(s);
                out.write("\"");
                if (s1 != null) {
                    out.write(" ");
                }
            }
            if (s1 != null) {
                out.write("encoding=\"");
                out.write(s1);
                out.write("\"");
            }
            out.write("?>");
            out.write(eol);
        }
        int n = this.nodes.size();
        for (int i = 0; i < n; ++i) {
            DeclNode node = this.nodes.elementAt(i);
            if (node.getNodeType() == 7 && !xmlPI) continue;
            out.write(node.toString());
            out.write(eol);
        }
    }

    public void writePI(Writer out) throws IOException {
        int n = this.nodes.size();
        for (int i = 0; i < n; ++i) {
            DeclNode node = this.nodes.elementAt(i);
            if (node.getNodeType() != 7) continue;
            out.write(node.toString());
            out.write(eol);
        }
    }

    public void writeEx(Writer out, boolean xmlPI) throws IOException {
        DeclNode node;
        int i;
        String s = this.properties.getValue("version");
        String s1 = this.properties.getValue("encoding");
        if (xmlPI && (s != null || s1 != null)) {
            out.write("<?xml ");
            if (s != null) {
                out.write("version=\"");
                out.write(s);
                out.write("\"");
                if (s1 != null) {
                    out.write(" ");
                }
            }
            if (s1 != null) {
                out.write("encoding=\"");
                out.write(s1);
                out.write("\"");
            }
            out.write("?>");
            out.write(eol);
        }
        int n = this.nodes.size();
        for (i = 0; i < n; ++i) {
            node = this.nodes.elementAt(i);
            out.write(node.toString());
            out.write(eol);
        }
        out.write(eol);
        n = this.nodes.size();
        for (i = 0; i < n; ++i) {
            String attr;
            DataTypeDecl dt;
            node = this.nodes.elementAt(i);
            int type = node.getNodeType();
            if (type == 20) {
                dt = node.getDataTypeDecl();
                if (dt == null) continue;
                ElementDecl element = (ElementDecl)node;
                attr = "element=\"" + element.getNodeName() + "\"";
                s = dt.getXML(attr);
                if (s == null) continue;
                out.write(dt.getXML(attr));
                out.write(eol);
                continue;
            }
            if (type != 22 || (dt = node.getDataTypeDecl()) == null) continue;
            AttDef attdef = (AttDef)node;
            attr = "element=\"" + attdef.getElementName() + "\" attr=\"" + attdef.getNodeName() + "\"";
            s = dt.getXML(attr);
            if (s == null) continue;
            out.write(dt.getXML(attr));
            out.write(eol);
        }
    }

    @Override
    public DeclNodeList getAttListDecls(String element) {
        ElementDeclNode elemdecl = (ElementDeclNode)this.getElementDecl(element);
        if (elemdecl == null) {
            return null;
        }
        return elemdecl.getAttListDecls();
    }

    @Override
    public AttDef getAttListDecl(String element, String attribute) {
        ElementDecl elementdecl = this.getElementDecl(element);
        if (elementdecl == null) {
            return null;
        }
        return elementdecl.getAttListDecl(attribute);
    }

    @Override
    public ElementDecl getElementDecl(String element) {
        DeclNode decl = (DeclNode)this.elementDecls.get(element);
        if (decl != null && decl.getNodeType() == 20) {
            return (ElementDecl)decl;
        }
        return null;
    }

    @Override
    public EntityDecl getEntityDecl(String entity) {
        return (EntityDeclNode)this.entityDecls.get(entity);
    }

    @Override
    public Enumeration getAllEntityDecls() {
        return this.entityDecls.elements();
    }

    @Override
    public Enumeration getAllElementDecls() {
        return this.elementDecls.elements();
    }

    @Override
    public DeclNodeList getSubElementDecls(String element) {
        ElementDecl elementdecl = (ElementDecl)this.elementDecls.get(element);
        if (elementdecl == null) {
            return null;
        }
        return elementdecl.getSubElementDecls();
    }

    @Override
    public DataTypeDecl getDataTypeDecl() {
        return null;
    }

    @Override
    public DeclNode getParentDecl() {
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean parseDTDDecl(XReader in) throws DTDException {
        try {
            do {
                in.peekWhitespace();
                if (in.isEOF()) return true;
            } while (this.parseElementDecl(in) || this.parseAttListDecl(in) || this.parseEntityDecl(in) || this.parseNotationDecl(in) || this.parsePI(in) || this.parseComment(in) || this.parsePEReference(in) || this.parseDataDecl(in));
            if (!in.isChar(']')) return true;
            return true;
        }
        catch (IOException e) {
            DTDDocument.fatal(e, (Locator)in);
        }
        return true;
    }

    private boolean parseExternalID(XReader in) throws DTDException, IOException {
        if (in.peek("SYSTEM")) {
            if (!in.peekWhitespace()) {
                DTDDocument.fatal("NEED_SYSTEMID", (Locator)in);
            }
            this.publicId = null;
            this.parseSystemLiteral(in);
            this.loadExternalDTD();
            return true;
        }
        if (in.peek("PUBLIC")) {
            if (!in.peekWhitespace()) {
                DTDDocument.fatal("NEED_PUBLICID", (Locator)in);
            }
            this.parsePubidLiteral(in);
            if (!in.peekWhitespace()) {
                DTDDocument.fatal("NEED_PUBLICID", (Locator)in);
            }
            this.parseSystemLiteral(in);
            this.loadExternalDTD();
            return true;
        }
        return false;
    }

    private boolean parseSystemLiteral(XReader in) throws DTDException, IOException {
        this.systemId = in.peekQuotedString();
        if (this.systemId == null) {
            DTDDocument.fatal("NEED_SYSTEMID", (Locator)in);
        }
        return true;
    }

    private boolean parsePubidLiteral(XReader in) throws DTDException, IOException {
        this.publicId = in.peekQuotedString();
        if (this.publicId == null) {
            DTDDocument.fatal("NEED_PUBLICID", (Locator)in);
        }
        return this.publicId != null;
    }

    protected boolean parseComment(XReader in) throws IOException, DTDException {
        if (!in.peek("<!--")) {
            return false;
        }
        String s1 = in.readStringTo("-->", false);
        if (s1 != null) {
            CommentDecl decl = DTDDocument.createCommentDecl(this, s1);
            this.appendChild(decl);
        } else {
            DTDDocument.fatal("INVALID_COMENT", (Locator)in);
        }
        return true;
    }

    protected boolean parsePEReference(XReader in) throws IOException, DTDException {
        if (!in.peekc('%')) {
            return false;
        }
        PERefDeclNode decl = new PERefDeclNode((DTDDecl)this, in);
        this.appendChild(decl);
        in.peekWhitespace();
        return true;
    }

    protected boolean parsePI(XReader in) throws IOException, DTDException {
        if (!in.peek("<?")) {
            return false;
        }
        String name2 = in.peekXmlName();
        if (name2 == null) {
            in.peekWhitespace();
            DTDDocument.fatal("INVALID_CHAR", (Locator)in, String.valueOf(in.getc()));
        }
        if (!in.peekWhitespace()) {
            DTDDocument.fatal("NEED_SPACE_AFTER", (Locator)in, "<?" + name2);
        }
        if (name2.equalsIgnoreCase("xml")) {
            while (!in.isEOF()) {
                String value;
                name2 = in.peekXmlName();
                if (name2 == null) {
                    in.peekWhitespace();
                    DTDDocument.fatal("INVALID_CHAR", (Locator)in, String.valueOf(in.getc()));
                }
                in.peekWhitespace();
                if (!in.peekc('=')) {
                    DTDDocument.fatal("NEED_CHAR", (Locator)in, "=");
                }
                in.peekWhitespace();
                if (!in.peekc('\"')) {
                    DTDDocument.fatal("NEED_QUOTE", (Locator)in);
                }
                if ((value = in.readStringTo('\"', false)) == null) {
                    DTDDocument.fatal("NEED_QUOTE_END", (Locator)in);
                }
                this.properties.repleace(name2, value);
                in.peekWhitespace();
                if (!in.peekc('?')) continue;
                if (!in.peekc('>')) {
                    DTDDocument.fatal("NEED_CHAR", (Locator)in, ">");
                }
                return true;
            }
        } else {
            String contents = in.readStringTo("?>", true);
            PIDeclNode decl = new PIDeclNode(this, name2, contents);
            this.appendChild(decl);
            return true;
        }
        DTDDocument.fatal("NEED_CHAR", (Locator)in, "?>");
        return false;
    }

    protected boolean parseElementDecl(XReader in) throws IOException, DTDException {
        if (!in.peek("<!ELEMENT")) {
            return false;
        }
        if (!in.peekWhitespace()) {
            DTDDocument.fatal("INVALID_ELEMENT", (Locator)in);
        }
        ElementDeclNode decl = new ElementDeclNode((DTDDecl)this, in);
        this.appendChild(decl);
        in.peekWhitespace();
        if (!in.peekc('>')) {
            DTDDocument.fatal("NEED_CHAR", (Locator)in, ">");
        }
        return true;
    }

    protected boolean parseAttListDecl(XReader in) throws IOException, DTDException {
        if (!in.peek("<!ATTLIST")) {
            return false;
        }
        if (!in.peekWhitespace()) {
            DTDDocument.fatal("INVALID_ATTLIST", (Locator)in);
        }
        AttlistDeclNode decl = new AttlistDeclNode(this, in);
        this.appendChild(decl);
        in.peekWhitespace();
        if (!in.peekc('>')) {
            DTDDocument.fatal("NEED_CHAR", (Locator)in, ">");
        }
        return true;
    }

    protected boolean parseEntityDecl(XReader in) throws IOException, DTDException {
        if (!in.peek("<!ENTITY")) {
            return false;
        }
        if (!in.peekWhitespace()) {
            DTDDocument.fatal("INVALID_ENTITY", (Locator)in);
        }
        EntityDeclNode decl = new EntityDeclNode(this, in);
        this.appendChild(decl);
        in.peekWhitespace();
        if (!in.peekc('>')) {
            DTDDocument.fatal("NEED_CHAR", (Locator)in, ">");
        }
        return true;
    }

    protected boolean parseNotationDecl(XReader in) throws IOException, DTDException {
        if (!in.peek("<!NOTATION")) {
            return false;
        }
        if (!in.peekWhitespace()) {
            DTDDocument.fatal("INVALID_NOTATION", (Locator)in);
        }
        NotationDeclNode decl = new NotationDeclNode(this, in);
        this.appendChild(decl);
        in.peekWhitespace();
        if (!in.peekc('>')) {
            DTDDocument.fatal("NEED_CHAR", (Locator)in, ">");
        }
        return true;
    }

    protected boolean parseDataDecl(XReader in) throws DTDException {
        if (!in.peek("<DATA")) {
            return false;
        }
        if (!in.peekWhitespace()) {
            DTDDocument.fatal("INVALID_DATADECL", (Locator)in);
        }
        Properties properties = new Properties();
        boolean hasEnded = false;
        while (!in.isEOF()) {
            if (in.isChar('\\')) {
                in.getc();
                if (in.isChar('>')) {
                    in.getc();
                    hasEnded = true;
                    break;
                }
                DTDDocument.fatal("NEED_CHAR", (Locator)in, ">");
            }
            if (in.isChar('>')) {
                in.getc();
                break;
            }
            String propertyname = in.peekXmlName();
            if (propertyname == null) {
                DTDDocument.fatal("INVALID_DATADECL", (Locator)in);
            }
            in.peekWhitespace();
            if (!in.peekc('=')) {
                DTDDocument.fatal("NEED_CHAR", (Locator)in, "=");
            }
            in.peekWhitespace();
            String propertyvalue = in.peekQuotedString();
            if (propertyvalue == null) {
                DTDDocument.fatal("NEED_CHAR", (Locator)in, "\"");
            }
            properties.append(propertyname, propertyvalue);
            in.peekWhitespace();
        }
        if (!hasEnded) {
            in.peekWhitespace();
            String s = in.readStringTo("</DATA>", false);
            properties.append("value", Properties.parseSpecialChar(s));
        }
        DataTypeDecl dtDecl = new DataTypeDecl(properties);
        String element = properties.getValue("element");
        if (element != null) {
            String attr = properties.getValue("attr");
            if (attr != null) {
                attr = properties.getValue("attribute");
            }
            if (attr != null) {
                AttDefNode attdef = (AttDefNode)this.getAttListDecl(element, attr);
                if (attdef != null) {
                    attdef.setDataTypeDecl(dtDecl);
                } else {
                    DTDDocument.fatal("UNDECL_ATTR", (Locator)in, attr);
                }
            } else {
                ElementDeclNode elemdecl = (ElementDeclNode)this.getElementDecl(element);
                if (elemdecl != null) {
                    elemdecl.setDataTypeDecl(dtDecl);
                } else {
                    DTDDocument.fatal("UNDECL_ELEM", (Locator)in, element);
                }
            }
        } else {
            DTDDocument.fatal("INVALID_DATADECL", (Locator)in);
        }
        return true;
    }

    private boolean loadExternalDTD() throws DTDException, IOException {
        if (this.systemId == null) {
            return false;
        }
        String urlid = this.getAllPath(this.systemId);
        this.load(urlid, true);
        return true;
    }

    private String getAllPath(String urlid) {
        if (urlid == null || this.url == null) {
            return urlid;
        }
        URL baseUri = null;
        if (this.url != null) {
            try {
                baseUri = new URL(this.url);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        URL uri = null;
        try {
            uri = new URL(urlid);
        }
        catch (MalformedURLException ex) {
            File file = new File(urlid);
            try {
                uri = !file.isAbsolute() && baseUri != null ? new URL(baseUri, file.getPath()) : file.toURL();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if (uri != null) {
            return uri.toString();
        }
        return null;
    }

    @Override
    public void resolveParameterRefrance() {
        int n = this.nodes.getLength();
        for (int pos = 0; pos < n; ++pos) {
            DeclNode node = this.nodes.item(pos);
            if (node.getNodeType() != 28) continue;
            EntityDecl entity = ((PERefDecl)node).getEntityDecl();
            if (entity != null) {
                DTDDocument exdtd = new DTDDocument();
                String address = this.getAllPath(entity.getSystemId());
                try {
                    exdtd.load(address, false);
                }
                catch (DTDException e) {
                    Debug.println(e);
                }
                catch (Exception e) {
                    Debug.println(e);
                }
                exdtd.resolveParameterRefrance();
                DeclNodeList exnodes = exdtd.getAllDeclNode();
                int exn = exnodes.getLength();
                this.removeChild(node);
                for (int i = 0; i < exn; ++i) {
                    try {
                        this.insertBefore(exnodes.item(i), pos);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ++pos;
                }
            }
            n = this.nodes.getLength();
        }
    }

    @Override
    public void resolveEntity() {
        int n = this.nodes.getLength();
        for (int pos = 0; pos < n; ++pos) {
            DeclNode node = this.nodes.item(pos);
            int type = node.getNodeType();
            try {
                if (type == 20) {
                    ((ElementDecl)node).repleaceEntity();
                    continue;
                }
                if (type == 6) {
                    ((EntityDecl)node).repleaceEntity();
                    continue;
                }
                if (type != 22) continue;
                ((AttDef)node).repleaceEntity();
                n = this.nodes.getLength();
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void resolveHierarchy() {
        DeclNode node;
        int i;
        int n = this.nodes.size();
        for (int i2 = 0; i2 < n; ++i2) {
            DeclNode node2 = this.nodes.elementAt(i2);
            if (node2.getNodeType() != 20) continue;
            DeclNodeList list = ((ElementDeclNode)node2).getSubElementDecls();
            int n1 = list.size();
            for (int j = 0; j < n1; ++j) {
                ElementDeclNode elem = (ElementDeclNode)list.item(j);
                elem.addParentDecl((ElementDecl)node2);
            }
        }
        if (this.name != null) {
            this.rootElement = (ElementDeclNode)this.elementDecls.get(this.name);
            if (this.rootElement != null) {
                this.rootElement.parents = null;
                return;
            }
        }
        ElementDeclNode first = null;
        for (i = 0; i < n; ++i) {
            node = this.nodes.elementAt(i);
            if (node.getNodeType() != 20) continue;
            if (first == null) {
                first = (ElementDeclNode)node;
            }
            if (node.getParentDecl() != null) continue;
            first = (ElementDeclNode)node;
            break;
        }
        if (first != null) {
            this.rootElement = first;
            this.rootElement.parents = null;
        } else {
            this.rootElement = null;
        }
        for (i = 0; i < n; ++i) {
            DeclNode parent;
            node = this.nodes.elementAt(i);
            if (node.getNodeType() != 20 || (parent = node.getParentDecl()) != null || this.rootElement == node) continue;
            String msgname = this.getNodeName();
            Debug.println("<" + msgname + ">\u30eb\u30fc\u30c8\u30a8\u30ec\u30e1\u30f3\u30c8\u304c\u5b58\u5728\u3057\u307e\u305b\u3093");
            break;
        }
    }

    public XReader getErrorXReader() {
        return this.docReader;
    }

    @Override
    public boolean load(String address) throws DTDException, IOException {
        return this.load(address, false);
    }

    public boolean load(String address, boolean isExternal) throws DTDException, IOException {
        String encoding;
        URL url = null;
        try {
            url = new URL(address);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        if (url == null) {
            File file = new File(address);
            url = file.toURL();
            address = url.toString();
        }
        this.docReader = (encoding = this.properties.getValue("encoding")) == null ? XReader.createReader(url, false) : XReader.createReader(url.openStream(), encoding);
        try {
            if (!isExternal) {
                this.url = this.docReader.getSystemId();
            }
            this.properties.repleace("encoding", this.docReader.getEncoding());
            this.parseDTDDecl(this.docReader);
            this.docReader.peekWhitespace();
            if (!this.docReader.isEOF()) {
                DTDDocument.fatal("INVALID_CHAR", (Locator)this.docReader, String.valueOf(this.docReader.getc()));
            }
            this.docReader.close();
            this.docReader = null;
            return true;
        }
        catch (DTDException e) {
            try {
                this.docReader.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
    }

    @Override
    public void save(String address) throws IOException {
        if (address.startsWith("file:/") && (address = address.substring(6)).startsWith("/")) {
            address = address.substring(1);
        }
        File file = new File(address);
        OutputStreamWriter writer = null;
        String encoding = this.getEncoding();
        if (encoding != null) {
            encoding = MIME2Java.convert(encoding);
        }
        try {
            if (encoding != null) {
                CharsetEncoder charsetEncoder = Charset.forName(encoding).newEncoder();
            }
            if (encoding == null) {
                writer = new OutputStreamWriter(new FileOutputStream(file));
                this.putProperty("encoding", MIME2Java.reverse(writer.getEncoding()));
            } else {
                writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), encoding);
            }
            this.write(writer);
            this.url = file.toURL().toString();
            writer.close();
        }
        catch (IllegalArgumentException e) {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new IOException(e.getMessage());
        }
        catch (IOException e) {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
    }

    @Override
    public void loadByXML(String address) throws DTDException, IOException {
        InputSource is;
        String encoding;
        URL url = null;
        try {
            File file = new File(address);
            if (file.exists()) {
                url = file.toURL();
            }
        }
        catch (IOException file) {
            // empty catch block
        }
        if (url == null) {
            url = new URL(address);
        }
        if ((encoding = this.properties.getValue("encoding")) == null) {
            is = XReader.createInputSource(url, false);
        } else {
            is = new InputSource(XReader.createReader(url.openStream(), encoding));
            is.setSystemId(url.toString());
        }
        encoding = is.getEncoding();
        if (encoding != null) {
            this.properties.repleace("encoding", encoding);
        }
        this.properties.repleace("version", "1.0");
        try {
            IXmlParser parser = XmlParser.getXmlParser();
            this.doc = parser.createXmlDocument(is, false);
        }
        catch (SAXParseException e) {
            throw new DTDException(null, e.getPublicId(), e.getSystemId(), e.getLineNumber(), e.getColumnNumber(), e);
        }
        catch (SAXException e) {
            throw new DTDException(null, is.getPublicId(), is.getSystemId(), 0, 0, e);
        }
        catch (ParserConfigurationException e) {
            throw new DTDException(null, is.getPublicId(), is.getSystemId(), 0, 0, e);
        }
        this.url = address;
        DocumentType dt = this.doc.getDoctype();
        if (dt == null) {
            this.extractFromXML(this.doc);
        } else {
            this.extractFromXML(this.doc);
        }
    }

    void extractFromXML(Document document) throws DTDException {
        DTDExtractor eg = new DTDExtractor(document);
        for (ElementDecl elem : eg.getElementDecls(this)) {
            String s = elem.getNodeName();
            this.elementDecls.put(s, elem);
            this.nodes.addElement(elem);
            DeclNodeList attlist = elem.getAttListDecls();
            int n1 = attlist == null ? 0 : attlist.size();
            for (int j = 0; j < n1; ++j) {
                this.nodes.addElement(attlist.item(j));
            }
        }
    }

    public Vector getPathNamesStringToRoot(String name2) {
        Vector<String> v = new Vector<String>();
        if (this.name == null) {
            return v;
        }
        ElementDecl decl = null;
        if (name2.startsWith("@")) {
            name2 = name2.substring(1);
            int n = this.nodes.size();
            for (int i = 0; i < n; ++i) {
                DeclNode node = this.nodes.item(i);
                if (node.getNodeType() != 22 || !name2.equals(node.getNodeName())) continue;
                name2 = ((AttDef)node).getElementName();
                decl = this.getElementDecl(name2);
                break;
            }
        } else {
            ElementDeclNode parentDecl = (ElementDeclNode)this.getElementDecl(name2);
            decl = (ElementDeclNode)parentDecl.getParentDecl();
        }
        while (decl != null) {
            v.insertElementAt(decl.getName(), 0);
            decl = (ElementDeclNode)decl.getParentDecl();
        }
        return v;
    }

    @Override
    public String getAbsolutePath(String[] names, char split) {
        int n = names.length;
        if (n < 1) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        ElementDecl parentDecl = null;
        for (int i = 0; i < n; ++i) {
            ContentParticle cp;
            String name2 = names[i];
            if (name2.startsWith("@")) {
                AttDef att;
                if (parentDecl != null && (att = parentDecl.getAttListDecl(name2.substring(1))) != null) {
                    sb.append(split);
                    sb.append(name2);
                }
                return sb.toString();
            }
            char c = '\u0000';
            if (parentDecl != null && (cp = ((ElementDeclNode)parentDecl).getContentParticle(name2)) != null) {
                c = ((ContentParticleImpl)cp).getLastOccurrence();
            }
            if ((parentDecl = this.getElementDecl(name2)) == null) break;
            sb.append(split);
            sb.append(name2);
            if (c == '\u0000') continue;
            sb.append('[');
            sb.append(c);
            sb.append(']');
        }
        return sb.toString();
    }

    public void removeAllEntityDecl() {
        int k = 0;
        while (k < this.nodes.size()) {
            DeclNode decl = this.nodes.elementAt(k);
            int type = decl.getNodeType();
            if (decl.getNodeType() == 6) {
                this.nodes.removeElementAt(k);
                continue;
            }
            ++k;
        }
        this.entityDecls.clear();
    }

    public void filter(String root) {
        this.filter(root, false);
    }

    public void filter(String root, boolean comment) {
        if (root == null || root.length() == 0) {
            return;
        }
        ElementDeclNode elem = (ElementDeclNode)this.getElementDecl(root);
        if (elem == null) {
            return;
        }
        this.rootElement = elem;
        this.name = this.rootElement.getNodeName();
        Hashtable sbset = new Hashtable();
        this.filter(elem, sbset);
        int k = 0;
        int rootpos = 0;
        while (k < this.nodes.size()) {
            int type;
            DeclNode decl = this.nodes.elementAt(k);
            if (this.rootElement == decl) {
                rootpos = k;
            }
            if ((type = decl.getNodeType()) == 8) {
                if (!comment) {
                    this.nodes.removeElementAt(k);
                    continue;
                }
            } else {
                if (type == 6) {
                    this.nodes.removeElementAt(k);
                    this.entityDecls.remove(decl.getNodeName());
                    continue;
                }
                if (type == 20) {
                    if (!sbset.containsKey(decl)) {
                        this.nodes.removeElementAt(k);
                        this.elementDecls.remove(decl.getNodeName());
                        continue;
                    }
                } else if (type == 22) {
                    if (!sbset.containsKey(decl)) {
                        this.nodes.removeElementAt(k);
                        continue;
                    }
                } else {
                    this.nodes.removeElementAt(k);
                    continue;
                }
            }
            ++k;
        }
        if (rootpos != 0) {
            this.nodes.removeElementAt(rootpos);
            this.nodes.insertElementAt(this.rootElement, 0);
        }
    }

    private void filter(ElementDeclNode elem, Hashtable sbset) {
        sbset.put(elem, Boolean.TRUE);
        DeclNodeList list = elem.getSubElementDecls();
        int n = list.getLength();
        for (int i = 0; i < n; ++i) {
            ElementDeclNode elem1 = (ElementDeclNode)list.item(i);
            if (sbset.containsKey(elem1)) continue;
            this.filter(elem1, sbset);
        }
        Hashtable attlist = elem.attributeDefs;
        if (attlist != null) {
            Enumeration en = attlist.elements();
            while (en.hasMoreElements()) {
                sbset.put(en.nextElement(), Boolean.TRUE);
            }
        }
    }

    public void filterAndSort(String root) {
        ElementDeclNode elem = (ElementDeclNode)this.getElementDecl(root);
        if (elem == null) {
            return;
        }
        this.rootElement = elem;
        this.name = this.rootElement.getNodeName();
        DeclNodeListImpl nodes1 = new DeclNodeListImpl(this.nodes.size());
        Hashtable elementDecls1 = new Hashtable();
        this.filterAndSort(elem, nodes1, elementDecls1);
        this.nodes = nodes1;
        this.elementDecls = elementDecls1;
    }

    private void filterAndSort(ElementDeclNode elem, DeclNodeListImpl nodes1, Hashtable elementDecls1) {
        nodes1.addElement(elem);
        elementDecls1.put(elem.getNodeName(), elem);
        Hashtable attlist = elem.attributeDefs;
        if (attlist != null) {
            Enumeration en = attlist.elements();
            while (en.hasMoreElements()) {
                nodes1.addElement((DeclNode)en.nextElement());
            }
        }
        DeclNodeList list = elem.getSubElementDecls();
        int n = list.getLength();
        for (int i = 0; i < n; ++i) {
            ElementDeclNode elem1 = (ElementDeclNode)list.item(i);
            if (elementDecls1.containsKey(elem1.getNodeName())) continue;
            this.filterAndSort(elem1, nodes1, elementDecls1);
        }
    }

    public void addPrefix(String prefix, String nsuri) {
        int n = this.nodes.size();
        int firstElementIndex = -1;
        for (int i = 0; i < n; ++i) {
            DeclNode decl = this.nodes.elementAt(i);
            int type = decl.getNodeType();
            if (type == 20) {
                ElementDeclNode elemNode = (ElementDeclNode)decl;
                if (elemNode.name.indexOf(58) < 0) {
                    elemNode.name = prefix + ":" + elemNode.name;
                }
                if (elemNode.type == 2) {
                    int m = elemNode.childNames == null ? 0 : elemNode.childNames.size();
                    for (int j = 0; j < m; ++j) {
                        String s = (String)elemNode.childNames.elementAt(j);
                        if (s.indexOf(58) >= 0) continue;
                        elemNode.childNames.setElementAt(prefix + ":" + s, j);
                    }
                } else if (elemNode.type == 3) {
                    this.addPrefix((ChildrenNode)elemNode.children, prefix);
                }
                if (elemNode.type == 0 || firstElementIndex != -1) continue;
                firstElementIndex = i;
                continue;
            }
            if (type != 22) continue;
            AttDefNode attNode = (AttDefNode)decl;
            if (attNode.name.indexOf(58) < 0) {
                attNode.name = prefix + ":" + attNode.name;
            }
            if (attNode.elementname.indexOf(58) >= 0) continue;
            attNode.elementname = prefix + ":" + attNode.elementname;
        }
        if (firstElementIndex >= 0 && nsuri != null && nsuri.length() > 0) {
            String eleName = this.nodes.item(firstElementIndex).getNodeName();
            try {
                AttlistDecl al = this.createAttListDecl(eleName, "xmlns:" + prefix + " CDATA #FIXED \"" + nsuri + "\"");
                AttDef attdef = al.getAttDef(0);
                this.insertBefore((DeclNode)attdef, firstElementIndex + 1);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void addPrefix(ChildrenNode child, String prefix) {
        if (child.cplist == null) {
            return;
        }
        int n = child.cplist.size();
        for (int i = 0; i < n; ++i) {
            ContentParticleImpl cp = (ContentParticleImpl)child.cplist.elementAt(i);
            ChildrenNode child1 = (ChildrenNode)cp.getChildren();
            if (child1 != null) {
                this.addPrefix(child1, prefix);
                continue;
            }
            if (cp.name == null || cp.name.indexOf(58) >= 0) continue;
            cp.name = prefix + ":" + cp.name;
        }
    }

    public static DTDDocument createDTDByXML(Document document) {
        DTDDocument dtd = new DTDDocument();
        try {
            DocumentType dt = document.getDoctype();
            if (dt == null) {
                dtd = DTDDocument.extractFromXML0(document);
                dtd.doc = document;
            } else {
                dtd = DTDDocument.extractFromXML0(document);
                dtd.doc = document;
            }
            dtd.lastErr = null;
        }
        catch (Exception e1) {
            dtd.lastErr = e1;
        }
        return dtd;
    }

    public Exception getLastErr() {
        return this.lastErr;
    }

    static DTDDocument extractFromXML0(Document document) throws DTDException {
        DTDExtractor eg = new DTDExtractor(document);
        int max = eg.size() - 1;
        if (max <= 0) {
            return null;
        }
        DTDDocument dtd = new DTDDocument();
        for (int i = 0; i < max; ++i) {
            String ac;
            String ec;
            String sn = eg.getElementName(i);
            if (i == 0) {
                dtd.name = sn;
            }
            if ((ec = eg.getElementContents(i)) != null) {
                ElementDecl eleNode = dtd.createElementDecl(sn, ec);
                dtd.appendChild(eleNode);
            }
            if ((ac = eg.getAttributeContents(i)) == null) continue;
            AttlistDecl decl = dtd.createAttListDecl(sn, ac);
            dtd.appendChild(decl);
        }
        return dtd;
    }

    public static String serializied(String str) {
        int k;
        if (str == null) {
            return null;
        }
        int n = str.length();
        char c = '\u0000';
        for (k = 0; k < n && (c = str.charAt(k)) != '\n' && c != '\r' && c != '%' && c != '*' && c != '[' && c != ']' && c != '<' && c != '>' && c != '&'; ++k) {
        }
        if (k == n) {
            return str;
        }
        StringBuffer sb = new StringBuffer();
        if (k > 0) {
            sb.append(str.substring(0, k));
        }
        sb.append("&#");
        sb.append((int)c);
        sb.append(';');
        ++k;
        while (k < n) {
            c = str.charAt(k);
            if (c == '\n' || c == '\r' || c == '%' || c == '*' || c == '[' || c == ']' || c == '<' || c == '>' || c == '&') {
                sb.append("&#");
                sb.append((int)c);
                sb.append(';');
            } else {
                sb.append(c);
            }
            ++k;
        }
        return sb.toString();
    }

    public static String unSerializied(String str) {
        int k;
        if (str == null) {
            return null;
        }
        int n = str.length();
        for (k = 0; k < n && str.charAt(k) != '&'; ++k) {
        }
        if (k > n - 1) {
            return str;
        }
        if (str.charAt(k + 1) != '#') {
            return str;
        }
        StringBuffer sb = new StringBuffer();
        if (k > 0) {
            sb.append(str.substring(0, k));
        }
        while (k < n) {
            char c = str.charAt(k);
            if (c == '&') {
                int k1 = k + 1;
                if (k1 < n && str.charAt(k1) == '#') {
                    int k2;
                    int base = 10;
                    if (++k1 < n && (str.charAt(k1) == 'x' || str.charAt(k1) == 'x')) {
                        base = 16;
                    }
                    for (k2 = ++k1; k2 < n && str.charAt(k2) != ';'; ++k2) {
                    }
                    if (k2 <= n && k2 > k1) {
                        String strnum = str.substring(k1, k2);
                        try {
                            int num = Integer.parseInt(strnum, base);
                            sb.append((char)num);
                            k = k2 + 1;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (k >= k2) continue;
                    sb.append(str.substring(k, k2));
                    k = k2;
                    continue;
                }
                sb.append(c);
                ++k;
                continue;
            }
            sb.append(c);
            ++k;
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        try {
            DTDDocument dtd = new DTDDocument();
            dtd.load("c:/B2BProxy2/book.dtd");
            ElementDeclNode decl = (ElementDeclNode)dtd.getElementDecl("Item");
            System.out.println(dtd.toString());
        }
        catch (IOException dtd) {
        }
        catch (DTDException e) {
            System.out.println(e);
        }
    }

    @Override
    public DeclNode getOwner() {
        return null;
    }

    public static void fatal(Exception e, Locator locator) throws DTDException {
        throw new DTDException(null, locator, e);
    }

    public static void fatal(String msgID, Locator locator) throws DTDException {
        DTDDocument.fatal(msgID, locator, new Object[0]);
    }

    public static void fatal(String msgID, Locator locator, String s) throws DTDException {
        DTDDocument.fatal(msgID, locator, new Object[]{s});
    }

    public static void fatal(String msgID, Locator locator, Object[] parameters) throws DTDException {
        String msg = msgCatalog.getMessage(msgID, parameters);
        DTDException e = new DTDException(msg, locator);
        e.msgID = msgID;
        throw e;
    }

    public static void fatal(String msgID, DTDDocument dtd, Object[] parameters) throws DTDException {
        String msg = msgCatalog.getMessage(msgID, parameters);
        DTDException e = new DTDException(msg, dtd.publicId, dtd.systemId, 0, 0);
        e.msgID = msgID;
        throw e;
    }

    @Override
    public String getNodeTypeName() {
        return "DTDDecl";
    }

    static {
        String temp;
        try {
            temp = System.getProperty("line.separator", "\n");
        }
        catch (SecurityException e) {
            temp = "\n";
        }
        eol = temp;
        String lang = System.getProperty("user.msg.lang", null);
        if (lang == null) {
            lang = Locale.getDefault().getLanguage();
        }
        String classbase = "com.argo21.jxp.dtd.DTDMessageCatalog_";
        try {
            msgCatalog = (MessageCatalog)Class.forName(classbase + lang).newInstance();
        }
        catch (Exception e) {
            try {
                msgCatalog = (MessageCatalog)Class.forName(classbase + "en").newInstance();
            }
            catch (Exception e1) {
                System.out.println(e1);
                System.exit(1);
            }
        }
    }
}

