/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.jxp.dtd;

import com.argo21.common.io.XReader;
import com.argo21.common.lang.DataTypeDecl;
import com.argo21.jxp.dtd.AttDef;
import com.argo21.jxp.dtd.Children;
import com.argo21.jxp.dtd.ChildrenNode;
import com.argo21.jxp.dtd.ContentParticle;
import com.argo21.jxp.dtd.ContentParticleImpl;
import com.argo21.jxp.dtd.DTDDecl;
import com.argo21.jxp.dtd.DTDDocument;
import com.argo21.jxp.dtd.DTDException;
import com.argo21.jxp.dtd.DeclNode;
import com.argo21.jxp.dtd.DeclNodeList;
import com.argo21.jxp.dtd.DeclNodeListImpl;
import com.argo21.jxp.dtd.ElementDecl;
import com.argo21.jxp.dtd.EntityDeclNode;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.xml.sax.Locator;

public class ElementDeclNode
implements ElementDecl {
    Hashtable attributeDefs = null;
    Vector childNames = null;
    Children children = null;
    String name;
    int type;
    DTDDecl dtd = null;
    DataTypeDecl dtDecl = null;
    boolean isEntityRef = false;
    DeclNodeListImpl parents = null;
    private XReader in = null;

    public ElementDeclNode(DTDDecl dtd, String declName) {
        this.dtd = dtd;
        this.name = declName;
        this.type = 0;
        this.isEntityRef = false;
    }

    public ElementDeclNode(DTDDecl dtd, String declName, int declType) {
        this.dtd = dtd;
        this.name = declName;
        this.type = declType;
        this.isEntityRef = false;
    }

    public ElementDeclNode(DTDDecl dtd, String declName, Vector childNames) {
        this.dtd = dtd;
        this.name = declName;
        this.type = 2;
        this.childNames = childNames;
        this.isEntityRef = false;
    }

    public ElementDeclNode(DTDDecl dtd, String declName, String entityName) {
        this.dtd = dtd;
        this.name = declName;
        this.type = 0;
        this.isEntityRef = true;
        this.childNames = new Vector();
        this.childNames.addElement(entityName);
    }

    public ElementDeclNode(DTDDecl dtd, String declName, Children children) {
        this.dtd = dtd;
        this.name = declName;
        this.type = 3;
        this.children = children;
        ((ChildrenNode)children).parent = this;
    }

    ElementDeclNode(DTDDecl dtd, String declName, char[] contentspec) throws DTDException {
        this.dtd = dtd;
        this.name = declName;
        this.in = XReader.createReader(contentspec, null);
        if (dtd != null) {
            this.in.setPublicId(dtd.getPublicId());
            this.in.setSystemId(dtd.getSystemId());
            this.in.setEncoding(dtd.getEncoding());
        }
        this.parseDeclContent();
        this.in = null;
    }

    ElementDeclNode(DTDDecl dtd, XReader in) throws DTDException {
        this.dtd = dtd;
        this.in = in;
        this.name = in.peekXmlName();
        if (this.name != null) {
            if (!in.peekWhitespace()) {
                DTDDocument.fatal("NEED_ELEM_NAME", (Locator)in, this.name);
            }
            this.parseDeclContent();
        } else {
            DTDDocument.fatal("NEED_ELEM_NAME", (Locator)in, this.name);
        }
        this.in = null;
    }

    @Override
    public int getNodeType() {
        return 20;
    }

    @Override
    public DeclNode getParentDecl() {
        if (this.parents == null) {
            return null;
        }
        if (this.parents.size() <= 0) {
            return null;
        }
        return this.parents.elementAt(0);
    }

    public DeclNodeList getParentDecls() {
        if (this.parents == null) {
            return new DeclNodeListImpl(0);
        }
        return this.parents;
    }

    void addParentDecl(ElementDecl node) {
        if (this.parents == null) {
            this.parents = new DeclNodeListImpl(1);
        }
        this.parents.addElement(node);
    }

    @Override
    public boolean isEntityRef() {
        return this.isEntityRef;
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public String getNodeTypeName() {
        return "Element";
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getNodeName() {
        return this.name;
    }

    @Override
    public Children getChildren() {
        return this.children;
    }

    @Override
    public DeclNodeList getAttListDecls() {
        DeclNodeListImpl list;
        Hashtable atts = this.getAttDefs();
        if (atts != null) {
            list = new DeclNodeListImpl(atts.size());
            Enumeration enumattr = atts.elements();
            while (enumattr.hasMoreElements()) {
                list.addElement((DeclNode)enumattr.nextElement());
            }
        } else {
            list = new DeclNodeListImpl(0);
        }
        return list;
    }

    @Override
    public AttDef getAttListDecl(String attribute) {
        Hashtable atts = this.getAttDefs();
        if (atts == null) {
            return null;
        }
        return (AttDef)atts.get(attribute);
    }

    @Override
    public boolean hasSubElementDecls() {
        if (this.type == 2) {
            return this.childNames != null;
        }
        return this.type == 3;
    }

    @Override
    public boolean hasAttListDecl() {
        Hashtable atts = this.getAttDefs();
        if (atts != null) {
            return false;
        }
        return !atts.isEmpty();
    }

    @Override
    public DeclNodeList getSubElementDecls() {
        Vector nv = this.getChildNames();
        if (nv == null) {
            return new DeclNodeListImpl(0);
        }
        int n = nv.size();
        DeclNodeListImpl list = new DeclNodeListImpl(n);
        for (int i = 0; i < n; ++i) {
            ElementDecl sub;
            String s = (String)nv.elementAt(i);
            if (s.equalsIgnoreCase("#PCDATA") || (sub = this.dtd.getElementDecl(s)) == null) continue;
            list.addElement(sub);
        }
        return list;
    }

    public ContentParticle getContentParticle(String name2) {
        if (this.type == 2) {
            if (this.childNames == null) {
                return null;
            }
            if (this.childNames.contains(name2)) {
                return new ContentParticleImpl('*', name2);
            }
            return null;
        }
        if (this.type == 3 && this.children != null) {
            return ((ChildrenNode)this.children).getContentParticle(name2);
        }
        return null;
    }

    @Override
    public DeclNode getSubElementDecl(String name2) {
        if (this.dtd == null || this.isEntityRef) {
            return null;
        }
        if (this.type == 2) {
            if (this.childNames == null) {
                return null;
            }
            if (this.childNames.contains(name2)) {
                return this.dtd.getElementDecl(name2);
            }
        } else if (this.type == 3 && this.children != null && ((ChildrenNode)this.children).getContentParticle(name2) != null) {
            return this.dtd.getElementDecl(name2);
        }
        return null;
    }

    @Override
    public Vector getChildNames() {
        if (this.isEntityRef) {
            return new Vector();
        }
        if (this.type == 2) {
            return this.childNames == null ? new Vector() : this.childNames;
        }
        if (this.type == 3) {
            Vector v = new Vector();
            ((ChildrenNode)this.children).getSubTags(v);
            return v;
        }
        return new Vector();
    }

    public Hashtable getAttDefs() {
        return this.attributeDefs;
    }

    void addAttDefs(Vector attdefs) {
        int n = attdefs.size();
        for (int i = 0; i < n; ++i) {
            this.addAttDef((AttDef)attdefs.elementAt(i));
        }
    }

    @Override
    public void addAttDef(AttDef attdef) {
        if (this.attributeDefs == null) {
            this.attributeDefs = new Hashtable(5);
        }
        this.attributeDefs.put(attdef.getAttributeName(), attdef);
    }

    void removeAttDef(AttDef attdef) {
        if (this.attributeDefs == null) {
            return;
        }
        this.attributeDefs.remove(attdef.getAttributeName());
    }

    @Override
    public DataTypeDecl getDataTypeDecl() {
        return this.dtDecl;
    }

    public void setDataTypeDecl(DataTypeDecl dtDecl) {
        this.dtDecl = dtDecl;
    }

    private boolean parseDeclContent() throws DTDException {
        this.in.peekWhitespace();
        if (this.in.peekc('%')) {
            this.type = 0;
            this.isEntityRef = true;
            String entityName = this.in.peekXmlName();
            if (entityName == null) {
                DTDDocument.fatal("NEED_ENTITY_REF", (Locator)this.in, "%");
            }
            if (!this.in.peekc(';')) {
                DTDDocument.fatal("INVALID_ENTITY_REF", (Locator)this.in, new Object[]{entityName, ";"});
            }
            this.childNames = new Vector();
            this.childNames.addElement(entityName);
        } else if (this.in.peek("EMPTY")) {
            this.type = 0;
        } else if (this.in.peek("ANY")) {
            this.type = 1;
        } else if (this.parseElementMixed()) {
            this.type = 2;
        } else {
            this.type = 3;
            new ChildrenNode((DeclNode)this, this.in);
        }
        this.in.peekWhitespace();
        return true;
    }

    private boolean parseElementMixed() throws DTDException {
        this.in.backup();
        if (!this.in.peekc('(')) {
            DTDDocument.fatal("NEED_CHAR", (Locator)this.in, "(");
        }
        this.in.peekWhitespace();
        if (!this.in.peek("#PCDATA")) {
            this.in.restore();
            return false;
        }
        this.in.peekWhitespace();
        if (this.in.peek(")")) {
            if (this.in.peek("*")) {
                // empty if block
            }
            this.childNames = null;
        } else {
            if (this.in.isEOF() || this.in.isChar('>')) {
                DTDDocument.fatal("NEED_CHAR", (Locator)this.in, ")");
            }
            this.childNames = new Vector();
            while (this.in.peek("|")) {
                this.in.peekWhitespace();
                if (this.in.peekc('%')) {
                    String entity = this.in.peekXmlName();
                    if (entity == null) {
                        DTDDocument.fatal("NEED_ENTITY_REF", (Locator)this.in, "%");
                    }
                    if (!this.in.peekc(';')) {
                        DTDDocument.fatal("INVALID_ENTITY_REF", (Locator)this.in, new Object[]{entity, ";"});
                    }
                    this.childNames.addElement("%" + entity + ";");
                } else {
                    String subtag = this.in.peekXmlName();
                    if (subtag == null) {
                        DTDDocument.fatal("INVALID_CHAR", (Locator)this.in, "|");
                    }
                    if (this.childNames.contains(subtag)) {
                        DTDDocument.fatal("DOUBLE_NAME", (Locator)this.in, subtag);
                    } else {
                        this.childNames.addElement(subtag);
                    }
                }
                this.in.peekWhitespace();
            }
            if (!this.in.peek(")*")) {
                DTDDocument.fatal("NEED_CHAR", (Locator)this.in, ")*");
            }
        }
        return true;
    }

    public String getXML() {
        StringBuffer sb = new StringBuffer();
        sb.append("<!ELEMENT ");
        sb.append(this.name);
        sb.append(' ');
        this.makeDeclContent(sb);
        sb.append('>');
        String s = sb.toString();
        return s;
    }

    @Override
    public String getEntityName() {
        if (!this.isEntityRef) {
            return null;
        }
        if (this.childNames == null) {
            return null;
        }
        if (this.childNames.size() < 1) {
            return null;
        }
        return this.childNames.elementAt(0).toString();
    }

    public String toString() {
        return this.getXML();
    }

    private void makeDeclContent(StringBuffer sb) {
        if (this.isEntityRef) {
            if (this.childNames == null) {
                return;
            }
            if (this.childNames.size() < 1) {
                return;
            }
            String s = (String)this.childNames.elementAt(0);
            if (s != null) {
                if ((s = s.trim()).equals("")) {
                    return;
                }
                sb.append('%');
                sb.append(s);
                sb.append(';');
            }
            return;
        }
        switch (this.type) {
            case 1: {
                sb.append("ANY");
                break;
            }
            case 0: {
                sb.append("EMPTY");
                break;
            }
            case 2: {
                sb.append("(#PCDATA");
                if (this.childNames == null) {
                    sb.append(")");
                    break;
                }
                int n = this.childNames.size();
                for (int i = 0; i < n; ++i) {
                    sb.append(" | ");
                    sb.append(this.childNames.elementAt(i));
                }
                sb.append(')');
                if (n == 0) break;
                sb.append('*');
                break;
            }
            case 3: {
                if (this.children == null) {
                    sb.append("(EMPTY)");
                    break;
                }
                ((ChildrenNode)this.children).makeChildren(sb);
            }
        }
    }

    @Override
    public void repleaceEntity() throws DTDException {
        if (this.dtd == null) {
            return;
        }
        if (this.isEntityRef) {
            if (this.childNames != null) {
                String entityName = (String)this.childNames.elementAt(0);
                if (entityName == null) {
                    return;
                }
                EntityDeclNode decl = (EntityDeclNode)this.dtd.getEntityDecl(entityName);
                if (decl == null) {
                    return;
                }
                String s = decl.getEntityValue();
                if (s != null) {
                    if (s.equals("ANY")) {
                        this.type = 1;
                    } else if (s.equals("EMPTY")) {
                        this.type = 0;
                    } else {
                        if (!s.startsWith("(")) {
                            s = "(" + s + ")";
                        }
                        this.in = XReader.createReader(s.toCharArray(), null);
                        this.in.setPublicId(this.dtd.getPublicId());
                        this.in.setSystemId(this.dtd.getSystemId());
                        this.in.setEncoding(this.dtd.getEncoding());
                        this.parseDeclContent();
                        this.in = null;
                    }
                }
            }
            this.isEntityRef = false;
        } else if (this.type == 2) {
            if (this.childNames == null) {
                return;
            }
            int n = this.childNames.size();
            int i = 0;
            while (i < n) {
                String s = (String)this.childNames.elementAt(i);
                if (s.startsWith("%") && s.endsWith(";")) {
                    String entity = s.substring(1, s.length() - 1);
                    EntityDeclNode decl = (EntityDeclNode)this.dtd.getEntityDecl(entity);
                    if (decl == null || (s = decl.getEntityValue()) == null) continue;
                    StringTokenizer st = new StringTokenizer(s, "|");
                    while (st.hasMoreElements()) {
                        this.childNames.insertElementAt(st.nextElement(), i);
                        ++i;
                    }
                    this.childNames.removeElementAt(i);
                    continue;
                }
                ++i;
            }
        } else if (this.type == 3) {
            Vector v;
            this.repleaceEntity((ChildrenNode)this.children);
            if (this.children != null && (v = this.children.getCPList()).size() == 1) {
                ContentParticleImpl cp = (ContentParticleImpl)v.elementAt(0);
                if (cp.children != null) {
                    this.children = cp.children;
                }
            }
        }
    }

    private void repleaceEntity(ChildrenNode child) throws DTDException {
        int k1;
        StringBuffer sb = new StringBuffer();
        if (child == null) {
            sb.append("(EMPTY)");
        } else {
            child.makeChildren(sb);
        }
        String s = sb.toString();
        boolean hasEntity = false;
        int k = 0;
        while ((k = s.indexOf(37, k)) >= 0 && (k1 = s.indexOf(59, k)) > 0) {
            String s1;
            String name2 = s.substring(k + 1, k1);
            EntityDeclNode decl = (EntityDeclNode)this.dtd.getEntityDecl(name2);
            String string2 = s1 = decl == null ? null : decl.getEntityValue();
            if (s1 != null) {
                hasEntity = true;
                s = s.substring(0, k) + "(" + s1 + ")" + s.substring(k1 + 1);
                continue;
            }
            k = k1;
        }
        if (!hasEntity) {
            return;
        }
        try {
            ElementDeclNode node = new ElementDeclNode(this.dtd, this.name, s.toCharArray());
            this.type = node.type;
            this.childNames = node.childNames;
            this.children = node.children;
            if (this.children != null) {
                ((ChildrenNode)this.children).parent = this;
            }
        }
        catch (DTDException dTDException) {
            // empty catch block
        }
    }

    private void repleaceEntity1(ChildrenNode child) throws DTDException {
        Vector v = child.getCPList();
        int n = v.size();
        for (int i = 0; i < n; ++i) {
            ContentParticleImpl cp = (ContentParticleImpl)v.elementAt(i);
            if (cp.isEntityRef()) {
                cp.repleaceEntity(this.dtd);
                continue;
            }
            ChildrenNode child1 = (ChildrenNode)cp.getChildren();
            if (child1 == null) continue;
            this.repleaceEntity(child1);
        }
    }

    @Override
    public DeclNode getOwner() {
        return this.dtd;
    }

    public static void main(String[] args) {
        try {
            ElementDeclNode e = new ElementDeclNode(null, "AAA", "(CCC,(RRR|DDD)*)*");
            System.out.println(e.toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

