/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.jxp.dtd;

import com.argo21.common.io.Debug;
import com.argo21.common.io.XReader;
import com.argo21.common.lang.DataTypeDecl;
import com.argo21.jxp.dtd.DTDDecl;
import com.argo21.jxp.dtd.DTDDocument;
import com.argo21.jxp.dtd.DTDException;
import com.argo21.jxp.dtd.DeclNode;
import com.argo21.jxp.dtd.EntityDecl;
import org.xml.sax.Locator;

public class EntityDeclNode
implements EntityDecl {
    String entityName = null;
    String entityValue = null;
    String publicId = null;
    String systemId = null;
    String notationName = null;
    int type = 0;
    boolean pedecl = false;
    public static final int ENTITYVALUE = 0;
    public static final int SYSTEM = 1;
    public static final int PUBLIC = 2;
    private XReader in = null;
    DTDDecl dtd = null;
    private DTDDecl externalDTD = null;

    private EntityDeclNode() {
    }

    EntityDeclNode(DTDDecl dtd, String entityName, String entityDef) throws DTDException {
        this(dtd, entityName, entityDef, false);
    }

    EntityDeclNode(DTDDecl dtd, String entityName, String entityDef, boolean peDecl) throws DTDException {
        this.dtd = dtd;
        this.entityName = entityName;
        this.pedecl = peDecl;
        this.in = XReader.createReader(entityDef.toCharArray(), null);
        this.parseEntityDecl();
        this.in = null;
    }

    EntityDeclNode(DTDDecl dtd, XReader in) throws DTDException {
        this.dtd = dtd;
        this.in = in;
        this.pedecl = in.peekc('%');
        if (this.pedecl && !in.peekWhitespace()) {
            DTDDocument.fatal("NEED_ENTITY_REF", (Locator)in, "%");
        }
        this.entityName = in.peekXmlName();
        if (this.entityName != null) {
            if (!in.peekWhitespace()) {
                DTDDocument.fatal("NEED_ENTITY_NAME", (Locator)in);
            }
            this.parseEntityDecl();
        } else {
            DTDDocument.fatal("NEED_ENTITY_NAME", (Locator)in);
        }
        this.in = null;
    }

    public EntityDeclNode(DTDDecl dtd, String entityName, boolean pedecl, String entityValue) {
        this.dtd = dtd;
        this.entityName = entityName;
        this.type = 0;
        this.pedecl = pedecl;
        this.entityValue = entityValue;
    }

    public EntityDeclNode(DTDDecl dtd, String entityName, boolean pedecl, String publicId, String systemId, String notationName) {
        this.dtd = dtd;
        this.entityName = entityName;
        this.type = publicId == null ? 1 : 2;
        this.publicId = publicId;
        this.pedecl = pedecl;
        this.systemId = systemId;
        this.notationName = notationName;
    }

    @Override
    public String getNodeName() {
        return this.entityName;
    }

    @Override
    public String getPublicId() {
        return this.publicId;
    }

    @Override
    public String getSystemId() {
        return this.systemId;
    }

    @Override
    public String getNotationName() {
        return this.notationName;
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public boolean getPeDecl() {
        return this.pedecl;
    }

    @Override
    public String getEntityValue() {
        return this.entityValue;
    }

    @Override
    public void repleaceEntity() throws DTDException {
        if (this.type == 0 && this.dtd != null && this.entityValue != null) {
            int pos1 = this.entityValue.indexOf("%");
            if (pos1 < 0) {
                return;
            }
            StringBuffer sb = new StringBuffer();
            int pos = 0;
            while (pos1 >= 0) {
                sb.append(this.entityValue.substring(pos, pos1));
                pos = pos1 + 1;
                pos1 = this.entityValue.indexOf(";", pos);
                if (pos1 > pos) {
                    String entity = this.entityValue.substring(pos, pos1);
                    EntityDecl decl = this.dtd.getEntityDecl(entity);
                    if (decl != null) {
                        sb.append(decl.getEntityValue());
                    } else {
                        sb.append("%");
                        sb.append(entity);
                        sb.append(";");
                    }
                } else {
                    sb.append(this.entityValue.substring(pos));
                    break;
                }
                pos = pos1 + 1;
                pos1 = this.entityValue.indexOf("%", pos);
            }
            sb.append(this.entityValue.substring(pos));
            this.entityValue = sb.toString();
        }
    }

    private boolean parseEntityDecl() throws DTDException {
        this.in.peekWhitespace();
        if (this.pedecl) {
            if (this.entityName == null) {
                return false;
            }
            if (this.parseExternalID()) {
                return true;
            }
            return this.parseEntityvalue();
        }
        if (this.parseExternalID()) {
            if (!this.in.peekWhitespace()) {
                return true;
            }
            if (this.in.peek("NDATA")) {
                if (!this.in.peekWhitespace()) {
                    DTDDocument.fatal("NEED_NOTATION_NAME", (Locator)this.in);
                }
                this.notationName = this.in.peekXmlName();
                if (this.notationName == null) {
                    DTDDocument.fatal("NEED_NOTATION_NAME", (Locator)this.in);
                }
            } else {
                this.notationName = null;
            }
            return true;
        }
        return this.parseEntityvalue();
    }

    private boolean parseEntityvalue() throws DTDException {
        this.type = 0;
        this.entityValue = this.in.peekQuotedString();
        if (this.entityValue == null) {
            DTDDocument.fatal("INVALID_ENTITY_V", (Locator)this.in, this.entityName);
        }
        return true;
    }

    private boolean parseExternalID() throws DTDException {
        if (this.in.peek("SYSTEM")) {
            this.type = 1;
            if (!this.in.peekWhitespace()) {
                DTDDocument.fatal("NEED_SYSTEMID", (Locator)this.in);
            }
            return this.parseSystemLiteral();
        }
        if (this.in.peek("PUBLIC")) {
            this.type = 2;
            if (!this.in.peekWhitespace()) {
                DTDDocument.fatal("NEED_PUBLICID", (Locator)this.in);
            }
            if (!this.parsePubidLiteral()) {
                DTDDocument.fatal("NEED_PUBLICID", (Locator)this.in);
            }
            if (!this.in.peekWhitespace()) {
                DTDDocument.fatal("NEED_SYSTEMID", (Locator)this.in);
            }
            return this.parseSystemLiteral();
        }
        return false;
    }

    private boolean parseSystemLiteral() throws DTDException {
        this.systemId = this.in.peekQuotedString();
        return this.systemId != null;
    }

    private boolean parsePubidLiteral() throws DTDException {
        this.publicId = this.in.peekQuotedString();
        return this.publicId != null;
    }

    @Override
    public EntityDecl cloneNode(boolean deep) {
        EntityDeclNode edecl = new EntityDeclNode();
        edecl.entityName = this.entityName;
        edecl.entityValue = this.entityValue;
        edecl.publicId = this.publicId;
        edecl.systemId = this.systemId;
        edecl.notationName = this.notationName;
        return edecl;
    }

    @Override
    public DeclNode getParentDecl() {
        return null;
    }

    @Override
    public int getNodeType() {
        return 6;
    }

    @Override
    public String getNodeTypeName() {
        return "Entity";
    }

    @Override
    public DataTypeDecl getDataTypeDecl() {
        return null;
    }

    public String getXML() {
        if (this.pedecl) {
            return "<!ENTITY % " + this.entityName + " " + this.getContents() + ">";
        }
        return "<!ENTITY " + this.entityName + " " + this.getContents() + ">";
    }

    public String toString() {
        return this.getXML();
    }

    private String getContents() {
        String s;
        if (this.type == 0) {
            if (this.entityValue == null) {
                return "\"null\"";
            }
            String quote = this.entityValue.indexOf("\"") >= 0 ? "'" : "\"";
            return quote + this.entityValue + quote;
        }
        if (this.type == 1) {
            if (this.systemId == null) {
                String s2 = "SYSTEM \"null\"";
                return "SYSTEM \"null\"";
            }
            String quote = this.systemId.indexOf("\"") >= 0 ? "'" : "\"";
            s = "SYSTEM " + quote + this.systemId + quote;
        } else {
            String quote;
            if (this.publicId == null) {
                s = "PUBLIC \"null\"";
            } else {
                quote = this.publicId.indexOf("\"") >= 0 ? "'" : "\"";
                s = "PUBLIC " + quote + this.publicId + quote;
            }
            if (this.systemId == null) {
                s = s + " \"null\"";
            } else {
                quote = this.systemId.indexOf("\"") >= 0 ? "'" : "\"";
                s = s + " " + quote + this.systemId + quote;
            }
        }
        if (!this.pedecl && this.notationName != null) {
            s = s + " NDATA " + this.notationName;
        }
        return s;
    }

    @Override
    public DTDDecl getExternalDTD() {
        return this.externalDTD;
    }

    void loadExternalDTD() {
        this.externalDTD = null;
        String urlid = this.systemId;
        if (urlid == null || this.dtd == null) {
            return;
        }
        if (urlid.charAt(0) != '/' && urlid.charAt(0) != '\\' && urlid.indexOf(":/") < 0 && urlid.indexOf(":\\") < 0) {
            String path = this.dtd.getURL();
            if (path == null) {
                return;
            }
            int k = path.lastIndexOf("/");
            if (k < 0) {
                k = path.lastIndexOf("\\");
            }
            if (k > 0) {
                urlid = path.substring(0, k + 1) + urlid;
            }
        }
        DTDDocument externalDTD = new DTDDocument();
        try {
            externalDTD.load(urlid);
        }
        catch (Exception e) {
            Debug.println(e);
        }
        externalDTD.resolveParameterRefrance();
    }

    @Override
    public DeclNode getOwner() {
        return this.dtd;
    }

    public static void main(String[] argv) {
        try {
            EntityDeclNode el = new EntityDeclNode(null, "AAA", "PUBLIC \"SDF\"  \"http://woodland.co.jp/a.xml\"");
            System.out.println(el.getXML());
        }
        catch (DTDException e) {
            System.out.println(e.getMessage());
        }
    }
}

