/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.jxp.dtd;

import com.argo21.common.io.XReader;
import com.argo21.common.lang.DataTypeDecl;
import com.argo21.jxp.dtd.DTDDecl;
import com.argo21.jxp.dtd.DTDDocument;
import com.argo21.jxp.dtd.DTDException;
import com.argo21.jxp.dtd.DeclNode;
import com.argo21.jxp.dtd.NotationDecl;
import org.xml.sax.Locator;

public class NotationDeclNode
implements NotationDecl {
    String notationName;
    String publicId;
    String systemId;
    DTDDecl dtd = null;
    int type = 0;
    public static final int SYSTEM = 1;
    public static final int PUBLIC = 2;
    private XReader in;

    private NotationDeclNode() {
    }

    NotationDeclNode(DTDDecl dtd, String notationName, String notationContents) throws DTDException {
        this.dtd = dtd;
        this.notationName = notationName;
        this.in = XReader.createReader(notationContents.toCharArray(), null);
        this.parseNotationDecl();
        this.in = null;
    }

    NotationDeclNode(DTDDecl dtd, XReader in) throws DTDException {
        this.dtd = dtd;
        this.in = in;
        this.notationName = in.peekXmlName();
        if (this.notationName != null) {
            if (!in.peekWhitespace()) {
                DTDDocument.fatal("NEED_NOTATION_NAME", (Locator)in);
            }
            this.parseNotationDecl();
        } else {
            DTDDocument.fatal("NEED_NOTATION_NAME", (Locator)in);
        }
        this.in = null;
    }

    public NotationDeclNode(DTDDecl dtd, String notationName, String publicId, String systemId) {
        this.dtd = dtd;
        this.notationName = notationName;
        this.publicId = publicId;
        this.systemId = systemId;
        this.type = this.publicId == null ? 1 : (this.publicId.equals("") ? 1 : 2);
    }

    private boolean parseNotationDecl() throws DTDException {
        this.in.peekWhitespace();
        if (this.in.peek("SYSTEM")) {
            this.type = 1;
            if (!this.in.peekWhitespace()) {
                DTDDocument.fatal("NEED_SYSTEMID", (Locator)this.in);
            }
            return this.parseSystemLiteral();
        }
        if (this.in.peek("PUBLIC")) {
            this.type = 2;
            if (!this.in.peekWhitespace()) {
                DTDDocument.fatal("NEED_PUBLICID", (Locator)this.in);
            }
            if (!this.parsePubidLiteral()) {
                DTDDocument.fatal("NEED_PUBLICID", (Locator)this.in);
            }
            if (this.in.peekWhitespace()) {
                this.parseSystemLiteral();
            }
            return true;
        }
        return false;
    }

    private boolean parseSystemLiteral() throws DTDException {
        this.systemId = this.in.peekQuotedString();
        if (this.systemId == null) {
            DTDDocument.fatal("NEED_SYSTEMID", (Locator)this.in);
        }
        return this.systemId != null;
    }

    private boolean parsePubidLiteral() throws DTDException {
        this.publicId = this.in.peekQuotedString();
        if (this.publicId == null) {
            DTDDocument.fatal("NEED_SYSTEMID", (Locator)this.in);
        }
        return this.publicId != null;
    }

    @Override
    public NotationDecl cloneNode(boolean deep) {
        NotationDeclNode edecl = new NotationDeclNode();
        edecl.notationName = this.notationName;
        edecl.publicId = this.publicId;
        edecl.systemId = this.systemId;
        return edecl;
    }

    @Override
    public DataTypeDecl getDataTypeDecl() {
        return null;
    }

    @Override
    public String getNodeTypeName() {
        return "Notation";
    }

    @Override
    public String getNodeName() {
        return this.notationName;
    }

    @Override
    public String getPublicId() {
        return this.publicId;
    }

    @Override
    public String getSystemId() {
        return this.systemId;
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public int getNodeType() {
        return 12;
    }

    @Override
    public DeclNode getParentDecl() {
        return null;
    }

    public String getXML() {
        return "<!NOTATION " + this.notationName + " " + this.getContents() + ">";
    }

    public String toString() {
        return this.getXML();
    }

    private String getContents() {
        if (this.type == 1) {
            return "SYSTEM \"" + this.systemId + "\"";
        }
        if (this.type == 2) {
            String s = "PUBLIC \"" + this.publicId + "\"";
            if (this.systemId != null) {
                return s + " \"" + this.systemId + "\"";
            }
            return s;
        }
        return null;
    }

    @Override
    public DeclNode getOwner() {
        return this.dtd;
    }

    public static void main(String[] argv) {
        try {
            NotationDeclNode el = new NotationDeclNode(null, "AAA", "PUBLIC \"SDF\"  \"http://woodland.co.jp/a.xml\"");
            System.out.println(el.getXML());
        }
        catch (DTDException e) {
            System.out.println(e.getMessage());
        }
    }
}

