/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.jxp.dtd;

import com.argo21.common.io.XReader;
import com.argo21.common.lang.DataTypeDecl;
import com.argo21.jxp.dtd.DTDDecl;
import com.argo21.jxp.dtd.DTDDocument;
import com.argo21.jxp.dtd.DTDException;
import com.argo21.jxp.dtd.DeclNode;
import com.argo21.jxp.dtd.DeclNodeList;
import com.argo21.jxp.dtd.EntityDecl;
import com.argo21.jxp.dtd.EntityDeclNode;
import com.argo21.jxp.dtd.PERefDecl;
import org.xml.sax.Locator;

public class PERefDeclNode
implements PERefDecl {
    String entityName = null;
    private XReader in = null;
    DTDDecl dtd = null;

    private PERefDeclNode() {
    }

    PERefDeclNode(DTDDecl dtd, XReader in) throws DTDException {
        this.dtd = dtd;
        this.in = in;
        this.entityName = in.peekXmlName();
        if (this.entityName == null) {
            DTDDocument.fatal("NEED_ENTITY_REF", (Locator)in, "%");
        }
        if (!in.peekc(';')) {
            DTDDocument.fatal("INVALID_ENTITY_REF", (Locator)in, new Object[]{this.entityName, ";"});
        }
        this.in = null;
    }

    public PERefDeclNode(DTDDecl dtd, String entityName) {
        this.dtd = dtd;
        this.entityName = entityName;
    }

    @Override
    public String getNodeName() {
        return this.entityName;
    }

    @Override
    public String getNodeTypeName() {
        return "PERef";
    }

    @Override
    public EntityDecl getEntityDecl() {
        if (this.dtd == null) {
            return null;
        }
        EntityDecl et = this.dtd.getEntityDecl(this.entityName);
        if (et != null) {
            return et;
        }
        DeclNodeList nodes = this.dtd.getAllDeclNode();
        int n = nodes.getLength();
        for (int i = 0; i < n; ++i) {
            DeclNode node = nodes.item(i);
            if (node.getNodeType() != 6 || !this.entityName.equals(node.getNodeName()) || !((EntityDecl)node).getPeDecl()) continue;
            return (EntityDeclNode)node;
        }
        return null;
    }

    @Override
    public PERefDecl cloneNode(boolean deep) {
        return new PERefDeclNode(null, this.entityName);
    }

    @Override
    public DeclNode getParentDecl() {
        return null;
    }

    @Override
    public int getNodeType() {
        return 28;
    }

    @Override
    public DataTypeDecl getDataTypeDecl() {
        return null;
    }

    public String getXML() {
        return "%" + this.entityName + ";";
    }

    public String toString() {
        return this.getXML();
    }

    @Override
    public DeclNode getOwner() {
        return this.dtd;
    }
}

