/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.jxp.dtd;

import com.argo21.common.io.Debug;
import com.argo21.common.lang.XmlNames;
import com.argo21.jxp.dtd.AttDef;
import com.argo21.jxp.dtd.AttType;
import com.argo21.jxp.dtd.Children;
import com.argo21.jxp.dtd.ContentParticle;
import com.argo21.jxp.dtd.DTDDecl;
import com.argo21.jxp.dtd.DTDDocument;
import com.argo21.jxp.dtd.ElementDecl;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XmlValidation {
    private final ElementValidator ANY = new ElementValidator();
    private final ElementValidator EMPTY = new EmptyValidator();
    private Hashtable ids;
    private Hashtable validators = new Hashtable();
    ErrorHandler errorHandler = null;
    DTDDecl dtd;
    Document doc;

    public XmlValidation(DTDDecl dtd, Document doc) {
        this(dtd, doc, null);
    }

    public XmlValidation(DTDDecl dtd, Document doc, ErrorHandler errorHandler) {
        this.dtd = dtd;
        this.doc = doc;
        this.ids = new Hashtable();
        this.errorHandler = errorHandler == null ? new DefaultErrorHandler() : errorHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        if (errorHandler != null) {
            this.errorHandler = errorHandler;
        } else {
            errorHandler = new DefaultErrorHandler();
        }
    }

    public void parse() throws SAXException {
        Element root = this.doc.getDocumentElement();
        if (root == null) {
            return;
        }
        String name2 = root.getNodeName();
        if (this.dtd.getElementDecl(name2) == null) {
            this.error("UNDEF_ELEMENT", new Object[]{name2});
            return;
        }
        this.parseElement(root, null);
    }

    private void parseElement(Element element, ElementValidator validator) throws SAXException {
        ElementDecl elemdecl;
        String name2 = element.getNodeName();
        if (validator != null) {
            validator.consume(name2);
        }
        if ((elemdecl = this.dtd.getElementDecl(name2)) == null) {
            this.error("UNDEF_ELEMENT", new Object[]{name2});
            return;
        }
        NamedNodeMap nnm = element.getAttributes();
        int n = nnm.getLength();
        for (int i = 0; i < n; ++i) {
            Node attr = nnm.item(i);
            String attrname = attr.getNodeName();
            AttDef attdecl = elemdecl.getAttListDecl(attrname);
            if (attdecl == null) {
                this.error("UNDEF_ATTR", new Object[]{name2, attrname});
                continue;
            }
            this.validateAttributeSyntax(attdecl, attr.getNodeValue());
        }
        validator = this.newValidator(elemdecl);
        Node child = element.getFirstChild();
        while (child != null) {
            short type = child.getNodeType();
            if (type == 1) {
                this.parseElement((Element)child, validator);
            } else if (type == 3) {
                String value;
                if (elemdecl.getType() != 2 && ((value = child.getNodeValue()) == null || value.trim().length() == 0)) {
                    Node ch = child;
                    child = child.getNextSibling();
                    element.removeChild(ch);
                    continue;
                }
                validator.text(name2);
            } else if (type == 4) {
                validator.text(name2);
            }
            child = child.getNextSibling();
        }
        validator.done();
    }

    void validateAttributeSyntax(AttDef attr, String value) throws SAXException {
        AttType attType = attr.getAttType();
        String name2 = attr.getNodeName();
        int type = attType.getDataType();
        if (1 == type) {
            Boolean b;
            if (!XmlNames.isName(value)) {
                this.error("INVALID_ATTID", new Object[]{attr.getElementName() + "/@" + name2, value});
            }
            if ((b = (Boolean)this.ids.get(value)) == null || b.equals(Boolean.FALSE)) {
                this.ids.put(value, Boolean.TRUE);
            } else {
                this.error("DOUBLE_ATTID", new Object[]{attr.getElementName() + "/@" + name2, value});
            }
        } else if (2 == type) {
            Boolean b;
            if (!XmlNames.isName(value)) {
                this.error("INVALID_ATTIDREF", new Object[]{attr.getElementName() + "/@" + name2, value});
            }
            if ((b = (Boolean)this.ids.get(value)) == null) {
                this.ids.put(value, Boolean.FALSE);
            }
        } else if (3 == type) {
            StringTokenizer tokenizer = new StringTokenizer(value);
            boolean sawValue = false;
            while (tokenizer.hasMoreTokens()) {
                Boolean b;
                value = tokenizer.nextToken();
                if (!XmlNames.isName(value)) {
                    this.error("INVALID_ATTIDREF", new Object[]{attr.getElementName() + "/@" + name2, value});
                }
                if ((b = (Boolean)this.ids.get(value)) == null) {
                    this.ids.put(value, Boolean.FALSE);
                }
                sawValue = true;
            }
            if (!sawValue) {
                this.error("INVALID_ATTIDREF", new Object[]{attr.getElementName() + "/@" + name2, value});
            }
        } else if (6 == type) {
            if (!XmlNames.isNmtoken(value)) {
                this.error("INVALID_ATTRBUTE", new Object[]{attr.getElementName() + "/@" + name2, value});
            }
        } else if (7 == type) {
            StringTokenizer tokenizer = new StringTokenizer(value);
            boolean sawValue = false;
            while (tokenizer.hasMoreTokens()) {
                value = tokenizer.nextToken();
                if (!XmlNames.isNmtoken(value)) {
                    this.error("INVALID_ATTRBUTE", new Object[]{attr.getElementName() + "/@" + name2, value});
                }
                sawValue = true;
            }
            if (!sawValue) {
                this.error("INVALID_ATTRBUTE", new Object[]{attr.getElementName() + "/@" + name2, value});
            }
        } else if (8 == type) {
            Vector v = attType.getNames();
            if (!v.contains(value)) {
                this.error("INVALID_ATTRBUTE", new Object[]{attr.getElementName() + "/@" + name2, value});
            }
        } else if (9 == type) {
            Vector v = attType.getNames();
            if (!v.contains(value)) {
                this.error("INVALID_ATTRBUTE", new Object[]{attr.getElementName() + "/@" + name2, value});
            }
        } else if (4 == type) {
            if (this.dtd.getEntityDecl(value) != null) {
                this.error("INVALID_ATTRBUTE", new Object[]{attr.getElementName() + "/@" + name2, value});
            }
        } else if (5 == type) {
            StringTokenizer tokenizer = new StringTokenizer(value);
            boolean sawValue = false;
            while (tokenizer.hasMoreTokens()) {
                value = tokenizer.nextToken();
                if (this.dtd.getEntityDecl(value) != null) {
                    this.error("INVALID_ATTRBUTE", new Object[]{attr.getElementName() + "/@" + name2, value});
                }
                sawValue = true;
            }
            if (!sawValue) {
                this.error("INVALID_ATTRBUTE", new Object[]{attr.getElementName() + "/@" + name2, value});
            }
        } else if (0 != type) {
            this.error("INVALID_ATTRBUTE", new Object[]{attr.getElementName() + "/@" + name2, value});
        }
    }

    private ElementValidator newValidator(ElementDecl element) {
        ElementValidator validator = (ElementValidator)this.validators.get(element);
        if (validator != null) {
            return validator;
        }
        int type = element.getType();
        if (type == 3) {
            return new ChildrenValidator(element);
        }
        if (type == 1) {
            validator = this.ANY;
            this.validators.put(element, validator);
        } else if (type == 0) {
            validator = this.EMPTY;
            this.validators.put(element, validator);
        } else {
            validator = new MixedValidator(element);
            this.validators.put(element, validator);
        }
        return validator;
    }

    public void error(String messageId, Object[] parameters) throws SAXException {
        String s = DTDDocument.msgCatalog.getMessage(messageId, parameters);
        SAXParseException x = new SAXParseException(s, null);
        this.errorHandler.warning(x);
    }

    int getOccurrence(Children c, String tagname) {
        int occurrence = c.getOccurrence();
        Vector s1 = c.getCPList();
        for (int i = 0; i < s1.size(); ++i) {
            ContentParticle cp = (ContentParticle)s1.elementAt(i);
            Children c1 = cp.getChildren();
            if (c1 == null) {
                if (!tagname.equals(cp.getName())) continue;
                char tagoccurrence = cp.getOccurrence();
                if (tagoccurrence == '+' || occurrence == 43) {
                    return 100000;
                }
                if (tagoccurrence == '*' || occurrence == 42) {
                    return 100000;
                }
                return 1;
            }
            int childOccurrence = this.getOccurrence(c1, tagname);
            if (childOccurrence == 0) continue;
            if (occurrence == 42 || occurrence == 43) {
                return 100000;
            }
            return childOccurrence;
        }
        return 0;
    }

    class ChildrenValidator
    extends ElementValidator {
        private ElementDecl element;
        private Hashtable savtags;

        ChildrenValidator(ElementDecl element) {
            this.savtags = new Hashtable(5);
            this.element = element;
        }

        @Override
        public void consume(String tag) throws SAXException {
            Children chdecl = this.element.getChildren();
            if (!chdecl.containsTag(tag)) {
                XmlValidation.this.error("UNDEF_SBELEMENT", new Object[]{this.element.getNodeName(), tag});
                return;
            }
            int num = XmlValidation.this.getOccurrence(chdecl, tag);
            int num1 = 0;
            Integer Inum = (Integer)this.savtags.get(tag);
            if (Inum != null) {
                num1 = Inum;
            }
            if (num1 == num) {
                XmlValidation.this.error("UNDEF_SBELEMENT", new Object[]{this.element.getNodeName(), tag});
            }
            this.savtags.put(tag, new Integer(++num1));
        }

        @Override
        public void text(String tag) throws SAXException {
            XmlValidation.this.error("UNDEF_TEXT", new Object[]{this.element.getNodeName()});
        }

        @Override
        public void done() throws SAXException {
            this.savtags.clear();
        }
    }

    class MixedValidator
    extends ElementValidator {
        private ElementDecl element;

        MixedValidator(ElementDecl element) {
            this.element = element;
        }

        @Override
        public void consume(String tag) throws SAXException {
            if (tag.equals("#PCDATA")) {
                return;
            }
            Vector v = this.element.getChildNames();
            if (v == null || !v.contains(tag)) {
                XmlValidation.this.error("UNDEF_ELEMENT", new Object[]{tag});
            }
        }
    }

    class EmptyValidator
    extends ElementValidator {
        EmptyValidator() {
        }

        @Override
        public void consume(String tag) throws SAXException {
            XmlValidation.this.error("UNDEF_ELEMENT", new Object[]{tag});
        }

        @Override
        public void text(String tag) throws SAXException {
            XmlValidation.this.error("UNDEF_TEXT", new Object[]{tag});
        }
    }

    class ElementValidator {
        ElementValidator() {
        }

        public void consume(String tag) throws SAXException {
        }

        public void text(String tag) throws SAXException {
        }

        public void done() throws SAXException {
        }
    }

    static class DefaultErrorHandler
    implements ErrorHandler {
        DefaultErrorHandler() {
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            Debug.println(exception.getMessage());
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            Debug.println(exception.getMessage());
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            Debug.println(exception.getMessage());
        }
    }
}

