/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.jxp.parser;

import com.argo21.common.io.XReader;
import com.argo21.jxp.parser.DefaultTransformer;
import com.argo21.jxp.parser.IXmlParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.Writer;
import java.lang.reflect.Method;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DefaultParser
implements IXmlParser {
    private DocumentBuilderFactory dbf = null;
    private int domLevel = 0;

    public DefaultParser() {
        this(null);
    }

    public DefaultParser(DocumentBuilderFactory dbf) {
        this.dbf = dbf != null ? dbf : DocumentBuilderFactory.newInstance();
    }

    protected int getDomLevel() {
        if (this.domLevel > 0) {
            return this.domLevel;
        }
        try {
            Method method = this.dbf.getClass().getMethod("setIgnoringElementContentWhitespace", Boolean.TYPE);
            this.domLevel = 2;
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.domLevel = 1;
        return this.domLevel;
    }

    @Override
    public Document createXmlDocument() throws ParserConfigurationException {
        DocumentBuilder db = this.dbf.newDocumentBuilder();
        return db.newDocument();
    }

    @Override
    public Document createXmlDocument(String documentURI) throws IOException, SAXException, ParserConfigurationException {
        InputSource in = new InputSource(documentURI);
        return this.createXmlDocument(in, false);
    }

    public Document createXmlDocument(URL url) throws IOException, SAXException, ParserConfigurationException {
        InputSource in = new InputSource(url.toString());
        return this.createXmlDocument(in, false);
    }

    @Override
    public Document createXmlDocument(InputStream in, boolean doValidate) throws IOException, SAXException, ParserConfigurationException {
        return this.createXmlDocument(in, doValidate, null);
    }

    @Override
    public Document createXmlDocument(InputStream in, boolean doValidate, ErrorHandler handler) throws IOException, SAXException, ParserConfigurationException {
        InputSource is = new InputSource(in);
        return this.createXmlDocument(is, doValidate, handler);
    }

    @Override
    public Document createXmlDocument(InputSource in, boolean doValidate) throws IOException, SAXException, ParserConfigurationException {
        return this.createXmlDocument(in, doValidate, null);
    }

    @Override
    public Document createXmlDocument(InputSource in, boolean doValidate, ErrorHandler handler) throws IOException, SAXException, ParserConfigurationException {
        this.dbf.setNamespaceAware(true);
        this.dbf.setValidating(doValidate);
        if (this.getDomLevel() >= 2) {
            this.dbf.setIgnoringElementContentWhitespace(true);
        }
        DocumentBuilder db = this.dbf.newDocumentBuilder();
        db.setEntityResolver(this.createEntityResolver(in.getSystemId()));
        if (handler != null) {
            db.setErrorHandler(handler);
        }
        return db.parse(in);
    }

    @Override
    public Document createXmlDocumentByString(String contents, boolean doValidate) throws IOException, SAXException, ParserConfigurationException {
        InputSource in = new InputSource(new StringReader(contents));
        return this.createXmlDocument(in, doValidate);
    }

    protected EntityResolver createEntityResolver(String uri) {
        URL tmp = null;
        if (uri != null) {
            try {
                tmp = new URL(uri);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        final URL baseUrl = tmp;
        EntityResolver entityResolver = new EntityResolver(){

            @Override
            public InputSource resolveEntity(String publicId, String systemId) throws IOException {
                URL url = baseUrl != null ? new URL(baseUrl, systemId) : new URL(systemId);
                InputSource is = XReader.createInputSource(url, false);
                is.setPublicId(publicId);
                return is;
            }
        };
        return entityResolver;
    }

    @Override
    public void writeXmlDocument(Document document, Writer writer, String encoding, boolean setIndent) throws IOException {
        DefaultTransformer transformer = new DefaultTransformer();
        transformer.writeXmlDocument(document, writer, encoding);
    }

    @Override
    public void writeXmlDocumentRoot(Document document, Writer writer, boolean setIndent) throws IOException {
        DefaultTransformer transformer = new DefaultTransformer();
        transformer.writeXmlDocumentRoot(document, writer);
    }

    @Override
    public void writeXmlElement(Element element, Writer writer) throws IOException {
        DefaultTransformer transformer = new DefaultTransformer();
        transformer.writeXmlElement(element, writer);
    }

    @Override
    public DocumentType setDoctype(Document document, String dtdPublicId, String dtdSystemId, String internalSubset) {
        return document.getDoctype();
    }

    @Override
    public String getSystemId(DocumentType doctype) {
        if (this.getDomLevel() >= 2) {
            return doctype.getSystemId();
        }
        return null;
    }

    @Override
    public String getPublicId(DocumentType doctype) {
        if (this.getDomLevel() >= 2) {
            return doctype.getPublicId();
        }
        return null;
    }

    @Override
    public String getInternalSubset(DocumentType doctype) {
        if (this.getDomLevel() >= 2) {
            return doctype.getInternalSubset();
        }
        return null;
    }
}

