/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.jxp.parser;

import java.io.IOException;
import java.io.Writer;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DefaultTransformer {
    private TransformerFactory tf = null;

    public DefaultTransformer() {
        this(null);
    }

    public DefaultTransformer(TransformerFactory tf) {
        this.tf = tf != null ? tf : TransformerFactory.newInstance();
    }

    public void writeXmlDocument(Document document, Writer writer, String encoding) throws IOException {
        try {
            Transformer transformer = this.tf.newTransformer();
            if (encoding != null) {
                transformer.setOutputProperty("encoding", encoding);
            }
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(new DOMSource(document), new StreamResult(writer));
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public void writeXmlDocumentRoot(Document document, Writer writer) throws IOException {
        try {
            Transformer transformer = this.tf.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(new DOMSource(document.getDocumentElement()), new StreamResult(writer));
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public void writeXmlElement(Element element, Writer writer) throws IOException {
        try {
            Transformer transformer = this.tf.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.transform(new DOMSource(element), new StreamResult(writer));
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }
}

