/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.jxp.parser;

import com.argo21.jxp.parser.BizTranXMLSerializer;
import com.argo21.jxp.parser.DefaultParser;
import java.io.IOException;
import java.io.Writer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.apache.xerces.dom.DocumentTypeImpl;
import org.apache.xml.serialize.OutputFormat;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Xerces
extends DefaultParser {
    private static String lineSep = null;
    private DocumentBuilderFactory dbf;

    public static void setEol(String eol) {
        lineSep = eol;
    }

    public Xerces() {
        this.dbf = DocumentBuilderFactory.newInstance();
    }

    public Xerces(DocumentBuilderFactory dbf) {
        this.dbf = dbf;
    }

    @Override
    protected int getDomLevel() {
        return 2;
    }

    @Override
    public Document createXmlDocument(InputSource in, boolean doValidate, ErrorHandler handler) throws IOException, SAXException, ParserConfigurationException {
        this.dbf.setNamespaceAware(true);
        this.dbf.setValidating(doValidate);
        this.dbf.setIgnoringElementContentWhitespace(true);
        this.dbf.setCoalescing(true);
        DocumentBuilder db = this.dbf.newDocumentBuilder();
        db.setEntityResolver(this.createEntityResolver(in.getSystemId()));
        if (handler != null) {
            db.setErrorHandler(handler);
        }
        return db == null ? null : db.parse(in);
    }

    @Override
    public DocumentType setDoctype(Document document, String dtdPublicId, String dtdSystemId, String internalSubset) {
        if (document instanceof CoreDocumentImpl) {
            CoreDocumentImpl ownerDocument = (CoreDocumentImpl)document;
            String name2 = ownerDocument.getDocumentElement().getNodeName();
            DocumentTypeImpl doctype = new DocumentTypeImpl(ownerDocument, name2, dtdPublicId, dtdSystemId);
            doctype.setInternalSubset(internalSubset);
            DocumentType oldDocType = ownerDocument.getDoctype();
            if (oldDocType != null) {
                ownerDocument.replaceChild((Node)doctype, (Node)oldDocType);
            } else {
                ownerDocument.insertBefore((Node)doctype, ownerDocument.getFirstChild());
            }
            return doctype;
        }
        return null;
    }

    @Override
    public void writeXmlDocument(Document document, Writer writer, String encoding, boolean setIndent) throws IOException {
        OutputFormat format = new OutputFormat();
        format.setIndenting(setIndent);
        format.setLineWidth(0);
        if (encoding != null) {
            format.setEncoding(encoding);
        }
        if (lineSep != null) {
            format.setLineSeparator(lineSep);
        }
        BizTranXMLSerializer serializer = new BizTranXMLSerializer(writer, format);
        serializer.asDOMSerializer();
        serializer.serialize(document);
    }

    @Override
    public void writeXmlDocumentRoot(Document document, Writer writer, boolean setIndent) throws IOException {
        OutputFormat format = new OutputFormat();
        format.setOmitXMLDeclaration(setIndent);
        format.setIndenting(true);
        if (lineSep != null) {
            format.setLineSeparator(lineSep);
        }
        BizTranXMLSerializer serializer = new BizTranXMLSerializer(writer, format);
        serializer.asDOMSerializer();
        serializer.serialize(document.getDocumentElement());
    }

    @Override
    public void writeXmlElement(Element element, Writer writer) throws IOException {
        OutputFormat format = new OutputFormat();
        format.setOmitXMLDeclaration(true);
        BizTranXMLSerializer serializer = new BizTranXMLSerializer(writer, format);
        serializer.asDOMSerializer();
        serializer.serialize(element);
    }

    @Override
    public String getSystemId(DocumentType doctype) {
        return doctype.getSystemId();
    }

    @Override
    public String getPublicId(DocumentType doctype) {
        return doctype.getPublicId();
    }

    @Override
    public String getInternalSubset(DocumentType doctype) {
        return doctype.getInternalSubset();
    }
}

