/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.jxp.parser;

import com.argo21.jxp.dtd.DTDDecl;
import com.argo21.jxp.dtd.ElementDecl;
import com.argo21.jxp.parser.DefaultParser;
import com.argo21.jxp.parser.IXmlParser;
import com.argo21.jxp.parser.JAXP1_0;
import com.argo21.jxp.parser.JAXP1_1;
import com.argo21.jxp.parser.Xerces;
import com.argo21.jxp.xsd.XSDDecl;
import com.argo21.jxp.xsd.XsdElementDecl;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XmlParser {
    public static IXmlParser xmlParser = null;

    private static boolean isInstance(Object obj, String clsName) {
        try {
            Class<?> cls = Class.forName(clsName);
            if (cls.isInstance(obj)) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static void setXmlParser(IXmlParser parser) {
        xmlParser = parser;
    }

    public static void setXmlParser(String classname) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class<?> cls = Class.forName(classname);
        xmlParser = (IXmlParser)cls.newInstance();
    }

    public static IXmlParser getXmlParser() {
        return xmlParser;
    }

    public static void appendCopyChild(Element parent, Node node) {
        Document doc = parent.getOwnerDocument();
        for (Node child = node.getFirstChild(); null != child; child = child.getNextSibling()) {
            short type = child.getNodeType();
            if (type == 1) {
                Element e1 = doc.createElement(child.getNodeName());
                NamedNodeMap nl = child.getAttributes();
                int len = nl.getLength();
                for (int i = 0; i < len; ++i) {
                    Node an = nl.item(i);
                    e1.setAttribute(an.getNodeName(), an.getNodeValue());
                }
                parent.appendChild(e1);
                XmlParser.appendCopyChild(e1, child);
                continue;
            }
            if (type == 4) {
                parent.appendChild(doc.createCDATASection(child.getNodeValue()));
                continue;
            }
            if (type == 3) {
                String text = child.getNodeValue();
                if (text.trim().length() <= 0) continue;
                parent.appendChild(doc.createTextNode(text));
                continue;
            }
            if (type == 8) {
                parent.appendChild(doc.createComment(child.getNodeValue()));
                continue;
            }
            if (type != 5) continue;
            parent.appendChild(doc.createEntityReference(child.getNodeValue()));
        }
    }

    public static String toXmlText(String data) {
        int last2;
        int start = 0;
        if (data == null) {
            return "null";
        }
        StringBuffer sb = new StringBuffer();
        int n = data.length();
        boolean b = false;
        for (last2 = 0; last2 < n; ++last2) {
            char c = data.charAt(last2);
            if (c == '<') {
                sb.append(data.substring(start, last2));
                start = last2 + 1;
                sb.append("&lt;");
                b = true;
                continue;
            }
            if (c == '>') {
                sb.append(data.substring(start, last2));
                start = last2 + 1;
                sb.append("&gt;");
                b = true;
                continue;
            }
            if (c != '&') continue;
            sb.append(data.substring(start, last2));
            start = last2 + 1;
            sb.append("&amp;");
            b = true;
        }
        if (!b) {
            return data;
        }
        sb.append(data.substring(start, last2));
        return sb.toString();
    }

    public static String getElementText(Node elem) {
        StringBuffer buf = new StringBuffer();
        for (Node child = elem.getFirstChild(); child != null; child = child.getNextSibling()) {
            short type = child.getNodeType();
            if (type == 3 || type == 4) {
                buf.append(((Text)child).getData());
                continue;
            }
            if (type != 5) continue;
            buf.append(XmlParser.getElementText(child));
        }
        return buf.toString();
    }

    public static void setElementText(Node elem, String value) {
        Node child = elem.getFirstChild();
        while (child != null) {
            short type = child.getNodeType();
            if (type == 3 || type == 4 || type == 5) {
                Node removingNode = child;
                child = child.getNextSibling();
                elem.removeChild(removingNode);
                continue;
            }
            child = child.getNextSibling();
        }
        Text text = elem.getOwnerDocument().createTextNode(value);
        elem.insertBefore(text, elem.getFirstChild());
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void trimNode(Element elem, DTDDecl dtd) {
        int k;
        ElementDecl decl;
        NodeList nl = elem.getChildNodes();
        int n = nl.getLength();
        if (n == 0) {
            return;
        }
        String name2 = elem.getNodeName();
        ElementDecl elementDecl = decl = dtd == null ? null : dtd.getElementDecl(name2);
        if (decl == null || decl.getType() != 2) {
            k = 0;
        } else {
            boolean has = false;
            int k2 = 0;
            while (k2 < n) {
                Node node = nl.item(k2);
                if (node.getNodeType() == 3) {
                    if (XmlParser.containValidData(node.getNodeValue())) {
                        if (!has) {
                            has = true;
                        } else {
                            elem.removeChild(node);
                            --n;
                            continue;
                        }
                    }
                } else if (node.getNodeType() == 1) {
                    XmlParser.trimNode((Element)node, dtd);
                }
                ++k2;
            }
            return;
        }
        while (k < n) {
            Node node = nl.item(k);
            if (node.getNodeType() == 3 && XmlParser.containValidData(node.getNodeValue())) {
                elem.removeChild(node);
                --n;
                continue;
            }
            if (node.getNodeType() == 1) {
                XmlParser.trimNode((Element)node, dtd);
            }
            ++k;
        }
    }

    private static boolean containValidData(String str) {
        char c;
        int first;
        int last2 = str.length();
        for (first = 0; first < last2 && ((c = str.charAt(first)) == '\r' || c == '\n' || c == '\b' || c == ' '); ++first) {
        }
        while (last2 > first && ((c = str.charAt(last2 - 1)) == '\r' || c == '\n' || c == '\b' || c == ' ')) {
            --last2;
        }
        return first == last2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void trimNode(Element elem, XSDDecl xsd) {
        int k;
        XsdElementDecl decl;
        NodeList nl = elem.getChildNodes();
        int n = nl.getLength();
        if (n == 0) {
            return;
        }
        String name2 = elem.getNodeName();
        XsdElementDecl xsdElementDecl = decl = xsd == null ? null : xsd.getElementDecl(name2);
        if (decl == null) {
            k = 0;
        } else {
            boolean has = false;
            int k2 = 0;
            while (k2 < n) {
                Node node = nl.item(k2);
                if (node.getNodeType() == 3) {
                    if (XmlParser.containValidData(node.getNodeValue())) {
                        if (!has) {
                            has = true;
                        } else {
                            elem.removeChild(node);
                            --n;
                            continue;
                        }
                    }
                } else if (node.getNodeType() == 1) {
                    XmlParser.trimNode((Element)node, xsd);
                }
                ++k2;
            }
            return;
        }
        while (k < n) {
            Node node = nl.item(k);
            if (node.getNodeType() == 3 && XmlParser.containValidData(node.getNodeValue())) {
                elem.removeChild(node);
                --n;
                continue;
            }
            if (node.getNodeType() == 1) {
                XmlParser.trimNode((Element)node, xsd);
            }
            ++k;
        }
    }

    public static void main(String[] args) {
    }

    static {
        DefaultParser parser = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        if (XmlParser.isInstance(factory, "com.sun.xml.parser.DocumentBuilderFactoryImpl")) {
            parser = new JAXP1_0(factory);
        } else if (XmlParser.isInstance(factory, "org.apache.crimson.jaxp.DocumentBuilderFactoryImpl")) {
            parser = new JAXP1_1(factory);
        } else if (XmlParser.isInstance(factory, "org.apache.xerces.jaxp.DocumentBuilderFactoryImpl")) {
            parser = new Xerces(factory);
        } else {
            try {
                DocumentBuilder db = factory.newDocumentBuilder();
                Document doc = db.newDocument();
                parser = XmlParser.isInstance(factory, "com.sun.xml.tree.XmlDocument") ? new JAXP1_0(factory) : (XmlParser.isInstance(factory, "org.apache.crimson.tree.XmlDocument") ? new JAXP1_1(factory) : (XmlParser.isInstance(factory, "org.apache.xerces.dom.DocumentImpl") ? new Xerces(factory) : new DefaultParser(factory)));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (parser != null) {
            XmlParser.setXmlParser(parser);
        }
    }
}

