/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.jxp.vdtd;

import com.argo21.common.gui.ComboTextFieldEx;
import com.argo21.common.lang.XmlNames;
import com.argo21.jxp.dtd.ElementDecl;
import com.argo21.jxp.vdtd.ContentsEditPanel;
import com.argo21.jxp.vdtd.CpDeclNodeData;
import com.argo21.jxp.vdtd.DTDEditorPanel;
import com.argo21.jxp.vdtd.ElementDeclNodeData;
import com.argo21.jxp.vdtd.ResultPanel;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.tree.DefaultMutableTreeNode;

class CpDeclPanel
extends ContentsEditPanel {
    ComboTextFieldEx nameField;
    JLabel nameLabel;
    JPanel namePanel;
    JPanel numPanel;
    JCheckBox entityRefField;
    ResultPanel result;
    JRadioButton[] occurrenceOption = new JRadioButton[4];

    CpDeclPanel() {
    }

    @Override
    public void init(DTDEditorPanel parentPanel) {
        this.parentPanel = parentPanel;
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridy = 0;
        gc.gridx = 0;
        gc.fill = 1;
        gc.weightx = 1.0;
        gc.insets = new Insets(2, 2, 2, 2);
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridy = 0;
        c.gridx = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.insets = new Insets(2, 2, 2, 2);
        c.fill = 1;
        this.namePanel = new JPanel();
        this.namePanel.setLayout(new GridBagLayout());
        this.namePanel.setOpaque(true);
        this.namePanel.setBorder(BorderFactory.createTitledBorder(CpDeclPanel.getMessage("TL_ELEM")));
        this.nameLabel = new JLabel(CpDeclPanel.getMessage("LAB_ELEM_NAME"));
        this.namePanel.add((Component)this.nameLabel, c);
        ++c.gridx;
        c.weightx = 1.0;
        Font defaultFont = this.getDefaultFont();
        this.nameField = new ComboTextFieldEx(){

            @Override
            public boolean valueChanged(Object source, String value) {
                CpDeclPanel.this.nameChanged(value);
                return true;
            }
        };
        this.namePanel.add((Component)this.nameField, c);
        this.entityRefField = new JCheckBox(CpDeclPanel.getMessage("LAB_PARAM_REF"));
        if (parentPanel.peRefEnabled) {
            c.gridx = 0;
            c.weightx = 0.0;
            ++c.gridy;
            ++c.gridx;
            c.weightx = 1.0;
            this.entityRefField.setFont(this.getDefaultFont());
            this.namePanel.add((Component)this.entityRefField, c);
            this.entityRefField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CpDeclPanel.this.entityRefCheckChanged();
                }
            });
        }
        this.add((Component)this.namePanel, gc);
        ++gc.gridy;
        this.numPanel = new JPanel();
        this.numPanel.setBorder(BorderFactory.createTitledBorder(CpDeclPanel.getMessage("TL_APP_NUM")));
        this.numPanel.setLayout(new BoxLayout(this.numPanel, 1));
        ButtonGroup group = new ButtonGroup();
        this.occurrenceOption[0] = new JRadioButton(CpDeclPanel.getMessage("LAB_JUSTONE"));
        this.numPanel.add(this.occurrenceOption[0]);
        this.occurrenceOption[1] = new JRadioButton(CpDeclPanel.getMessage("LAB_ONEMORE"));
        this.numPanel.add(this.occurrenceOption[1]);
        this.occurrenceOption[2] = new JRadioButton(CpDeclPanel.getMessage("LAB_ZEROONE"));
        this.numPanel.add(this.occurrenceOption[2]);
        this.occurrenceOption[3] = new JRadioButton(CpDeclPanel.getMessage("LAB_ZEROMORE"));
        this.numPanel.add(this.occurrenceOption[3]);
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CpDeclPanel.this.occurrenceChanged((JRadioButton)e.getSource());
            }
        };
        for (int i = 0; i < 4; ++i) {
            group.add(this.occurrenceOption[i]);
            this.occurrenceOption[i].setFont(this.getDefaultFont());
            this.occurrenceOption[i].addActionListener(al);
        }
        this.add((Component)this.numPanel, gc);
        ++gc.gridy;
        gc.gridwidth = 0;
        gc.gridheight = 0;
        gc.weighty = 1.0;
        gc.weightx = 1.0;
        this.result = new ResultPanel(parentPanel);
        this.add((Component)this.result, gc);
    }

    void nameChanged(String value) {
        CpDeclNodeData data = (CpDeclNodeData)this.node.getUserObject();
        String s = data.getNodeName();
        if (!s.equals(value)) {
            if (!XmlNames.isName(value)) {
                JOptionPane.showMessageDialog(this.parentPanel, CpDeclPanel.getMessage("INVALID_NAME", value));
                JTextField tt = (JTextField)this.nameField.getEditor().getEditorComponent();
                tt.setText(s);
                return;
            }
            this.nameChangedTo(value);
            this.viewResult();
        }
    }

    void entityRefCheckChanged() {
        CpDeclNodeData data = (CpDeclNodeData)this.node.getUserObject();
        data.setIsEntity(this.entityRefField.isSelected());
        this.reviewPanel(false);
        this.nodeChanged();
        this.viewResult();
    }

    void reviewPanel(boolean mustdo) {
        boolean showAttr;
        boolean bl = showAttr = !this.entityRefField.isSelected();
        if (this.numPanel.isVisible() != showAttr || mustdo) {
            if (showAttr) {
                this.nameLabel.setText(CpDeclPanel.getMessage("LAB_ELEM_NAME"));
            } else {
                this.nameLabel.setText(CpDeclPanel.getMessage("LAB_REF_NAME"));
            }
            this.numPanel.setVisible(showAttr);
            this.revalidate();
            Vector vet = showAttr ? this.parentPanel.getAllDeclNodesBefore(20, null) : this.parentPanel.getAllValueEntitysBefore(this.node);
            this.nameField.setEnabledEvent(false);
            this.nameField.setList(vet);
            CpDeclNodeData data = (CpDeclNodeData)this.node.getUserObject();
            this.nameField.setText(data.getNodeName());
            this.nameField.setEnabledEvent(true);
        }
    }

    void occurrenceChanged(JRadioButton occurrenceopt) {
        CpDeclNodeData data;
        int oldoccurrence;
        if (!occurrenceopt.isSelected()) {
            return;
        }
        int occurrence = occurrenceopt == this.occurrenceOption[1] ? 43 : (occurrenceopt == this.occurrenceOption[2] ? 63 : (occurrenceopt == this.occurrenceOption[3] ? 42 : 0));
        if (occurrence == (oldoccurrence = (data = (CpDeclNodeData)this.node.getUserObject()).getOccurrence())) {
            return;
        }
        data.setOccurrence(occurrence);
        this.nodeChanged();
        this.viewResult();
    }

    void viewResult() {
        for (DefaultMutableTreeNode parent = (DefaultMutableTreeNode)this.node.getParent(); parent != null; parent = (DefaultMutableTreeNode)parent.getParent()) {
            Object data1 = parent.getUserObject();
            if (!(data1 instanceof ElementDeclNodeData)) continue;
            ElementDecl declnode = DTDEditorPanel.createElementDecl(null, parent);
            String rs = declnode == null ? "" : declnode.toString();
            this.result.viewResult(rs);
            break;
        }
    }

    @Override
    public void setTreeNode(DefaultMutableTreeNode node) {
        Object data = node.getUserObject();
        this.node = node;
        if (data instanceof CpDeclNodeData) {
            CpDeclNodeData elem = (CpDeclNodeData)data;
            this.entityRefField.setVisible(this.parentPanel.peRefEnabled);
            this.entityRefField.setSelected(elem.isEntity() & this.parentPanel.peRefEnabled);
            JTextField tt = (JTextField)this.nameField.getEditor().getEditorComponent();
            tt.setText(elem.getNodeName());
            int oc = elem.getOccurrence();
            if (oc == 0) {
                this.occurrenceOption[0].setSelected(true);
            } else if (oc == 43) {
                this.occurrenceOption[1].setSelected(true);
            } else if (oc == 63) {
                this.occurrenceOption[2].setSelected(true);
            } else if (oc == 42) {
                this.occurrenceOption[3].setSelected(true);
            }
            this.numPanel.setVisible(this.entityRefField.isSelected());
            this.reviewPanel(true);
            this.viewResult();
        }
    }
}

