/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.jxp.vdtd;

import com.argo21.common.gui.ImageLoader;
import com.argo21.common.gui.StatusChangedListener;
import com.argo21.common.gui.TextEditorPanel;
import com.argo21.common.io.FileEx;
import com.argo21.common.io.MIME2Java;
import com.argo21.common.io.XReader;
import com.argo21.common.security.LicenceKeys;
import com.argo21.jxp.dtd.DTDDecl;
import com.argo21.jxp.dtd.DTDDocument;
import com.argo21.jxp.vdtd.DTDDeclNodeData;
import com.argo21.jxp.vdtd.DTDEditorPanel;
import com.argo21.jxp.vdtd.DTDStructView;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.JarURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.Hashtable;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.border.BevelBorder;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.filechooser.FileFilter;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

class DTDEditorFrame
extends JFrame {
    public static int WIDTH;
    public static int HEIGHT;
    public static final String CMD_NEW_FILE = "NEW";
    public static final String CMD_OPEN_FILE = "OPEN";
    public static final String CMD_SAVE_FILE = "SAVE";
    public static final String CMD_SAVEAS_FILE = "SAVEAS";
    public static final String CMD_OPEN_URL = "OPENURL";
    public static final String CMD_OPEN_XML = "OPENXML";
    public static final String CMD_OPEN_XMLURL = "OPENXMLURL";
    public static final String CMD_EXIT = "EXIT";
    public static final String CMD_VIEW_DTDEDIT = "DTDEDIT";
    public static final String CMD_VIEW_TEXTEDIT = "TEXTEDIT";
    public static final String CMD_VIEW_DTDSTRUCT = "DTDSTRUCT";
    public static final String CMD_VIEW_TOOLBAR = "TOOLBAL";
    public static final String CMD_VIEW_STATUSBAR = "STATUSBAR";
    public static final String CMD_VIEW_INFORMATION = "INFORMATION";
    private static int VALIDPERIOD;
    private static String USER_KEY;
    private static String VERSION;
    private static String COMPANY;
    private static String USERNAME;
    private static Date LASTMODIFY;
    static final String fileSeparator;
    static String USER_DIR;
    static String SAMPLES_DIR;
    static String LIB_DIR;
    static final String HOME_DIR;
    static String DTDEditorINI;
    static String[] fileToolBarNames;
    static String[] fileToolBarNames1;
    static String[] textToolBarNames;
    static String[] dtdToolBarNames;
    static String[][] fileMenus;
    static String[][] fileMenus1;
    static String[][] textEditMenus;
    static String[][] dtdEditMenus;
    static String[][] structViewEditMenus;
    static String[][] viewMenus;
    static String[][] helpMenus;
    static String NO_NAMING_FILE;
    private JMenuBar menuBar;
    private JPanel toolBar;
    private DTDEditorPanel dtdEditPanel;
    private TextEditorPanel textEditPanel;
    private DTDStructView structViewPanel;
    private Component currentContentsPanel = null;
    private StatusBar statusBar;
    private JToolBar fileToolBar;
    private JToolBar dtdToolBar;
    private JToolBar textToolBar;
    private JMenu fileMenu;
    private JMenu dtdEditMenu;
    private JMenu textEditMenu;
    private JMenu structEditMenu;
    private String filename = null;
    private int recentFilepos = 0;
    private Hashtable toolButtons;
    private Hashtable menuItems;
    private Hashtable actions;
    private boolean isInteralEditor = false;
    private boolean hasStarted = false;
    private PopupMenuListener popupMenuListener;
    VersionDialog infoDlg = null;

    static ImageIcon loadImage(String name2) {
        return ImageLoader.load(name2 + ".gif", name2);
    }

    static String getMessage(String MsgId) {
        return DTDEditorPanel.msgCatalog.getMessage(MsgId);
    }

    static String getMessage(String MsgId, String param) {
        return DTDEditorPanel.msgCatalog.getMessage(MsgId, new Object[]{param});
    }

    private static int getIntegerParameter(Properties properties, String key, int def) {
        String s = properties.getProperty(key, null);
        if (s == null) {
            return def;
        }
        try {
            int k = Integer.parseInt(s);
            if (k > 0) {
                return k;
            }
            return def;
        }
        catch (Exception exception) {
            return def;
        }
    }

    void viewInformation() {
        int y;
        int x;
        if (this.infoDlg == null) {
            this.infoDlg = new VersionDialog(this, true);
        }
        Dimension dlgsize = this.infoDlg.getSize();
        if (this.currentContentsPanel != null) {
            Point p = this.currentContentsPanel.getLocationOnScreen();
            x = p.x + (this.currentContentsPanel.getWidth() - dlgsize.width) / 2;
            y = p.y + (this.currentContentsPanel.getHeight() - dlgsize.height) / 2;
        } else {
            Rectangle rect = this.getBounds();
            x = rect.x + (rect.width - dlgsize.width) / 2;
            y = rect.y + (rect.height - dlgsize.height) / 2;
        }
        this.infoDlg.setLocation(x, y);
        this.infoDlg.setVisible(true);
    }

    DTDEditorFrame() {
        this(false);
    }

    DTDEditorFrame(boolean isInteralEditor) {
        this.isInteralEditor = isInteralEditor;
    }

    @Override
    public void setVisible(boolean b) {
        if (b && !this.hasStarted) {
            this.start();
        }
        super.setVisible(b);
    }

    Window getVersionDialog() {
        return new VersionDialog(this, false);
    }

    void start() {
        if (this.hasStarted) {
            return;
        }
        this.hasStarted = true;
        this.viewWaitCursor(null);
        ImageIcon img = ImageLoader.load("dtdIcon.gif", "mapIcon");
        if (img != null) {
            this.setIconImage(img.getImage());
        }
        this.toolButtons = new Hashtable(41);
        this.menuItems = new Hashtable(61);
        this.actions = new Hashtable(61);
        this.dtdEditPanel = new DTDEditorPanel((DTDDeclNodeData)null, false, true);
        JTree tree = this.dtdEditPanel.tree;
        this.popupMenuListener = new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                JPopupMenu menu = (JPopupMenu)e.getSource();
                if (DTDEditorFrame.this.isDTDEditPanel()) {
                    menu.setInvoker(DTDEditorFrame.this.dtdEditMenu);
                } else if (DTDEditorFrame.this.isTextEditPanel()) {
                    menu.setInvoker(DTDEditorFrame.this.textEditMenu);
                }
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        };
        tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getModifiers() != 16) {
                    JPopupMenu menu = DTDEditorFrame.this.dtdEditMenu.getPopupMenu();
                    menu.addPopupMenuListener(DTDEditorFrame.this.popupMenuListener);
                    menu.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
        this.dtdEditPanel.addStatusChangedListener(new StatusChangedListener(){

            @Override
            public void statusChanged(int id2, EventObject e) {
                DTDEditorFrame.this.dtdEditorStatusChanged();
            }
        });
        this.textEditPanel = new TextEditorPanel();
        Component c = this.textEditPanel.getDragComponent();
        c.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getModifiers() != 16) {
                    JPopupMenu menu = DTDEditorFrame.this.textEditMenu.getPopupMenu();
                    menu.addPopupMenuListener(DTDEditorFrame.this.popupMenuListener);
                    menu.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
        this.textEditPanel.addStatusChangedListener(new StatusChangedListener(){

            @Override
            public void statusChanged(int id2, EventObject e) {
                DTDEditorFrame.this.textEditorStatusChanged();
            }
        });
        this.structViewPanel = new DTDStructView();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        this.registActions();
        this.menuBar = this.createMenuBar();
        this.setJMenuBar(this.menuBar);
        JPanel tp = new JPanel();
        tp.setBorder(BorderFactory.createEtchedBorder());
        tp.setLayout(new BorderLayout());
        this.setContentPane(tp);
        this.toolBar = new JPanel(new FlowLayout(0));
        this.fileToolBar = this.isInteralEditor ? this.createToolbar(fileToolBarNames1) : this.createToolbar(fileToolBarNames);
        this.textToolBar = this.createToolbar(textToolBarNames);
        this.dtdToolBar = this.createToolbar(dtdToolBarNames);
        this.toolBar.add(this.fileToolBar);
        this.toolBar.add(this.textToolBar);
        tp.add((Component)this.toolBar, "North");
        this.statusBar = new StatusBar();
        this.statusBar.setMinimumSize(new Dimension(100, 20));
        tp.add((Component)this.statusBar, "South");
        this.switchViewToTextEditPanel();
        this.loadInitParamenter();
        this.statusChanged();
        this.setTitle();
        this.viewDefaultCursor("\u30ec\u30c7\u30a3\uff1a");
    }

    private void switchViewToTextEditPanel() {
        Container tp = this.getContentPane();
        if (this.currentContentsPanel != null) {
            tp.remove(this.currentContentsPanel);
        }
        this.currentContentsPanel = this.textEditPanel;
        tp.add(this.currentContentsPanel, "Center");
        tp.invalidate();
        this.currentContentsPanel.requestFocus();
        ((JMenuItem)this.menuItems.get(CMD_VIEW_DTDEDIT)).setSelected(false);
        ((JMenuItem)this.menuItems.get(CMD_VIEW_TEXTEDIT)).setSelected(true);
        ((JMenuItem)this.menuItems.get(CMD_VIEW_DTDSTRUCT)).setSelected(false);
        JMenu menu = this.menuBar.getMenu(1);
        if (menu == this.dtdEditMenu || menu == this.structEditMenu) {
            this.menuBar.remove(menu);
        }
        this.menuBar.add((Component)this.textEditMenu, 1);
        this.menuBar.invalidate();
        this.menuBar.repaint();
        this.toolBar.remove(this.dtdToolBar);
        this.toolBar.add(this.textToolBar);
        this.textToolBar.setEnabled(true);
        this.dtdToolBar.setEnabled(false);
        this.toolBar.revalidate();
        this.repaint();
    }

    private void switchViewToDTDEditPanel() {
        if (this.currentContentsPanel != null) {
            this.getContentPane().remove(this.currentContentsPanel);
        }
        this.currentContentsPanel = this.dtdEditPanel;
        this.getContentPane().add(this.currentContentsPanel, "Center");
        this.getContentPane().invalidate();
        ((JMenuItem)this.menuItems.get(CMD_VIEW_DTDEDIT)).setSelected(true);
        ((JMenuItem)this.menuItems.get(CMD_VIEW_TEXTEDIT)).setSelected(false);
        ((JMenuItem)this.menuItems.get(CMD_VIEW_DTDSTRUCT)).setSelected(false);
        JMenu menu = this.menuBar.getMenu(1);
        if (menu == this.textEditMenu || menu == this.structEditMenu) {
            this.menuBar.remove(menu);
        }
        this.menuBar.add((Component)this.dtdEditMenu, 1);
        this.menuBar.invalidate();
        this.menuBar.repaint();
        this.toolBar.remove(this.textToolBar);
        this.toolBar.add(this.dtdToolBar);
        this.textToolBar.setEnabled(false);
        this.dtdToolBar.setEnabled(true);
        this.toolBar.revalidate();
        this.repaint();
    }

    private void switchViewToDTDStructPanel() {
        if (this.currentContentsPanel != null) {
            this.getContentPane().remove(this.currentContentsPanel);
        }
        this.currentContentsPanel = this.structViewPanel;
        this.getContentPane().add(this.currentContentsPanel, "Center");
        this.getContentPane().invalidate();
        ((JMenuItem)this.menuItems.get(CMD_VIEW_DTDEDIT)).setSelected(false);
        ((JMenuItem)this.menuItems.get(CMD_VIEW_TEXTEDIT)).setSelected(false);
        ((JMenuItem)this.menuItems.get(CMD_VIEW_DTDSTRUCT)).setSelected(true);
        JMenu menu = this.menuBar.getMenu(1);
        if (menu == this.textEditMenu || menu == this.dtdEditMenu) {
            this.menuBar.remove(menu);
        }
        this.menuBar.add((Component)this.structEditMenu, 1);
        this.menuBar.invalidate();
        this.menuBar.repaint();
        this.toolBar.remove(this.textToolBar);
        this.toolBar.remove(this.dtdToolBar);
        this.textToolBar.setEnabled(false);
        this.dtdToolBar.setEnabled(false);
        this.toolBar.revalidate();
        this.repaint();
    }

    boolean isDTDEditPanel() {
        return this.currentContentsPanel == this.dtdEditPanel;
    }

    boolean isTextEditPanel() {
        return this.currentContentsPanel == this.textEditPanel;
    }

    boolean isDTDStructPanel() {
        return this.currentContentsPanel == this.structViewPanel;
    }

    private void loadInitParamenter() {
        Properties properties = new Properties();
        try {
            properties.load(new FileInputStream(DTDEditorINI));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        int x = DTDEditorFrame.getIntegerParameter(properties, "window.left", 0);
        int y = DTDEditorFrame.getIntegerParameter(properties, "window.top", 0);
        int w = DTDEditorFrame.getIntegerParameter(properties, "window.width", 0);
        int h = DTDEditorFrame.getIntegerParameter(properties, "window.height", 0);
        if (w > 0 && h > 0) {
            this.setBounds(x, y, w, h);
        } else {
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            this.setBounds(screenSize.width / 2 - WIDTH / 2, screenSize.height / 2 - HEIGHT / 2, WIDTH, HEIGHT);
        }
        if (!this.isInteralEditor) {
            for (int i = 0; i < 10; ++i) {
                String s = properties.getProperty("recent." + String.valueOf(i), null);
                if (s == null) continue;
                this.addRecentFile(s);
            }
        }
    }

    private void saveInitParamenter() {
        Properties properties = new Properties();
        Rectangle rect = this.getBounds();
        properties.put("window.left", String.valueOf(rect.x));
        properties.put("window.top", String.valueOf(rect.y));
        properties.put("window.width", String.valueOf(rect.width));
        properties.put("window.height", String.valueOf(rect.height));
        int n = this.fileMenu.getItemCount() - 2;
        if (this.recentFilepos + 10 < n) {
            n = this.recentFilepos + 10;
        }
        int k = 0;
        for (int i = this.recentFilepos; i < n; ++i) {
            String s = this.fileMenu.getItem(i).getText();
            properties.put("recent." + String.valueOf(k), s);
            ++k;
        }
        try {
            FileOutputStream out = new FileOutputStream(DTDEditorINI);
            properties.store(out, "DTDEditor initialize file");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        if (e.getID() == 201 && !this.closedWindow()) {
            return;
        }
        super.processWindowEvent(e);
        if (e.getID() == 205 && this.infoDlg != null) {
            this.infoDlg.setVisible(false);
        }
    }

    public boolean hasContents() {
        return this.filename != null;
    }

    boolean closedWindow() {
        if (!this.isInteralEditor) {
            this.saveInitParamenter();
            return this.closeFile();
        }
        this.closeFile();
        return false;
    }

    private void dtdEditorStatusChanged() {
        boolean b;
        Action act;
        AbstractButton bt;
        int i;
        boolean bb = this.hasContents();
        for (i = 0; i < dtdToolBarNames.length; ++i) {
            bt = (JButton)this.toolButtons.get(dtdToolBarNames[i]);
            act = (Action)this.actions.get(dtdToolBarNames[i]);
            if (bt == null || act == null) continue;
            b = act.isEnabled() & bb;
            if (bt.isEnabled() == b) continue;
            bt.setEnabled(b);
        }
        for (i = 0; i < dtdEditMenus.length; ++i) {
            bt = (JMenuItem)this.menuItems.get(dtdEditMenus[i][0]);
            act = (Action)this.actions.get(dtdEditMenus[i][0]);
            if (bt == null || act == null) continue;
            b = act.isEnabled() & bb;
            if (bt.isEnabled() == b) continue;
            ((JMenuItem)bt).setEnabled(b);
        }
    }

    private void textEditorStatusChanged() {
        boolean b;
        Action act;
        AbstractButton bt;
        int i;
        boolean bb = this.hasContents();
        for (i = 0; i < textToolBarNames.length; ++i) {
            bt = (JButton)this.toolButtons.get(textToolBarNames[i]);
            act = (Action)this.actions.get(textToolBarNames[i]);
            if (bt == null || act == null) continue;
            b = act.isEnabled() & bb;
            if (bt.isEnabled() == b) continue;
            bt.setEnabled(b);
        }
        for (i = 0; i < textEditMenus.length; ++i) {
            bt = (JMenuItem)this.menuItems.get(textEditMenus[i][0]);
            act = (Action)this.actions.get(textEditMenus[i][0]);
            if (bt == null || act == null) continue;
            b = act.isEnabled() & bb;
            if (bt.isEnabled() == b) continue;
            ((JMenuItem)bt).setEnabled(b);
        }
    }

    void statusChanged() {
        boolean b = this.hasContents();
        this.setMenuItemEnabled(CMD_SAVE_FILE, b);
        this.setMenuItemEnabled(CMD_SAVEAS_FILE, b);
        this.setToolButtonEnabled(CMD_SAVE_FILE, b);
        ((JMenuItem)this.menuItems.get(CMD_VIEW_DTDSTRUCT)).setEnabled(b);
        ((JMenuItem)this.menuItems.get(CMD_VIEW_TEXTEDIT)).setEnabled(b);
        ((JMenuItem)this.menuItems.get(CMD_VIEW_DTDEDIT)).setEnabled(b);
        this.textEditPanel.setEditable(b);
        if (this.currentContentsPanel == this.dtdEditPanel) {
            this.dtdEditorStatusChanged();
        } else if (this.currentContentsPanel == this.textEditPanel) {
            this.textEditorStatusChanged();
        }
    }

    private void setToolButtonEnabled(String name2, boolean b) {
        JButton bt = (JButton)this.toolButtons.get(name2);
        if (bt != null && bt.isEnabled() != b) {
            bt.setEnabled(b);
        }
    }

    private void setMenuItemEnabled(String name2, boolean b) {
        JMenuItem item = (JMenuItem)this.menuItems.get(name2);
        if (item != null && item.isEnabled() != b) {
            item.setEnabled(b);
        }
    }

    boolean closeFile() {
        if (this.filename == null) {
            return true;
        }
        boolean sv = false;
        if (this.isDTDEditPanel()) {
            if (this.dtdEditPanel.isChanged()) {
                sv = true;
            }
        } else if (this.isTextEditPanel()) {
            sv = true;
        }
        if (sv) {
            int rs = JOptionPane.showConfirmDialog(this, DTDEditorFrame.getMessage("QST_SAVE", this.filename), DTDEditorFrame.getMessage("DLG_CONFIRM"), 1);
            if (rs == 2) {
                return false;
            }
            if (rs == 0 && !this.saveFile()) {
                return false;
            }
        }
        return true;
    }

    private boolean checkFile(File file) {
        if (!file.isFile() || !file.exists()) {
            JOptionPane.showMessageDialog(this, DTDEditorFrame.getMessage("INVALID_FILE"));
            return false;
        }
        return true;
    }

    void newFile() {
        if (!this.closeFile()) {
            return;
        }
        DTDDeclNodeData rootdata = new DTDDeclNodeData("New_DTD_1");
        this.dtdEditPanel.setRootData(rootdata);
        this.dtdEditPanel.setDTD(null);
        this.switchViewToDTDEditPanel();
        this.filename = NO_NAMING_FILE;
        this.textEditPanel.setName(rootdata.getNodeName());
        this.textEditPanel.setText("");
        this.textEditPanel.clearChanged();
        this.viewDefaultCursor(" ");
        this.setTitle();
        this.statusChanged();
        this.show();
    }

    void openFile() {
        if (!this.closeFile()) {
            return;
        }
        MyFileFilter filter = new MyFileFilter(new String[]{"dtd"}, "DTD Files");
        File file = this.getOpenFileNameJ(filter, this.filename);
        if (file != null) {
            if (!this.checkFile(file)) {
                return;
            }
            try {
                String s = DTDEditorFrame.toURL(file);
                if (this.loadDTD(s, false)) {
                    this.addRecentFile(s);
                    this.statusChanged();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    void openURL() {
        if (!this.closeFile()) {
            return;
        }
        String rs = JOptionPane.showInputDialog(this, (Object)DTDEditorFrame.getMessage("DLG_NEED_URL"));
        if (rs == null) {
            return;
        }
        rs = rs.trim();
        try {
            URL url = new URL(rs);
            if (url != null) {
                if (this.loadDTD(url.toString(), false)) {
                    this.addRecentFile(rs);
                    this.statusChanged();
                }
                return;
            }
        }
        catch (Exception e1) {
            JOptionPane.showMessageDialog(this, DTDEditorFrame.getMessage("INVALID_URL", rs) + "\n" + e1.getMessage());
            return;
        }
        JOptionPane.showMessageDialog(this, DTDEditorFrame.getMessage("INVALID_URL", rs));
    }

    void openXmlFile() {
        if (!this.closeFile()) {
            return;
        }
        MyFileFilter filter = new MyFileFilter(new String[]{"xml"}, "XML Files");
        File file = this.getOpenFileNameJ(filter, this.filename);
        if (file == null) {
            return;
        }
        if (!this.checkFile(file)) {
            return;
        }
        try {
            this.loadDTD(DTDEditorFrame.toURL(file), true);
            this.statusChanged();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void openXmlUrl() {
        if (!this.closeFile()) {
            return;
        }
        String rs = JOptionPane.showInputDialog(this, (Object)DTDEditorFrame.getMessage("DLG_NEED_URL"));
        if (rs == null) {
            return;
        }
        if ((rs = rs.trim()).length() > 7 && rs.substring(0, 7).toLowerCase().equals("http://")) {
            try {
                URL url = new URL(rs);
                if (url != null) {
                    this.loadDTD(url.toString(), true);
                    this.statusChanged();
                }
            }
            catch (Exception e1) {
                JOptionPane.showMessageDialog(this, DTDEditorFrame.getMessage("INVALID_URL", rs) + "\n" + e1.getMessage());
                return;
            }
        }
    }

    boolean loadDTD(String address, boolean byXML) {
        this.filename = byXML ? NO_NAMING_FILE : address;
        this.viewWaitCursor(DTDEditorFrame.getMessage("ST_LODING", address));
        DTDDocument dtd = new DTDDocument();
        try {
            String dtdname;
            if (byXML) {
                dtd.loadByXML(address);
            } else {
                dtd.load(address);
            }
            int k = this.filename.lastIndexOf("\\");
            if (k < 0) {
                k = this.filename.lastIndexOf("/");
            }
            if ((k = (dtdname = k > 0 ? this.filename.substring(k + 1) : this.filename).lastIndexOf(".")) > 0) {
                dtdname = dtdname.substring(0, k);
            }
            DTDDeclNodeData rootdata = new DTDDeclNodeData(dtdname, dtd);
            this.dtdEditPanel.setRootData(rootdata);
            this.dtdEditPanel.setDTD(dtd);
            this.textEditPanel.setName(rootdata.getNodeName());
            this.textEditPanel.setText(dtd.toString());
            this.textEditPanel.clearChanged();
            this.switchViewToDTDEditPanel();
            this.setTitle();
            this.show();
            this.viewDefaultCursor(DTDEditorFrame.getMessage("ST_EDITING", address));
            return true;
        }
        catch (IOException e) {
            this.filename = null;
            this.textEditPanel.setText("");
            this.switchViewToTextEditPanel();
            this.setTitle();
            this.show();
            String s = DTDEditorFrame.getMessage("ST_CANT_LODE", address);
            JOptionPane.showMessageDialog(this, s + "\n" + e.getMessage());
            this.viewDefaultCursor(s);
            return false;
        }
        catch (SAXException e) {
            if (!byXML) {
                try {
                    XReader in = XReader.createReader(new InputSource(address));
                    this.textEditPanel.setText(in);
                }
                catch (IOException e1) {
                    this.filename = null;
                    this.textEditPanel.setText("");
                }
            } else {
                this.filename = null;
                this.textEditPanel.setText("");
            }
            this.textEditPanel.changeContents();
            this.switchViewToTextEditPanel();
            this.setTitle();
            this.show();
            if (e instanceof SAXParseException) {
                SAXParseException e1 = (SAXParseException)e;
                this.textEditPanel.selectLine(e1.getLineNumber());
                String s = e1.getSystemId() + " <" + e1.getLineNumber() + ">\n" + e1.getMessage();
                this.getToolkit().beep();
                this.statusBar.setStatusText(s);
                JOptionPane.showMessageDialog(this, s);
            } else {
                this.getToolkit().beep();
                this.statusBar.setStatusText(e.getMessage());
                JOptionPane.showMessageDialog(this, e.getMessage());
            }
            this.viewDefaultCursor("");
            return true;
        }
    }

    private void setTitle() {
        if (this.filename == null) {
            this.setTitle("Visual DTD Editor ");
        } else {
            this.setTitle("Visual DTD Editor -- " + this.filename);
        }
    }

    private void clearChanged() {
        this.dtdEditPanel.clearChanged();
        this.textEditPanel.clearChanged();
    }

    boolean saveFile(File file) {
        XReader dr = null;
        DTDDecl dtd = null;
        try {
            String s;
            if (this.isDTDEditPanel()) {
                dtd = this.dtdEditPanel.getDTD();
                this.textEditPanel.setText(dtd.toString());
                s = dtd.getNodeName();
                if (s != null) {
                    this.textEditPanel.setName(s);
                }
                this.textEditPanel.clearChanged();
            } else if (this.isTextEditPanel()) {
                s = this.textEditPanel.getText();
                dr = XReader.createReader(s.toCharArray(), null);
                DTDDocument dtd1 = new DTDDocument(this.textEditPanel.getName());
                dtd1.parseDTDDecl(dr);
                DTDDeclNodeData rootdata = new DTDDeclNodeData(dtd);
                this.dtdEditPanel.setRootData(rootdata);
                this.dtdEditPanel.setDTD(dtd1);
                this.dtdEditPanel.clearChanged();
                dtd = dtd1;
            } else {
                dtd = this.dtdEditPanel.getDTD();
            }
        }
        catch (SAXException e) {
            if (this.isTextEditPanel()) {
                this.textEditPanel.selectLine(dr.getLineNumber());
            } else if (this.isDTDEditPanel()) {
                this.dtdEditPanel.selectToErrorNode();
            }
            String s = e.getMessage() + "\n" + DTDEditorFrame.getMessage("QST_NOSAVE");
            this.getToolkit().beep();
            this.statusBar.setStatusText(s);
            int rs = JOptionPane.showConfirmDialog(this, s, DTDEditorFrame.getMessage("DLG_CONFIRM"), 0);
            return rs != 1;
        }
        try {
            if (dtd != null) {
                dtd.save(file.getPath());
            }
            this.textEditPanel.clearChanged();
            this.dtdEditPanel.clearChanged();
        }
        catch (IOException e) {
            String s = DTDEditorFrame.getMessage("SAVE_ERR") + ":" + e.getMessage() + "\n" + DTDEditorFrame.getMessage("QST_NOSAVE");
            this.getToolkit().beep();
            this.statusBar.setStatusText(s);
            int rs = JOptionPane.showConfirmDialog(this, s, DTDEditorFrame.getMessage("DLG_CONFIRM"), 0);
            return rs != 1;
        }
        return true;
    }

    boolean saveFile(String encoding, String text, File file) throws IOException {
        OutputStreamWriter writer = null;
        if (encoding != null) {
            encoding = MIME2Java.convert(encoding);
        }
        try {
            CharsetEncoder ce = Charset.forName(encoding).newEncoder();
            writer = encoding == null ? new OutputStreamWriter(new FileOutputStream(file)) : new OutputStreamWriter((OutputStream)new FileOutputStream(file), encoding);
            writer.write(text);
            writer.close();
        }
        catch (IllegalArgumentException e) {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new IOException(e.getMessage() + "\n " + DTDEditorFrame.getMessage("INVALID_ENCODING", encoding));
        }
        catch (IOException e) {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
        return true;
    }

    boolean saveFile() {
        if (this.filename == null) {
            return true;
        }
        if (this.filename.equals(NO_NAMING_FILE)) {
            return this.saveFileAs();
        }
        if (this.filename.length() > 7 && this.filename.substring(0, 7).toLowerCase().equals("http://")) {
            return this.saveFileAs();
        }
        String s = this.filename.startsWith("file:/") ? this.filename.substring(6) : this.filename;
        File file = new File(s);
        if (file.isFile()) {
            return this.saveFile(file);
        }
        return this.saveFileAs();
    }

    boolean saveFileAs() {
        int rs;
        MyFileFilter filter = new MyFileFilter(new String[]{"dtd"}, "DTD Files");
        File file = this.getSaveFileNameJ(filter, this.filename);
        if (file == null) {
            return false;
        }
        String s = file.getPath();
        if (s.indexOf(".") <= 0) {
            file = new File(s + ".dtd");
        }
        if (file.isDirectory()) {
            JOptionPane.showMessageDialog(this, DTDEditorFrame.getMessage("INVALID_FILE", file.getPath()));
            return false;
        }
        if (file.exists() && (rs = JOptionPane.showConfirmDialog(this, s = DTDEditorFrame.getMessage("QST_SAVEOVER", file.getPath()), DTDEditorFrame.getMessage("DLG_CONFIRM"), 0)) == 1) {
            return false;
        }
        if (this.saveFile(file)) {
            this.filename = DTDEditorFrame.toURL(file);
            this.setTitle();
            if (!this.isInteralEditor) {
                this.addRecentFile(this.filename);
            }
            this.viewDefaultCursor(DTDEditorFrame.getMessage("ST_EDITING", this.filename));
            return true;
        }
        return false;
    }

    public static String toURL(File file) {
        String path = file.getAbsolutePath();
        if (File.separatorChar != '/') {
            path = path.replace(File.separatorChar, '/');
        }
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        if (!path.endsWith("/") && file.isDirectory()) {
            path = path + "/";
        }
        return "file:" + path;
    }

    private void openRecentFile(ActionEvent e) {
        JMenuItem item = (JMenuItem)e.getSource();
        String text = item.getText();
        if (text == null) {
            return;
        }
        if (text.equalsIgnoreCase(this.filename)) {
            return;
        }
        try {
            URL url = new URL(text);
            text = url.toString();
        }
        catch (IOException e1) {
            File file = new File(text);
            text = DTDEditorFrame.toURL(file);
        }
        if (!this.closeFile()) {
            return;
        }
        try {
            this.loadDTD(text, false);
            this.statusChanged();
        }
        catch (Exception e1) {
            JOptionPane.showMessageDialog(this, DTDEditorFrame.getMessage("INVALID_URL", text) + "\n" + e1.getMessage());
            this.fileMenu.remove(item);
        }
    }

    private void viewStructPanel() {
        JMenuItem viewStructItem = (JMenuItem)this.menuItems.get(CMD_VIEW_DTDSTRUCT);
        if (!viewStructItem.isSelected()) {
            viewStructItem.setSelected(true);
            return;
        }
        if (this.currentContentsPanel == this.structViewPanel) {
            return;
        }
        this.viewWaitCursor(DTDEditorFrame.getMessage("ST_STR_VIEWING"));
        DTDDecl dtd = this.saveDTDtoEachEditor();
        if (dtd == null) {
            viewStructItem.setSelected(false);
            this.viewDefaultCursor("");
            return;
        }
        DTDDeclNodeData rootdata = new DTDDeclNodeData("Elements");
        this.structViewPanel.setRootData(rootdata);
        this.structViewPanel.setDTD(dtd);
        this.switchViewToDTDStructPanel();
        this.statusChanged();
        this.viewDefaultCursor("");
        this.show();
    }

    private void viewTextEditPanel() {
        JMenuItem viewTextEditItem = (JMenuItem)this.menuItems.get(CMD_VIEW_TEXTEDIT);
        if (!viewTextEditItem.isSelected()) {
            viewTextEditItem.setSelected(true);
            return;
        }
        if (this.currentContentsPanel == this.textEditPanel) {
            return;
        }
        this.viewWaitCursor(DTDEditorFrame.getMessage("ST_TEXT_VIEWING"));
        if (this.currentContentsPanel == this.dtdEditPanel && this.dtdEditPanel.isChanged()) {
            DTDDecl dtd = null;
            try {
                dtd = this.dtdEditPanel.getDTD();
            }
            catch (Exception e1) {
                viewTextEditItem.setSelected(false);
                this.dtdEditPanel.selectToErrorNode();
                this.getToolkit().beep();
                this.statusBar.setStatusText(e1.getMessage());
                JOptionPane.showMessageDialog(this.dtdEditPanel, e1.getMessage());
                this.viewDefaultCursor("");
                return;
            }
            if (dtd != null) {
                this.textEditPanel.setText(dtd.toString());
                String s = dtd.getNodeName();
                if (s != null) {
                    this.textEditPanel.setName(s);
                }
            } else {
                this.textEditPanel.setText("");
            }
        }
        this.switchViewToTextEditPanel();
        this.viewDefaultCursor("");
        this.statusChanged();
        this.show();
    }

    private void viewDTDEditPanel() {
        JMenuItem viewDTDEditItem = (JMenuItem)this.menuItems.get(CMD_VIEW_DTDEDIT);
        if (!viewDTDEditItem.isSelected()) {
            viewDTDEditItem.setSelected(true);
            return;
        }
        if (this.currentContentsPanel == this.dtdEditPanel) {
            return;
        }
        this.viewWaitCursor(DTDEditorFrame.getMessage("ST_VDTD_VIEWING"));
        if (this.currentContentsPanel == this.textEditPanel && this.textEditPanel.isChanged()) {
            DTDDocument dtd = this.getDTDFromTextEdit();
            if (dtd != null) {
                DTDDeclNodeData rootdata = new DTDDeclNodeData(dtd);
                this.dtdEditPanel.setRootData(rootdata);
                this.dtdEditPanel.setDTD(dtd);
            } else {
                viewDTDEditItem.setSelected(false);
                this.viewDefaultCursor("");
                return;
            }
        }
        this.switchViewToDTDEditPanel();
        this.viewDefaultCursor("");
        this.statusChanged();
        this.show();
    }

    private void viewToolBar() {
        JMenuItem viewToolBarItem = (JMenuItem)this.menuItems.get(CMD_VIEW_TOOLBAR);
        if (viewToolBarItem.isSelected()) {
            this.getContentPane().add((Component)this.toolBar, "North");
        } else {
            this.getContentPane().remove(this.toolBar);
        }
        this.getContentPane().invalidate();
        this.getContentPane().repaint();
        this.statusChanged();
        this.show();
    }

    private void viewStatusBar() {
        JMenuItem viewStatusBarItem = (JMenuItem)this.menuItems.get(CMD_VIEW_STATUSBAR);
        if (viewStatusBarItem.isSelected()) {
            this.getContentPane().add((Component)this.statusBar, "South");
        } else {
            this.getContentPane().remove(this.statusBar);
        }
        this.getContentPane().invalidate();
        this.getContentPane().repaint();
        this.statusChanged();
        this.show();
    }

    private DTDDecl saveDTDtoEachEditor() {
        if (this.currentContentsPanel == this.textEditPanel) {
            String s = this.textEditPanel.getText();
            String sn = this.textEditPanel.getName();
            XReader reader = XReader.createReader(s.toCharArray(), null);
            DTDDocument dtd = new DTDDocument(sn, this.filename);
            try {
                dtd.parseDTDDecl(reader);
                if (this.textEditPanel.isChanged()) {
                    DTDDeclNodeData rootdata = new DTDDeclNodeData(dtd);
                    this.dtdEditPanel.setRootData(rootdata);
                    this.dtdEditPanel.setDTD(dtd);
                }
                return dtd;
            }
            catch (Exception e1) {
                this.textEditPanel.selectLine(reader.getLineNumber());
                this.getToolkit().beep();
                this.statusBar.setStatusText(e1.getMessage());
                JOptionPane.showMessageDialog(this.textEditPanel, e1.getMessage());
                return null;
            }
        }
        if (this.currentContentsPanel == this.dtdEditPanel) {
            DTDDecl dtd = null;
            try {
                dtd = this.dtdEditPanel.getDTD();
                dtd.setURL(this.filename);
            }
            catch (Exception e) {
                this.dtdEditPanel.selectToErrorNode();
                this.getToolkit().beep();
                this.statusBar.setStatusText(e.getMessage());
                JOptionPane.showMessageDialog(this.dtdEditPanel, e.getMessage());
                return null;
            }
            if (this.dtdEditPanel.isChanged()) {
                if (dtd != null) {
                    this.textEditPanel.setText(dtd.toString());
                    String s = dtd.getNodeName();
                    if (s != null) {
                        this.textEditPanel.setName(s);
                    }
                } else {
                    this.textEditPanel.setText("");
                }
            }
            return dtd;
        }
        return null;
    }

    private DTDDocument getDTDFromTextEdit() {
        String s = this.textEditPanel.getText();
        String sn = this.textEditPanel.getName();
        XReader reader = XReader.createReader(s.toCharArray(), null);
        DTDDocument dtd = new DTDDocument(sn, this.filename);
        try {
            dtd.parseDTDDecl(reader);
            return dtd;
        }
        catch (Exception e1) {
            this.textEditPanel.selectLine(reader.getLineNumber());
            this.getToolkit().beep();
            this.statusBar.setStatusText(e1.getMessage());
            JOptionPane.showMessageDialog(this.textEditPanel, e1.getMessage());
            return null;
        }
    }

    String getAbsoluteFileName(String oldfilename) {
        int k;
        String path = null;
        if (this.filename != null) {
            int k1 = this.filename.lastIndexOf("/");
            if (k1 < 0) {
                k1 = this.filename.lastIndexOf("\\");
            }
            if (k1 > 0) {
                path = this.filename.substring(0, k1 + 1);
            }
        }
        if ((k = oldfilename.indexOf(":")) < 0 && path != null) {
            return path + oldfilename;
        }
        return oldfilename;
    }

    String getFileName() {
        return this.filename;
    }

    String searchFileName(String oldfilename) {
        String path = null;
        if (this.filename != null) {
            int k1 = this.filename.lastIndexOf("/");
            if (k1 < 0) {
                k1 = this.filename.lastIndexOf("\\");
            }
            if (k1 > 0) {
                path = this.filename.substring(0, k1 + 1);
            }
        } else {
            JOptionPane.showMessageDialog(this, DTDEditorFrame.getMessage("WAR_SAVE_BEFORE"));
            return "";
        }
        int k = oldfilename.indexOf(":");
        if (k < 0 && path != null) {
            oldfilename = path + oldfilename;
        }
        MyFileFilter filter = new MyFileFilter(new String[]{"dtd"}, "DTD Files");
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setMultiSelectionEnabled(false);
        fileChooser.setDialogTitle(DTDEditorFrame.getMessage("DLG_DTD_OPEN"));
        fileChooser.addChoosableFileFilter(filter);
        fileChooser.setFileFilter(filter);
        fileChooser.setPreferredSize(new Dimension(500, 260));
        try {
            File file = new File(oldfilename);
            fileChooser.setCurrentDirectory(file);
            fileChooser.setSelectedFile(file);
        }
        catch (Exception file) {
            // empty catch block
        }
        int result = fileChooser.showOpenDialog(this);
        if (result != 0) {
            return null;
        }
        File file = fileChooser.getSelectedFile();
        String newfilename = file.getPath();
        File file1 = new File(this.filename);
        if (file1.getPath().equalsIgnoreCase(newfilename)) {
            JOptionPane.showMessageDialog(this, DTDEditorFrame.getMessage("WAR_CANT_REF_OWN"));
            return "";
        }
        if (path != null) {
            String newpath;
            int k1 = newfilename.lastIndexOf("/");
            if (k1 < 0) {
                k1 = newfilename.lastIndexOf("\\");
            }
            if (k1 > 0 && (newpath = newfilename.substring(0, k1 + 1)).equalsIgnoreCase(path)) {
                return newfilename.substring(k1 + 1);
            }
        }
        return newfilename;
    }

    File getOpenFileNameJ(FileFilter filter, String filename) {
        File file;
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setMultiSelectionEnabled(false);
        fileChooser.setDialogTitle(DTDEditorFrame.getMessage("DLG_DTD_OPEN"));
        fileChooser.addChoosableFileFilter(filter);
        fileChooser.setFileFilter(filter);
        fileChooser.setPreferredSize(new Dimension(500, 260));
        if (filename != null && !NO_NAMING_FILE.equals(filename)) {
            try {
                String s = filename.startsWith("file:/") ? filename.substring(6) : filename;
                file = new File(s);
                fileChooser.setCurrentDirectory(file);
                fileChooser.setSelectedFile(file);
            }
            catch (Exception s) {}
        } else {
            try {
                File file2 = new File(SAMPLES_DIR);
                fileChooser.setCurrentDirectory(file2);
            }
            catch (Exception file2) {
                // empty catch block
            }
        }
        int result = fileChooser.showOpenDialog(this);
        if (result != 0) {
            return null;
        }
        file = fileChooser.getSelectedFile();
        if (!file.exists()) {
            return null;
        }
        return file;
    }

    File getSaveFileNameJ(FileFilter filter, String filename) {
        File file;
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setMultiSelectionEnabled(false);
        fileChooser.setDialogTitle(DTDEditorFrame.getMessage("DLG_DTD_SAVE"));
        if (filename != null && !NO_NAMING_FILE.equals(filename)) {
            try {
                String s = filename.startsWith("file:/") ? filename.substring(6) : filename;
                file = new File(s);
                fileChooser.setCurrentDirectory(file);
                fileChooser.setSelectedFile(file);
            }
            catch (Exception s) {}
        } else {
            try {
                File file2 = new File(SAMPLES_DIR);
                fileChooser.setCurrentDirectory(file2);
            }
            catch (Exception file2) {
                // empty catch block
            }
        }
        fileChooser.addChoosableFileFilter(filter);
        fileChooser.setFileFilter(filter);
        fileChooser.setPreferredSize(new Dimension(500, 260));
        int result = fileChooser.showSaveDialog(this);
        if (result != 0) {
            return null;
        }
        file = fileChooser.getSelectedFile();
        return file;
    }

    void addRecentFile(String name2) {
        JPopupMenu pop = this.fileMenu.getPopupMenu();
        int n = pop.getComponentCount();
        for (int i = this.recentFilepos; i < n; ++i) {
            String s;
            Component c = pop.getComponent(i);
            if (!(c instanceof JMenuItem) || (s = ((JMenuItem)c).getText()) == null || !s.equalsIgnoreCase(name2)) continue;
            pop.remove(c);
            break;
        }
        JMenuItem item = new JMenuItem(name2);
        pop.insert(item, this.recentFilepos);
        Font font = new Font(this.fileMenu.getFont().getName(), 0, 12);
        item.setFont(font);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DTDEditorFrame.this.openRecentFile(e);
            }
        });
    }

    JMenuBar createMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        Font font1 = menuBar.getFont();
        Font font = new Font(font1.getName(), 0, 12);
        menuBar.setAlignmentX(0.0f);
        menuBar.setAlignmentY(0.0f);
        this.fileMenu = this.isInteralEditor ? this.creatMenu(DTDEditorFrame.getMessage("MENU_FILE") + "(F)", fileMenus1) : this.creatMenu("\u30d5\u30a1\u30a4\u30eb(F)", fileMenus);
        this.fileMenu.setMnemonic('F');
        menuBar.add(this.fileMenu);
        this.recentFilepos = this.fileMenu.getItemCount() - 2;
        this.dtdEditMenu = this.creatMenu(DTDEditorFrame.getMessage("MENU_EDIT") + "(E)", dtdEditMenus);
        this.dtdEditMenu.setMnemonic('E');
        this.textEditMenu = this.creatMenu(DTDEditorFrame.getMessage("MENU_EDIT") + "(E)", textEditMenus);
        this.textEditMenu.setMnemonic('E');
        this.structEditMenu = this.creatMenu(DTDEditorFrame.getMessage("MENU_EDIT") + "(E)", structViewEditMenus);
        this.structEditMenu.setMnemonic('E');
        JMenu viewMenu = this.creatMenu(DTDEditorFrame.getMessage("MENU_VIEW") + "(V)", viewMenus);
        viewMenu.setMnemonic('V');
        menuBar.add(viewMenu);
        JMenu helpMenu = this.creatMenu(DTDEditorFrame.getMessage("MENU_HELP") + "(H)", helpMenus);
        helpMenu.setMnemonic('H');
        menuBar.add(helpMenu);
        return menuBar;
    }

    private JMenu creatMenu(String menuName, String[][] items) {
        JMenu menu = new JMenu(menuName);
        Font font1 = menu.getFont();
        Font font = new Font(font1.getName(), 0, 12);
        menu.setFont(font);
        for (int i = 0; i < items.length; ++i) {
            String itemname = items[i][0];
            if (itemname.equals("-")) {
                menu.addSeparator();
                continue;
            }
            Action act = (Action)this.actions.get(itemname);
            String dec = (String)act.getValue("ShortDescription");
            if (items[i][1] != null && dec.indexOf(items[i][1]) < 0) {
                dec = dec + "(" + items[i][1] + ")";
            }
            JMenuItem menuItem = items[i][2] == null ? new JMenuItem(dec) : new JCheckBoxMenuItem(dec);
            menu.add(menuItem);
            ImageIcon icon = (ImageIcon)act.getValue("SmallIcon");
            if (icon != null) {
                menuItem.setIcon(icon);
                menuItem.setHorizontalTextPosition(4);
            }
            menuItem.addActionListener(act);
            if (items[i][1] != null) {
                menuItem.setMnemonic(items[i][1].charAt(0));
            }
            if (items[i][2] != null) {
                menuItem.setSelected(items[i][2].equals("Y"));
            }
            if (items[i][3] != null) {
                try {
                    String s = items[i][3];
                    int k = s.indexOf(":");
                    if (k >= 0) {
                        int mask = Integer.parseInt(s.substring(0, k));
                        int keyid = Integer.parseInt(s.substring(k + 1));
                        menuItem.setAccelerator(KeyStroke.getKeyStroke(keyid, mask));
                    } else {
                        int keyid = Integer.parseInt(s);
                        menuItem.setAccelerator(KeyStroke.getKeyStroke(keyid, 0));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            menuItem.setFont(font);
            this.menuItems.put(itemname, menuItem);
        }
        return menu;
    }

    private JToolBar createToolbar(String[] names) {
        JToolBar toolbar = new JToolBar();
        toolbar.setMargin(new Insets(0, 0, 0, 0));
        toolbar.setFloatable(false);
        int n = names.length;
        for (int i = 0; i < n; ++i) {
            if (names[i].equals("-")) {
                toolbar.addSeparator();
                continue;
            }
            Action act = (Action)this.actions.get(names[i]);
            if (act == null) continue;
            ImageIcon icon = (ImageIcon)act.getValue("SmallIcon");
            JButton bt = new JButton((Icon)icon){

                @Override
                public float getAlignmentY() {
                    return 0.5f;
                }
            };
            bt.setRequestFocusEnabled(false);
            bt.setMargin(new Insets(1, 1, 1, 1));
            bt.setName(names[i]);
            bt.setToolTipText((String)act.getValue("ShortDescription"));
            bt.addActionListener(act);
            toolbar.add(bt);
            this.toolButtons.put(names[i], bt);
        }
        return toolbar;
    }

    void viewWaitCursor(String msg) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        if (this.statusBar != null) {
            if (msg != null && msg.length() > 0) {
                this.statusBar.setStatusText(msg);
            } else {
                this.statusBar.setStatusText("   ");
            }
            this.statusBar.repaint();
        }
    }

    void viewDefaultCursor(String msg) {
        this.setCursor(Cursor.getPredefinedCursor(0));
        if (this.statusBar != null) {
            if (msg != null && msg.length() > 0) {
                this.statusBar.setStatusText(msg);
            } else {
                this.statusBar.setStatusText("   ");
            }
            this.statusBar.repaint();
        }
    }

    private void registActions() {
        MyAction a = new MyAction(CMD_NEW_FILE, DTDEditorFrame.getMessage("CMD_NEW_FILE"), (Icon)DTDEditorFrame.loadImage("new")){

            @Override
            public void actionPerformed(ActionEvent e) {
                DTDEditorFrame.this.newFile();
            }
        };
        this.actions.put(CMD_NEW_FILE, a);
        a = new MyAction(CMD_OPEN_FILE, DTDEditorFrame.getMessage("CMD_OPEN_FILE"), (Icon)DTDEditorFrame.loadImage("open")){

            @Override
            public void actionPerformed(ActionEvent e) {
                DTDEditorFrame.this.openFile();
            }
        };
        this.actions.put(CMD_OPEN_FILE, a);
        a = new MyAction(CMD_SAVE_FILE, DTDEditorFrame.getMessage("CMD_SAVE_FILE"), (Icon)DTDEditorFrame.loadImage("save")){

            @Override
            public void actionPerformed(ActionEvent e) {
                DTDEditorFrame.this.saveFile();
            }
        };
        this.actions.put(CMD_SAVE_FILE, a);
        a = new MyAction(CMD_SAVEAS_FILE, DTDEditorFrame.getMessage("CMD_SAVEAS_FILE")){

            @Override
            public void actionPerformed(ActionEvent e) {
                DTDEditorFrame.this.saveFileAs();
            }
        };
        this.actions.put(CMD_SAVEAS_FILE, a);
        a = new MyAction(CMD_OPEN_URL, DTDEditorFrame.getMessage("CMD_OPEN_URL")){

            @Override
            public void actionPerformed(ActionEvent e) {
                DTDEditorFrame.this.openURL();
            }
        };
        this.actions.put(CMD_OPEN_URL, a);
        a = new MyAction(CMD_OPEN_XML, DTDEditorFrame.getMessage("CMD_OPEN_XML")){

            @Override
            public void actionPerformed(ActionEvent e) {
                DTDEditorFrame.this.openXmlFile();
            }
        };
        this.actions.put(CMD_OPEN_XML, a);
        a = new MyAction(CMD_OPEN_XMLURL, DTDEditorFrame.getMessage("CMD_OPEN_XMLURL")){

            @Override
            public void actionPerformed(ActionEvent e) {
                DTDEditorFrame.this.openXmlUrl();
            }
        };
        this.actions.put(CMD_OPEN_XMLURL, a);
        a = new MyAction(CMD_EXIT, DTDEditorFrame.getMessage("CMD_EXIT")){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DTDEditorFrame.this.closedWindow()) {
                    System.exit(0);
                }
            }
        };
        this.actions.put(CMD_EXIT, a);
        this.actions.put("UNDO", this.textEditPanel.getAction("UNDO"));
        this.actions.put("REDO", this.textEditPanel.getAction("REDO"));
        this.actions.put("CUT", this.textEditPanel.getAction("CUT"));
        this.actions.put("COPY", this.textEditPanel.getAction("COPY"));
        this.actions.put("PASTE", this.textEditPanel.getAction("PASTE"));
        this.actions.put("DELETE", this.textEditPanel.getAction("DELETE"));
        this.actions.put("SELECTALL", this.textEditPanel.getAction("SELECTALL"));
        this.actions.put("FINDTEXT", this.textEditPanel.getAction("FINDTEXT"));
        this.actions.put("REFINDTEXT", this.textEditPanel.getAction("REFINDTEXT"));
        this.actions.put("ELEMENT", this.dtdEditPanel.getAction("ELEMENT"));
        this.actions.put("SUBELEMENT", this.dtdEditPanel.getAction("SUBELEMENT"));
        this.actions.put("ATTDEF", this.dtdEditPanel.getAction("ATTDEF"));
        this.actions.put("ENTITY", this.dtdEditPanel.getAction("ENTITY"));
        this.actions.put("NOTATION", this.dtdEditPanel.getAction("NOTATION"));
        this.actions.put("COMMENT", this.dtdEditPanel.getAction("COMMENT"));
        this.actions.put("PI", this.dtdEditPanel.getAction("PI"));
        this.actions.put("PEREF", this.dtdEditPanel.getAction("PEREF"));
        this.actions.put("NODECOPY", this.dtdEditPanel.getAction("NODECOPY"));
        this.actions.put("REMOVE", this.dtdEditPanel.getAction("REMOVE"));
        this.actions.put("TOUP", this.dtdEditPanel.getAction("TOUP"));
        this.actions.put("TODOWN", this.dtdEditPanel.getAction("TODOWN"));
        this.actions.put("FINDNODE", this.dtdEditPanel.getAction("FINDNODE"));
        this.actions.put("REFINDNODE", this.dtdEditPanel.getAction("REFINDNODE"));
        this.actions.put("FINDTREENODE", this.structViewPanel.getAction("FINDTREENODE"));
        this.actions.put("REFINDTREENODE", this.structViewPanel.getAction("REFINDTREENODE"));
        a = new MyAction(CMD_VIEW_DTDEDIT, DTDEditorFrame.getMessage("CMD_VIEW_DTDEDIT")){

            @Override
            public void actionPerformed(ActionEvent e) {
                DTDEditorFrame.this.viewDTDEditPanel();
            }
        };
        this.actions.put(CMD_VIEW_DTDEDIT, a);
        a = new MyAction(CMD_VIEW_TEXTEDIT, DTDEditorFrame.getMessage("CMD_VIEW_TEXTEDIT")){

            @Override
            public void actionPerformed(ActionEvent e) {
                DTDEditorFrame.this.viewTextEditPanel();
            }
        };
        this.actions.put(CMD_VIEW_TEXTEDIT, a);
        a = new MyAction(CMD_VIEW_DTDSTRUCT, DTDEditorFrame.getMessage("CMD_VIEW_DTDSTRUCT")){

            @Override
            public void actionPerformed(ActionEvent e) {
                DTDEditorFrame.this.viewStructPanel();
            }
        };
        this.actions.put(CMD_VIEW_DTDSTRUCT, a);
        a = new MyAction(CMD_VIEW_TOOLBAR, DTDEditorFrame.getMessage("CMD_VIEW_TOOLBAR")){

            @Override
            public void actionPerformed(ActionEvent e) {
                DTDEditorFrame.this.viewToolBar();
            }
        };
        this.actions.put(CMD_VIEW_TOOLBAR, a);
        a = new MyAction(CMD_VIEW_STATUSBAR, DTDEditorFrame.getMessage("CMD_VIEW_STATUSBAR")){

            @Override
            public void actionPerformed(ActionEvent e) {
                DTDEditorFrame.this.viewStatusBar();
            }
        };
        this.actions.put(CMD_VIEW_STATUSBAR, a);
        a = new MyAction(CMD_VIEW_INFORMATION, DTDEditorFrame.getMessage("CMD_VIEW_INFORMATION")){

            @Override
            public void actionPerformed(ActionEvent e) {
                DTDEditorFrame.this.viewInformation();
            }
        };
        this.actions.put(CMD_VIEW_INFORMATION, a);
    }

    public static void main(String[] args) {
        long diff;
        VersionDialog dlg;
        String vers = System.getProperty("java.version");
        if (vers.compareTo("1.2.2") < 0) {
            JOptionPane.showMessageDialog(new Frame(), DTDEditorFrame.getMessage("WAR_NEED_JDK"));
            System.exit(0);
        }
        DTDEditorFrame frame = new DTDEditorFrame();
        Properties ps = LicenceKeys.ps;
        if (ps == null) {
            String fileName = "license.key";
            File file = new File(USER_DIR, fileName);
            if (!file.isFile() && !(file = LIB_DIR != null ? new File(LIB_DIR, fileName) : new File(new File(USER_DIR, "lib"), fileName)).isFile()) {
                File userdir = new File(System.getProperty("user.dir", "."));
                File parent = userdir.getParentFile();
                if (parent != null) {
                    file = new File(parent, fileName);
                    if (!file.isFile()) {
                        file = new File(userdir, fileName);
                    }
                } else {
                    file = new File(userdir, fileName);
                }
            }
            ps = LicenceKeys.loadKeys(file);
        }
        if (ps == null) {
            System.out.println("Lincense error!");
            JOptionPane.showMessageDialog(frame, DTDEditorFrame.getMessage("WAR_NEED_KEY"));
            System.exit(0);
        }
        USER_KEY = ps.getProperty("USER_KEY");
        COMPANY = ps.getProperty("COMPANY");
        USERNAME = ps.getProperty("USERNAME");
        String s = ps.getProperty("LASTMODIFY");
        if (s != null) {
            try {
                SimpleDateFormat format = new SimpleDateFormat("yyyy/MM/dd");
                LASTMODIFY = format.parse(s, new ParsePosition(0));
            }
            catch (Exception e) {
                LASTMODIFY = null;
            }
        }
        if ((s = ps.getProperty("DTDEDITOR")) == null) {
            VALIDPERIOD = -1;
        } else {
            try {
                VALIDPERIOD = Integer.parseInt(s);
            }
            catch (Exception e) {
                VALIDPERIOD = -1;
            }
        }
        if (USER_KEY == null || COMPANY == null || COMPANY == null || USERNAME == null || LASTMODIFY == null || VALIDPERIOD < 0) {
            System.out.println("Lincense error!");
            JOptionPane.showMessageDialog(frame, DTDEditorFrame.getMessage("WAR_NEED_KEY"));
            System.exit(0);
        }
        ImageIcon img = DTDEditorFrame.loadImage("vdtdInfo");
        frame.infoDlg = dlg = new VersionDialog(frame, false, img);
        dlg.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dlgsize = dlg.getSize();
        dlg.setLocation(screenSize.width / 2 - dlgsize.width / 2, screenSize.height / 2 - dlgsize.width / 2);
        dlg.setVisible(true);
        if (VALIDPERIOD > 0 && (diff = System.currentTimeMillis() - LASTMODIFY.getTime()) > (long)VALIDPERIOD * 24L * 3600000L) {
            JOptionPane.showMessageDialog(frame, DTDEditorFrame.getMessage("WAR_OVER_TEST"));
            dlg.dispose();
            System.exit(0);
        }
        frame.start();
        dlg.modal = true;
        frame.setVisible(true);
        dlg.endDialog();
        while (true) {
            try {
                while (true) {
                    Thread.sleep(1000L);
                }
            }
            catch (Exception exception) {
                continue;
            }
            break;
        }
    }

    static {
        File f;
        String name2;
        File parent;
        File file;
        WIDTH = 790;
        HEIGHT = 550;
        VALIDPERIOD = -1;
        USER_KEY = null;
        VERSION = "2.02";
        COMPANY = null;
        USERNAME = null;
        LASTMODIFY = null;
        fileSeparator = System.getProperty("file.separator", "/");
        URL resource = ClassLoader.getSystemResource("com/argo21/jxp/vdtd/DTDEditorFrame.class");
        if (resource != null) {
            if ("file".equals(resource.getProtocol())) {
                try {
                    USER_DIR = FileEx.urlToFile(new URL(resource, "../../../../"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (USER_DIR != null) {
                    file = new File(USER_DIR);
                    parent = file.getParentFile();
                    name2 = file.getName();
                    if ("out".equals(name2) && parent != null) {
                        USER_DIR = parent.getAbsolutePath();
                    }
                }
            } else if ("jar".equals(resource.getProtocol())) {
                try {
                    JarURLConnection connect = (JarURLConnection)resource.openConnection();
                    LIB_DIR = FileEx.urlToFile(new URL(connect.getJarFileURL(), "./"));
                }
                catch (Exception connect) {
                    // empty catch block
                }
                if (LIB_DIR != null) {
                    USER_DIR = new File(LIB_DIR).getParent();
                }
            }
        }
        if (USER_DIR == null || !new File(USER_DIR).isDirectory()) {
            file = new File(System.getProperty("user.dir", "."));
            parent = file.getParentFile();
            name2 = file.getName();
            USER_DIR = (name2.startsWith("bin") || "src".equals(name2)) && parent != null ? parent.getAbsolutePath() : file.getAbsolutePath();
        }
        if (USER_DIR != null) {
            SAMPLES_DIR = new File(new File(USER_DIR, "samples"), "vdtd").getPath();
        }
        if (!(f = new File(HOME_DIR = System.getProperty("user.home", "."), ".esooner")).exists()) {
            try {
                f.mkdirs();
            }
            catch (Exception e) {
                System.err.println(e);
            }
        }
        File DTDEditorINIfile = new File(f, "DTDEditor.ini");
        DTDEditorINI = DTDEditorINIfile.getPath();
        fileToolBarNames = new String[]{CMD_NEW_FILE, CMD_OPEN_FILE, CMD_SAVE_FILE};
        fileToolBarNames1 = new String[]{CMD_SAVE_FILE};
        textToolBarNames = new String[]{"UNDO", "REDO", "CUT", "COPY", "PASTE", "DELETE", "FINDTEXT"};
        dtdToolBarNames = new String[]{"ELEMENT", "SUBELEMENT", "ATTDEF", "ENTITY", "NOTATION", "PEREF", "COMMENT", "PI", "-", "NODECOPY", "REMOVE", "TOUP", "TODOWN"};
        fileMenus = new String[][]{{CMD_NEW_FILE, "N", null, "2:78"}, {CMD_OPEN_FILE, "O", null, "2:79"}, {CMD_OPEN_URL, "U", null, null}, {"-", null, null, null}, {CMD_OPEN_XML, "X", null, null}, {CMD_OPEN_XMLURL, null, null, null}, {"-", null, null, null}, {CMD_SAVE_FILE, "S", null, "2:83"}, {CMD_SAVEAS_FILE, "A", null, null}, {"-", null, null, null}, {"-", null, null, null}, {CMD_EXIT, "X", null, null}};
        fileMenus1 = new String[][]{{CMD_SAVE_FILE, "S", null, "2:83"}, {"-", null, null, null}, {CMD_EXIT, "X", null, null}};
        textEditMenus = new String[][]{{"UNDO", "U", null, "2:90"}, {"REDO", "R", null, "2:89"}, {"-", null, null, null}, {"CUT", "T", null, "2:88"}, {"COPY", "C", null, "2:155"}, {"PASTE", "P", null, "1:155"}, {"-", null, null, null}, {"FINDTEXT", "F", null, "2:70"}, {"REFINDTEXT", "A", null, String.valueOf(114)}, {"-", null, null, null}, {"SELECTALL", "S", null, "2:65"}, {"-", null, null, null}, {"DELETE", "D", null, String.valueOf(127)}};
        dtdEditMenus = new String[][]{{"ELEMENT", "E", null, null}, {"SUBELEMENT", "S", null, null}, {"ATTDEF", "A", null, null}, {"ENTITY", "T", null, null}, {"NOTATION", "N", null, null}, {"PEREF", "R", null, null}, {"COMMENT", "M", null, null}, {"PI", "P", null, null}, {"-", null, null, null}, {"NODECOPY", "C", null, "2:155"}, {"REMOVE", "D", null, String.valueOf(127)}, {"-", null, null, null}, {"FINDNODE", "F", null, "2:70"}, {"REFINDNODE", "R", null, String.valueOf(114)}, {"-", null, null, null}, {"TOUP", "U", null, null}, {"TODOWN", "W", null, null}};
        structViewEditMenus = new String[][]{{"FINDTREENODE", "F", null, "2:70"}, {"REFINDTREENODE", "R", null, String.valueOf(114)}};
        viewMenus = new String[][]{{CMD_VIEW_DTDEDIT, "D", "N", null}, {CMD_VIEW_TEXTEDIT, "T", "Y", null}, {CMD_VIEW_DTDSTRUCT, "S", "N", null}, {"-", null, null, null}, {CMD_VIEW_TOOLBAR, "T", "Y", null}, {CMD_VIEW_STATUSBAR, "U", "Y", null}};
        helpMenus = new String[][]{{CMD_VIEW_INFORMATION, "V", null, null}};
        NO_NAMING_FILE = DTDEditorFrame.getMessage("NO_NAMING_FILE");
    }

    static class MyFileFilter
    extends FileFilter {
        private String TYPE_UNKNOWN = "Type Unknown";
        private String HIDDEN_FILE = "Hidden File";
        private Hashtable filters = null;
        private String description = null;
        private String fullDescription = null;
        private boolean useExtensionsInDescription = true;

        public MyFileFilter() {
            this((String)null, (String)null);
        }

        public MyFileFilter(String extension) {
            this(extension, null);
        }

        public MyFileFilter(String extension, String description) {
            this(new String[]{extension}, description);
        }

        public MyFileFilter(String[] filters) {
            this(filters, null);
        }

        public MyFileFilter(String[] filters, String description) {
            this.filters = new Hashtable(filters.length);
            for (int i = 0; i < filters.length; ++i) {
                this.addExtension(filters[i]);
            }
            this.setDescription(description);
        }

        @Override
        public boolean accept(File f) {
            if (f != null) {
                if (f.isDirectory()) {
                    return true;
                }
                String extension = this.getExtension(f);
                if (extension != null && this.filters.get(this.getExtension(f)) != null) {
                    return true;
                }
            }
            return false;
        }

        public String getExtension(File f) {
            String filename;
            int i;
            if (f != null && (i = (filename = f.getName()).lastIndexOf(46)) > 0 && i < filename.length() - 1) {
                return filename.substring(i + 1).toLowerCase();
            }
            return null;
        }

        public void addExtension(String extension) {
            if (this.filters == null) {
                this.filters = new Hashtable(5);
            }
            this.filters.put(extension.toLowerCase(), this);
            this.fullDescription = null;
        }

        @Override
        public String getDescription() {
            if (this.fullDescription == null) {
                if (this.description == null || this.isExtensionListInDescription()) {
                    if (this.description != null) {
                        this.fullDescription = this.description;
                    }
                    this.fullDescription = this.fullDescription + " (";
                    Enumeration extensions = this.filters.keys();
                    if (extensions != null) {
                        this.fullDescription = this.fullDescription + "." + (String)extensions.nextElement();
                        while (extensions.hasMoreElements()) {
                            this.fullDescription = this.fullDescription + ", " + (String)extensions.nextElement();
                        }
                    }
                    this.fullDescription = this.fullDescription + ")";
                } else {
                    this.fullDescription = this.description;
                }
            }
            return this.fullDescription;
        }

        public void setDescription(String description) {
            this.description = description;
            this.fullDescription = null;
        }

        public void setExtensionListInDescription(boolean b) {
            this.useExtensionsInDescription = b;
            this.fullDescription = null;
        }

        public boolean isExtensionListInDescription() {
            return this.useExtensionsInDescription;
        }
    }

    static class VersionDialog
    extends JWindow {
        JLabel label;
        boolean modal;

        VersionDialog(Frame owner, boolean modal) {
            this(owner, modal, null);
        }

        VersionDialog(Frame owner, boolean modal, ImageIcon img) {
            super(owner);
            int k;
            this.modal = modal;
            this.setBackground(Color.white);
            this.getContentPane().setLayout(new BorderLayout());
            if (img == null) {
                img = DTDEditorFrame.loadImage("vdtdInfo");
            }
            int w = img.getIconWidth();
            int h = img.getIconHeight();
            this.label = new JLabel(img);
            this.label.setOpaque(false);
            this.label.setBorder(BorderFactory.createEtchedBorder());
            this.getContentPane().add((Component)this.label, "Center");
            this.pack();
            Dimension size = this.label.getSize();
            Font defaultFont = this.getFont();
            int charH = 16;
            int sp = 6;
            try {
                defaultFont = new Font("Dialog", 0, 12);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.label.setLayout(null);
            if (VALIDPERIOD > 0) {
                k = 5;
                String s = USERNAME == null || USERNAME.length() == 0 ? System.getProperty("user.name", "None") : USERNAME;
                JLabel label1 = new JLabel(DTDEditorFrame.getMessage("WAR_USER") + " : " + s, 4);
                label1.setForeground(Color.black);
                label1.setFont(defaultFont);
                this.label.add(label1);
                label1.setBounds(w / 2 - sp, k, w / 2, charH);
                label1.setBackground(Color.white);
                label1.setOpaque(true);
                k += charH;
                label1 = new JLabel(DTDEditorFrame.getMessage("WAR_LIMIT"), 4);
                label1.setForeground(Color.black);
                label1.setFont(defaultFont);
                this.label.add(label1);
                label1.setBounds(w / 2 - sp, k, w / 2, charH);
                label1.setBackground(Color.white);
                label1.setOpaque(true);
                k += charH;
                long diff = System.currentTimeMillis() - LASTMODIFY.getTime();
                diff = diff < 0L ? 0L : (diff /= 86400000L);
                s = DTDEditorFrame.getMessage("WAR_CAN_USE", String.valueOf((long)VALIDPERIOD - diff));
                label1 = new JLabel(s, 4);
                label1.setForeground(Color.black);
                label1.setFont(defaultFont);
                this.label.add(label1);
                label1.setBounds(w / 2 - sp, k, w / 2, charH);
                label1.setBackground(Color.white);
                label1.setOpaque(true);
                k += charH;
            } else {
                k = 5;
                String s = USERNAME == null || USERNAME.length() == 0 ? System.getProperty("user.name", "None") : USERNAME;
                JLabel label1 = new JLabel(DTDEditorFrame.getMessage("WAR_USER") + " : " + s, 4);
                label1.setForeground(Color.black);
                label1.setFont(defaultFont);
                this.label.add(label1);
                label1.setBounds(w / 2 - sp, k, w / 2, charH);
                label1.setBackground(Color.white);
                label1.setOpaque(true);
                k += charH;
                label1 = new JLabel(COMPANY, 4);
                label1.setForeground(Color.black);
                label1.setFont(defaultFont);
                this.label.add(label1);
                label1.setBounds(w / 2 - sp, k, w / 2, charH);
                label1.setBackground(Color.white);
                label1.setOpaque(true);
                k += charH;
                label1 = new JLabel(USER_KEY, 4);
                label1.setForeground(Color.black);
                label1.setFont(defaultFont);
                this.label.add(label1);
                label1.setBounds(w / 2 - sp, k, w / 2, charH);
                label1.setBackground(Color.white);
                label1.setOpaque(true);
            }
            this.label.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (modal) {
                        this.endDialog();
                    }
                }
            });
            JLabel label3 = new JLabel("Version  " + VERSION);
            label3.setForeground(Color.black);
            label3.setFont(defaultFont);
            this.label.add(label3);
            label3.setSize(w / 2, charH);
            label3.setLocation(sp + 2, h - 50);
            label3.setBackground(Color.white);
            label3.setOpaque(true);
            this.label.add(label3);
        }

        @Override
        public void setVisible(boolean b) {
            super.setVisible(b);
            if (!b) {
                return;
            }
            this.toFront();
            this.requestFocus();
        }

        void endDialog() {
            this.setVisible(false);
        }
    }

    static class StatusBar
    extends JPanel {
        protected JLabel text;

        public StatusBar() {
            this.setLayout(new BorderLayout());
            this.text = new JLabel();
            this.add("Center", this.text);
            this.text.setBorder(new BevelBorder(1));
        }

        public void setStatusText(String s) {
            this.text.setText(s);
        }

        public String getStatusText() {
            return this.text.getText();
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
        }
    }

    static class MyAction
    extends AbstractAction {
        MyAction(String name2, String description) {
            super(name2);
            this.putValue("ShortDescription", description);
            this.setEnabled(false);
        }

        MyAction(String name2, String description, Icon icon) {
            super(name2, icon);
            this.putValue("ShortDescription", description);
            this.setEnabled(false);
        }

        MyAction(String name2, String shortdes, String longdes, Icon icon) {
            super(name2, icon);
            this.putValue("ShortDescription", shortdes);
            this.putValue("LongDescription", longdes);
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    }
}

