/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.jxp.vdtd;

import com.argo21.common.gui.FindDialog;
import com.argo21.common.gui.GuiUtils;
import com.argo21.common.gui.ImageLoader;
import com.argo21.common.gui.StatusChangedListener;
import com.argo21.common.io.Debug;
import com.argo21.common.lang.DataTypeDecl;
import com.argo21.common.lang.MessageCatalog;
import com.argo21.jxp.dtd.AttDef;
import com.argo21.jxp.dtd.AttDefNode;
import com.argo21.jxp.dtd.Children;
import com.argo21.jxp.dtd.ChildrenNode;
import com.argo21.jxp.dtd.CommentDecl;
import com.argo21.jxp.dtd.CommentDeclNode;
import com.argo21.jxp.dtd.ContentParticle;
import com.argo21.jxp.dtd.ContentParticleImpl;
import com.argo21.jxp.dtd.DTDDecl;
import com.argo21.jxp.dtd.DTDDocument;
import com.argo21.jxp.dtd.DeclNode;
import com.argo21.jxp.dtd.DeclNodeList;
import com.argo21.jxp.dtd.ElementDecl;
import com.argo21.jxp.dtd.ElementDeclNode;
import com.argo21.jxp.dtd.EntityDecl;
import com.argo21.jxp.dtd.EntityDeclNode;
import com.argo21.jxp.dtd.NotationDecl;
import com.argo21.jxp.dtd.NotationDeclNode;
import com.argo21.jxp.dtd.PERefDecl;
import com.argo21.jxp.dtd.PERefDeclNode;
import com.argo21.jxp.dtd.PIDecl;
import com.argo21.jxp.dtd.PIDeclNode;
import com.argo21.jxp.vdtd.AttDefDeclNodeData;
import com.argo21.jxp.vdtd.ChildrenDeclNodeData;
import com.argo21.jxp.vdtd.ContentsEditPanel;
import com.argo21.jxp.vdtd.CpDeclNodeData;
import com.argo21.jxp.vdtd.DTDDeclNodeData;
import com.argo21.jxp.vdtd.DeclNodeData;
import com.argo21.jxp.vdtd.ElementDeclNodeData;
import com.argo21.jxp.vdtd.EntityDeclNodeData;
import com.argo21.jxp.vdtd.NSDeclNodeData;
import com.argo21.jxp.vdtd.NotationDeclNodeData;
import com.argo21.jxp.vdtd.PERefDeclNodeData;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.xml.sax.SAXException;

public class DTDEditorPanel
extends JSplitPane {
    public static final int CAN_NEW_ELEMENT = 1;
    public static final int CAN_NEW_SUBELEMENT = 2;
    public static final int CAN_NEW_ATTDEF = 4;
    public static final int CAN_NEW_ENTITY = 8;
    public static final int CAN_NEW_NOTATION = 16;
    public static final int CAN_NEW_COMMENT = 32;
    public static final int CAN_NEW_PEREF = 64;
    public static final int CAN_NEW_PI = 128;
    public static final int CAN_NEW_NSDEF = 512;
    public static final int CAN_NODECOPY = 1024;
    public static final int CAN_REMOVE = 2048;
    public static final int CAN_TO_UP = 4096;
    public static final int CAN_TO_DOWN = 8192;
    public static final int CAN_FINDNODE = 16384;
    public static final int CAN_REFINDNODE = 32768;
    public static MessageCatalog msgCatalog;
    static Border defaultBorder;
    private static final int DTD_SELECT_STATUS = 253;
    private static final int CHILDREN_SELECT_STATUS = 2051;
    private static final int ELEMENT_SELECT_STATUS = 3839;
    private static final int CP_SELECT_STATUS = 3079;
    private static final int OTHER_SELECT_STATUS = 3325;
    public static final String CMD_NEW_ELEMENT = "ELEMENT";
    public static final String CMD_NEW_SUBELEMENT = "SUBELEMENT";
    public static final String CMD_NEW_ATTDEF = "ATTDEF";
    public static final String CMD_NEW_NSDEF = "NAMESPACE";
    public static final String CMD_NEW_ENTITY = "ENTITY";
    public static final String CMD_NEW_NOTATION = "NOTATION";
    public static final String CMD_NEW_COMMENT = "COMMENT";
    public static final String CMD_NEW_PEREF = "PEREF";
    public static final String CMD_NEW_PI = "PI";
    public static final String CMD_NODECOPY = "NODECOPY";
    public static final String CMD_REMOVE = "REMOVE";
    public static final String CMD_TO_UP = "TOUP";
    public static final String CMD_TO_DOWN = "TODOWN";
    public static final String CMD_FINDNODE = "FINDNODE";
    public static final String CMD_REFINDNODE = "REFINDNODE";
    protected JTree tree;
    protected JScrollPane treeSp;
    protected JPanel contentsPanel;
    protected DefaultTreeModel treeModel = null;
    protected Hashtable contentsEditPanel = new Hashtable(11);
    protected Vector defaultNodes = new Vector();
    protected Font defaultFont = null;
    protected boolean extendEnabled = false;
    protected boolean peRefEnabled = false;
    protected boolean dtdChanged = false;
    protected boolean disableSelectChange = false;
    protected int status = 0;
    protected boolean hasSetActionStatus = false;
    protected Vector myStatusChangedListener = new Vector(4);
    public static Color SelectedBackgroundColor;
    protected Frame parentFrame = null;
    protected Hashtable actions = new Hashtable(20);
    private String refpath = null;
    private DefaultMutableTreeNode curentSelectedNode = null;
    protected DefaultMutableTreeNode lastErrorNode = null;
    protected boolean isForward = true;
    protected String searchText = "";
    protected boolean ignoreCase = false;
    FindDialog findDialog = null;
    protected Hashtable entityBuff = new Hashtable(23);
    protected DTDDecl tmpdtd = null;
    private boolean dividerInitialed = false;

    public static String getPackageName(Class cls) {
        String classbase = cls.getName();
        int k = classbase.lastIndexOf(".");
        if (k > 0) {
            classbase = classbase.substring(0, k);
        }
        return classbase;
    }

    static PERefDecl createPERefDecl(DTDDecl dtd, DefaultMutableTreeNode treenode) {
        DeclNodeData userobj = (DeclNodeData)treenode.getUserObject();
        String nodename = userobj.getNodeName();
        return new PERefDeclNode(dtd, nodename);
    }

    static EntityDecl createEntityDecl(DTDDecl dtd, DefaultMutableTreeNode treenode) {
        EntityDeclNodeData userobj = (EntityDeclNodeData)treenode.getUserObject();
        int type = userobj.getType();
        if (type == 0) {
            return new EntityDeclNode(dtd, userobj.getNodeName(), userobj.getPeDecl(), (String)userobj.getNodeValue());
        }
        if (type == 1) {
            return new EntityDeclNode(dtd, userobj.getNodeName(), userobj.getPeDecl(), null, userobj.getSystemId(), userobj.getNotationName());
        }
        return new EntityDeclNode(dtd, userobj.getNodeName(), userobj.getPeDecl(), userobj.getPublicId(), userobj.getSystemId(), userobj.getNotationName());
    }

    static NotationDecl createNotationDecl(DTDDecl dtd, DefaultMutableTreeNode treenode) {
        NotationDeclNodeData userobj = (NotationDeclNodeData)treenode.getUserObject();
        int type = userobj.getType();
        if (type == 1) {
            return new NotationDeclNode(dtd, userobj.getNodeName(), null, userobj.getSystemId());
        }
        return new NotationDeclNode(dtd, userobj.getNodeName(), userobj.getPublicId(), userobj.getSystemId());
    }

    static AttDef createAttdef(DTDDecl dtd, DefaultMutableTreeNode treenode) {
        AttDefDeclNodeData userobj = (AttDefDeclNodeData)treenode.getUserObject();
        if (userobj.isEntityRef) {
            return new AttDefNode(dtd, userobj.elementname, userobj.nodename);
        }
        AttDefNode attdef = new AttDefNode(dtd, userobj.elementname, userobj.nodename, userobj.attType, userobj.attDefault);
        if (userobj.dtDecl != null && !userobj.dtDecl.isDefalut()) {
            attdef.setDataTypeDecl(userobj.dtDecl);
        }
        return attdef;
    }

    static ElementDecl createElementDecl(DTDDecl dtd, DefaultMutableTreeNode treenode) {
        ElementDeclNodeData userobj = (ElementDeclNodeData)treenode.getUserObject();
        String nodename = userobj.getNodeName();
        int type = userobj.getType();
        ElementDeclNode elemdecl = null;
        if (userobj.isEntityRef()) {
            String entityname = userobj.getEntityName();
            if (entityname != null) {
                try {
                    elemdecl = new ElementDeclNode(dtd, nodename, entityname);
                }
                catch (Exception exception) {}
            }
        } else if (type == 0 || type == 1) {
            try {
                elemdecl = new ElementDeclNode(dtd, nodename, type);
            }
            catch (Exception entityname) {}
        } else if (type == 2) {
            int n = treenode.getChildCount();
            Vector<String> v = new Vector<String>();
            for (int i = 0; i < n; ++i) {
                DefaultMutableTreeNode subnode = (DefaultMutableTreeNode)treenode.getChildAt(i);
                DeclNodeData userobj1 = (DeclNodeData)subnode.getUserObject();
                String s = userobj1.getNodeName();
                if (userobj1 instanceof CpDeclNodeData && ((CpDeclNodeData)userobj1).isEntity()) {
                    s = "%" + s + ";";
                }
                v.addElement(s);
            }
            try {
                elemdecl = new ElementDeclNode(dtd, nodename, v);
                DataTypeDecl dt = userobj.getDataTypeDecl();
                if (dt != null && elemdecl != null && !dt.isDefalut()) {
                    elemdecl.setDataTypeDecl(dt);
                }
            }
            catch (Exception dt) {}
        } else if (type == 3) {
            DefaultMutableTreeNode subnode = null;
            try {
                subnode = (DefaultMutableTreeNode)treenode.getFirstChild();
            }
            catch (Exception v) {
                // empty catch block
            }
            if (subnode == null) {
                return null;
            }
            Object subuserobj = subnode.getUserObject();
            if (subuserobj instanceof CpDeclNodeData) {
                CpDeclNodeData obj1 = (CpDeclNodeData)subuserobj;
                ContentParticleImpl cp = obj1.isEntity() ? new ContentParticleImpl(obj1.getNodeName()) : new ContentParticleImpl((char)obj1.getOccurrence(), obj1.getNodeName());
                Vector<ContentParticleImpl> v = new Vector<ContentParticleImpl>();
                v.addElement(cp);
                ChildrenNode children = new ChildrenNode(0, '\u0000', v);
                try {
                    elemdecl = new ElementDeclNode(dtd, nodename, children);
                }
                catch (Exception exception) {}
            } else if (subuserobj instanceof ChildrenDeclNodeData) {
                Children children = DTDEditorPanel.createChildrenDecl(subnode);
                if (children == null) {
                    return null;
                }
                try {
                    elemdecl = new ElementDeclNode(dtd, nodename, children);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return elemdecl;
    }

    static Children createChildrenDecl(DefaultMutableTreeNode treenode) {
        ChildrenDeclNodeData declnode = (ChildrenDeclNodeData)treenode.getUserObject();
        ChildrenNode children = null;
        int n = treenode.getChildCount();
        Vector<ContentParticleImpl> v = new Vector<ContentParticleImpl>();
        for (int i = 0; i < n; ++i) {
            ContentParticleImpl cp;
            DefaultMutableTreeNode subnode = (DefaultMutableTreeNode)treenode.getChildAt(i);
            DeclNodeData userobj = (DeclNodeData)subnode.getUserObject();
            if (userobj instanceof CpDeclNodeData) {
                CpDeclNodeData obj1 = (CpDeclNodeData)userobj;
                cp = obj1.isEntity() ? new ContentParticleImpl(obj1.getNodeName()) : new ContentParticleImpl((char)obj1.getOccurrence(), obj1.getNodeName());
                v.addElement(cp);
                continue;
            }
            if (!(userobj instanceof ChildrenDeclNodeData)) continue;
            Children ch = DTDEditorPanel.createChildrenDecl(subnode);
            cp = new ContentParticleImpl('\u0000', ch);
            v.addElement(cp);
        }
        children = new ChildrenNode(declnode.getType(), (char)declnode.getOccurrence(), v);
        return children;
    }

    static void addElementChilden(DefaultMutableTreeNode treeNode, Children childen) {
        ContentParticle cp;
        Vector v = childen.getCPList();
        int n = v.size();
        if (n <= 0) {
            return;
        }
        if (n == 1 && !(cp = (ContentParticle)v.elementAt(0)).hasChildren()) {
            CpDeclNodeData userdata = new CpDeclNodeData(cp);
            treeNode.add(new DefaultMutableTreeNode(userdata));
            return;
        }
        DefaultMutableTreeNode childTreeNode = new DefaultMutableTreeNode(new ChildrenDeclNodeData(childen));
        treeNode.add(childTreeNode);
        for (int i = 0; i < n; ++i) {
            ContentParticle cp2 = (ContentParticle)v.elementAt(i);
            if (cp2.hasChildren()) {
                DTDEditorPanel.addElementChilden(childTreeNode, cp2.getChildren());
                continue;
            }
            CpDeclNodeData userdata = new CpDeclNodeData(cp2);
            childTreeNode.add(new DefaultMutableTreeNode(userdata));
        }
    }

    protected void registContentsEditorPanel() {
        String s = DTDEditorPanel.getPackageName(DTDEditorPanel.class) + ".";
        this.setContentsEditPanel(20, s + "ElementDeclPanel");
        this.setContentsEditPanel(30, s + "ChildrenDeclPanel");
        this.setContentsEditPanel(31, s + "CpDeclPanel");
        this.setContentsEditPanel(22, s + "AttDefDeclPanel");
        this.setContentsEditPanel(8, s + "CommentDeclPanel");
        this.setContentsEditPanel(25, s + "NSDeclPanel");
        this.setContentsEditPanel(7, s + "PIDeclPanel");
        this.setContentsEditPanel(27, s + "DTDDeclPanel");
        this.setContentsEditPanel(28, s + "PERefDeclPanel");
        this.setContentsEditPanel(6, s + "EntityDeclPanel");
        this.setContentsEditPanel(12, s + "NotationDeclPanel");
        this.setContentsEditPanel(32, s + "DataTypeDeclPanel");
    }

    protected void registAction() {
        MyAction a = new MyAction(CMD_NEW_ELEMENT, "CMD_NEW_ELEMENT", ImageLoader.load("element.gif", "EL")){

            @Override
            public void actionPerformed(ActionEvent e) {
                DTDEditorPanel.this.addNewElementDeclNode();
            }
        };
        this.actions.put(CMD_NEW_ELEMENT, a);
        a = new MyAction(CMD_NEW_SUBELEMENT, "CMD_NEW_SUBELEMENT", this.loadImage("subelement")){

            @Override
            public void actionPerformed(ActionEvent e) {
                DTDEditorPanel.this.addNewSubElementDeclNode();
            }
        };
        this.actions.put(CMD_NEW_SUBELEMENT, a);
        a = new MyAction(CMD_NEW_ATTDEF, "CMD_NEW_ATTDEF", ImageLoader.load("attr.gif", "AT")){

            @Override
            public void actionPerformed(ActionEvent e) {
                DTDEditorPanel.this.addNewAttDefDeclNode();
            }
        };
        this.actions.put(CMD_NEW_ATTDEF, a);
        a = new MyAction(CMD_NEW_ENTITY, "CMD_NEW_ENTITY", ImageLoader.load("entity.gif", CMD_NEW_ENTITY)){

            @Override
            public void actionPerformed(ActionEvent e) {
                DTDEditorPanel.this.addNewEntityDeclNode();
            }
        };
        this.actions.put(CMD_NEW_ENTITY, a);
        a = new MyAction(CMD_NEW_NOTATION, "CMD_NEW_NOTATION", ImageLoader.load("notation.gif", CMD_NEW_NOTATION)){

            @Override
            public void actionPerformed(ActionEvent e) {
                DTDEditorPanel.this.addNewNotationDeclNode();
            }
        };
        this.actions.put(CMD_NEW_NOTATION, a);
        a = new MyAction(CMD_NEW_COMMENT, "CMD_NEW_COMMENT", ImageLoader.load("comment.gif", CMD_NEW_COMMENT)){

            @Override
            public void actionPerformed(ActionEvent e) {
                DTDEditorPanel.this.addNewCommentDeclNode();
            }
        };
        this.actions.put(CMD_NEW_COMMENT, a);
        a = new MyAction(CMD_NEW_PI, "CMD_NEW_PI", ImageLoader.load("pi.gif", CMD_NEW_PI)){

            @Override
            public void actionPerformed(ActionEvent e) {
                DTDEditorPanel.this.addNewPIDeclNode();
            }
        };
        this.actions.put(CMD_NEW_PI, a);
        a = new MyAction(CMD_NEW_PEREF, "CMD_NEW_PEREF", ImageLoader.load("peref.gif", CMD_NEW_PEREF)){

            @Override
            public void actionPerformed(ActionEvent e) {
                DTDEditorPanel.this.addNewPERefDeclNode();
            }
        };
        this.actions.put(CMD_NEW_PEREF, a);
        a = new MyAction(CMD_NODECOPY, "CMD_COPY", this.loadImage("copy")){

            @Override
            public void actionPerformed(ActionEvent e) {
                DTDEditorPanel.this.copyDeclNode();
            }
        };
        this.actions.put(CMD_NODECOPY, a);
        a = new MyAction(CMD_REMOVE, "CMD_REMOVE", this.loadImage("delete")){

            @Override
            public void actionPerformed(ActionEvent e) {
                DTDEditorPanel.this.removeDeclNode();
            }
        };
        this.actions.put(CMD_REMOVE, a);
        a = new MyAction(CMD_TO_UP, "CMD_TO_UP", this.loadImage("toup")){

            @Override
            public void actionPerformed(ActionEvent e) {
                DTDEditorPanel.this.toUp();
            }
        };
        this.actions.put(CMD_TO_UP, a);
        a = new MyAction(CMD_TO_DOWN, "CMD_TO_DOWN", this.loadImage("todown")){

            @Override
            public void actionPerformed(ActionEvent e) {
                DTDEditorPanel.this.toDown();
            }
        };
        this.actions.put(CMD_TO_DOWN, a);
        a = new MyAction(CMD_FINDNODE, "CMD_FIND", this.loadImage("find")){

            @Override
            public void actionPerformed(ActionEvent e) {
                DTDEditorPanel.this.findNode();
            }
        };
        this.actions.put(CMD_FINDNODE, a);
        a = new MyAction(CMD_REFINDNODE, "CMD_REFIND", null){

            @Override
            public void actionPerformed(ActionEvent e) {
                DTDEditorPanel.this.refindNode();
            }
        };
        this.actions.put(CMD_REFINDNODE, a);
    }

    protected ImageIcon loadImage(String name2) {
        return ImageLoader.load(name2 + ".gif", name2);
    }

    public Action getAction(String command) {
        if (!this.hasSetActionStatus) {
            this.setActionEnabled();
        }
        return (Action)this.actions.get(command);
    }

    public DTDEditorPanel() {
        this((DTDDeclNodeData)null, false);
    }

    public DTDEditorPanel(boolean extendEnabled) {
        this((DTDDeclNodeData)null, extendEnabled);
    }

    public DTDEditorPanel(DTDDecl dtd, String rootName) {
        this(rootName);
        this.setDTD(dtd);
    }

    public DTDEditorPanel(DTDDecl dtd) {
        this((DTDDeclNodeData)null, false, false);
        this.setDTD(dtd);
    }

    public DTDEditorPanel(DTDDecl dtd, boolean extendEnabled) {
        this((DTDDeclNodeData)null, extendEnabled, false);
        this.setDTD(dtd);
    }

    public DTDEditorPanel(DTDDecl dtd, String rootName, boolean extendEnabled) {
        this(new DTDDeclNodeData(rootName), extendEnabled, false);
        this.setDTD(dtd);
    }

    public DTDEditorPanel(String rootName) {
        this(new DTDDeclNodeData(rootName), false, false);
    }

    public DTDEditorPanel(String rootName, boolean extendEnabled) {
        this(new DTDDeclNodeData(rootName), extendEnabled, false);
    }

    public DTDEditorPanel(DTDDeclNodeData rootdata, boolean extendEnabled) {
        this(rootdata, extendEnabled, false);
    }

    public DTDEditorPanel(DTDDeclNodeData rootdata, boolean extendEnabled, boolean peRefEnabled) {
        super(1, false);
        this.setDividerSize(2);
        this.dividerInitialed = false;
        this.peRefEnabled = peRefEnabled;
        this.extendEnabled = extendEnabled;
        this.setBorder(defaultBorder);
        try {
            this.defaultFont = new Font("Dialog", 0, 12);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.registContentsEditorPanel();
        this.registAction();
        if (rootdata == null) {
            rootdata = new DTDDeclNodeData("DEFAULT-ROOT");
        }
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(rootdata);
        this.treeModel = new DefaultTreeModel(root);
        this.tree = new JTree(this.treeModel);
        this.tree.setCellRenderer(new MyTreeCellRenderer());
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int y;
                int x;
                JTree source = (JTree)e.getSource();
                TreePath path = source.getClosestPathForLocation(x = e.getX(), y = e.getY());
                if (path != null && e.getModifiers() == 16) {
                    source.setSelectionPath(path);
                }
            }
        });
        GuiUtils.setLookAndFeel(GuiUtils.lookAndFeelClassName, this.tree);
        this.treeSp = new JScrollPane();
        this.treeSp.getViewport().add(this.tree);
        this.setLeftComponent(this.treeSp);
        this.contentsPanel = new JPanel();
        this.contentsPanel.setLayout(new BorderLayout());
        this.contentsPanel.setBorder(defaultBorder);
        this.setRightComponent(this.contentsPanel);
        this.tree.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeExpanded(TreeExpansionEvent event) {
                DTDEditorPanel.this.treeNodeExpanded(event.getPath());
            }

            @Override
            public void treeCollapsed(TreeExpansionEvent event) {
            }
        });
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                DTDEditorPanel.this.treeNodeSelected(e);
            }
        });
    }

    @Override
    public void setBounds(int x, int y, int w, int h) {
        super.setBounds(x, y, w, h);
        if (!this.dividerInitialed && w > 100 && h > 100) {
            this.dividerInitialed = true;
            this.setDividerLocation(0.4);
            int n = this.getDividerLocation();
        }
    }

    public DefaultMutableTreeNode getRoot() {
        return (DefaultMutableTreeNode)this.treeModel.getRoot();
    }

    public DTDDeclNodeData getRootData() {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.treeModel.getRoot();
        return (DTDDeclNodeData)root.getUserObject();
    }

    public void setRootData(DTDDeclNodeData data) {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.treeModel.getRoot();
        root.setUserObject(data);
        this.treeModel.nodeChanged(root);
    }

    public boolean getStructViewVisible() {
        return this.treeSp.isVisible();
    }

    public void setStructViewVisible(boolean visible) {
        if (this.treeSp.isVisible() != visible) {
            this.treeSp.setVisible(visible);
            this.changeView();
        }
    }

    public boolean getContentsViewVisible() {
        return this.contentsPanel.isVisible();
    }

    public void setContentsViewVisible(boolean visible) {
        if (this.contentsPanel.isVisible() != visible) {
            this.contentsPanel.setVisible(visible);
            this.changeView();
        }
    }

    void changeView() {
        this.removeAll();
        if (this.treeSp.isVisible()) {
            this.add(this.treeSp);
        }
        if (this.contentsPanel.isVisible()) {
            this.add(this.contentsPanel);
        }
        this.revalidate();
        this.repaint();
    }

    public void addStatusChangedListener(StatusChangedListener e) {
        this.myStatusChangedListener.addElement(e);
    }

    public void removeStatusChangedListener(StatusChangedListener l) {
        this.myStatusChangedListener.removeElement(l);
    }

    public void addTreeExpansionListener(TreeExpansionListener e) {
        this.tree.addTreeExpansionListener(e);
    }

    public void setContentsEditPanel(int type, Object panel) {
        this.contentsEditPanel.put(new Integer(type), panel);
    }

    public ContentsEditPanel getContentsEditPanel(int type) {
        Object obj = this.contentsEditPanel.get(new Integer(type));
        if (obj instanceof ContentsEditPanel) {
            return (ContentsEditPanel)obj;
        }
        try {
            if (obj instanceof Class) {
                ContentsEditPanel ce = (ContentsEditPanel)((Class)obj).newInstance();
                ce.init(this);
                return ce;
            }
            ContentsEditPanel ce = (ContentsEditPanel)Class.forName(obj.toString()).newInstance();
            ce.init(this);
            return ce;
        }
        catch (Exception e) {
            System.err.println(e);
            return null;
        }
    }

    public Font getDefaultFont() {
        return this.defaultFont;
    }

    public void setDefaultFont(Font defaultFont) {
        this.defaultFont = defaultFont;
    }

    public boolean getExtendEnabled() {
        return this.extendEnabled;
    }

    public void setExtendEnabled(boolean extendEnabled) {
        if (this.extendEnabled == extendEnabled) {
            return;
        }
        this.extendEnabled = extendEnabled;
        ContentsEditPanel ep = this.getContentsEditPanel(20);
        ep.init(this);
        ep = this.getContentsEditPanel(22);
        ep.init(this);
    }

    public void execCommand(String cmd) {
        Action a = (Action)this.actions.get(cmd);
        if (a != null) {
            ActionEvent ae = new ActionEvent(this, 1001, cmd);
            a.actionPerformed(ae);
        }
    }

    public void toUp() {
        DefaultMutableTreeNode node = this.getSelectedTreeNode();
        if (node == null) {
            return;
        }
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent();
        if (parent == null) {
            return;
        }
        int index = this.treeModel.getIndexOfChild(parent, node);
        if (index < 1) {
            return;
        }
        this.disableSelectChange = true;
        this.treeModel.removeNodeFromParent(node);
        this.treeModel.insertNodeInto(node, parent, --index);
        this.disableSelectChange = false;
        this.tree.setSelectionPath(new TreePath(node.getPath()));
        this.changeContents();
    }

    public void toDown() {
        DefaultMutableTreeNode node = this.getSelectedTreeNode();
        if (node == null) {
            return;
        }
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent();
        if (parent == null) {
            return;
        }
        int index = this.treeModel.getIndexOfChild(parent, node);
        if (index >= parent.getChildCount() - 1) {
            return;
        }
        this.disableSelectChange = true;
        this.treeModel.removeNodeFromParent(node);
        this.treeModel.insertNodeInto(node, parent, ++index);
        this.disableSelectChange = false;
        this.tree.setSelectionPath(new TreePath(node.getPath()));
        this.changeContents();
    }

    public void addNewElementDeclNode() {
        DefaultMutableTreeNode selNode = this.getSelectedTreeNode();
        if (selNode == null) {
            return;
        }
        DeclNodeData select = (DeclNodeData)selNode.getUserObject();
        if (select == null) {
            return;
        }
        String name2 = this.getNewDefaultNodeName(20);
        int type = select.getNodeType();
        DefaultMutableTreeNode node = null;
        if (type == 27) {
            node = new DefaultMutableTreeNode(new ElementDeclNodeData(name2));
            this.addToDefaultNode(node);
            selNode.add(node);
            this.treeModel.nodeStructureChanged(selNode);
            this.setSelectedTreeNode(node);
            this.changeContents();
            return;
        }
        if (type == 30) {
            node = new DefaultMutableTreeNode(new CpDeclNodeData(name2));
            selNode.add(node);
            this.nodeStructureChanged(selNode);
        } else if (type == 31) {
            DefaultMutableTreeNode parent = (DefaultMutableTreeNode)selNode.getParent();
            if (parent == null) {
                return;
            }
            DeclNodeData pd = (DeclNodeData)parent.getUserObject();
            if (pd.getNodeType() != 30) {
                this.addNewSubElementDeclNode();
                return;
            }
            node = new DefaultMutableTreeNode(new CpDeclNodeData(name2));
            DefaultMutableTreeNode pa = (DefaultMutableTreeNode)selNode.getParent();
            int n = pa.getChildCount();
            int index = pa.getIndex(selNode);
            this.treeModel.insertNodeInto(node, pa, index + 1);
        } else {
            DefaultMutableTreeNode pa = (DefaultMutableTreeNode)selNode.getParent();
            if (this.treeModel.getRoot() == pa) {
                int index = pa.getIndex(selNode);
                node = new DefaultMutableTreeNode(new ElementDeclNodeData(name2));
                this.treeModel.insertNodeInto(node, pa, index + 1);
                this.addToDefaultNode(node);
                this.setSelectedTreeNode(node);
                this.changeContents();
                return;
            }
        }
        if (node != null) {
            this.addToDefaultNode(node);
            this.addRelationNode(node);
            this.setSelectedTreeNode(node);
        }
        this.changeContents();
    }

    public void addNewSubElementDeclNode() {
        DefaultMutableTreeNode selNode = this.getSelectedTreeNode();
        if (selNode == null) {
            return;
        }
        DeclNodeData select = (DeclNodeData)selNode.getUserObject();
        if (select == null) {
            return;
        }
        String prefix = this.searchPrefix(selNode);
        String name2 = this.getNewDefaultNodeName(20, prefix);
        DefaultMutableTreeNode node = null;
        int type = select.getNodeType();
        if (type == 30) {
            node = new DefaultMutableTreeNode(new CpDeclNodeData(name2));
            this.treeModel.insertNodeInto(node, selNode, selNode.getChildCount());
        } else if (type == 31) {
            DefaultMutableTreeNode pa = (DefaultMutableTreeNode)selNode.getParent();
            DeclNodeData padata = (DeclNodeData)pa.getUserObject();
            if (padata.getNodeType() == 20 && ((ElementDeclNodeData)padata).getType() != 3) {
                return;
            }
            node = new DefaultMutableTreeNode(new CpDeclNodeData(name2));
            DefaultMutableTreeNode node1 = new DefaultMutableTreeNode(selNode.getUserObject());
            selNode.setUserObject(new ChildrenDeclNodeData(""));
            this.nodeChanged(selNode);
            this.treeModel.insertNodeInto(node1, selNode, selNode.getChildCount());
            int no = this.defaultNodes.indexOf(selNode);
            if (no >= 0) {
                this.defaultNodes.setElementAt(node1, no);
            }
            this.treeModel.insertNodeInto(node, selNode, selNode.getChildCount());
        } else if (type == 20) {
            node = this.appendCpNodeToElement(selNode, name2);
        }
        if (node != null) {
            this.addToDefaultNode(node);
            this.addRelationNode(node);
            this.setSelectedTreeNode(node);
        }
        this.changeContents();
    }

    protected DefaultMutableTreeNode appendCpNodeToElement(DefaultMutableTreeNode parent, String subtag) {
        if (parent == null) {
            return null;
        }
        DeclNodeData select = (DeclNodeData)parent.getUserObject();
        if (select.getNodeType() != 20) {
            return null;
        }
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(new CpDeclNodeData(subtag));
        ElementDeclNodeData data = (ElementDeclNodeData)select;
        if (data.getType() == 2) {
            this.treeModel.insertNodeInto(node, parent, parent.getChildCount());
        } else {
            int n;
            if (data.getType() != 3) {
                data.setType(3);
            }
            if ((n = parent.getChildCount()) == 0) {
                this.treeModel.insertNodeInto(node, parent, parent.getChildCount());
            } else {
                DefaultMutableTreeNode children;
                DefaultMutableTreeNode node1 = (DefaultMutableTreeNode)parent.getLastChild();
                DeclNodeData data1 = (DeclNodeData)node1.getUserObject();
                int type1 = data1.getNodeType();
                if (type1 == 31) {
                    children = new DefaultMutableTreeNode(new ChildrenDeclNodeData(" "));
                    this.treeModel.removeNodeFromParent(node1);
                    this.treeModel.insertNodeInto(children, parent, parent.getChildCount());
                    this.treeModel.insertNodeInto(node1, children, children.getChildCount());
                } else {
                    children = node1;
                }
                this.treeModel.insertNodeInto(node, children, children.getChildCount());
            }
        }
        return node;
    }

    void addRelationNode(DefaultMutableTreeNode node) {
        String name2 = ((DeclNodeData)node.getUserObject()).getNodeName();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.treeModel.getRoot();
        DefaultMutableTreeNode node2 = new DefaultMutableTreeNode(new ElementDeclNodeData(name2));
        this.addToDefaultNode(node2);
        DefaultMutableTreeNode refNode = node.getPreviousSibling();
        if (refNode == null) {
            refNode = (DefaultMutableTreeNode)node.getParent();
        }
        if (refNode != null) {
            String name1 = ((DeclNodeData)refNode.getUserObject()).getNodeName();
            int n = root.getChildCount();
            int pos = -1;
            for (int i = 0; i < n; ++i) {
                refNode = (DefaultMutableTreeNode)root.getChildAt(i);
                DeclNodeData data1 = (DeclNodeData)refNode.getUserObject();
                if (!name1.equals(data1.getNodeName()) || data1.getNodeType() != 20) continue;
                pos = i;
                break;
            }
            if (pos > 0) {
                this.treeModel.insertNodeInto(node2, root, pos + 1);
            } else {
                this.treeModel.insertNodeInto(node2, root, root.getChildCount());
            }
        } else {
            this.treeModel.insertNodeInto(node2, root, root.getChildCount());
        }
    }

    public void addNewAttDefDeclNode() {
        String prefix;
        DefaultMutableTreeNode selNode = this.getSelectedTreeNode();
        if (selNode == null) {
            return;
        }
        DeclNodeData select = (DeclNodeData)selNode.getUserObject();
        if (select == null) {
            return;
        }
        int type = select.getNodeType();
        String elemName = null;
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.treeModel.getRoot();
        if (type == 20) {
            elemName = select.getNodeName();
        } else if (type == 31) {
            elemName = select.getNodeName();
            selNode = this.getTreeNodeByName(20, elemName);
        } else {
            DefaultMutableTreeNode cur = null;
            try {
                cur = (DefaultMutableTreeNode)root.getFirstChild();
            }
            catch (Exception exception) {
                // empty catch block
            }
            while (cur != null) {
                DeclNodeData data1 = (DeclNodeData)cur.getUserObject();
                if (data1.getNodeType() == 20) {
                    elemName = data1.getNodeName();
                    break;
                }
                cur = cur.getNextSibling();
            }
        }
        if (elemName == null) {
            prefix = null;
            elemName = "New_Element_1";
        } else {
            prefix = this.searchPrefix(elemName);
        }
        String name2 = this.getNewDefaultNodeName(22, prefix);
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(new AttDefDeclNodeData(elemName, name2));
        this.addToDefaultNode(node);
        if (selNode == null || type == 27) {
            this.treeModel.insertNodeInto(node, root, root.getChildCount());
        } else {
            while (selNode.getParent() != root) {
                selNode = (DefaultMutableTreeNode)selNode.getParent();
            }
            int pos = this.treeModel.getIndexOfChild(root, selNode);
            this.treeModel.insertNodeInto(node, root, pos + 1);
        }
        this.setSelectedTreeNode(node);
        this.changeContents();
    }

    public void addNewEntityDeclNode() {
        DefaultMutableTreeNode selNode = this.getSelectedTreeNode();
        if (selNode == null) {
            return;
        }
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.treeModel.getRoot();
        if (selNode != root && selNode.getParent() != root) {
            return;
        }
        DeclNodeData select = (DeclNodeData)selNode.getUserObject();
        if (select == null) {
            return;
        }
        String name2 = this.getNewDefaultNodeName(6);
        int type = select.getNodeType();
        EntityDeclNodeData userdata = new EntityDeclNodeData(name2, "Default_Value", this.refpath);
        this.entityBuff.put(name2, userdata);
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(userdata);
        this.addToDefaultNode(node);
        if (type == 27) {
            this.treeModel.insertNodeInto(node, root, root.getChildCount());
        } else {
            int pos = this.treeModel.getIndexOfChild(root, selNode);
            this.treeModel.insertNodeInto(node, root, pos + 1);
        }
        this.setSelectedTreeNode(node);
        this.changeContents();
    }

    public void addNewNotationDeclNode() {
        DefaultMutableTreeNode selNode = this.getSelectedTreeNode();
        if (selNode == null) {
            return;
        }
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.treeModel.getRoot();
        if (selNode != root && selNode.getParent() != root) {
            return;
        }
        DeclNodeData select = (DeclNodeData)selNode.getUserObject();
        if (select == null) {
            return;
        }
        String name2 = this.getNewDefaultNodeName(12);
        int type = select.getNodeType();
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(new NotationDeclNodeData(name2));
        this.addToDefaultNode(node);
        if (type == 27) {
            this.treeModel.insertNodeInto(node, root, root.getChildCount());
        } else {
            int pos = this.treeModel.getIndexOfChild(root, selNode);
            this.treeModel.insertNodeInto(node, root, pos + 1);
        }
        this.setSelectedTreeNode(node);
        this.changeContents();
    }

    public void addNewCommentDeclNode() {
        DefaultMutableTreeNode selNode = this.getSelectedTreeNode();
        if (selNode == null) {
            return;
        }
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.treeModel.getRoot();
        if (selNode != root && selNode.getParent() != root) {
            return;
        }
        DeclNodeData select = (DeclNodeData)selNode.getUserObject();
        if (select == null) {
            return;
        }
        int type = select.getNodeType();
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(new DeclNodeData(8, CMD_NEW_COMMENT, "Comment"));
        this.addToDefaultNode(node);
        if (type == 27) {
            this.treeModel.insertNodeInto(node, root, root.getChildCount());
        } else {
            int pos = this.treeModel.getIndexOfChild(root, selNode);
            this.treeModel.insertNodeInto(node, root, pos + 1);
        }
        this.setSelectedTreeNode(node);
        this.changeContents();
    }

    void addNewPIDeclNode() {
        DefaultMutableTreeNode selNode = this.getSelectedTreeNode();
        if (selNode == null) {
            return;
        }
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.treeModel.getRoot();
        if (selNode != root && selNode.getParent() != root) {
            return;
        }
        DeclNodeData select = (DeclNodeData)selNode.getUserObject();
        if (select == null) {
            return;
        }
        int type = select.getNodeType();
        String name2 = this.getNewDefaultNodeName(7);
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(new DeclNodeData(7, name2, "Processing Instruction"));
        this.addToDefaultNode(node);
        if (type == 27) {
            this.treeModel.insertNodeInto(node, root, root.getChildCount());
        } else {
            int pos = this.treeModel.getIndexOfChild(root, selNode);
            this.treeModel.insertNodeInto(node, root, pos + 1);
        }
        this.setSelectedTreeNode(node);
        this.changeContents();
    }

    void addNewPERefDeclNode() {
        if (this.getExtendEnabled()) {
            return;
        }
        DefaultMutableTreeNode selNode = this.getSelectedTreeNode();
        if (selNode == null) {
            return;
        }
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.treeModel.getRoot();
        DeclNodeData select = (DeclNodeData)selNode.getUserObject();
        if (select == null) {
            return;
        }
        String name2 = this.getFirstParameterEntity();
        if (name2 == null) {
            name2 = this.getNewDefaultNodeName(28);
        }
        int type = select.getNodeType();
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(new PERefDeclNodeData(name2));
        this.addToDefaultNode(node);
        if (type == 27) {
            this.treeModel.insertNodeInto(node, root, root.getChildCount());
        } else {
            DefaultMutableTreeNode parent = (DefaultMutableTreeNode)selNode.getParent();
            int pos = this.treeModel.getIndexOfChild(parent, selNode);
            this.treeModel.insertNodeInto(node, parent, pos + 1);
        }
        this.setSelectedTreeNode(node);
        this.changeContents();
    }

    public void copyDeclNode() {
        DefaultMutableTreeNode selNode = this.getSelectedTreeNode();
        if (selNode == null) {
            return;
        }
        if (selNode == this.treeModel.getRoot()) {
            return;
        }
        DefaultMutableTreeNode node = this.cloneNode(selNode);
        DeclNodeData data = (DeclNodeData)node.getUserObject();
        String name2 = this.getNewDefaultNodeName(data.getNodeType());
        data.setNodeName(name2);
        this.addToDefaultNode(node);
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)selNode.getParent();
        int pos = this.treeModel.getIndexOfChild(parent, selNode);
        this.treeModel.insertNodeInto(node, parent, pos + 1);
        this.setSelectedTreeNode(node);
        this.changeContents();
    }

    DefaultMutableTreeNode cloneNode(DefaultMutableTreeNode node) {
        DeclNodeData data = (DeclNodeData)node.getUserObject();
        DeclNodeData data1 = (DeclNodeData)data.clone();
        DefaultMutableTreeNode node1 = new DefaultMutableTreeNode(data1);
        int n = node.getChildCount();
        for (int i = 0; i < n; ++i) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getChildAt(i);
            node1.add(this.cloneNode(child));
        }
        return node1;
    }

    public void removeDeclNode() {
        TreePath[] sels = this.tree.getSelectionPaths();
        if (sels == null) {
            return;
        }
        int row = this.tree.getMinSelectionRow();
        boolean questDialog = true;
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.treeModel.getRoot();
        for (int i = 0; i < sels.length; ++i) {
            DefaultMutableTreeNode selNode = (DefaultMutableTreeNode)sels[i].getLastPathComponent();
            if (!root.isNodeRelated(selNode) || selNode == root || selNode.getParent() == null) continue;
            int rs = this.removeDeclNode(selNode, questDialog);
            if (rs == 2) break;
            if (rs != 1) continue;
            questDialog = false;
        }
        TreePath sel = null;
        try {
            sel = this.tree.getPathForRow(row);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (row > 0 && sel == null) {
            try {
                sel = this.tree.getPathForRow(row--);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (sel != null) {
            this.tree.setSelectionPath(sel);
        }
    }

    int removeDeclNode(DefaultMutableTreeNode selNode, boolean questDialog) {
        int last2;
        String nodename;
        int k;
        int rs;
        DeclNodeData select = (DeclNodeData)selNode.getUserObject();
        String name2 = select.getNodeName();
        boolean disQuest = this.defaultNodes.contains(name2);
        int n = rs = questDialog ? 1 : 0;
        if (!disQuest && questDialog && select.getNodeName() != null) {
            String s = msgCatalog.getMessage("QST_DEL_NODE", new Object[]{select.getNodeTypeNameDes(), select.getNodeName()});
            Object[] param = new String[]{msgCatalog.getMessage("BUTTON_OK"), msgCatalog.getMessage("BUTTON_DELALL"), msgCatalog.getMessage("BUTTON_CANCEL")};
            rs = JOptionPane.showOptionDialog(this.getFrame(), s, msgCatalog.getMessage("DLG_NODEDEL"), -1, 3, null, param, msgCatalog.getMessage("BUTTON_CANCEL"));
            if (rs == -1) {
                return 2;
            }
            if (rs == 2) {
                return rs;
            }
        }
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)selNode.getParent();
        int index = this.treeModel.getIndexOfChild(parent, selNode);
        DeclNodeData userdata = (DeclNodeData)selNode.getUserObject();
        if (userdata.getNodeType() == 6) {
            this.entityBuff.remove(userdata.getNodeName());
        } else if (userdata.getNodeType() == 25 && (k = (nodename = userdata.getNodeName()).indexOf(58)) >= 0) {
            this.nameSpaceChanged(nodename.substring(k + 1) + ":", "");
        }
        this.treeModel.removeNodeFromParent(selNode);
        this.defaultNodes.removeElement(selNode);
        int type = select.getNodeType();
        for (int i = last2 = this.defaultNodes.size() - 1; i >= 0; --i) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.defaultNodes.elementAt(i);
            DeclNodeData data1 = (DeclNodeData)node.getUserObject();
            if (!name2.equals(data1.getNodeName())) continue;
            this.defaultNodes.removeElementAt(i);
            DefaultMutableTreeNode parenttmp = (DefaultMutableTreeNode)node.getParent();
            if (parenttmp == null) continue;
            this.treeModel.removeNodeFromParent(node);
            DeclNodeData parentData = (DeclNodeData)parenttmp.getUserObject();
            if (parentData.getNodeType() != 30) continue;
            int n2 = parenttmp.getChildCount();
            if (n2 == 0) {
                this.treeModel.removeNodeFromParent(parenttmp);
                continue;
            }
            if (n2 != 1) continue;
            DefaultMutableTreeNode no1 = (DefaultMutableTreeNode)parenttmp.getChildAt(0);
            parenttmp.removeAllChildren();
            parenttmp.setUserObject(no1.getUserObject());
            int no = this.defaultNodes.indexOf(no1);
            if (no >= 0) {
                this.defaultNodes.setElementAt(parenttmp, no);
            }
            this.treeModel.nodeChanged(parenttmp);
            this.treeModel.nodeStructureChanged(parenttmp);
        }
        DeclNodeData parentData = (DeclNodeData)parent.getUserObject();
        selNode = null;
        if (parentData.getNodeType() != 30) {
            int n3 = parent.getChildCount();
            if (index >= n3) {
                --index;
            }
            selNode = index >= 0 ? (DefaultMutableTreeNode)parent.getChildAt(index) : parent;
        } else {
            int n4 = parent.getChildCount();
            if (n4 == 0) {
                DefaultMutableTreeNode node1 = parent;
                parent = (DefaultMutableTreeNode)node1.getParent();
                this.treeModel.removeNodeFromParent(node1);
                selNode = parent;
            } else if (n4 == 1) {
                DefaultMutableTreeNode no1 = (DefaultMutableTreeNode)parent.getFirstChild();
                DeclNodeData data1 = (DeclNodeData)no1.getUserObject();
                if ((parent = (DefaultMutableTreeNode)parent.getParent()) != null) {
                    parent.removeAllChildren();
                    parent.add(no1);
                }
                this.treeModel.nodeChanged(parent);
                this.treeModel.nodeStructureChanged(parent);
                selNode = no1;
            } else {
                if (index >= n4) {
                    --index;
                }
                selNode = index >= 0 ? (DefaultMutableTreeNode)parent.getChildAt(index) : parent;
            }
        }
        this.changeContents();
        return rs;
    }

    public void findNode() {
        if (this.findDialog == null) {
            Frame f = (Frame)SwingUtilities.getRoot(this);
            this.findDialog = new FindDialog(f);
        }
        DeclNodeData data = this.getSelectedTreeNodeData();
        String nodeName = null;
        if (data != null && (nodeName = data.getNodeName()) != null && nodeName.length() == 0) {
            nodeName = null;
        }
        if (nodeName != null) {
            this.findDialog.setText(nodeName);
        } else {
            this.findDialog.setText(this.searchText);
        }
        this.findDialog.setForward(this.isForward);
        this.findDialog.setIgnoreCase(this.ignoreCase);
        this.findDialog.setVisible(true);
        if (!this.findDialog.isOK()) {
            return;
        }
        this.ignoreCase = this.findDialog.ignoreCase();
        this.isForward = this.findDialog.isForward();
        this.searchText = this.findDialog.getText().trim();
        if (this.searchText.equals("")) {
            return;
        }
        this.refindNode();
    }

    public void refindNode() {
        DefaultMutableTreeNode node = this.getSelectedTreeNode();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.treeModel.getRoot();
        if (node == null) {
            node = root;
        }
        if (this.isForward) {
            while (node != null) {
                DeclNodeData data;
                String s;
                if ((node = node.getNextNode()) == null || (s = (data = (DeclNodeData)node.getUserObject()).getNodeName()) == null) continue;
                if (this.ignoreCase) {
                    String word = this.searchText.toUpperCase();
                    if ((s = s.toUpperCase()).indexOf(word) < 0) continue;
                    this.setSelectedTreeNode(node);
                    return;
                }
                if (s.indexOf(this.searchText) < 0) continue;
                this.setSelectedTreeNode(node);
                return;
            }
        } else {
            while (node != null) {
                DeclNodeData data;
                String s;
                if ((node = node.getPreviousNode()) == null || (s = (data = (DeclNodeData)node.getUserObject()).getNodeName()) == null) continue;
                if (this.ignoreCase) {
                    String word = this.searchText.toUpperCase();
                    if ((s = s.toUpperCase()).indexOf(word) < 0) continue;
                    this.setSelectedTreeNode(node);
                    return;
                }
                if (s.indexOf(this.searchText) < 0) continue;
                this.setSelectedTreeNode(node);
                return;
            }
        }
    }

    public int getEditorStatus() {
        return this.status;
    }

    public void setDTD(DTDDecl dtd) {
        this.setDTD(dtd, this.peRefEnabled);
    }

    public void setDTD(DTDDecl dtd, boolean enableExternalDTD) {
        this.tmpdtd = null;
        this.peRefEnabled = enableExternalDTD;
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.tree.getModel().getRoot();
        Object rootName = null;
        this.refpath = null;
        if (dtd != null) {
            String url = dtd.getURL();
            if (url != null) {
                int k = url.lastIndexOf("/");
                if (k < 0) {
                    k = url.lastIndexOf("\\");
                }
                if (k >= 0) {
                    this.refpath = url.substring(0, k + 1);
                }
            }
            DTDDeclNodeData rootdata = new DTDDeclNodeData(dtd);
            root.setUserObject(rootdata);
        }
        this.entityBuff.clear();
        root.removeAllChildren();
        this.defaultNodes.removeAllElements();
        if (dtd == null) {
            this.treeModel.nodeStructureChanged(root);
            this.tree.expandRow(0);
            this.tree.setSelectionRow(0);
            this.dtdChanged = false;
            return;
        }
        this.insertDTD(dtd, -1, false);
        this.treeModel.nodeStructureChanged(root);
        this.tree.expandRow(0);
        this.tree.setSelectionRow(0);
        this.setStructViewVisible(true);
        this.setContentsViewVisible(true);
        this.dtdChanged = false;
        this.resetEditStatus();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void insertDTD(DTDDecl dtd, int index, boolean check) {
        int nodetype;
        DeclNode node;
        int i;
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.tree.getModel().getRoot();
        Hashtable<String, DefaultMutableTreeNode> checkTab = null;
        if (check) {
            checkTab = new Hashtable<String, DefaultMutableTreeNode>();
            DefaultMutableTreeNode child = null;
            try {
                child = (DefaultMutableTreeNode)root.getFirstChild();
            }
            catch (Exception exception) {
                // empty catch block
            }
            while (child != null) {
                DeclNodeData userobj = (DeclNodeData)child.getUserObject();
                int nodetype2 = userobj.getNodeType();
                String name2 = userobj.getNodeName();
                if (nodetype2 == 20) {
                    checkTab.put(name2, child);
                } else if (nodetype2 == 22 || nodetype2 == 25) {
                    checkTab.put(((AttDefDeclNodeData)userobj).getElementName() + "/" + name2, child);
                } else if (nodetype2 == 6) {
                    checkTab.put(name2, child);
                }
                child = child.getNextSibling();
            }
        }
        Hashtable<String, DefaultMutableTreeNode> store = new Hashtable<String, DefaultMutableTreeNode>();
        DeclNodeList nodes = dtd.getAllDeclNode();
        int n = nodes.size();
        block12: for (i = 0; i < n; ++i) {
            node = nodes.elementAt(i);
            nodetype = node.getNodeType();
            DefaultMutableTreeNode treeNode = null;
            String name3 = node.getNodeName();
            switch (nodetype) {
                case 20: {
                    if (check && checkTab.containsKey(name3)) {
                        Debug.println(DTDDocument.getErrorMessage("DOUBLE_NAME", new Object[]{name3}));
                        continue block12;
                    }
                    DeclNodeData userdata = new ElementDeclNodeData((ElementDecl)node);
                    userdata.setDataTypeDecl(node.getDataTypeDecl());
                    treeNode = new DefaultMutableTreeNode(userdata);
                    store.put(userdata.getNodeName(), treeNode);
                    break;
                }
                case 22: {
                    String namekey;
                    if (check && checkTab.containsKey(namekey = ((AttDef)node).getElementName() + "/" + name3)) {
                        Debug.println(DTDDocument.getErrorMessage("DOUBLE_NAME", new Object[]{namekey}));
                        continue block12;
                    }
                    DeclNodeData userdata = name3.equals("xmlns") || name3.startsWith("xmlns:") ? new NSDeclNodeData((AttDef)node) : new AttDefDeclNodeData((AttDef)node);
                    userdata.setDataTypeDecl(node.getDataTypeDecl());
                    treeNode = new DefaultMutableTreeNode(userdata);
                    break;
                }
                case 6: {
                    if (check && checkTab.containsKey(name3)) {
                        Debug.println(DTDDocument.getErrorMessage("DOUBLE_NAME", new Object[]{name3}));
                        continue block12;
                    }
                    DeclNodeData userdata = new EntityDeclNodeData((EntityDecl)node, this.refpath);
                    treeNode = new DefaultMutableTreeNode(userdata);
                    this.entityBuff.put(userdata.getNodeName(), userdata);
                    break;
                }
                case 12: {
                    DeclNodeData userdata = new NotationDeclNodeData((NotationDecl)node);
                    treeNode = new DefaultMutableTreeNode(userdata);
                    break;
                }
                case 8: {
                    String s = ((CommentDecl)node).getComment();
                    if (s == null) {
                        s = "";
                    }
                    DeclNodeData userdata = new DeclNodeData(8, CMD_NEW_COMMENT, s);
                    treeNode = new DefaultMutableTreeNode(userdata);
                    break;
                }
                case 7: {
                    String s = ((PIDecl)node).getContents();
                    if (s == null) {
                        s = "";
                    }
                    DeclNodeData userdata = new DeclNodeData(7, node.getNodeName(), s);
                    treeNode = new DefaultMutableTreeNode(userdata);
                    break;
                }
                case 28: {
                    DeclNodeData userdata = new PERefDeclNodeData(node.getNodeName());
                    treeNode = new DefaultMutableTreeNode(userdata);
                }
            }
            if (treeNode == null) continue;
            if (index < 0) {
                this.treeModel.insertNodeInto(treeNode, root, root.getChildCount());
                continue;
            }
            this.treeModel.insertNodeInto(treeNode, root, index);
            ++index;
        }
        i = 0;
        while (true) {
            if (i >= n) {
                this.changeContents();
                return;
            }
            node = nodes.elementAt(i);
            nodetype = node.getNodeType();
            if (nodetype == 20) {
                ElementDecl elem = (ElementDecl)node;
                String elemname = node.getNodeName();
                DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)store.get(elemname);
                if (treeNode != null) {
                    Children childen;
                    if (elem.getType() == 2) {
                        Vector names = elem.getChildNames();
                        if (names != null) {
                            for (int j = 0; j < names.size(); ++j) {
                                String s1 = (String)names.elementAt(j);
                                boolean b = s1.startsWith("%") & s1.endsWith(";");
                                if (b) {
                                    s1 = s1.substring(1, s1.length() - 1);
                                }
                                CpDeclNodeData userdata = new CpDeclNodeData(s1, b);
                                treeNode.add(new DefaultMutableTreeNode(userdata));
                                this.nodeStructureChanged(treeNode);
                            }
                        }
                    } else if (elem.getType() == 3 && (childen = elem.getChildren()) != null) {
                        DTDEditorPanel.addElementChilden(treeNode, childen);
                    }
                }
            }
            ++i;
        }
    }

    void selectToErrorNode() {
        if (this.lastErrorNode != null) {
            this.setSelectedTreeNode(this.lastErrorNode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DTDDecl getDTD() throws SAXException {
        if (this.tmpdtd != null) {
            return this.tmpdtd;
        }
        this.lastErrorNode = null;
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.tree.getModel().getRoot();
        DTDDeclNodeData rootdata = (DTDDeclNodeData)root.getUserObject();
        DTDDocument dtd = this.extendEnabled ? new DTDDocument(rootdata.getNodeName()) : new DTDDocument(rootdata.getNodeName());
        dtd.setProperties(rootdata.getProperties());
        DefaultMutableTreeNode currentNode = null;
        try {
            currentNode = (DefaultMutableTreeNode)root.getFirstChild();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            while (currentNode != null) {
                DeclNodeData userobj = (DeclNodeData)currentNode.getUserObject();
                int nodetype = userobj.getNodeType();
                DeclNode declnode = null;
                switch (nodetype) {
                    case 20: {
                        declnode = DTDEditorPanel.createElementDecl(dtd, currentNode);
                        break;
                    }
                    case 22: 
                    case 25: {
                        declnode = DTDEditorPanel.createAttdef(dtd, currentNode);
                        break;
                    }
                    case 8: {
                        declnode = new CommentDeclNode(dtd, (String)userobj.getNodeValue());
                        break;
                    }
                    case 6: {
                        declnode = DTDEditorPanel.createEntityDecl(dtd, currentNode);
                        break;
                    }
                    case 28: {
                        declnode = DTDEditorPanel.createPERefDecl(dtd, currentNode);
                        break;
                    }
                    case 12: {
                        declnode = DTDEditorPanel.createNotationDecl(dtd, currentNode);
                        break;
                    }
                    case 7: {
                        declnode = new PIDeclNode(userobj.getNodeName(), (String)userobj.getNodeValue());
                    }
                }
                if (declnode == null) {
                    String msg = msgCatalog.getMessage("INVALID_DECL", new Object[]{userobj.getNodeTypeNameDes(), userobj.getNodeName()});
                    throw new SAXException(msg);
                }
                dtd.appendChild(declnode);
                currentNode = currentNode.getNextSibling();
            }
        }
        finally {
            this.lastErrorNode = currentNode;
        }
        this.tmpdtd = dtd;
        return dtd;
    }

    public void changeContents() {
        this.dtdChanged = true;
        this.tmpdtd = null;
    }

    public void clearChanged() {
        this.dtdChanged = false;
    }

    public boolean isChanged() {
        return this.dtdChanged;
    }

    public void treeNodeNameChanged(DefaultMutableTreeNode node, String newName) {
        DeclNodeData data = (DeclNodeData)node.getUserObject();
        String oldName = data.getNodeName();
        if (oldName.equals(newName)) {
            return;
        }
        String s = oldName;
        int k = s.indexOf(58);
        if (k > 0) {
            s = s.substring(k + 1);
        }
        if (s.startsWith("New_")) {
            for (k = this.defaultNodes.size() - 1; k >= 0; --k) {
                DefaultMutableTreeNode node1 = (DefaultMutableTreeNode)this.defaultNodes.elementAt(k);
                DeclNodeData data1 = (DeclNodeData)node1.getUserObject();
                if (!data1.getNodeName().equals(oldName)) continue;
                data1.setNodeName(newName);
                this.treeModel.nodeChanged(node1);
                this.defaultNodes.removeElementAt(k);
            }
        }
        data.setNodeName(newName);
        k = data.getNodeType();
        if (k == 6) {
            this.entityBuff.remove(oldName);
            this.entityBuff.put(newName, data);
        } else if (k == 20) {
            this.changeNsElement(oldName, newName);
        }
        this.treeModel.nodeChanged(node);
        this.changeContents();
    }

    public Frame getFrame() {
        Container parent;
        if (this.parentFrame != null) {
            return this.parentFrame;
        }
        for (parent = this.getParent(); parent != null && !(parent instanceof Frame); parent = parent.getParent()) {
        }
        if (parent != null) {
            this.parentFrame = (Frame)parent;
            return this.parentFrame;
        }
        return null;
    }

    public JTree getStructTree() {
        return this.tree;
    }

    String getFirstParameterEntity() {
        return null;
    }

    public EntityDeclNodeData findEntityDecl(String name2) {
        EntityDeclNodeData data1 = (EntityDeclNodeData)this.entityBuff.get(name2);
        if (data1 != null && data1.getPeDecl()) {
            return data1;
        }
        return null;
    }

    public Vector getAllElementsBefore(DefaultMutableTreeNode node) {
        node = this.getValidDeclNode(node);
        DefaultMutableTreeNode root = this.getRoot();
        DefaultMutableTreeNode node1 = null;
        Vector<String> vet = new Vector<String>();
        try {
            node1 = (DefaultMutableTreeNode)root.getFirstChild();
        }
        catch (Exception exception) {
            // empty catch block
        }
        while (node1 != null && node1 != node) {
            EntityDeclNodeData data2;
            DeclNodeData data1 = (DeclNodeData)node1.getUserObject();
            int type = data1.getNodeType();
            if (type == 20) {
                vet.addElement(data1.getNodeName());
            } else if (type == 28 && (data2 = (EntityDeclNodeData)this.entityBuff.get(data1.getNodeName())) != null) {
                data2.addAllElements(vet);
            }
            node1 = node1.getNextSibling();
        }
        return vet;
    }

    public Vector getAllNotationsBefore(DefaultMutableTreeNode node) {
        return this.getAllDeclNodesBefore(12, node);
    }

    public Vector getAllDeclNodesBefore(int type, DefaultMutableTreeNode node) {
        node = this.getValidDeclNode(node);
        DefaultMutableTreeNode root = this.getRoot();
        DefaultMutableTreeNode node1 = null;
        Vector<String> vet = new Vector<String>();
        try {
            node1 = (DefaultMutableTreeNode)root.getFirstChild();
        }
        catch (Exception exception) {
            // empty catch block
        }
        while (node1 != null && node1 != node) {
            EntityDeclNodeData data2;
            DeclNodeData data1 = (DeclNodeData)node1.getUserObject();
            int nodetype = data1.getNodeType();
            if (nodetype == type) {
                vet.addElement(data1.getNodeName());
            } else if (nodetype == 28 && (data2 = (EntityDeclNodeData)this.entityBuff.get(data1.getNodeName())) != null) {
                data2.addAllDeclNodes(type, vet);
            }
            node1 = node1.getNextSibling();
        }
        return vet;
    }

    public Vector getAllValueEntitysBefore(DefaultMutableTreeNode node) {
        node = this.getValidDeclNode(node);
        DefaultMutableTreeNode root = this.getRoot();
        DefaultMutableTreeNode node1 = null;
        Vector<String> vet = new Vector<String>();
        try {
            node1 = (DefaultMutableTreeNode)root.getFirstChild();
        }
        catch (Exception exception) {
            // empty catch block
        }
        while (node1 != null && node1 != node) {
            EntityDeclNodeData data2;
            DeclNodeData data1 = (DeclNodeData)node1.getUserObject();
            int type = data1.getNodeType();
            if (type == 6) {
                data2 = (EntityDeclNodeData)data1;
                if (data2.getPeDecl() && data2.getType() == 0) {
                    vet.addElement(data1.getNodeName());
                }
            } else if (type == 28 && (data2 = (EntityDeclNodeData)this.entityBuff.get(data1.getNodeName())) != null) {
                data2.addAllValueEntitys(vet);
            }
            node1 = node1.getNextSibling();
        }
        return vet;
    }

    public Vector getAllPerefEntitysBefore(DefaultMutableTreeNode node) {
        node = this.getValidDeclNode(node);
        DefaultMutableTreeNode root = this.getRoot();
        DefaultMutableTreeNode node1 = null;
        Vector<String> vet = new Vector<String>();
        try {
            node1 = (DefaultMutableTreeNode)root.getFirstChild();
        }
        catch (Exception exception) {
            // empty catch block
        }
        while (node1 != null && node1 != node) {
            EntityDeclNodeData data2;
            DeclNodeData data1 = (DeclNodeData)node1.getUserObject();
            int type = data1.getNodeType();
            if (type == 6) {
                data2 = (EntityDeclNodeData)data1;
                if (data2.getPeDecl() && data2.getType() != 0) {
                    vet.addElement(data1.getNodeName());
                }
            } else if (type == 28 && (data2 = (EntityDeclNodeData)this.entityBuff.get(data1.getNodeName())) != null) {
                data2.addAllPerefEntitys(vet);
            }
            node1 = node1.getNextSibling();
        }
        return vet;
    }

    public String getEntityValueBefore(DefaultMutableTreeNode node, String entityName) {
        DeclNodeData userdata = (DeclNodeData)this.entityBuff.get(entityName);
        if (userdata != null) {
            return (String)userdata.getNodeValue();
        }
        DefaultMutableTreeNode root = this.getRoot();
        while (node.getParent() != root) {
            node = (DefaultMutableTreeNode)node.getParent();
        }
        DefaultMutableTreeNode node1 = null;
        try {
            node1 = (DefaultMutableTreeNode)root.getFirstChild();
        }
        catch (Exception exception) {
            // empty catch block
        }
        String entityValue = null;
        while (node1 != null && node1 != node) {
            EntityDeclNodeData data2;
            DeclNodeData data1 = (DeclNodeData)node1.getUserObject();
            int type = data1.getNodeType();
            if (type == 28 && (data2 = (EntityDeclNodeData)this.entityBuff.get(data1.getNodeName())) != null && (entityValue = data2.getPerefEntityValue(entityName)) != null) {
                return entityValue;
            }
            node1 = node1.getNextSibling();
        }
        return null;
    }

    public String repleaceEntity(String entityValue) {
        return this.repleaceEntity(entityValue, this.curentSelectedNode);
    }

    DefaultMutableTreeNode getValidDeclNode(DefaultMutableTreeNode node) {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.treeModel.getRoot();
        if (node == null || node == root) {
            return node;
        }
        while (node.getParent() != root) {
            node = (DefaultMutableTreeNode)node.getParent();
        }
        return node;
    }

    public String repleaceEntity(String entityValue, DefaultMutableTreeNode node) {
        node = this.getValidDeclNode(node);
        int pos1 = entityValue.indexOf("%");
        if (pos1 < 0) {
            return entityValue;
        }
        StringBuffer sb = new StringBuffer();
        int pos = 0;
        while (pos1 >= 0) {
            sb.append(entityValue.substring(pos, pos1));
            pos = pos1 + 1;
            pos1 = entityValue.indexOf(";", pos);
            if (pos1 > pos) {
                String entity = entityValue.substring(pos, pos1);
                String value = this.getEntityValueBefore(node, entity);
                if (value != null) {
                    value = this.repleaceEntity(value, node);
                    sb.append(value);
                } else {
                    sb.append('%');
                    sb.append(entity);
                    sb.append(';');
                }
                pos = pos1 + 1;
            } else {
                if (pos1 != pos) {
                    sb.append(entityValue.substring(pos));
                    break;
                }
                ++pos;
            }
            pos1 = entityValue.indexOf("%", pos);
        }
        sb.append(entityValue.substring(pos));
        return sb.toString();
    }

    protected String getNewDefaultNodeName(int type) {
        if (type == 8) {
            return CMD_NEW_COMMENT;
        }
        if (type == 25) {
            String basename = "xmlns:prefix";
            return this.getNewDefaultNodeName(basename);
        }
        String basename = "New_" + DeclNodeData.getNodeTypeName(type) + "_";
        return this.getNewDefaultNodeName(basename);
    }

    protected String getNewDefaultNodeName(int type, String prefix) {
        String basename = prefix == null ? "New_" + DeclNodeData.getNodeTypeName(type) + "_" : prefix + ":New_" + DeclNodeData.getNodeTypeName(type) + "_";
        return this.getNewDefaultNodeName(basename);
    }

    protected String getNewDefaultNodeName(String basename) {
        DeclNodeData data;
        DefaultMutableTreeNode node;
        int i;
        boolean has;
        String name2;
        int index = 1;
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.treeModel.getRoot();
        int n = root.getChildCount();
        while (true) {
            name2 = basename + String.valueOf(index);
            has = false;
            for (i = 0; i < n; ++i) {
                node = (DefaultMutableTreeNode)root.getChildAt(i);
                data = (DeclNodeData)node.getUserObject();
                if (!data.getNodeName().equals(name2)) continue;
                has = true;
                break;
            }
            if (!has) break;
            ++index;
        }
        n = this.defaultNodes.size();
        while (true) {
            has = false;
            for (i = 0; i < n; ++i) {
                node = (DefaultMutableTreeNode)this.defaultNodes.elementAt(i);
                data = (DeclNodeData)node.getUserObject();
                if (!data.getNodeName().equals(name2)) continue;
                has = true;
                break;
            }
            if (!has) {
                return name2;
            }
            name2 = basename + String.valueOf(index);
            ++index;
        }
    }

    protected void addToDefaultNode(DefaultMutableTreeNode node) {
        DeclNodeData data = (DeclNodeData)node.getUserObject();
        int type = data.getNodeType();
        if (type != 30) {
            this.defaultNodes.addElement(node);
        }
    }

    protected void removeFromDefaultNode(String name2) {
        int n;
        for (int i = n = this.defaultNodes.size() - 1; i > 0; --i) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.defaultNodes.elementAt(i);
            DeclNodeData data = (DeclNodeData)node.getUserObject();
            if (!data.getNodeName().equals(name2)) continue;
            this.defaultNodes.removeElementAt(i);
        }
    }

    void treeNodeExpanded(TreePath path) {
        if (path == null) {
            return;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
        if (node == null) {
            return;
        }
        DeclNodeData userdata = (DeclNodeData)node.getUserObject();
        int type = userdata.getNodeType();
        if (20 == type) {
            this.expandedAllChildren(node);
        }
    }

    protected void expandedAllChildren(DefaultMutableTreeNode node) {
        int n = node.getChildCount();
        for (int i = 0; i < n; ++i) {
            DefaultMutableTreeNode sub = (DefaultMutableTreeNode)node.getChildAt(i);
            this.tree.expandPath(new TreePath(sub.getPath()));
            int n1 = sub.getChildCount();
            if (n1 <= 0) continue;
            this.expandedAllChildren(sub);
        }
    }

    protected DefaultMutableTreeNode getSelectedTreeNode() {
        return this.curentSelectedNode;
    }

    protected DeclNodeData getSelectedTreeNodeData() {
        if (this.curentSelectedNode == null) {
            return null;
        }
        return (DeclNodeData)this.curentSelectedNode.getUserObject();
    }

    public void setSelectedTreeNode(DefaultMutableTreeNode node) {
        TreePath path = new TreePath(node.getPath());
        this.tree.setSelectionPath(path);
        this.tree.scrollPathToVisible(path);
    }

    private void treeNodeSelected(TreeSelectionEvent e) {
        if (this.disableSelectChange) {
            return;
        }
        TreePath sel = this.tree.getSelectionPath();
        this.curentSelectedNode = sel == null ? null : (DefaultMutableTreeNode)sel.getLastPathComponent();
        this.toContentsDeclPanel();
        this.resetEditStatus();
        for (int i = 0; i < this.myStatusChangedListener.size(); ++i) {
            StatusChangedListener sl = (StatusChangedListener)this.myStatusChangedListener.elementAt(i);
            sl.statusChanged(2, new EventObject(this));
        }
    }

    protected void resetEditStatus() {
        DefaultMutableTreeNode selNode;
        if (this.status != 0) {
            this.status = 0;
            this.hasSetActionStatus = false;
        }
        if ((selNode = this.getSelectedTreeNode()) == null) {
            return;
        }
        if (!this.getContentsViewVisible()) {
            return;
        }
        DeclNodeData select = (DeclNodeData)selNode.getUserObject();
        if (select == null) {
            return;
        }
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)selNode.getParent();
        int type = select.getNodeType();
        switch (type) {
            case 27: {
                this.status = 253;
                break;
            }
            case 30: {
                this.status = 2051;
                break;
            }
            case 20: {
                this.status = 3839;
                break;
            }
            case 31: {
                this.status = 3079;
                DeclNodeData padata = (DeclNodeData)parent.getUserObject();
                if (padata.getNodeType() != 20 || ((ElementDeclNodeData)padata).getType() == 3) break;
                this.status ^= 2;
                break;
            }
            default: {
                this.status = 3325;
            }
        }
        if (parent != null) {
            if (parent.getFirstChild() != selNode) {
                this.status |= 0x1000;
            }
            if (parent.getLastChild() != selNode) {
                this.status |= 0x2000;
            }
        }
        this.status |= 0x4000;
        this.status = !this.searchText.equals("") ? (this.status |= 0x8000) : (this.status ^= 0x8000);
        this.hasSetActionStatus = false;
    }

    void toContentsDeclPanel() {
        int type;
        Object userdata;
        ContentsEditPanel conPanel = null;
        if (this.curentSelectedNode != null && (userdata = this.curentSelectedNode.getUserObject()) instanceof DeclNodeData && (conPanel = this.getContentsEditPanel(type = ((DeclNodeData)userdata).getNodeType())) != null) {
            conPanel.setTreeNode(this.curentSelectedNode);
        }
        if (this.contentsPanel.getComponentCount() == 0) {
            if (conPanel != null) {
                this.contentsPanel.add(conPanel, "Center", 0);
                this.contentsPanel.revalidate();
                this.contentsPanel.repaint();
            }
        } else {
            JPanel conPanel1 = (JPanel)this.contentsPanel.getComponent(0);
            if (conPanel != conPanel1) {
                this.contentsPanel.removeAll();
                if (conPanel != null) {
                    this.contentsPanel.add(conPanel, "Center", 0);
                    this.contentsPanel.revalidate();
                }
                this.contentsPanel.repaint();
            }
        }
    }

    public void toDataTypeDeclPanel() {
        ContentsEditPanel conPanel = this.getContentsEditPanel(32);
        if (conPanel == null) {
            return;
        }
        DefaultMutableTreeNode select = this.getSelectedTreeNode();
        if (select == null) {
            return;
        }
        conPanel.setTreeNode(select);
        this.contentsPanel.removeAll();
        this.contentsPanel.repaint();
        this.contentsPanel.add(conPanel, "Center", 0);
        this.contentsPanel.revalidate();
    }

    void nodeChanged(DefaultMutableTreeNode treenode) {
        this.treeModel.nodeChanged(treenode);
    }

    void nodeStructureChanged(DefaultMutableTreeNode treenode) {
        this.treeModel.nodeStructureChanged(treenode);
    }

    public boolean hasNameWithoutSelect(int type, String name2) {
        DefaultMutableTreeNode select = this.getSelectedTreeNode();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.treeModel.getRoot();
        DefaultMutableTreeNode node = null;
        try {
            node = (DefaultMutableTreeNode)root.getFirstChild();
        }
        catch (Exception exception) {
            // empty catch block
        }
        while (node != null) {
            DeclNodeData data;
            if (select != node && (data = (DeclNodeData)node.getUserObject()).getNodeType() == type && data.getNodeName().equals(name2)) {
                return true;
            }
            node = node.getNextSibling();
        }
        return false;
    }

    public boolean hasNameWithoutSelect(String name2) {
        DefaultMutableTreeNode select = this.getSelectedTreeNode();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.treeModel.getRoot();
        DefaultMutableTreeNode node = null;
        try {
            node = (DefaultMutableTreeNode)root.getFirstChild();
        }
        catch (Exception exception) {
            // empty catch block
        }
        while (node != null) {
            DeclNodeData data;
            if (select != node && (data = (DeclNodeData)node.getUserObject()).getNodeName().equals(name2)) {
                return true;
            }
            node = node.getNextSibling();
        }
        return false;
    }

    protected boolean hasName(String name2) {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.treeModel.getRoot();
        DefaultMutableTreeNode node = null;
        try {
            node = (DefaultMutableTreeNode)root.getFirstChild();
        }
        catch (Exception exception) {
            // empty catch block
        }
        while (node != null) {
            DeclNodeData data = (DeclNodeData)node.getUserObject();
            if (data.getNodeName().equals(name2)) {
                return true;
            }
            node = node.getNextSibling();
        }
        return false;
    }

    DefaultMutableTreeNode getTreeNodeByName(int type, String name2) {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.treeModel.getRoot();
        DefaultMutableTreeNode node = null;
        try {
            node = (DefaultMutableTreeNode)root.getFirstChild();
        }
        catch (Exception exception) {
            // empty catch block
        }
        while (node != null) {
            DeclNodeData data = (DeclNodeData)node.getUserObject();
            if (data.getNodeType() == type && data.getNodeName().equals(name2)) {
                return node;
            }
            node = node.getNextSibling();
        }
        return null;
    }

    protected void setActionEnabled() {
        ((Action)this.actions.get(CMD_NEW_ELEMENT)).setEnabled((this.status & 1) != 0);
        ((Action)this.actions.get(CMD_NEW_SUBELEMENT)).setEnabled((this.status & 2) != 0);
        ((Action)this.actions.get(CMD_NEW_ATTDEF)).setEnabled((this.status & 4) != 0);
        ((Action)this.actions.get(CMD_NEW_ENTITY)).setEnabled((this.status & 8) != 0);
        ((Action)this.actions.get(CMD_NEW_NOTATION)).setEnabled((this.status & 0x10) != 0);
        ((Action)this.actions.get(CMD_NEW_PEREF)).setEnabled((this.status & 0x40) != 0);
        ((Action)this.actions.get(CMD_NEW_COMMENT)).setEnabled((this.status & 0x20) != 0);
        ((Action)this.actions.get(CMD_NEW_PI)).setEnabled((this.status & 0x80) != 0);
        ((Action)this.actions.get(CMD_NODECOPY)).setEnabled((this.status & 0x400) != 0);
        ((Action)this.actions.get(CMD_REMOVE)).setEnabled((this.status & 0x800) != 0);
        ((Action)this.actions.get(CMD_TO_UP)).setEnabled((this.status & 0x1000) != 0);
        ((Action)this.actions.get(CMD_TO_DOWN)).setEnabled((this.status & 0x2000) != 0);
        ((Action)this.actions.get(CMD_FINDNODE)).setEnabled((this.status & 0x4000) != 0);
        ((Action)this.actions.get(CMD_REFINDNODE)).setEnabled((this.status & 0x8000) != 0);
        this.hasSetActionStatus = true;
    }

    protected String searchPrefix(DefaultMutableTreeNode node) {
        return null;
    }

    protected String searchPrefix(String element) {
        return null;
    }

    protected void nameSpaceChanged(String prefix, String prefix1) {
    }

    protected void changeNsElement(String oldelem, String newelem) {
    }

    static {
        String lang = System.getProperty("user.msg.lang", null);
        if (lang == null) {
            lang = Locale.getDefault().getLanguage();
        }
        String classbase = DTDEditorPanel.getPackageName(DTDEditorPanel.class) + ".MessageCatalog_";
        try {
            msgCatalog = (MessageCatalog)Class.forName(classbase + lang).newInstance();
        }
        catch (Exception e) {
            try {
                msgCatalog = (MessageCatalog)Class.forName(classbase + "en").newInstance();
            }
            catch (Exception e1) {
                System.out.println(e1);
                System.exit(1);
            }
        }
        defaultBorder = BorderFactory.createEtchedBorder();
        SelectedBackgroundColor = UIManager.getColor("Tree.selectionBackground");
    }

    class MyTreeCellRenderer
    extends JLabel
    implements TreeCellRenderer {
        protected boolean selected;

        MyTreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            String stringValue = tree.convertValueToText(value, selected, expanded, leaf, row, hasFocus);
            this.setText(stringValue);
            this.setToolTipText(stringValue);
            Object userObject = ((DefaultMutableTreeNode)value).getUserObject();
            if (userObject instanceof DeclNodeData) {
                this.setIcon(((DeclNodeData)userObject).getImageIcon());
            }
            this.setFont(DTDEditorPanel.this.defaultFont);
            this.selected = selected;
            return this;
        }

        @Override
        public void paint(Graphics g) {
            Icon currentI = this.getIcon();
            Color bColor = this.selected ? SelectedBackgroundColor : (this.getParent() != null ? this.getParent().getBackground() : this.getBackground());
            g.setColor(bColor);
            if (currentI != null && this.getText() != null) {
                int offset = currentI.getIconWidth() + this.getIconTextGap();
                g.fillRect(offset, 0, this.getWidth() - 1 - offset, this.getHeight() - 1);
            } else {
                g.fillRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
            }
            super.paint(g);
        }
    }

    class MyAction
    extends AbstractAction {
        MyAction(String name2, String msgId, Icon icon) {
            super(name2, icon);
            this.putValue("ShortDescription", msgCatalog.getMessage(msgId));
            this.setEnabled(false);
        }

        MyAction(String name2, String shortdes, String longdes, Icon icon) {
            super(name2, icon);
            this.putValue("ShortDescription", msgCatalog.getMessage(shortdes));
            this.putValue("LongDescription", msgCatalog.getMessage(longdes));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }

        @Override
        public boolean isEnabled() {
            if (!DTDEditorPanel.this.hasSetActionStatus) {
                DTDEditorPanel.this.setActionEnabled();
            }
            return this.enabled;
        }
    }
}

