/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.jxp.vdtd;

import com.argo21.common.gui.FindDialog;
import com.argo21.common.gui.GuiUtils;
import com.argo21.common.gui.ImageLoader;
import com.argo21.jxp.dtd.AttDef;
import com.argo21.jxp.dtd.DTDDecl;
import com.argo21.jxp.dtd.DeclNode;
import com.argo21.jxp.dtd.DeclNodeList;
import com.argo21.jxp.dtd.ElementDecl;
import com.argo21.jxp.vdtd.AttDefDeclNodeData;
import com.argo21.jxp.vdtd.DTDDeclNodeData;
import com.argo21.jxp.vdtd.DTDEditorPanel;
import com.argo21.jxp.vdtd.DeclNodeData;
import com.argo21.jxp.vdtd.ElementDeclNodeData;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.Hashtable;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;

public class DTDStructView
extends JPanel {
    public static final String CMD_FINDTREENODE = "FINDTREENODE";
    public static final String CMD_REFINDTREENODE = "REFINDTREENODE";
    private JTree tree;
    private JScrollPane treeSp;
    private DefaultTreeModel treeModel = null;
    public static Color SelectedBackgroundColor = UIManager.getColor("Tree.selectionBackground");
    JTextPane result;
    private DTDDecl dtd = null;
    Font defaultFont;
    private boolean isForward = true;
    private String searchText = "";
    protected boolean ignoreCase = false;
    FindDialog findDialog = null;
    private MyAction findAction = new MyAction("FINDTREENODE", this.getMessage("CMD_FIND"), DTDStructView.loadImage("find")){

        @Override
        public void actionPerformed(ActionEvent e) {
            DTDStructView.this.findNode();
        }
    };
    private MyAction refindAction = new MyAction("FINDTREENODE", this.getMessage("CMD_REFIND"), null){

        @Override
        public void actionPerformed(ActionEvent e) {
            DTDStructView.this.refindNode();
        }
    };

    String getMessage(String MsgId) {
        return DTDEditorPanel.msgCatalog.getMessage(MsgId);
    }

    static ImageIcon loadImage(String name2) {
        return ImageLoader.load(name2 + ".gif", name2);
    }

    public DTDStructView() {
        this((DTDDeclNodeData)null);
    }

    public DTDStructView(DTDDeclNodeData rootdata, DTDDecl dtd) {
        this(rootdata);
        this.setDTD(dtd);
    }

    public DTDStructView(DTDDeclNodeData rootdata) {
        try {
            this.defaultFont = new Font("Dialog", 0, 12);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (rootdata == null) {
            rootdata = new DTDDeclNodeData("DEFAULT-ROOT");
        }
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(rootdata);
        this.treeModel = new DefaultTreeModel(root);
        this.tree = new JTree(this.treeModel);
        this.tree.setCellRenderer(new MyTreeCellRenderer());
        GuiUtils.setLookAndFeel(GuiUtils.lookAndFeelClassName, this.tree);
        this.treeSp = new JScrollPane();
        this.treeSp.getViewport().add(this.tree);
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                DTDStructView.this.treeNodeSelected(e);
            }
        });
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridy = 0;
        gc.gridx = 0;
        gc.fill = 1;
        gc.weightx = 1.0;
        gc.weighty = 1.0;
        gc.insets = new Insets(2, 2, 2, 2);
        this.setLayout(new GridBagLayout());
        this.add((Component)this.treeSp, gc);
        this.result = new JTextPane();
        this.result.setFont(this.defaultFont);
        this.result.setEditable(false);
        JScrollPane sp = new JScrollPane(this.result);
        sp.setPreferredSize(new Dimension(100, 70));
        sp.setBorder(BorderFactory.createEtchedBorder());
        ++gc.gridy;
        gc.fill = 1;
        gc.weighty = 0.0;
        this.add((Component)sp, gc);
    }

    public void treeNodeSelected(TreeSelectionEvent e) {
        DeclNode decl = this.getSelectedNodeDecl();
        if (decl == null) {
            this.result.setText("");
            return;
        }
        String name2 = decl.getNodeName();
        String s = this.dtd.getAbsolutePath(this.getSelectedPathNames(), '/');
        s = s + "\n\n" + decl.toString();
        this.result.setText(s);
    }

    public TreePath getSelectedPath() {
        return this.tree.getSelectionPath();
    }

    public String[] getSelectedPathNames() {
        TreePath sel = this.tree.getSelectionPath();
        if (sel == null) {
            return new String[0];
        }
        int n = sel.getPathCount();
        String[] names = new String[n - 1];
        for (int i = 1; i < n; ++i) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)sel.getPathComponent(i);
            DeclNodeData userobj = (DeclNodeData)node.getUserObject();
            names[i - 1] = userobj.getNodeType() == 22 ? "@" + userobj.getNodeName() : userobj.getNodeName();
        }
        return names;
    }

    public DeclNode getSelectedNodeDecl() {
        TreePath sel = this.tree.getSelectionPath();
        if (sel == null) {
            return null;
        }
        DefaultMutableTreeNode currentNode = (DefaultMutableTreeNode)sel.getLastPathComponent();
        DeclNodeData userobj = (DeclNodeData)currentNode.getUserObject();
        int nodetype = userobj.getNodeType();
        String name2 = userobj.getNodeName();
        Object declnode = null;
        switch (nodetype) {
            case 20: {
                return this.dtd.getElementDecl(name2);
            }
            case 22: {
                String elem = ((AttDefDeclNodeData)userobj).getElementName();
                return this.dtd.getAttListDecl(elem, name2);
            }
        }
        return null;
    }

    public void setDTD(DTDDecl dtd) {
        ElementDeclNodeData userdata;
        DynamicTreeNode treeNode;
        ElementDecl decl;
        this.findAction.setEnabled(true);
        this.refindAction.setEnabled(false);
        this.dtd = dtd;
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.tree.getModel().getRoot();
        String rootName = null;
        if (dtd != null) {
            rootName = dtd.getNodeName();
        }
        if (root.getUserObject().toString().equals("DEFAULT-ROOT") && rootName != null) {
            DeclNodeData rootdata = new DeclNodeData(27, rootName, null);
            root.setUserObject(rootdata);
        }
        if (dtd != null) {
            dtd.resolveParameterRefrance();
            dtd.resolveEntity();
            dtd.resolveHierarchy();
        }
        root.removeAllChildren();
        if (dtd == null) {
            this.treeModel.nodeStructureChanged(root);
            this.tree.expandRow(0);
            this.tree.setSelectionRow(0);
            return;
        }
        Hashtable store = new Hashtable();
        DeclNodeList nodes = dtd.getAllDeclNode();
        int n = nodes.size();
        for (int i = 0; i < n; ++i) {
            ElementDecl decl2;
            int type;
            DeclNode node = nodes.elementAt(i);
            int nodetype = node.getNodeType();
            if (nodetype != 20 || (type = (decl2 = (ElementDecl)node).getType()) == 2 || type == 0) continue;
            ElementDeclNodeData userdata2 = new ElementDeclNodeData(decl2);
            DynamicTreeNode treeNode2 = new DynamicTreeNode(userdata2);
            root.add(treeNode2);
        }
        if (root.getChildCount() == 0 && (decl = dtd.getRootElement()) != null && (treeNode = new DynamicTreeNode(userdata = new ElementDeclNodeData(decl))) != null) {
            root.add(treeNode);
        }
        this.treeModel.nodeStructureChanged(root);
        store.clear();
        this.expandAllSubNode(root, store, root.getChildCount() < 2);
        this.tree.setSelectionRow(0);
    }

    private void expandAllSubNode(DefaultMutableTreeNode node, Hashtable elemTab, boolean deep) {
        block4: {
            block3: {
                this.tree.expandPath(new TreePath(node.getPath()));
                if (!deep) {
                    return;
                }
                DeclNodeData data = (DeclNodeData)node.getUserObject();
                int type = data.getNodeType();
                if (type != 20) break block3;
                String name2 = data.getNodeName();
                if (elemTab.containsKey(name2)) break block4;
                elemTab.put(name2, data);
                int n = node.getChildCount();
                for (int i = 0; i < n; ++i) {
                    DefaultMutableTreeNode sub = (DefaultMutableTreeNode)node.getChildAt(i);
                    this.expandAllSubNode(sub, elemTab, deep);
                }
                break block4;
            }
            int n = node.getChildCount();
            for (int i = 0; i < n; ++i) {
                DefaultMutableTreeNode sub = (DefaultMutableTreeNode)node.getChildAt(i);
                this.expandAllSubNode(sub, elemTab, deep);
            }
        }
    }

    public Action getAction(String command) {
        if (command.equals(CMD_FINDTREENODE)) {
            return this.findAction;
        }
        if (command.equals(CMD_REFINDTREENODE)) {
            return this.refindAction;
        }
        return null;
    }

    public DefaultMutableTreeNode getRoot() {
        return (DefaultMutableTreeNode)this.treeModel.getRoot();
    }

    public DTDDeclNodeData getRootData() {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.treeModel.getRoot();
        return (DTDDeclNodeData)root.getUserObject();
    }

    public void setRootData(DTDDeclNodeData data) {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.treeModel.getRoot();
        root.setUserObject(data);
        this.treeModel.nodeChanged(root);
    }

    void addSubNodesTo(DefaultMutableTreeNode parent) {
        DeclNodeData data = (DeclNodeData)parent.getUserObject();
        int type = data.getNodeType();
        String name2 = data.getNodeName();
        if (type == 20) {
            DeclNodeData data1;
            int i;
            ElementDecl decl = this.dtd.getElementDecl(name2);
            if (name2 == null) {
                return;
            }
            DeclNodeList list = decl.getAttListDecls();
            int n = list.getLength();
            for (i = 0; i < n; ++i) {
                data1 = new AttDefDeclNodeData((AttDef)list.item(i));
                parent.add(new DefaultMutableTreeNode(data1));
            }
            list = decl.getSubElementDecls();
            n = list.getLength();
            for (i = 0; i < n; ++i) {
                data1 = new ElementDeclNodeData((ElementDecl)list.item(i));
                parent.add(new DynamicTreeNode(data1));
            }
        }
    }

    void treeNodeExpanded(TreePath path) {
    }

    protected void expandedAllChildren(DefaultMutableTreeNode node) {
        int n = node.getChildCount();
        for (int i = 0; i < n; ++i) {
            DefaultMutableTreeNode sub = (DefaultMutableTreeNode)node.getChildAt(i);
            this.tree.expandPath(new TreePath(sub.getPath()));
            int n1 = sub.getChildCount();
            if (n1 <= 0) continue;
            this.expandedAllChildren(sub);
        }
    }

    public void findNode() {
        if (this.findDialog == null) {
            Frame f = (Frame)SwingUtilities.getRoot(this);
            this.findDialog = new FindDialog(f);
        }
        this.findDialog.setText(this.searchText);
        this.findDialog.setForward(this.isForward);
        DefaultMutableTreeNode node = this.getSelectedTreeNode();
        DeclNodeData data = node == null ? null : (DeclNodeData)node.getUserObject();
        String nodeName = null;
        if (data != null && (nodeName = data.getNodeName()) != null && nodeName.length() == 0) {
            nodeName = null;
        }
        if (nodeName != null) {
            this.findDialog.setText(nodeName);
        } else {
            this.findDialog.setText(this.searchText);
        }
        this.findDialog.setVisible(true);
        if (!this.findDialog.isOK()) {
            return;
        }
        this.isForward = this.findDialog.isForward();
        this.searchText = this.findDialog.getText().trim();
        this.ignoreCase = this.findDialog.ignoreCase();
        if (this.searchText.equals("")) {
            this.refindAction.setEnabled(false);
            return;
        }
        this.refindNode();
        this.refindAction.setEnabled(true);
    }

    public void refindNode() {
        DefaultMutableTreeNode node;
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.treeModel.getRoot();
        if (node == null) {
            return;
        }
        if (this.isForward) {
            while (node != null) {
                DeclNodeData data;
                String s;
                if ((node = node.getNextNode()) == null || (s = (data = (DeclNodeData)node.getUserObject()).getNodeName()) == null) continue;
                if (this.ignoreCase) {
                    String word = this.searchText.toUpperCase();
                    if ((s = s.toUpperCase()).indexOf(word) < 0) continue;
                    this.setSelectedTreeNode(node);
                    return;
                }
                if (s.indexOf(this.searchText) < 0) continue;
                this.setSelectedTreeNode(node);
                return;
            }
        } else {
            for (node = this.getSelectedTreeNode(); node != null; node = node.getPreviousNode()) {
                try {
                    continue;
                }
                catch (Exception e) {
                    return;
                }
            }
        }
    }

    DefaultMutableTreeNode getSelectedTreeNode() {
        TreePath path = this.tree.getSelectionPath();
        if (path == null) {
            return null;
        }
        return (DefaultMutableTreeNode)path.getLastPathComponent();
    }

    void setSelectedTreeNode(DefaultMutableTreeNode node) {
        TreePath path = new TreePath(node.getPath());
        this.tree.setSelectionPath(path);
        this.tree.scrollPathToVisible(path);
    }

    class DynamicTreeNode
    extends DefaultMutableTreeNode {
        protected boolean hasLoaded;

        public DynamicTreeNode(Object obj) {
            super(obj);
        }

        @Override
        public boolean isLeaf() {
            return false;
        }

        @Override
        public int getChildCount() {
            if (!this.hasLoaded) {
                this.loadChildren();
            }
            return super.getChildCount();
        }

        protected void loadChildren() {
            this.hasLoaded = true;
            DTDStructView.this.addSubNodesTo(this);
        }
    }

    class MyTreeCellRenderer
    extends JLabel
    implements TreeCellRenderer {
        protected boolean selected;

        MyTreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            String stringValue = tree.convertValueToText(value, selected, expanded, leaf, row, hasFocus);
            this.setText(stringValue);
            this.setToolTipText(stringValue);
            Object userObject = ((DefaultMutableTreeNode)value).getUserObject();
            if (userObject instanceof DeclNodeData) {
                this.setIcon(((DeclNodeData)userObject).getImageIcon());
            }
            this.setFont(DTDStructView.this.defaultFont);
            this.selected = selected;
            return this;
        }

        @Override
        public void paint(Graphics g) {
            Icon currentI = this.getIcon();
            Color bColor = this.selected ? SelectedBackgroundColor : (this.getParent() != null ? this.getParent().getBackground() : this.getBackground());
            g.setColor(bColor);
            if (currentI != null && this.getText() != null) {
                int offset = currentI.getIconWidth() + this.getIconTextGap();
                g.fillRect(offset, 0, this.getWidth() - 1 - offset, this.getHeight() - 1);
            } else {
                g.fillRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
            }
            super.paint(g);
        }
    }

    class MyAction
    extends AbstractAction {
        MyAction(String name2, String description, Icon icon) {
            super(name2, icon);
            this.putValue("ShortDescription", description);
            this.setEnabled(false);
        }

        MyAction(String name2, String shortdes, String longdes, Icon icon) {
            super(name2, icon);
            this.putValue("ShortDescription", shortdes);
            this.putValue("LongDescription", longdes);
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }

        @Override
        public boolean isEnabled() {
            return this.enabled;
        }
    }
}

