/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.jxp.vdtd;

import com.argo21.common.gui.ComboTextFieldEx;
import com.argo21.common.gui.TextFieldEx;
import com.argo21.common.lang.XmlNames;
import com.argo21.jxp.dtd.ChildrenNode;
import com.argo21.jxp.dtd.ContentParticleImpl;
import com.argo21.jxp.dtd.ElementDecl;
import com.argo21.jxp.vdtd.ContentsEditPanel;
import com.argo21.jxp.vdtd.CpDeclNodeData;
import com.argo21.jxp.vdtd.DTDEditorPanel;
import com.argo21.jxp.vdtd.ElementDeclNodeData;
import com.argo21.jxp.vdtd.ResultPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.tree.DefaultMutableTreeNode;

class ElementDeclPanel
extends ContentsEditPanel {
    static String[] ELEMENT_TYPE_NAMES = new String[]{ElementDeclPanel.getMessage("LAB_ELEM_EMPTY"), ElementDeclPanel.getMessage("LAB_ELEM_ANY"), ElementDeclPanel.getMessage("LAB_ELEM_MIX"), ElementDeclPanel.getMessage("LAB_ELEM_CHILD")};
    TextFieldEx nameField;
    JRadioButton[] contentOption = new JRadioButton[5];
    JPanel entityPanel;
    JPanel typePanel;
    ComboTextFieldEx entityField;
    JCheckBox entityRefField;
    ResultPanel result;
    JButton bt;

    ElementDeclPanel() {
    }

    @Override
    public void init(DTDEditorPanel parentPanel) {
        this.parentPanel = parentPanel;
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridy = 0;
        gc.gridx = 0;
        gc.fill = 1;
        gc.weightx = 1.0;
        gc.insets = new Insets(2, 2, 2, 2);
        this.setLayout(new GridBagLayout());
        if (parentPanel.getExtendEnabled()) {
            this.bt = new JButton(ElementDeclPanel.getMessage("TO_DATA_DECL"));
            this.bt.setMargin(new Insets(0, 0, 0, 0));
            this.bt.setBorder(null);
            this.bt.setBackground(SystemColor.activeCaption);
            this.bt.setForeground(Color.white);
            this.bt.setHorizontalAlignment(4);
            this.bt.setFocusPainted(false);
            this.bt.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ElementDeclPanel.this.toDataTypeDeclPanel();
                }
            });
            this.add((Component)this.bt, gc);
            ++gc.gridy;
        }
        GridBagConstraints c = new GridBagConstraints();
        c.gridy = 0;
        c.gridx = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.insets = new Insets(2, 2, 2, 2);
        c.fill = 1;
        JPanel tp = new JPanel();
        tp.setLayout(new GridBagLayout());
        tp.setOpaque(true);
        tp.setBorder(BorderFactory.createTitledBorder(ElementDeclPanel.getMessage("TL_ELEM")));
        JLabel label = new JLabel(ElementDeclPanel.getMessage("LAB_NAME"));
        tp.add((Component)label, c);
        ++c.gridx;
        c.weightx = 1.0;
        this.nameField = new TextFieldEx(10){

            @Override
            public boolean valueChanged(Object Source2, String value) {
                ElementDeclPanel.this.nameChanged(value.trim());
                return true;
            }
        };
        tp.add((Component)this.nameField, c);
        this.entityRefField = new JCheckBox(ElementDeclPanel.getMessage("LAB_PARAM_REF"));
        if (parentPanel.peRefEnabled) {
            c.gridx = 0;
            c.weightx = 0.0;
            ++c.gridy;
            ++c.gridx;
            c.weightx = 1.0;
            this.entityRefField.setFont(this.getDefaultFont());
            tp.add((Component)this.entityRefField, c);
            this.entityRefField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ElementDeclPanel.this.entityRefCheckChanged();
                }
            });
        }
        this.add((Component)tp, gc);
        ++gc.gridy;
        this.typePanel = new JPanel();
        this.typePanel.setBorder(BorderFactory.createTitledBorder(ElementDeclPanel.getMessage("TL_CONTENTS")));
        this.typePanel.setLayout(new BoxLayout(this.typePanel, 1));
        ButtonGroup group = new ButtonGroup();
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ElementDeclPanel.this.typeChanged((JRadioButton)e.getSource());
            }
        };
        for (int i = 0; i < 4; ++i) {
            this.contentOption[i] = new JRadioButton(ELEMENT_TYPE_NAMES[i]);
            this.typePanel.add(this.contentOption[i]);
            group.add(this.contentOption[i]);
            this.contentOption[i].setFont(this.getDefaultFont());
            this.contentOption[i].addActionListener(al);
        }
        this.add((Component)this.typePanel, gc);
        ++gc.gridy;
        this.entityPanel = new JPanel();
        c.gridy = 0;
        c.gridx = 0;
        c.weightx = 0.0;
        this.entityPanel.setLayout(new GridBagLayout());
        this.entityPanel.setOpaque(true);
        this.entityPanel.setBorder(BorderFactory.createTitledBorder(ElementDeclPanel.getMessage("TL_ELEM")));
        label = new JLabel(ElementDeclPanel.getMessage("LAB_NAME"));
        this.entityPanel.add((Component)label, c);
        ++c.gridx;
        c.weightx = 1.0;
        this.entityField = new ComboTextFieldEx(){

            @Override
            public boolean valueChanged(Object source, String value) {
                ElementDeclPanel.this.entityNameChanged(value.trim());
                return true;
            }
        };
        this.entityPanel.add((Component)this.entityField, c);
        this.add((Component)this.entityPanel, gc);
        ++gc.gridy;
        gc.gridwidth = 0;
        gc.gridheight = 0;
        gc.weighty = 1.0;
        gc.weightx = 1.0;
        this.result = new ResultPanel(parentPanel);
        this.add((Component)this.result, gc);
    }

    void toDataTypeDeclPanel() {
        this.parentPanel.toDataTypeDeclPanel();
    }

    void entityRefCheckChanged() {
        ElementDeclNodeData data = (ElementDeclNodeData)this.node.getUserObject();
        boolean b = this.entityRefField.isSelected();
        if (data.isEntityRef() == b) {
            return;
        }
        int type = data.getType();
        String message = b ? ElementDeclPanel.getMessage("QST_TO_PARAM", new Object[]{ELEMENT_TYPE_NAMES[type]}) : ElementDeclPanel.getMessage("QST_FROM_PARAM", new Object[]{ELEMENT_TYPE_NAMES[type]});
        message = message + "\n" + ElementDeclPanel.getMessage("WAR_MSG_LOST");
        int rs = JOptionPane.showConfirmDialog(this.parentPanel.getFrame(), message, "Select an Option", 0);
        if (rs != 0) {
            this.entityRefField.setSelected(data.isEntityRef());
            return;
        }
        data.setEntityRef(b);
        this.entityPanel.setVisible(b);
        this.typePanel.setVisible(!b);
        if (this.entityRefField.isSelected()) {
            data.setType(0);
            this.loadEntities(data.getEntityName());
            this.node.removeAllChildren();
            this.nodeStructureChanged();
        }
        this.revalidate();
        this.viewResult();
    }

    void typeChanged(JRadioButton typeopt) {
        if (!typeopt.isSelected()) {
            return;
        }
        if (this.entityRefField.isSelected()) {
            return;
        }
        int type = 0;
        if (typeopt == this.contentOption[0]) {
            type = 0;
        } else if (typeopt == this.contentOption[1]) {
            type = 1;
        } else if (typeopt == this.contentOption[2]) {
            type = 2;
        } else if (typeopt == this.contentOption[3]) {
            type = 3;
        } else {
            return;
        }
        ElementDeclNodeData data = (ElementDeclNodeData)this.node.getUserObject();
        int oldtype = data.getType();
        if (type == oldtype) {
            return;
        }
        if (type == 0 || type == 1) {
            if (oldtype != 0 && oldtype != 1) {
                String message = ElementDeclPanel.getMessage("QST_ELEM_CHANG", new Object[]{ELEMENT_TYPE_NAMES[oldtype], ELEMENT_TYPE_NAMES[type]});
                message = message + "\n" + ElementDeclPanel.getMessage("WAR_MSG_LOST");
                int rs = JOptionPane.showConfirmDialog(this.parentPanel.getFrame(), message, "Select an Option", 0);
                if (rs != 0) {
                    this.contentOption[oldtype].setSelected(true);
                    return;
                }
            }
            data.setType(type);
            this.node.removeAllChildren();
        } else {
            ElementDecl declnode = DTDEditorPanel.createElementDecl(null, this.node);
            Vector subnames = null;
            if (declnode != null) {
                subnames = declnode.getChildNames();
            }
            data.setType(type);
            this.node.removeAllChildren();
            if (type == 3) {
                Vector<ContentParticleImpl> cplist = new Vector<ContentParticleImpl>();
                if (subnames != null) {
                    int n = subnames.size();
                    for (int i = 0; i < n; ++i) {
                        cplist.addElement(new ContentParticleImpl('\u0000', (String)subnames.elementAt(i)));
                    }
                }
                ChildrenNode children = new ChildrenNode(1, '\u0000', cplist);
                DTDEditorPanel.addElementChilden(this.node, children);
                this.parentPanel.nodeStructureChanged(this.node);
                this.parentPanel.expandedAllChildren(this.node);
            } else if (subnames != null) {
                for (int j = 0; j < subnames.size(); ++j) {
                    CpDeclNodeData userdata = new CpDeclNodeData((String)subnames.elementAt(j), 0);
                    this.node.add(new DefaultMutableTreeNode(userdata));
                }
            }
        }
        if (this.bt != null) {
            this.bt.setEnabled(type == 2);
        }
        this.nodeChanged();
        this.nodeStructureChanged();
        this.viewResult();
    }

    void entityNameChanged(String value) {
        ElementDeclNodeData data = (ElementDeclNodeData)this.node.getUserObject();
        data.setEntityName(value);
        this.viewResult();
    }

    boolean nameChanged(String value) {
        Object data = this.node.getUserObject();
        if (data instanceof ElementDeclNodeData) {
            ElementDeclNodeData elem = (ElementDeclNodeData)data;
            int oldtype = elem.getType();
            String s = elem.getNodeName();
            if (!s.equals(value)) {
                if (!XmlNames.isName(value)) {
                    JOptionPane.showMessageDialog(this.parentPanel.getFrame(), ElementDeclPanel.getMessage("INVALID_NAME", new Object[]{value}));
                    this.nameField.setText(s);
                    return false;
                }
                if (this.parentPanel.hasNameWithoutSelect(20, value)) {
                    JOptionPane.showMessageDialog(this.parentPanel.getFrame(), ElementDeclPanel.getMessage("DOUBLE_NAME", new Object[]{value}));
                    this.nameField.setText(s);
                    return false;
                }
                this.nameChangedTo(value);
                this.viewResult();
            }
        }
        return true;
    }

    void viewResult() {
        ElementDecl declnode = DTDEditorPanel.createElementDecl(null, this.node);
        String rs = declnode == null ? "" : declnode.toString();
        this.result.viewResult(rs);
    }

    @Override
    public void setTreeNode(DefaultMutableTreeNode node) {
        this.node = node;
        ElementDeclNodeData elem = (ElementDeclNodeData)node.getUserObject();
        this.nameField.setText(elem.getNodeName());
        int type = elem.getType();
        if (type == 0) {
            this.contentOption[0].setSelected(true);
        } else if (type == 1) {
            this.contentOption[1].setSelected(true);
        } else if (type == 2) {
            this.contentOption[2].setSelected(true);
        } else if (type == 3) {
            this.contentOption[3].setSelected(true);
        }
        if (this.bt != null) {
            this.bt.setEnabled(type == 2);
        }
        this.entityRefField.setVisible(this.parentPanel.peRefEnabled);
        this.entityRefField.setSelected(elem.isEntityRef() & this.parentPanel.peRefEnabled);
        this.typePanel.setVisible(!this.entityRefField.isSelected());
        this.entityPanel.setVisible(elem.isEntityRef() & this.parentPanel.peRefEnabled);
        if (this.entityPanel.isVisible()) {
            this.loadEntities(elem.getEntityName());
        }
        this.revalidate();
        this.viewResult();
    }

    void loadEntities(String select) {
        Vector vet = this.parentPanel.getAllValueEntitysBefore(this.node);
        this.entityField.setEnabledEvent(false);
        this.entityField.setList(vet);
        this.entityField.setText(select);
        this.entityField.setEnabledEvent(true);
    }
}

